//------------------------------------------------------------------------------------------------------------
/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

// Class definition include
//------------------------------------------------------------------------------------------------------------
#include "LogicalColorBar.h"


//------------------------------------------------------------------------------------------------------------
// Class implementation
//------------------------------------------------------------------------------------------------------------
/** file LogicalColorBar.cxx */


//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	LogicalColorBar :: LogicalColorBar () 
	{
		minValue = 0;
		maxValue = 0;
		bar_orientation = true;
	}

	LogicalColorBar :: ~ LogicalColorBar () 
	{
		//logicColorPoints.clear();
	}

//------------------------------------------------------------------------------------------------------------
// Methods Implementation 
//------------------------------------------------------------------------------------------------------------



//
	// Gets the first point
	//
	pColorPoint * LogicalColorBar :: getFirstPoint()
	{
		return logicColorPoints.front();
	}


	//
	// Gets the last point
	//
	pColorPoint * LogicalColorBar :: getLastPoint()
	{
		return logicColorPoints.back();
	}


	double LogicalColorBar :: getMinValue()
	{
		return minValue;
	}


	void  LogicalColorBar :: setMinValue(double valueMin)
	{
		minValue = valueMin;
	}


	double LogicalColorBar :: getMaxValue()
	{
		return maxValue;
	}


	void LogicalColorBar :: setMaxValue(double valueMax)
	{
		maxValue = valueMax;
	}


	bool LogicalColorBar :: getOrientation()
	{
		return bar_orientation;
	}

	void LogicalColorBar :: setOrientation(bool orientation)
	{
		bar_orientation = orientation;
	}

	//
	// Adds a color degrade point to the color bar.
	// param xRealValue The real xValue of the point
	// param theColour The assigned color for the point
	// param temporalStart Indicates if the inserted point is the temporal startShowing point
	// param temporalEnd Indicates if the inserted point is the temporal startShowing point
	// return Returns true if the point was succesfully inserted.
	////
	bool LogicalColorBar :: addColorPoint (double xRealValue, wxColour theColour )
	{
		bool addedPoint = false;
		
		if(xRealValue>=minValue && xRealValue<=maxValue)
		{
			// bool ifContinue = true; // JPRx
			//pColorPoint * colorPoint, nextColorPoint;
			int maxIndex= logicColorPoints.size()-1;
			// int nextIndex = 0; // JPRx
			//int nextX = 0; // JPRx
			int i = 0;
					
			std::vector <pColorPoint*>::iterator iter;
			std::vector <pColorPoint*>::iterator nextIter;
			pColorPoint * newColorPoint = new pColorPoint ( xRealValue, theColour, false );
			if(logicColorPoints.empty())
			{
				logicColorPoints.push_back(newColorPoint);
				addedPoint = true;
			}else{				
				iter = logicColorPoints.begin();
				for (i=0; i<=maxIndex && !addedPoint; i++)
				{
					nextIter = iter;
					int before = (*iter)->getRealX() ;
					if(before>xRealValue && i==0)
					{
						//Is the first point
						logicColorPoints.insert( iter, newColorPoint );
						addedPoint =true;
						lastAddedPoint = newColorPoint;
					}
					else if(before<xRealValue && i==maxIndex)
					{
						//Is the last point 
						logicColorPoints.push_back(newColorPoint );	
						addedPoint =true;
						lastAddedPoint = newColorPoint;
					}
					else if(i<maxIndex)
					{
						//
						nextIter++;			
						int after = (*nextIter)->getRealX();				
						if( before < xRealValue && after> xRealValue)
						{
							logicColorPoints.insert( nextIter, newColorPoint );	
							addedPoint =true;
							lastAddedPoint = newColorPoint;
						}
					}		
					//std::cout<<"JCPaddColorPoint iterator "<<*iter<<std::endl;
					if(!addedPoint)
						++iter;
				}		
			}			
		}
		return addedPoint;		
	}

	bool LogicalColorBar :: deleteColorPoint ( double  valErase )
	{
		bool deletedPoint = false;		
		std::vector <pColorPoint*>::iterator pointIterator = logicColorPoints.begin();
		for(int i=0; i<logicColorPoints.size() && !deletedPoint; i++)
		{
			pColorPoint  aPoint =**pointIterator;
			if(aPoint.getRealX() == valErase)
			{
				logicColorPoints.erase(pointIterator);
				deletedPoint = true;
			}			
			pointIterator++;
		}
		return deletedPoint;
	}
	
	void LogicalColorBar :: getPointersToRangeLimits( std::deque<pColorPoint *> &theInputQueue, int &startIndex, int &endIndex, int startSearched, int endSearched )
	//void LogicalColorBar :: getListIndexRangeLimits( std::vector<pColorPoint *> &theVector, bool &startFOUND, bool &endFOUND, int startSearched, int endSearched );
	{
		bool foundedStart = false;
		bool foundedEnd = false;
		
		/*for (int i=0; i<logicColorPoints.size()&&(!foundedStart || !foundedEnd);i++)
		{
			pColorPoint colorPoint = logicColorPoints[i];
			double actualValue = colorPoint->getRealX();
			if(!foundedStart)
			{
				if((startSearched <= actualValue) )
				{
					startIndex = i;
					if((startSearched == actualValue) )
						foundedStart = true;
				}					
			}
			if(!foundedEnd)
			{
				if((actualValue <= endSearched) )
				{
					endIndex = i;
					if((endSearched == actualValue))
						foundedEnd = true;
				}			
			}						
		}		*/

		for (int i=0; i<logicColorPoints.size()&& !foundedEnd;i++)
		{
			pColorPoint * colorPoint = logicColorPoints[i];
			double actualValue = colorPoint->getRealX();
			if(!foundedStart)
			{
				if((startSearched <= actualValue) )
				{
					startIndex = i;
					//if((startSearched == actualValue) )					
					foundedStart = true;											
				}					
			}
			if(!foundedEnd)
			{
				if((actualValue <= endSearched) )
				{
					endIndex = i;
					if((endSearched == actualValue))
					{
						foundedEnd = true;						
					}
				}			
			}						
			if(actualValue>=startSearched && actualValue<=endSearched)
			{
				if(startSearched<endSearched)
					theInputQueue.push_back(colorPoint);
			}
		}			
	}

	pColorPoint * LogicalColorBar :: getLastAddedPoint()
	{
		return lastAddedPoint;
	}

	pColorPoint * LogicalColorBar :: getPointAtIndex(int anIndex)
	{
		if(anIndex>=0 && logicColorPoints.size()>anIndex)
			return logicColorPoints[anIndex];
		else
			return NULL;
	}

	
	int LogicalColorBar :: getCount()
	{
		return logicColorPoints.size();
	}

	void LogicalColorBar :: getDataAt(int index, double &x,int &red,int &green,int &blue)
	{
		pColorPoint * colorPoint = logicColorPoints[index];		
		wxColour color = colorPoint->getColor();
		red = color.Red();
		blue = color.Blue();
		green = color.Green();
		x = colorPoint->getRealX();
	}

	void LogicalColorBar :: clearPoints()
	{	
		logicColorPoints.clear();
	}

	double LogicalColorBar :: getMinAddedValue()
	{
		return logicColorPoints.front()->getRealX();		
	}

	double LogicalColorBar :: getMaxAddedValue()
	{
		return logicColorPoints.back()->getRealX();
	}

	void LogicalColorBar :: changeColor(double pointValue, wxColour theNewColor)
	{
		bool changedCol = false;
		for(int i=0; i<logicColorPoints.size() && !changedCol; i++)
		{
			pColorPoint * aPoint = logicColorPoints[i];
			if(aPoint->getRealX() == pointValue)
			{
				aPoint->setColor( theNewColor );
				changedCol = true;
			}			
		}
	}

	bool LogicalColorBar :: setColorPoints (std::vector<pColorPoint *> pointsVector)
	{
		bool addedAll = true;
		for(int i=0; i<pointsVector.size() && addedAll; i++)
		{
			pColorPoint * aPoint  = pointsVector[i];
			addedAll &= addColorPoint(aPoint->getRealX(), aPoint->getColor());
		}
		if(addedAll)
		{
			minValue = getMinAddedValue();
			maxValue = getMaxAddedValue();
		}
		else
			logicColorPoints.clear();

		return addedAll;
	}
   
   
