/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __LOGICAL_COLOR_BAR__
#define __LOGICAL_COLOR_BAR__

// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include <vector>
#include <math.h>
#include <iostream>
#include <string>
#include <deque>
#include <vector>

#include "pColorPoint.h"

/** file LogicalColorBar.h */
class LogicalColorBar {

public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	LogicalColorBar ();

	~LogicalColorBar();

	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

	/*
	* Gets the first point
	*/
	pColorPoint * getFirstPoint();

	/*
	* Gets the last point
	*/
	pColorPoint * getLastPoint();

	double getMinValue();

	void  setMinValue(double valueMin);

	double getMaxValue();

	void setMaxValue(double valueMax);

	bool getOrientation();

	void setOrientation(bool orientation);

	bool addColorPoint(double xRealValue, wxColour theColour);

	bool deleteColorPoint ( double  valErase );

	//void getListIndexRangeLimits( int &startIndex, int &endIndex, int startSearched, int endSearched );
	
	void getPointersToRangeLimits( std::deque<pColorPoint *> &theInputQueue, int &startIndex, int &endIndex, int startSearched, int endSearched );

	pColorPoint * getLastAddedPoint();

	pColorPoint * getPointAtIndex(int anIndex);

	int getCount();

	void getDataAt(int index, double &x,int &red,int &green,int &blue);

	void clearPoints();

	double getMinAddedValue();

	double getMaxAddedValue();

	void changeColor(double pointValue, wxColour theNewColor);

	bool setColorPoints (std::vector<pColorPoint *> pointsVector);
//	
//private: 

	bool bar_orientation;

	//wxList	logicColorPoints;
	std::vector<pColorPoint * > logicColorPoints;

	pColorPoint * lastAddedPoint;

	double minValue;

	double maxValue;

	//DECLARE_CLASS(LogicalColorBar)
};	
#endif 



