/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "MaximumsDialog.h"

IMPLEMENT_CLASS(MaximumsDialog, wxDialog)

MaximumsDialog::MaximumsDialog(wxWindow *parent,wxString title)
:wxDialog(parent,-1,title,wxDefaultPosition,wxDefaultSize, wxDEFAULT_DIALOG_STYLE,_T("dialogBox"))
{
	/*
	 where the user can put the values of the maxX and maxY of the axes of the plotter
	*/
	m_maxX = new wxTextCtrl( this, -1, wxT(""));
    m_maxY = new wxTextCtrl( this, -1, wxT(""));

	/*
	* just labels
	*/
	maxX=new wxStaticText(this,-1,_T("Max X:"));
	maxY=new wxStaticText(this,-1,_T("Max Y:"));
	
	/*
	Buttons
	*/
	okBtn = new wxButton(this,wxID_OK ,_T("OK"));
	cancelBtn = new wxButton(this,wxID_CANCEL,_T("Cancel"));

	//BOXES
	//Upper Box
	wxBoxSizer * upper_box = new wxBoxSizer( wxHORIZONTAL );
	//Including components for plotter control
	upper_box->Add( maxX, wxSizerFlags().Border(wxALL,6));
	upper_box->Add( m_maxX, wxSizerFlags().Border(wxALL,6));
	upper_box->Add( maxY, wxSizerFlags().Border(wxALL,6));
	upper_box->Add( m_maxY, wxSizerFlags().Border(wxALL,6));
	

	//bottom Sizer
	wxBoxSizer *bottomBox = new wxBoxSizer( wxHORIZONTAL );
	bottomBox->Add( okBtn, wxSizerFlags().Center());
	bottomBox->AddSpacer(40);
	bottomBox->Add( cancelBtn,wxSizerFlags().Center() );

	// Adding the components to the sizer
	wxFlexGridSizer *sizer = new wxFlexGridSizer(1);
	sizer->Add( upper_box,0,wxALIGN_BOTTOM);
	//sizer->AddGrowableRow (1,1);
	sizer->Add( bottomBox,0,wxALIGN_CENTER);
    
	SetAutoLayout( TRUE );
    SetSizer( sizer );
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	SetBestSize(wxSize(325,100));
#else
	SetSize(wxSize(325,100));
#endif
}
//-----------------------------------------------------------------
float MaximumsDialog::getXValue()
{
	wxString mx=m_maxX->GetValue();
	if(mx.IsNumber())
	{
			return (float)atoi( (const char*)(mx.mb_str()) );
	}
	else
		return -1;
}
//----------------------------------------------------------------
float MaximumsDialog::getYValue()
{
	wxString my=m_maxY->GetValue();
	if(my.IsNumber())
	{
			return atof( (const char*) (my.mb_str()) );
	}
	else
		return -1;
}
//----------------------------------------------------------------



