 /*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file 
 *  \brief ClassThresholdImageViewPanel . 
 */

#include "mBarRange2.h"


DEFINE_EVENT_TYPE(wxEVT_BarRange2_Change)


/**
 ** Begin of the  panel
 **/
mBarRange2::mBarRange2(wxWindow* parent,int width, int height)
: wxPanel(parent, -1, wxDefaultPosition, wxSize(width,height), wxBORDER_SUNKEN)
{
	_minValue			= 0;
	_maxValue			= 100;
	_scalarType			= 0;
	_mBarRange			= new mBarRange(this,width,height);
	_mBarRange->SetOrientation( true );
	_mBarRange->setActiveStateTo(true);
	_mBarRange->setVisibleLabels( false );
	_mBarRange->setDeviceEndMargin(10);
	_mBarRange->setDeviceBlitStart(10,10); 
	_mBarRange->setIfWithActualDrawed( false );
	_mBarRange->setRepresentedValues( 0, 100 );
	_mBarRange->SetStart(0);
	_mBarRange->SetEnd(100);  
	_textctrlStart 	= new wxTextCtrl( this, -1, _T(""),wxDefaultPosition, wxSize(60,20),wxTE_PROCESS_ENTER );
	_textctrlEnd 		= new wxTextCtrl( this, -1, _T(""),wxDefaultPosition, wxSize(60,20),wxTE_PROCESS_ENTER );
	Connect( _textctrlStart->GetId(), wxEVT_COMMAND_TEXT_ENTER	, (wxObjectEventFunction) &mBarRange2::onTxtCtrl );
	Connect( _textctrlEnd->GetId(), wxEVT_COMMAND_TEXT_ENTER	, (wxObjectEventFunction) &mBarRange2::onTxtCtrl );
	wxFlexGridSizer * sizer					= new wxFlexGridSizer(1);
	wxFlexGridSizer * sizerTextCtrl		= new wxFlexGridSizer(2);
	sizerTextCtrl -> Add( _textctrlStart	, 1, wxGROW );	
	sizerTextCtrl -> Add( _textctrlEnd		, 1, wxGROW );	
	sizer -> Add( _mBarRange					, 1, wxGROW );	
	sizer -> Add( sizerTextCtrl				, 1, wxGROW );	
	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout();
	RefreshTextCntrl();
}

//----------------------------------------------------------------------------
mBarRange2::~mBarRange2()
{
}

//----------------------------------------------------------------------------
wxString mBarRange2::CleanNumberStr(wxString string)
{
	wxString tmpStr=string;
	while (tmpStr[tmpStr.Length()-1]=='0') 
	{
		tmpStr=tmpStr.SubString (0, tmpStr.Length()-1-1 );
	} //

	if (tmpStr[tmpStr.Length()-1]=='.')
	{
		tmpStr.Append(_T("0"));
	}
	return tmpStr;
}


//----------------------------------------------------------------------------
double mBarRange2::GetStartValue()
{
	return _startValue;
}

//----------------------------------------------------------------------------
double mBarRange2::GetEndValue()
{
	return _endValue;
}

//----------------------------------------------------------------------------
void mBarRange2::RefreshTextCntrl()
{
   double startPorcentage 	= _mBarRange->GetStart();
	double endPorcentage 	= _mBarRange->GetEnd();  
	_startValue 				= (_maxValue-_minValue)*(startPorcentage/100) + _minValue;
	_endValue 					= (_maxValue-_minValue)*(endPorcentage/100) + _minValue;

	wxString startValueStr;
	wxString endValueStr;

	if ( (_scalarType==10) || (_scalarType==11) )  // 10=VTK_FLOAT   11=VTK_DOUBLE  
	{
		startValueStr.Printf(_T("%f"),_startValue);
		startValueStr=CleanNumberStr( startValueStr );
		endValueStr.Printf(_T("%f"),_endValue);
		endValueStr=CleanNumberStr( endValueStr );
	} else {
		startValueStr.Printf(_T("%d"),(int)_startValue);	
		endValueStr.Printf(_T("%d"),(int)_endValue);
	}

	_textctrlStart->SetValue( startValueStr );
	_textctrlEnd->SetValue( endValueStr );	
}


//----------------------------------------------------------------------------
void mBarRange2::createAndSendEvent(WXTYPE theEventType)
{
	wxCommandEvent cevent( theEventType, GetId() );
	cevent.SetEventObject( this );
	GetEventHandler()->ProcessEvent( cevent );
}



//----------------------------------------------------------------------------
void mBarRange2::onBarRangeChange(wxCommandEvent& event)
{
	RefreshTextCntrl();
	createAndSendEvent( wxEVT_BarRange2_Change );
}

//----------------------------------------------------------------------------
void mBarRange2::onTxtCtrl(wxCommandEvent& event)
{
	double value;
	double startPorcentage;
	double endPorcentage;
	if (_textctrlStart->GetValue().ToDouble(&value)==true)
	{ 
		startPorcentage = (value - _minValue)*100/(_maxValue-_minValue);
		_mBarRange->SetStart( startPorcentage );
	} 

	if (_textctrlEnd->GetValue().ToDouble(&value)==true)
	{ 
		endPorcentage = (value - _minValue)*100/(_maxValue-_minValue);
		_mBarRange->SetEnd( endPorcentage );
	} 

	RefreshTextCntrl();		
}

//----------------------------------------------------------------------------
void mBarRange2::SetMinMaxValue(double min, double max)
{
	_minValue = min;
	_maxValue = max;
	RefreshTextCntrl();		
}


//----------------------------------------------------------------------------
void mBarRange2::SetScalarType(int value)
{
	_scalarType = value;
}



//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE(mBarRange2, wxPanel)
  EVT_COMMAND( wxID_ANY, wxEVT_TSBAR_START	, mBarRange2::onBarRangeChange	)
  EVT_COMMAND( wxID_ANY, wxEVT_TSBAR_END		, mBarRange2::onBarRangeChange	)
  EVT_COMMAND( wxID_ANY, wxEVT_TSBAR_MOVED	, mBarRange2::onBarRangeChange	)	
END_EVENT_TABLE()


// EOF

