/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//------------------------------------------------------------------------------------------------------------
// Class definition include
//------------------------------------------------------------------------------------------------------------
#include "pColorPoint.h"

// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//------------------------------------------------------------------------------------------------------------
// Class implementation
//------------------------------------------------------------------------------------------------------------

IMPLEMENT_CLASS(pColorPoint, wxObject)

//------------------------------------------------------------------------------------------------------------
// Constructors and destructors
//------------------------------------------------------------------------------------------------------------

/**
* Create a point of the function.
* @param x The x real value
* @param _color The asigned colour 
* @param isTemp The temporal o fixed asignation to the color
*/
pColorPoint :: pColorPoint(double  x , wxColour  col, bool isTemp)
{
	realX = x;
	colour = col;	
	isTemporal = isTemp;
}

pColorPoint :: ~pColorPoint()
{

}
//------------------------------------------------------------------------------------------------------------
// Methods implementation
//------------------------------------------------------------------------------------------------------------
/*
* Returns the x-value of the point
* @ realX
*/
double pColorPoint :: getRealX ()
{
	return realX;
}
/**
	* Returns the colour of the point
	* @retval colour
	*/
wxColor pColorPoint :: getColor ()
{
	return colour;
}

/**
* Indicates if the colour point is temporal or not
* @retval isTemporal
*/
bool pColorPoint :: isTemporalColor ()
{
	return isTemporal;
}


