/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "pFigure.h"

// ---------------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ---------------------------------------------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file pFigure.cxx */
IMPLEMENT_CLASS(pFigure, wxObject)

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	/**
	* Create a figure with edges_n edges
	* @param edges_n The number of edges of the new figure
	* @param _w The width to set
	* @param _h The height to set
	* @param _orientation The orientation to set
	*/
	pFigure :: pFigure(int edges_n, int _w, int _h, int _orientation, bool bar_orientation)
	{
		edges 		= edges_n;
		orientation = _orientation;
		width 		= _w;
		heigth		= _h;
		setBarOrientation( bar_orientation );
	}

	pFigure :: ~pFigure()
	{

	}

	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

	/**
	* Gets the number of edges of the figure
	* @retval edges Number of edges in the figure
	*/
	int pFigure :: getNumberEdges()
	{
		return edges;
	}

	/**
	* Sets the vertex points of the figure
	* @param edges Number of edges in the figure to set
	*/
	void pFigure :: setNumberEdges(int n_edges)
	{
		edges = n_edges;
	}

	/**
	* Gets the vertex points of the figure
	* @param wxPoint The vector to get the points
	* @retval points Vertex points distribution in the figure
	*/
	void pFigure :: getVertexPoints(wxPoint thePoints[])
	{
		if (edges == TRIANGLE)
		{
			int halfWidth = 0;
			int halfHeigth = 0;
			if ( barOrientation ) // HORIZONTAL
			{
				halfWidth = (int)(width/2);
				halfHeigth = (int)(heigth/2);
				switch ( orientation ) 
				{
				  case UP : 
					thePoints[0].x = halfWidth;
					thePoints[0].y = 0;
					thePoints[1].x = width;
					thePoints[1].y = heigth;
					thePoints[2].x = -halfWidth;
					thePoints[2].y = heigth;
					break;
					
				  case DOWN : 
					thePoints[0].x = halfWidth;
					thePoints[0].y = heigth;
					thePoints[1].x = width;
					thePoints[1].y = 0;
					thePoints[2].x = -halfWidth;
					thePoints[2].y = 0;
					break;

				  case LEFT : 
					thePoints[0].x = 0;
					thePoints[0].y = halfHeigth;
					thePoints[1].x = width;
					thePoints[1].y = 0;
					thePoints[2].x = width;
					thePoints[2].y = heigth;
					break;

				  case RIGHT : 		
					thePoints[0].x = width;
					thePoints[0].y = halfHeigth;		
					thePoints[1].x = 0;
					thePoints[1].y = 0;
					thePoints[2].x = 0;
					thePoints[2].y = heigth;
					break;
				}			
			}
			else // VERTICAL
			{
				halfWidth = (int)(heigth/2);
				halfHeigth = (int)(width/2);
				switch ( orientation ) 
				{
				  case UP : 
					thePoints[0].x = halfWidth;
					thePoints[0].y = 0;
					thePoints[1].x = heigth;
					thePoints[1].y = width;
					thePoints[2].x = -halfWidth;
					thePoints[2].y = width;
					break;
					
				  case DOWN : 
					thePoints[0].x = halfWidth;
					thePoints[0].y = width;
					thePoints[1].x = heigth;
					thePoints[1].y = 0;
					thePoints[2].x = -halfWidth;
					thePoints[2].y = 0;
					break;

				  case LEFT : 
					thePoints[0].x = 0;
					thePoints[0].y = halfHeigth;
					thePoints[1].x = heigth;
					thePoints[1].y = -halfHeigth;
					thePoints[2].x = heigth;
					thePoints[2].y = width;
					break;

				  case RIGHT : 		
					thePoints[0].x = heigth;
					thePoints[0].y = halfHeigth;		
					thePoints[1].x = 0;
					thePoints[1].y = -halfHeigth;
					thePoints[2].x = 0;
					thePoints[2].y = width;
					break;
				}	
			}				
		}
		else if (edges == RECTANGLE)
		{
			if ( barOrientation ) // HORIZONTAL
			{
				thePoints[0].x = 0;
				thePoints[0].y = 0;		
				thePoints[1].x = width;
				thePoints[1].y = 0;
				thePoints[2].x = width;
				thePoints[2].y = heigth;
				thePoints[3].x = 0;
				thePoints[3].y = heigth;
			}
			else // VERTICAL
			{
				thePoints[0].x = 0;
				thePoints[0].y = 0;		
				thePoints[1].x = heigth;
				thePoints[1].y = 0;
				thePoints[2].x = heigth;
				thePoints[2].y = width;
				thePoints[3].x = 0;
				thePoints[3].y = width;
			}
		}
	}

	/**
	* Sets the vertex points of the figure
	* @param edges Vertex points distribution in the figure to set
	*/
	void pFigure :: setVertexPoints(wxPoint * n_points)
	{
		v_points = n_points;
	}

	/*
	* Sets the heigth of the figure
	* @param _h The heigth to set
	*/
	void pFigure :: setHeigth(int _h)
	{
		heigth = _h;
	}

	/*
	* Gets the heigth of the figure
	* @retval heigth The heigth of the figure
	*/
	int pFigure :: getHeigth()
	{
		return heigth;
	}

	/*
	* Sets the width of the figure
	* @param _w The width to set
	*/
	void pFigure :: setWidth(int _w)
	{
		width = _w;
	}

	/*
	* Gets the width of the figure
	* @retval width The width of the figure
	*/
	int pFigure :: getWidth()
	{
		return width;
	}

	/*
	* Indicates if a pixel point is inside the figure
	* @param xFig_PixelPoint The known reference point inside the figure
	* @param xPixel The x-pixel coord asking for
	* @retval Returns true if the point is inside
	*/
	bool pFigure :: isPointInside(int xFig_PixelPoint, int xPixel)
	{
		bool isInside = false;

		if (edges == TRIANGLE)
		{
			int halfWidth = (int)(width/2)+1;
			int halfHeigth = (int)(heigth/2)+1;
			if ( orientation == UP || orientation == DOWN )
			{
				isInside = (xPixel>=xFig_PixelPoint-halfWidth) && (xPixel<=xFig_PixelPoint+halfWidth);
			}
			else if( orientation == LEFT || orientation == RIGHT )
			{
				isInside = (xPixel>=xFig_PixelPoint-halfHeigth) && (xPixel<=xFig_PixelPoint+halfHeigth);
			}						
		}
		else if (edges == RECTANGLE)
		{
			isInside = (xPixel >= xFig_PixelPoint) && (xPixel<=xFig_PixelPoint+width);
		}
		return isInside;
	}

	/*
	* Sets the bar orientation 
	* @ bar_orientation The orientation to set (true for horizontal, false for vertical)
	*/
	void pFigure :: setBarOrientation(bool bar_orientation)
	{
		barOrientation = bar_orientation;
	}

	/*
	* Sets the bar orientation used for triangles
	* @ bar_orientation The orientation to set (LEFT = -4, RIGHT = -6, UP = -8, DOWN = -2)
	*/
	void pFigure :: setFigureOrientation(int fig_orientation)
	{
		orientation = fig_orientation;
	}




