/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------
#include "pFunctionPoint.h"

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

IMPLEMENT_CLASS(pFunctionPoint, wxObject)

//----------------------------------------------------------------------------
// Constructors
//----------------------------------------------------------------------------
/**
* Create a point of the function.
* @param x The x value
* @param y The y value
*/
pFunctionPoint :: pFunctionPoint(int  x , int  y ) 
{
	realX = x;
	realY = y;
	hasColorForLevel = false;
}
//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------
/*
* Returns the x-value of the point
* @ realX
*/
int pFunctionPoint ::getRealX ()
{
	return realX;
}
/**
* Returns the x-value of the point
* @ realY
*/
int pFunctionPoint :: getRealY ()
{
	return realY;
}
/*
* Sets the state of having an asigned color
*/
void  pFunctionPoint :: setHasColor (bool hasColor)
{
	hasColorForLevel = hasColor;
}
/*
* Indicates if the point has an asigned color for the level 
*/
bool  pFunctionPoint :: getHasColorForLevel()
{
	return hasColorForLevel;
}


