/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------

#include "pHistogram.h"
//#include "vtkJPEGReader.h"
#include "vtkImageData.h"
#include "vtkImageCast.h"
#include "vtkComputeHistogram2DOutliers.h"
#include "vtkTable.h"


#include <iostream>
#include <fstream>
#include <string>
#include <vector>

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

/*
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
*/
//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

//IMPLEMENT_CLASS(pHistogram, wxObject)

//----------------------------------------------------------------------------
// Constructors
//----------------------------------------------------------------------------
pHistogram::pHistogram(std::string filePath)
{
	path			= filePath;
	points		= vtkImageData::New();
	size			= 100;
	sizeImage	= 0;
	buildHistogram();
}

pHistogram::pHistogram(vtkImageData* imageData)
{
	points		= vtkImageData::New();
	size			= 100;
	sizeImage	= 0;
	buildHistogram(imageData);
}

//----------------------------------------------------------------------------
pHistogram::~pHistogram()
{
	if(points!=NULL)points->Delete();
}

//----------------------------------------------------------------------------
void pHistogram::setImagePath(std::string filePath)
{
	path=filePath;
}

//----------------------------------------------------------------------------
void pHistogram::buildHistogram()
{
	/*
		reader: is the reader of the image
		histogramVector:Is the image data of the original image
		imageData: vtkImageData of the image that we are reading
		range :it has the (min/max) range of the levels of grey
	*/
	points= vtkImageData::New();
	vtkMetaImageReader *reader = vtkMetaImageReader::New();
	vtkImageData* imageData=NULL;
	double range[2];
	
	//reading
	reader->SetFileName(path.c_str());
	reader->Update();

	
	// getting the data 
	imageData=reader->GetOutput();
	imageData->GetScalarRange(range);
	initializePoints(size);
	setPoints(imageData);
}

/*
Calculate the histogram and save it in the attribute points
it is used if the user had given the imageData
Pre: Size had to be setted if the user wants
another value that 100
*/
void pHistogram::buildHistogram(vtkImageData* imageData)
{
	initializePoints(size);
	setPoints(imageData);	
}

/*
  getting ready the points
*/
void pHistogram::initializePoints(int xDimension)
{
	//setting image data of the points
	points->SetDimensions(xDimension,1,1);
//EED	points->SetScalarTypeToUnsignedShort();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	points->SetScalarTypeToDouble();
	points->AllocateScalars();
	points->Update();
#else
	points->AllocateScalars(VTK_DOUBLE,1);
#endif

}

/*
	 constructing the histogram
*/
void pHistogram::setPoints(vtkImageData* imageData)
{

/*
printf("EED pHistogram::setPoints Test: vtkPComputeHistogram2DOutliers\n");
vtkComputeHistogram2DOutliers *vtkhist = vtkComputeHistogram2DOutliers::New();
vtkhist->SetPreferredNumberOfOutliers(10);
vtkhist->SetInput(imageData);
vtkTable *resulttable = vtkhist->GetOutputTable();

printf("EED pHistogram::setPoints rows:%d\n", (int)(resulttable->GetNumberOfRows()) );
printf("EED pHistogram::setPoints colums:%d\n", (int)(resulttable->GetNumberOfColumns()) );
*/

	/*
		Pointers
	*/

	char* 				dataImagePointerC		= (char*)imageData->GetScalarPointer(0,0,0);
	unsigned char* 		dataImagePointerUC		= (unsigned char*)imageData->GetScalarPointer(0,0,0);
	short* 				dataImagePointerS		= (short*)imageData->GetScalarPointer(0,0,0);
	unsigned short* 	dataImagePointerUS		= (unsigned short*)imageData->GetScalarPointer(0,0,0);
	float* 				dataImagePointerF		= (float*)imageData->GetScalarPointer(0,0,0);
	double* 			dataImagePointerD		= (double*)imageData->GetScalarPointer(0,0,0);
	double* 			dataHistogramPointer	= (double*)points->GetScalarPointer(0,0,0);
	
	/*
	 Range of greys
	*/
	double range[2];
	if(imageData==NULL)
	{
		range[1] = 1;
	} else {
		imageData->GetScalarRange(range);
	} // imageData

	/*
	 Setting the  minimun and maximum levels of grey
	*/
	maxLevelOfGrey = range[1];
	minLevelOfGrey = range[0];
	//std::cout<<"maxLevelOfGrey "<<maxLevelOfGrey<<" minLevelOfGrey "<<minLevelOfGrey<<std::endl;
	/*
	 Image Size
	*/
	int ext[6];
	imageData->GetExtent(ext);
	int sx,sy,sz;
	sx = ext[1]-ext[0]+1;
	sy = ext[3]-ext[2]+1;
	sz = ext[5]-ext[4]+1;

	sizeImage=sx*sy*sz;

	int i;
	/*
	  getting ready the histogram
	*/
	for(i=0;i<size;i++)
	{
		dataHistogramPointer[i]=0;
	}
	
	long int j=0;


	if (imageData->GetScalarType()==VTK_CHAR)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerC);
			dataImagePointerC++;
			dataHistogramPointer[j]++;
		}  // for i
	} //  CHAR

	if (imageData->GetScalarType()==VTK_UNSIGNED_CHAR)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerUC);
			dataImagePointerUC++;
			dataHistogramPointer[j]++;
		}  // for i
	} // UNSIGNED CHAR


	if (imageData->GetScalarType()==VTK_SHORT)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerS);
			dataImagePointerS++;
			dataHistogramPointer[j]++;
		}  // for i
	} // SHORT

	if (imageData->GetScalarType()==VTK_UNSIGNED_SHORT)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerUS);
			dataImagePointerUS++;
			dataHistogramPointer[j]++;
		}  // for i
	} // UNSIGNED SHORT


	if (imageData->GetScalarType()==VTK_FLOAT)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerF);
			dataImagePointerF++;
			dataHistogramPointer[j]++;
		}  // for i
	} // FLOAT


	if (imageData->GetScalarType()==VTK_DOUBLE)
	{
		for(i=0;i<sizeImage;i++)
		{
			j=getIndex(*dataImagePointerD);
			dataImagePointerD++;
			dataHistogramPointer[j]++;
		}  // for i
	} // DOUBLE

}


/*
Returns the poins of the histograms
*/
vtkImageData* pHistogram::getHistogram()
{
	return points;
}

/*
hash por getting the index for the histogram vector of the original
image
@gValue: Level of grey for which wants the index in the histogrram
*/
int pHistogram::getIndex(double gValue)
{
	double p;
	double diff=maxLevelOfGrey-minLevelOfGrey;
	if (diff!=0)
	{
		p=((double)gValue-minLevelOfGrey)/(maxLevelOfGrey-minLevelOfGrey);
	} else {
		p=0;
	}
	double k=p*(size-1);
	//std::cout<<"gValue "<<gValue<<" k "<<k<<std::endl;
	return (int)k;
}
/*
Setting the size
*/
void pHistogram::setSize(int nSize)
{
	size=nSize;
}
/*
	Get Image Size
*/
int pHistogram::getImageSize()
{ 
	return sizeImage;
}
/*
	Get Size of the histogram
*/
int pHistogram::getSize()
{
	return size;
}
/*
	Get the maximum value of grey of the histogram
*/
int pHistogram::getMaximumLevelOfGrey()
{
	return maxLevelOfGrey;
}
/*
	Get the minimum value of grey of the histogram
*/
int pHistogram::getMinimumLevelOfGrey()
{
	return minLevelOfGrey;
}
/*
		get a point of the Histogram
		given the grey value
*/
int pHistogram::getHistogramPoint(int gValue)
{
	//double p=((float)gValue-minLevelOfGrey)/(maxLevelOfGrey-minLevelOfGrey); // JPRx
	//double k=p*size;

	double* dataHistogramPointer = dataHistogramPointer=(double*)points->GetScalarPointer(0,0,0);
	return dataHistogramPointer[gValue];
}


