/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//---------------------------------------------------------------------------------------------
// Class definition include
//---------------------------------------------------------------------------------------------
#include "pPlotter.h"

// --------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// --------------------------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//---------------------------------------------------------------------------------------------
// Class implementation
//---------------------------------------------------------------------------------------------

IMPLEMENT_CLASS(pPlotter, wxPanel)

//------------------------------------------------------------------------------------------------------------
// Generated events declaration and definition
//------------------------------------------------------------------------------------------------------------
BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( wxEVT_NW_TEXT_MESAGGE, -1 )	
END_DECLARE_EVENT_TYPES()

DEFINE_EVENT_TYPE( wxEVT_NW_TEXT_MESAGGE )

// ----------------------------------------------------------------------------------------------------
// Handdled events from pColorBar
// ----------------------------------------------------------------------------------------------------
DECLARE_EVENT_TYPE(wxEVT_ADDED_POINT, -1)
DECLARE_EVENT_TYPE(wxEVT_REMOVED_POINT, -1)
DECLARE_EVENT_TYPE(wxEVT_MOVED_POINT, -1)
DECLARE_EVENT_TYPE(wxEVT_CHANGED_POINT, -1)
DECLARE_EVENT_TYPE(wxEVT_ON_COLOR_BAR, -1)

// ----------------------------------------------------------------------------------------------------
// Handdled events from plotter
// ----------------------------------------------------------------------------------------------------
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_CHANGED_FUNCTION, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_MOVE, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_ADD, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_DELETE, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_GUIDELINES, -1)

// ----------------------------------------------------------------------------------------------------
// Handdled events from max-min barrange
// ----------------------------------------------------------------------------------------------------
DECLARE_EVENT_TYPE(wxEVT_TSBAR, -1)
DECLARE_EVENT_TYPE(wxEVT_TSBAR_ACTUAL, -1)
DECLARE_EVENT_TYPE(wxEVT_TSBAR_START, -1)
DECLARE_EVENT_TYPE(wxEVT_TSBAR_END, -1)
DECLARE_EVENT_TYPE(wxEVT_TSBAR_MOVED, -1)
DECLARE_EVENT_TYPE(wxEVT_SELECTION_END, -1)


// ----------------------------------------------------------------------------------------------------
// EVENT TABLE (->Connect: analogous)
//-----------------------------------------------------------------------------------------------------
BEGIN_EVENT_TABLE(pPlotter, wxPanel)
	//OnSize
	//EVT_SIZE  (pPlotter::OnSize)
	
	// Connectting the handled envents for the plotter to the corresponding methods
	EVT_COMMAND  (-1,wxEVT_PPLOTTER_CHANGED_FUNCTION, pPlotter::onChangeFunction)
	EVT_COMMAND  (-1,wxEVT_PPLOTTER_POINT_MOVE, pPlotter::onMovePoint_Plotter)
	EVT_COMMAND  (-1,wxEVT_PPLOTTER_POINT_ADD, pPlotter::onAddedPoint_Plotter)
	EVT_COMMAND  (-1,wxEVT_PPLOTTER_POINT_DELETE, pPlotter::onRemovedPoint_Plotter)
	EVT_COMMAND  (-1,wxEVT_PPLOTTER_GUIDELINES, pPlotter::onGuideLines)

	// Connectting the handled envents for the color bar  to the corresponding methods
    EVT_COMMAND  (-1,wxEVT_ADDED_POINT, pPlotter :: onAdded_ColorPoint )
	EVT_COMMAND  (-1,wxEVT_REMOVED_POINT, pPlotter :: onRemoved_ColorPoint )
	EVT_COMMAND  (-1,wxEVT_MOVED_POINT, pPlotter :: onMoved_ColorPoint )
	EVT_COMMAND  (-1,wxEVT_CHANGED_POINT, pPlotter :: onChanged_ColorPoint )
	EVT_COMMAND  (-1,wxEVT_ON_COLOR_BAR, pPlotter :: onColorBar )

	// Connectting the handled envents from the max-min barrange  to the corresponding methods
  	EVT_COMMAND  (-1,wxEVT_TSBAR, pPlotter::onBarrange)
	EVT_COMMAND  (-1,wxEVT_SELECTION_END, pPlotter::onSelectionEnd)
	EVT_COMMAND  (-1,wxEVT_TSBAR_MOVED, pPlotter::onMovedBar)
	EVT_COMMAND  (-1,wxEVT_TSBAR_ACTUAL, pPlotter:: onActualChange_Bar)
	EVT_COMMAND  (-1,wxEVT_TSBAR_START, pPlotter::onStartChange_Bar)
	EVT_COMMAND  (-1,wxEVT_TSBAR_END, pPlotter::onEndChange_Bar)

END_EVENT_TABLE()


//---------------------------------------------------------------------------------------------
// Constructors & Destructors
//---------------------------------------------------------------------------------------------
	/*
	* Creates an integrated plotter instance 
	* @param *parent Container window
	*/
	pPlotter :: pPlotter  (wxWindow *parent,int nWidth, int nHeight)
	:wxPanel(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL)
	{
		SetBackgroundColour(wxColour(255,255,255));
		m_plot = new pPlotterWindow( this, -1, wxPoint(0,0), wxSize(nWidth,nHeight), wxSUNKEN_BORDER );
		actualFunction =NULL;
		// Adding the axis layers to the plotter
		m_plot->AddLayer( new pPlotterScaleX() );
		m_plot->AddLayer( new pPlotterScaleY() );  

		// Creating the log window
	/*
	   
		m_log = new wxTextCtrl( panel, -1, wxT("This is the log window.\n"), wxPoint(0,0), wxSize(400,100), wxTE_MULTILINE );
		// Sharing the log window of the application with the plotter widget	
		m_plot->setmLog(m_log);
		
		*/


		// Creating a function for the plotter with given points x-vector and y-vector

		/*
		double vectX_F1 [] = { 0, 20, 50, 80, 100, 115, 120, 210, 220,250 };

		
//		double vectX_F1 [] = { 0, 20, 50, 80, 100, 115, 120, 210, 220,250 };

		double vectY_F1 [] = { 0, 40, 70, 100, 200, 100, 40, 170, 0, 50  };
		pGraphicalFunction * f1 = m_plot ->getFunctionForVectors( vectX_F1, 10, vectY_F1, 10 ); 
		// Including and drawing the created function in the plotter
		if (f1)
		{
			m_plot->addFunction( f1 );
			m_plot->addFunctionToMove(f1);
			//m_plot->addFunctionToMove(f1);
			wxPen mypen1(*wxBLUE, 2, wxDOT_DASH );
			mypen1.SetWidth(2);
			f1->SetPen( mypen1 );
		}
		*/
		
		//=================== lines to sychronyze the bars width with the drawed plotter--------------------------

		mpWindow* mplotWindow = ((mpWindow*)m_plot);
		float minReal_X = 0; //(float)mplotWindow->getMinScrX();
		float maxReal_X =(float)mplotWindow->getMaxScrX();
		//float scrX=(float)mplotWindow->GetScrX()-100; // JPRx
		//double scaleX=(scrX/(maxReal_X))* (mplotWindow->getZoomFactor()); // JPRx
			
		// Creating the color bar with values according to the plotter added widget
		color_bar = new pColorBar(this, (m_plot->GetSize()).GetWidth(),40, true);
		color_bar -> setRepresentedValues ((int)minReal_X, (int)maxReal_X);
		color_bar -> setDeviceBlitStart (70,0);
		color_bar -> setVisibleRange ((int)minReal_X,(int) maxReal_X);
		color_bar -> setDeviceEndMargin (50);
		
		
		// Creating the min-max barrange bar with values according to the plotter added widget
		barrange = new mBarRange(this, (m_plot->GetSize()).GetWidth(),30);
		barrange -> setVisibleLabels (false);
		barrange -> setRepresentedValues (minReal_X, maxReal_X);
		barrange -> setDeviceBlitStart (70,0);
		barrange -> setDeviceEndMargin (50);

		// Adding the components to the sizer 
		/*
		if(m_plot->getActualFunction())
			setAll();
		*/	
		wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
		sizer->Add( m_plot, 4, wxEXPAND);	
		sizer->Add( color_bar,0, wxEXPAND );
		sizer->Add( barrange, 0, wxEXPAND );

		// sizer->Add( m_log, 0, wxEXPAND);
		
		// Stablishing the layout and sizer of the panel
		/*panel->*/SetAutoLayout(true);
		/*panel->*/SetSizer(sizer);
		/*panel->*/Layout();

		/*panel->*/Refresh();
	}


	pPlotter :: ~pPlotter ()
	{	
		
		
	}

//---------------------------------------------------------------------------------------------
// Methods
//---------------------------------------------------------------------------------------------
/*
Set the bars according to the actual function 
*/

void pPlotter::setAll()
{
	actualFunction = m_plot->getActualFunction();
	if (actualFunction != NULL)
	{
		barrange -> setActiveStateTo(true);
		color_bar -> setActiveStateTo(true);
		text.Clear();
		text = _T("minX=");
		double realMin_X = actualFunction->getMinX();
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		text = text + realMin_X;	
#else
		text = text + wxString::FromDouble( realMin_X );	
#endif
		text = text + _T(" maxX=");
		double realMax_X = actualFunction->getMaxX();
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		text = text + realMax_X;
#else
		text = text + wxString::FromDouble( realMax_X );	
#endif
		int minShowed = actualFunction->getMinXShowed();
		int maxShowed = actualFunction->getMaxXShowed();
		barrange -> setRepresentedValues (realMin_X, realMax_X);
		barrange->SetStart( minShowed );
		barrange->SetEnd( maxShowed );
		std::vector<pColorPoint *> actualColorPoints;
		actualFunction->getColorPoints(actualColorPoints);
		if(actualColorPoints.empty())
		{
			color_bar->reinitiateColorBar (realMin_X, realMax_X);
		} else {
			color_bar->reinitiateColorBarTo(actualColorPoints);
		}
		color_bar->setVisibleRange (minShowed, maxShowed);
		// Refresh
		color_bar->RefreshForce();
		barrange->RefreshForce();	
		sendTMessage(text);
	} // if actualFunction
}

	
//*****************************************************************************************************
// Color bar control methods
//*****************************************************************************************************

//-----------------------------------------------------------------------------------------------------
// Updating methods for occured events in the color bar
//-----------------------------------------------------------------------------------------------------
void  pPlotter::onAdded_ColorPoint(wxCommandEvent& event)
{
	text.Clear();
	text = _T( "Last event was on color bar: Color point added, total#");
	actualFunction = m_plot->getActualFunction();
	if(actualFunction!=NULL)
	{		
		std::vector<pColorPoint *> actualColorPoints;
		color_bar ->getAddedColorsPointsList(actualColorPoints);
		actualFunction -> setColorPoints(actualColorPoints);
		text << actualColorPoints.size();
		sendTMessage(text);
	}
}

void  pPlotter :: onRemoved_ColorPoint(wxCommandEvent& event)
{	
	text.Clear();
	text = _T( "Last event on color bar: Color point removed total#");
	actualFunction = m_plot->getActualFunction();
	std::vector<pColorPoint *> actualColorPoints;
	color_bar ->getAddedColorsPointsList(actualColorPoints);
	actualFunction -> setColorPoints(actualColorPoints);
	text << actualColorPoints.size();
	sendTMessage(text);
}

void  pPlotter :: onMoved_ColorPoint(wxCommandEvent& event)
{
	text.Clear();
	text = _T( "Last event was on color bar: Color point moved to: ");
	int lastReal_X = (int)(color_bar->getLastMovedColorPoint())->getRealX();
	text << lastReal_X;
	barrange ->setRealX_vertical_line (lastReal_X);
	barrange -> RefreshForce();
	m_plot->setRealGuideX (lastReal_X);
	m_plot->UpdateAll();
	sendTMessage(text);
}

void  pPlotter:: onChanged_ColorPoint(wxCommandEvent& event)
{
  	text.Clear();
	sendTMessage(_T("Last event was on color bar: Color point changed color"));
}

void pPlotter :: onColorBar( wxCommandEvent& event )
{
	if( (barrange->getRealX_vertical_line())!=-1)
	{
		barrange ->setRealX_vertical_line (-1);	
		m_plot->setRealGuideX (-1);

		barrange -> RefreshForce();
		m_plot->UpdateAll();
	}
}

//*****************************************************************************************************
// Plotter control methods
//*****************************************************************************************************


/*
* Method called when actual function is changed
*/
void pPlotter :: onChangeFunction (wxCommandEvent& event)
{
	actualFunction = m_plot->getActualFunction();
	
	if (actualFunction != NULL)
	{
		if( !barrange->isActive() )
		{
			barrange -> setActiveStateTo(true);
			color_bar -> setActiveStateTo(true);
		}

		text.Clear();
		text = _T("Last event was on plotter: function changed, minX=");
		double realMin_X = actualFunction->getMinX();
		text << realMin_X;	
		text << _T(" maxX=");
		double realMax_X = actualFunction->getMaxX();
		text << realMax_X;

		int minShowed = actualFunction->getMinXShowed();
		int maxShowed = actualFunction->getMaxXShowed();

		barrange -> setRepresentedValues (realMin_X, realMax_X);
		barrange->SetStart( minShowed );
		barrange->SetEnd( maxShowed );
		
		std::vector<pColorPoint *> actualColorPoints;
		actualFunction->getColorPoints(actualColorPoints);
		if(actualColorPoints.empty())
		{
			color_bar->reinitiateColorBar (realMin_X, realMax_X);
		} else {
			color_bar->reinitiateColorBarTo(actualColorPoints);
		}
		color_bar->setVisibleRange ((int)realMin_X, maxShowed);
		
		// Refresh
		color_bar->RefreshForce();
		barrange->RefreshForce();	
		
		sendTMessage(text);
	} // if actualFunction
}


/*
* Method called when a point is added to the actual function on the plotter
*/

void pPlotter :: onAddedPoint_Plotter (wxCommandEvent& event)
{
	text.Clear();
	m_plot->writeInText(text);
	sendTMessage(text);
}

/*
* Method called when a point is removed to the actual function on the plotter
*/
void pPlotter :: onRemovedPoint_Plotter (wxCommandEvent& event)
{
	text.Clear();
	m_plot->writeInText(text);
	sendTMessage(text);	
}

/*
* Method called when a point is moved from the actual function on the plotter
*/
void pPlotter :: onMovePoint_Plotter (wxCommandEvent& event)
{
	text.Clear();
	m_plot->writeInText(text);
	sendTMessage(text);
}
/*
* Method called when turn off the guide line from the actual function on the plotter
*/
void pPlotter::onGuideLines(wxCommandEvent& event)
{
		
}



//*****************************************************************************************************
// Max-Min Barrange control methods
//*****************************************************************************************************
/*
*
*/
void  pPlotter::onBarrange(wxCommandEvent& event)
{
		
}
/*
*
*/
void  pPlotter::onActualChange_Bar(wxCommandEvent& event)
{
	int lastActual_X = barrange->GetActual();
	
	color_bar ->setRealX_vertical_line (lastActual_X);
	color_bar -> RefreshForce();	

	m_plot->setRealGuideX(lastActual_X);
	m_plot->UpdateAll();

	text.Clear();
	text = _T( "Last event was on min-max bar: Actual triangle moved to: " );
	text << lastActual_X;
	sendTMessage(text);
}

/*
* Method called when the start triangle is moved. Adjusts the plotter and color bar view-range.
*/
void  pPlotter::onStartChange_Bar(wxCommandEvent& event)
{
	text.Clear();
    
	text = _T( "Last event was on min-max bar: Start triangle moved to: ");
	int realMin_X = barrange->GetStart();
	text += wxString::Format(_T("%d"), realMin_X);	
	double realMax_X = m_plot->getMaxScrX();
	
	color_bar -> setVisibleRange (realMin_X, (int)realMax_X);
	
	m_plot->actualizeViewRange(realMin_X, (int)realMax_X);
	
	//setting the plotter for draw the functions that
	//it has to move.
	
	float startP	=	(float)barrange->getStartShowPorcentage();
	float endP		=	(float)barrange->getEndShowPorcentage();
	m_plot->moveFunctions(startP,endP);
	
	//Updating
	color_bar -> RefreshForce();
	m_plot -> UpdateAll();
	sendTMessage(text);
}

void  pPlotter::onEndChange_Bar(wxCommandEvent& event)
{
	text.Clear();
	text += _T("Last event was on min-max bar: End  triangle moved to: ");
	int realMax_X 		= barrange->GetEnd();
	text += wxString::Format(_T("%d"),realMax_X);	
	double realMin_X 	= m_plot->getMinScrX();
	color_bar -> setVisibleRange ((int)realMin_X, realMax_X);
	m_plot->actualizeViewRange((int)realMin_X,realMax_X);
	float startP		= (float)barrange->getStartShowPorcentage();
	float endP			= (float)barrange->getEndShowPorcentage();
	m_plot->moveFunctions(startP,endP);
	color_bar -> RefreshForce();
	m_plot -> UpdateAll();
	sendTMessage(text);
}

void pPlotter :: onSelectionEnd(wxCommandEvent& event)
{
	if( (color_bar->getRealX_vertical_line())!=-1)
	{
		color_bar ->setRealX_vertical_line (-1);	
		m_plot->setRealGuideX (-1);

		color_bar -> RefreshForce();
		m_plot->UpdateAll();	
	}
}
void  pPlotter :: onMovedBar(wxCommandEvent& event)
{
	text.Clear();
	text = _T( "Last event was on min-max bar: Moved bar to min:" );
	
	int realMin_X = barrange->GetStart();
	text +=  wxString::Format(_T("%d"),realMin_X);	
	text +=  _T(" max:");

	int realMax_X = barrange->GetEnd();
	text +=  wxString::Format(_T("%d"),realMax_X);

	color_bar -> setVisibleRange (realMin_X, realMax_X);
	
	float startP=(float)barrange->getStartShowPorcentage();
	float endP=(float)barrange->getEndShowPorcentage();
	m_plot->moveFunctions(startP,endP);
	
	color_bar -> RefreshForce();
	m_plot -> UpdateAll();

	sendTMessage(text);
}

/*
	* Method for sending a text message to the container window
	* @param theText Is the text of the message
	*/
void pPlotter :: sendTMessage(wxString theText)
{
	//Creating a message event 
	wxCommandEvent puntualMSG_Event( wxEVT_NW_TEXT_MESAGGE, GetId() );
	puntualMSG_Event.SetEventObject(this);
	//Sending the event
	GetEventHandler()->ProcessEvent( puntualMSG_Event );
}

/*
	* Sets the text message
	* @param nMessage Is the text message to set
	*/
	void pPlotter :: setTextMessage(wxString nMessage)
	{
		text = nMessage;
	}

	/*
	* Gets the text message
	* @param text Is the actual text message 
	*/
	wxString pPlotter :: getTextMessage()
	{
		return text;
	}
	/**
	* Add a function to the plotter
	* when the function doesnt come from window
	*/
	int pPlotter:: addFunction(pGraphicalFunction * function)
	{
		return m_plot->addFunction(function);  
	}
	/**
	* Creates and returns a graphical funcion according to the indicated vectors.
	*/
	pGraphicalFunction* pPlotter::getFunctionForVectors( double* vectorX, int sizeX,double * vectorY, int sizeY )
	{
		return m_plot->getFunctionForVectors(vectorX,sizeX, vectorY, sizeY );
	}
		/*
	 Set Type
	*/
	void pPlotter::setType(int t)
	{
		m_plot->setType(t);
	}
	/*
	 Get a function in the plotter given the index
	*/
	pGraphicalFunction* pPlotter:: getFunction(int index)
	{
		return m_plot->getFunction(index);
	}
	/*
	 Adds  function to move with the bar min max
	*/
	int pPlotter::addFunctionToMove(pGraphicalFunction * function)
	{
		return m_plot->addFunctionToMove(function);
	}
	
	/*
	  move the functions that the user wants to move
	  and that were setted in functionsToMove
	  @param porcentageMinX:the porcentage that the minShowed
	  of the funcntions have to be move
	  @param porcentageMaxX:the porcentage that the maxShowed
	  of the funcntions have to be move

	*/
	void pPlotter:: moveFunctions(float porcentageMinX,float porcentageMaxX)
	{
		m_plot->moveFunctions(porcentageMinX,porcentageMaxX);
	}
	/*
	* deletes the function from the plotter
	*/
	/*
	bool pPlotter::deleteFunction(pGraphicalFunction * function);
		{
			return m_plot->deleteFunction(function);

		}

	*/
	//--------------------
	// Color information
	//---------------------
	/**
		Returns the number of points that the bar color has
	*/
	int pPlotter::getColorPointsSize()
	{
		return color_bar->getColorPointsSize();
	}
	/*
	 Get the RGB values of the color point that is in the
	 index given
	*/
	void pPlotter::getBarColorDataAt(int index,double& x, int& red,int& green,int& blue)
	{
		color_bar->getDataAt(index,x,red,green,blue);
	}
	/*
	 add a color Point 
	 returns true if the point was succesfully added
	 PRE: 0<=red<=255 0<=green<=255 0<=blue<=255
	*/
	bool pPlotter::addColorPoint(int x,int red,int green, int blue)
	{
		wxColour color= wxColour(red,green,blue);
		return color_bar->addColorPoint((double)x, color);
	}
	void pPlotter::eraseColorPoints()
	{
		int min=(int)color_bar->getMinValue();
		int max=(int)color_bar->getMaxValue();
		color_bar->reinitiateColorBar(min,max);
	}

	//--------------------
	// bar Information
	//---------------------
	float pPlotter::getMaxShowedPorcentage()
	{
		return barrange->getEndShowPorcentage();
	}

	float pPlotter::getMinShowedPorcentage()
	{
		return barrange->getStartShowPorcentage();
	}

	float pPlotter::getActualShowedPorcentage()
	{
		return barrange->getActualShowPorcentage();
	}
	
	//--------------------
	// plotter Information
	//---------------------
	void pPlotter::setActual(pGraphicalFunction* nActual)
	{
		m_plot->setActualFunction(nActual);
	}
	void pPlotter::update()
	{
		//if it is a plotter of histograms
		if(m_plot->getType()==2)
		{
			pGraphicalFunction* tf= m_plot->getActualFunction();
			if(tf->getType()==2)
			{
				tf->clearSplineVectors();
				tf->addSplinesPoints();
				tf->initializeSplineVectors();
			}
		}

		m_plot->UpdateAll();
	}
	//----------------------------
	//Handling Options Menu
	//----------------------------
	
	void pPlotter::setPopUpMenu(bool startD,bool stopD,bool smooth,bool line, bool zoomIn,
					  bool zoomOut,bool showPoints,bool noShowPoints,bool changeColor, bool addP,
					  bool delPoint,bool load,bool save)
	{
		m_plot->setPopUpMenu(startD, stopD, smooth, line,  zoomIn,
					   zoomOut, showPoints, noShowPoints, changeColor,  addP,
					   delPoint, load, save);
	}


	/*
		if the user resize the window	
	*/
	
	
	
	/*
	void pPlotter::OnSize( wxSizeEvent &WXUNUSED(event) )
	{
		int scrX,scrY;
		GetClientSize(&scrX,&scrY);
		m_plot->SetSize(scrX,scrY);
		
		
		pGraphicalFunction* actual=m_plot->getActualFunction();
		if(actual!=NULL)
		{		
			actual->setScreens(scrX,scrY);
			actual->setScales();
		}
		
		
	}
	*/
	

/**
**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
**/
void pPlotter::GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value, int histogramsize)
{
	if(actualFunction != NULL)
	{
		double* xval = actualFunction->getX_RealValues();
		double* yval = actualFunction->getY_RealValues();
		actualFunction->getScaleY();
		for(int i = 0; i < actualFunction->getSizePoints();i++)
		{
			greylevel.push_back(xval[i]);
			value.push_back(yval[i]/histogramsize);
		} // for
	} // if
}

/**
**	Returns two vectors, the grey level of the point and its value, the red, green
**	and blue value is between [0,1]
**/
void pPlotter::GetValuesColorPointsFunction(std::vector<double>& greylevel,
								std::vector<double>& red,
								std::vector<double>& green,
								std::vector<double>& blue)
{
	if(color_bar != NULL)
	{
		std::vector<pColorPoint*> colors;
      color_bar->getAddedColorsPointsList(colors);
		for(int i = 0; i < colors.size();i++)
		{
			pColorPoint* pcolor 	= colors[i];
			greylevel.push_back(pcolor->getRealX());
			wxColour colour 		= pcolor->getColor();
			double _red 			= (double)(colour.Red())/255.0;
			double _green 			= (double)(colour.Green())/255.0;
			double _blue 			= (double)(colour.Blue())/255.0;
			red.push_back(_red);
			green.push_back(_green);
			blue.push_back(_blue);
		} // for
	} // if
}




