/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __pPlotter_h__
#define __pPlotter_h__

// --------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// --------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------

#include "pColorBar.h"
#include "mBarRange.h"
#include "mathplot.h"
#include "pFunctionPoint.h"
#include "pGraphicalFunction.h"
#include "pPlotterLayer.h"
#include "pPlotterWindow.h"
#include "pPlotterScaleY.h"
#include "pPlotterScaleX.h"
#include <iostream>
#include <vector>

//-------------------------------------------------------------------------------------------------------------
// Enum declarations
//-------------------------------------------------------------------------------------------------------------
/** Command IDs used by pColorPoint */

//--------------------------------------------------------------------------------------------
// Class definition
//--------------------------------------------------------------------------------------------

/*
* Represents the integrated plotter that consists of the a drawing area, and control bars (min-max bar, degrade bar)
*/
/** @file pPlotter.h */
class pPlotter : public wxPanel{

public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	/*
	* Creates an integrated plotter instance 
	* @param *parent Container window
	*/
	pPlotter (wxWindow *parent,int nWidth, int nHeight);

	~pPlotter ();

    //----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------

	// Plotter received events	
	void		onChangeFunction (wxCommandEvent& event);
	void		onAddedPoint_Plotter (wxCommandEvent& event);
	void		onRemovedPoint_Plotter (wxCommandEvent& event);
	void		onMovePoint_Plotter (wxCommandEvent& event);
	void		onGuideLines (wxCommandEvent& event);

	// Color bar received events
	void		onAdded_ColorPoint ( wxCommandEvent& event );
	void		onRemoved_ColorPoint ( wxCommandEvent& event );
	void		onMoved_ColorPoint( wxCommandEvent& event );
	void		onChanged_ColorPoint( wxCommandEvent& event );
	void		onColorBar( wxCommandEvent& event );

	// Min-Max Barrange received events
	void         onBarrange(wxCommandEvent& event);
	void         onActualChange_Bar(wxCommandEvent& event);
	void         onStartChange_Bar(wxCommandEvent& event);
	void         onEndChange_Bar(wxCommandEvent& event);
	void         onSelectionEnd(wxCommandEvent& event);
	void         onMovedBar(wxCommandEvent& event);

	/*
	* Method for sending a text message to the container window
	* @param theText Is the text of the message
	*/
	void		 sendTMessage(wxString theText);

	// Other methods
	wxWindow*	initialize(wxWindow *parent);

	/*
	* Sets the text message
	* @param nMessage Is the text message to set
	*/
	void setTextMessage(wxString nMessage);

	/*
	* Gets the text message
	* @param text Is the actual text message 
	*/
	wxString getTextMessage();
	/**
	* Creates and returns a graphical funcion according to the indicated vectors.
	*/
	pGraphicalFunction* getFunctionForVectors( double* vectorX, int sizeX,double * vectorY, int sizeY );
	/**
	* Add a function to the plotter
	* when the function doesnt come from window
	*/
	int addFunction(pGraphicalFunction * function);
	/*
	 Set Type
	*/
	void setType(int t);
	/*
	 Get a function in the plotter given the index
	*/
	pGraphicalFunction* getFunction(int index);
	
	/*
		if the user resize the window	
	*/
	void OnSize( wxSizeEvent &WXUNUSED(event) );
	/*
	 Get a function in the plotter given the index
	*/
	//pGraphicalFunction* getFunction(int index);
	
	/*
	  move the functions that the user wants to move
	  and that were setted in functionsToMove
	  @param porcentageMinX:the porcentage that the minShowed
	  of the funcntions have to be move
	  @param porcentageMaxX:the porcentage that the maxShowed
	  of the funcntions have to be move

	*/
	void moveFunctions(float porcentageMinX,float porcentageMaxX);

	/*
	 Adds  function to move with the bar min max
	*/
	int addFunctionToMove(pGraphicalFunction * function);
	/*
	Set the bars according to the actual function 
	*/

	void setAll();
	/*
	* deletes the function from the plotter
	*/
	//bool deleteFunction(pGraphicalFunction* function);

	
	//--------------------
	// Color information
	//---------------------

	/**
		Returns the number of points that the bar color has
	*/
	int getColorPointsSize();

	/*
	 Get the RGB values of the color point that is in the
	 index given
	*/
	void getBarColorDataAt(int index,double&x,int& red,int& green,int& blue);
	/*
	 add a color Point 
	 returns true if the point was succesfully added
	 PRE: 0<=red<=255 0<=green<=255 0<=blue<=255
	*/
	bool addColorPoint (int x,int red,int green, int blue);

	void eraseColorPoints();

		
	//--------------------
	// bar Information
	//---------------------
	float getMaxShowedPorcentage();
	float getMinShowedPorcentage();	
	float getActualShowedPorcentage();	
	//--------------------
	// plotter Information
	//---------------------
	void setActual(pGraphicalFunction* nActual);
	void update();
	
	//----------------------------
	//Handling Options Menu
	//----------------------------
	/*
	if any parameter is true, is going to be remove from the popUp menu
	*/
	void setPopUpMenu(bool startD,bool stopD,bool smooth,bool line, bool zoomIn,
					  bool zoomOut,bool showPoints,bool noShowPoints,bool changeColor, bool addP,
					  bool delPoint,bool load,bool save);


	/**
	**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
	**/
	void GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value, int histogramsize);

	/**
	**	Returns two vectors, the grey level of the point and its value, the red, green
	**	and blue value is between [0,1]
	**/
	void GetValuesColorPointsFunction(std::vector<double>& greylevel,
									std::vector<double>& red,
									std::vector<double>& green,
									std::vector<double>& blue);
	
	//----------------------------------------------------------------------------------------
	// Attributes declration
	//----------------------------------------------------------------------------------------
private: 

	/*
	* Represents the plotter widget drawing area
	*/
	pPlotterWindow	*m_plot;
	/*
	* Represents the color bar instance
	*/
	pColorBar	*color_bar;
	/*
	* Represents the barrange instance
	*/
	mBarRange	*barrange;
	/*
	* Represents the pointer to the actual funtion in the unified plotter
	*/
	pGraphicalFunction* actualFunction;

	/*
	* Represents the text message 
	*/
	wxString text;

	/*
	* Declaring the existence of the class
	*/
	DECLARE_CLASS (pPlotter)
	/*
	* Declaring the use of events
	*/
	DECLARE_EVENT_TABLE()
};

#endif


