/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------
#include "pPlotterLayer.h"

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <vector>
#include <fstream>
#include <iostream>
//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

IMPLEMENT_ABSTRACT_CLASS(pPlotterLayer, mpLayer)
//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------

/** 
*@param name  Label
*@param flags Label alignment, pass one of #mpALIGN_NE, #mpALIGN_NW, #mpALIGN_SW, #mpALIGN_SE.
*/
pPlotterLayer:: pPlotterLayer(wxString name , int flags )
{
	SetName(name);
	m_flags = flags;
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	points.DeleteContents(TRUE);
#else
	// ...
#endif
	offsetX	= 0;
	offsetY	= 0;
}

/*
Draw the line from (x1,y1) to (x2,y2) only passing by the 
positive points in the line
*/
void  pPlotterLayer::draw(wxDC & dc,mpWindow & w,double x1,double y1,double x2,double y2, int orgy)
{
	
	//intercepts
	float m=((float)(y2-y1))/(x2-x1);
	float x0=-y1/m+x1;
	float y0=-m*x1+y1;	

	double sizedc = dc.GetSize().GetHeight()-orgy;

	//analyzing the curve

		if(x1<=0 && x2>=0)
		{
			if(y2>=0 && y1>=0)
					dc.DrawLine(0,GetYTranslated(sizedc,y0), x2,GetYTranslated(sizedc,y2));

			else if(y2<=0 && y1>=0)
			{
				if(y0>=0 && x0>=0)
					dc.DrawLine(0,GetYTranslated(sizedc,y0),x0,GetYTranslated(sizedc,0) );
			}
			else if(y2>=0 && y1<=0)
			{
				if(y0>=0) 
				dc.DrawLine(0,GetYTranslated(sizedc,y0),x2,GetYTranslated(sizedc,y2) );
			}
	
		}

		if(x1>=0 && x2>=0)
		{
			if(y1>=0 && y2>=0 )
				dc.DrawLine(x1,GetYTranslated(sizedc,y1), x2,GetYTranslated(sizedc,y2));
			else if(y1>=0 && y2<=0)
				dc.DrawLine(x1,GetYTranslated(sizedc,y1),x0,GetYTranslated(sizedc,0) );
			else if(y1<=0 && y2>=0) 
					dc.DrawLine(x0,GetYTranslated(sizedc,0),x2,GetYTranslated(sizedc,y2));
		}
		
		
}
	
/**
* Draw the function with th spline points
*
*/
void pPlotterLayer::drawSplineCurve(wxDC & dc,mpWindow & w, int orgy)
{
	std::vector<double> vx=getXSpline();
	std::vector<double> vy=getYSpline();
	wxPoint* ppoints;
	
	int /*counter=0,*/ minX,maxX,minY,maxY; // JPRx
	/*
	This is the offset of every point scale to the window
	pixel
	*/
	int offsetpx=getOffsetPixelsXv();
	int offsetpy=getOffsetPixelsYv();
	
	// type of plotter
	int type=getmType();
 
	wxPoint point;
	/***********/
	getMaxShowed(maxX,maxY);
	getMinShowed(minX,minY);
	/***********/

	
	if(type==2)
	{
	 /*
		Fill the function if it represented an histogram
	  */
		ppoints=(wxPoint*)malloc(sizeof(int)*2*(vx.size()+2));
		//initialize points
		point.x=-5000;
		point.y=-5000;
		ppoints[0]=point;
		ppoints[1]=point;
	}
	
	int size=vx.size();
	int j=2;

	for(int i=0;(i+1)< size;i++)
	{
		
		
		double cxi=(vx.at(i)-minX-offsetX)*scaleX+offsetpx;
		double cyi=(vy.at(i)-minY-offsetY)*scaleY+offsetpy;
		
		double cxj=(vx.at(i+1)-minX-offsetX)*scaleX+offsetpx;
		double cyj=(vy.at(i+1)-minY-offsetY)*scaleY+offsetpy;
		
		
		if(type!=2) 	
			draw(dc,w,cxi,cyi,cxj,cyj,orgy);
		else if(type==2)
		{
			if(!initializePolygon(ppoints,cxi,cyi,cxj,cyj) && ((cxi<=0 && cxj>=0)||(cxi>=0 && cxj>=0)))
			{
					point.x=cxj;
					point.y=cyj;
					ppoints[j]=point;
					j++;
		
			}
		}
		
	}
	if(type==2)
	{
		//point.x=vx.at(size-1)* scaleX + offsetpx;
		point.x=ppoints[j-1].x;
		point.y=0;
		//ppoints[vx.size()]=point;
		ppoints[j]=point;
		/*
		Fill the function if it represented an histogram
	  */
		//ppoints=(wxPoint*)malloc(sizeof(int)*2*(vx.size()+1));
		//settings for fill
		//point.x=vx.at(0)*scaleX + offsetpx;
		point.x=ppoints[0].x;
		point.y=0;
		//ppoints[vx.size()+1]=point;
		ppoints[j+1]=point;

		dc.SetBrush(wxBrush( wxColour(239,238,242) ,wxSOLID  ));
		dc.SetPen(wxPen( wxColour(0,0,0) ,1,wxSOLID  ));
		//dc.DrawPolygon(vx.size()+2,ppoints,0,0);
		for(int i = 0; i <= j + 1; i++){
			int sizedc = dc.GetSize().GetHeight()-orgy;
			ppoints[i].y = GetYTranslated(sizedc, ppoints[i].y);
		}	
		dc.DrawPolygon(j+2,ppoints,0,0);
	}
	
	
}

/*
 it define the first point of the polygon for be drawing
 returns true if the first and second point of the polygon are set
*/
bool pPlotterLayer::initializePolygon(wxPoint* points,double x1, double y1,double x2, double y2)
{
	bool setted=false;

		//intercepts
	float m=((float)(y2-y1))/(x2-x1);
	float x0=-y1/m+x1;
	float y0=-m*x1+y1;	

	if(points[0].x<=0&& points[1].x<=0 && points[0].y<=0&& points[1].y<=0)
	{
	
		//int offsetpx=getOffsetPixelsXv(); //JPRx	

		//analyzing the curve

			if(x1<=0 && x2>=0)
			{
				if(y2>=0 && y1>=0)
				{
						//dc.DrawLine(0,y0, x2,y2);
						points[0].x=0;
						points[0].y=y0;
						points[1].x=x2;
						points[1].y=y2;
						setted=true;					
					
				}
				else if(y2<=0 && y1>=0)
				{
					if(y0>=0 && x0>=0)
					{
						//dc.DrawLine(0,y0,x0,0 );
						points[0].x=0;
						points[0].y=y0;
						points[1].x=x0;
						points[1].y=0;
						setted=true;	

					}
						
				}
				else if(y2>=0 && y1<=0)
				{	
					if(y0>=0) 
					{	
						//dc.DrawLine(0,y0,x2,y2 );
						points[0].x=0;
						points[0].y=y0;
						points[1].x=x2;
						points[1].y=y2;
						setted=true;	
					}
				}
		
			}

			if(x1>=0 && x2>=0)
			{
				if(y1>=0 && y2>=0 )
				{
					//dc.DrawLine(x1,y1, x2,y2);
					points[0].x=x1;
					points[0].y=y1;
					points[1].x=x2;
					points[1].y=y2;
					setted=true;	
				}
				else if(y1>=0 && y2<=0)
				{
					//dc.DrawLine(x1,y1,x0,0 );
					points[0].x=x1;
					points[0].y=y1;
					points[1].x=x0;
					points[1].y=0;
					setted=true;	
				}
				else if(y1<=0 && y2>=0) 
				{	
					//dc.DrawLine(x0,0,x2,y2);
					points[0].x=x0;
					points[0].y=0;
					points[1].x=x2;
					points[1].y=y2;
					setted=true;	
				}
			}
			else
			return setted;
	}
	else
		return setted;
	return setted; 
}

/**
* Draw the lines between the points of the function
*/
void pPlotterLayer::drawFunction(wxDC & dc,mpWindow & w, int orgy)
{
	int scrwX,scrwY,offsetpx,offsetpy,maxX,minX,maxY,minY;
	wxPoint* ppoints = NULL;

	/*
	This is the offset of every point scale to the window
	pixel
	*/
	offsetpx = getOffsetPixelsXv();
	offsetpy = getOffsetPixelsYv();	
	Rewind();
	dc.GetSize(&scrwX, &scrwY);
	//Lines between the points
	int sizedc = dc.GetSize().GetHeight()-orgy;
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	GetPoints(points);
#else
  //...
#endif
	// type of plotter
	int type=getmType();
	/***********/
	getMaxShowed(maxX,maxY);
	getMinShowed(minX,minY);
	/***********/

	//traslation
	//int xTraslation=getXTraslation(); //JPRx
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxNode* node= points.GetFirst();
#else
	wxNode* node= GetPointsPtr()->GetFirst();
#endif
	// int i=1;//points.GetCount()+1; //JPRx
	int j=2;
	/*
	 Fill it if it is an histogram
	*/
	wxPoint point;
	// pFunctionPoint* pointk; //JPRx
	if(type==2)
	{
		/*
		Fill the function if it represented an histogram
	  */
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		ppoints		= (wxPoint*)malloc(sizeof(int)*2*(points.GetCount()+2));
#else
		ppoints		= (wxPoint*)malloc(sizeof(int)*2*(GetPointsPtr()->GetCount()+2));
#endif
		//initialize points
		point.x		= -5000;
		point.y		= GetYTranslated(sizedc,-5000);
		ppoints[0]	= point;
		ppoints[1]	= point;
	}
	
	while (node!=NULL && node->GetNext()!=NULL)
	{ 
		pFunctionPoint* pointi=(pFunctionPoint*)node->GetData();
				wxNode* nextNode=node->GetNext();
		pFunctionPoint* pointj=(pFunctionPoint*)nextNode->GetData();
						
		// we do the offset
		int pxi=(pointi->getRealX()-minX)-offsetX;
		int pyi=(pointi->getRealY()-minY)-offsetY;
		int pxj=(pointj->getRealX()-minX)-offsetX;
		int pyj=(pointj->getRealY()-minY)-offsetY;
		int cxi=pxi* scaleX + offsetpx; //+ xTraslation;
		int cxj=pxj* scaleX + offsetpx; //+ xTraslation;
		int cyi=pyi* scaleY+ offsetpy ;
		int cyj=pyj* scaleY+ offsetpy ;
		//dc.DrawLine(pxi* scaleX + offsetpx,pyi* scaleY+ offsetpy, pxj* scaleX + offsetpx,pyj* scaleY+ offsetpy );
		if(type!=2)
		{
			draw(dc,w,pxi* scaleX + offsetpx,pyi* scaleY+ offsetpy, pxj* scaleX + offsetpx,pyj* scaleY+ offsetpy,orgy );
			//dc.DrawLine(pxi* scaleX + offsetpx,pyi* scaleY+ offsetpy, pxj* scaleX + offsetpx,pyj* scaleY+ offsetpy );
		} else if(type==2) {
			if(!initializePolygon(ppoints,cxi,cyi,cxj,cyj) && ((cxi<=0 && cxj>=0)||(cxi>=0 && cxj>=0)))
			{
					point.x=cxj;
					point.y=GetYTranslated(sizedc,cyj);
					ppoints[j]=point;
					j++;
		
			} // if
		} // if type
		node=node->GetNext();
	} 
	if(type==2)
	{
		//point.x=vx.at(size-1)* scaleX + offsetpx;
		point.x=ppoints[j-1].x;
		point.y=GetYTranslated(sizedc,0);
		//ppoints[vx.size()]=point;
		ppoints[j]=point;
		/*
		Fill the function if it represented an histogram
	  */
		//ppoints=(wxPoint*)malloc(sizeof(int)*2*(vx.size()+1));
		//settings for fill
		//point.x=vx.at(0)*scaleX + offsetpx;
		point.x=ppoints[0].x;
		point.y=GetYTranslated(sizedc,0);
		//ppoints[vx.size()+1]=point;
		ppoints[j+1]=point;

		dc.SetBrush(wxBrush( wxColour(239,238,242) ,wxSOLID  ));
		dc.SetPen(wxPen( wxColour(0,0,0) ,1,wxSOLID  ));
		//dc.DrawPolygon(vx.size()+2,ppoints,0,0);
		dc.DrawPolygon(j+2,ppoints,0,0);
	} // if type
}

/**
*  Draw the points of the function
*/
void pPlotterLayer::drawPoints(wxDC & dc,mpWindow & w, int orgy)
{
	
	Rewind();
	double x, y;
	int minX,maxX,minY,maxY;

	double sizedc = dc.GetSize().GetHeight()-orgy;
	
	/*
	This is the offset of every point scale to the window
	pixel
	*/
	int offsetpx=getOffsetPixelsXv();
	int offsetpy=getOffsetPixelsYv();
	//traslation
//	int xTraslation=getXTraslation();  //EED
	/*wxPen mypen(*wxBLACK, 5, wxSOLID);
	dc.SetPen(mypen);*/
	/***********/
	getMaxShowed(maxX,maxY);
	getMinShowed(minX,minY);
	/***********/
	//we have to draw the points

	while (GetNextXY(x, y))
	{
		//GetNextXY(x, y);
		//set the points of the polygons
		wxPoint points[4];
		dc.SetBrush(wxBrush( wxColour(255,0,0),wxSOLID  ));
		//dc.SetPen(wxPen(wxColour(0,0,0),1,wxSOLID) );
		points[0].x=((x-minX-offsetX)*scaleX + offsetpx-MOVE);
		points[0].y=GetYTranslated(sizedc,((y-minY-offsetY)*scaleY+ offsetpy-MOVE));
		points[1].x=((x-minX-offsetX)*scaleX+ offsetpx+MOVE);
		points[1].y=GetYTranslated(sizedc,((y-minY-offsetY)*scaleY+ offsetpy-MOVE));
		points[2].x=((x-minX-offsetX)*scaleX+ offsetpx+MOVE);
		points[2].y=GetYTranslated(sizedc,((y-minY-offsetY)*scaleY+ offsetpy+MOVE));
		points[3].x=((x-minX-offsetX)*scaleX+ offsetpx-MOVE);
		points[3].y=GetYTranslated(sizedc,((y-minY-offsetY)*scaleY+ offsetpy+MOVE));
		if((x-minX-offsetX)*scaleX >=0 && (y-minY-offsetY/*w.getMinScrY()*/)*scaleY>=0)
		dc.DrawPolygon(4,points,0,0);
	}
}

/**
* Draw the line between the last point of the function
* and the position of the mouse
*/
void pPlotterLayer::drawLineToMousePoint(wxDC & dc,mpWindow & w, int orgy)
{
	int x,y,sizeP,maxX,maxY,minX,minY;
	bool direction;
	
	Rewind();
	
	getMousePoint(x,y);
	getDirection(direction);
	getSize(sizeP);
	//Lines betwen the points

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	GetPoints(points);
	wxNode *node	= points.GetLast();
	wxNode *node1	= points.GetFirst();
#else
	wxNode *node	= GetPointsPtr()->GetLast();
	wxNode *node1	= GetPointsPtr()->GetFirst();
#endif
	
	
	/*
	This is the offset of every point scale to the window
	pixel
	*/
	int offsetpx = getOffsetPixelsXv();
	int offsetpy = getOffsetPixelsYv();
	/***********/
	getMaxShowed(maxX,maxY);
	getMinShowed(minX,minY);
	/***********/
	//traslation
//	int xTraslation=getXTraslation(); //EED
	
	if(node)
	{
		pFunctionPoint* lastPoint=(pFunctionPoint*)node->GetData();
		pFunctionPoint* firstPoint=(pFunctionPoint*)node1->GetData();

		//LeftDrawing
		if(lastPoint->getRealX()<x && direction && sizeP >=2)
			
			dc.DrawLine((lastPoint->getRealX()-minX-offsetX)*scaleX + offsetpx,(lastPoint->getRealY()-minY-offsetY)*scaleY+ offsetpy, (x-minX)*scaleX + offsetpx, (y-minY)*scaleY + offsetpy);
		
		//right drawing
		else if(firstPoint->getRealX()>x && !direction && sizeP >=2 )
			
			dc.DrawLine((firstPoint->getRealX()-minX-offsetX)*scaleX+ offsetpx,(firstPoint->getRealY()-minY-offsetY)*scaleY+ offsetpy,(x-minX)*scaleX+ offsetpx, (y-minY)*scaleY+ offsetpy);
		
		//just a point
		else if(sizeP==1 )
		{
			dc.DrawLine((lastPoint->getRealX()-minX-offsetX)*scaleX + offsetpx,(lastPoint->getRealY()-minY-offsetY)*scaleY+ offsetpy, (x-minX)*scaleX+ offsetpx, (y-minY)*scaleY+ offsetpy);
		}
	}			
	
	if( w.drawGuideLines() )  
	{
		dc.SetPen(wxPen(  wxColour(255,0,0),1,wxDOT ));
		// Drawing the horizontal guide line	
		dc.DrawLine( 0, (y-minY)*scaleY + offsetpy, (x-minX)*scaleX + offsetpx, (y-minY)*scaleY + offsetpy);					
		// Drawing the vertical guide line	
		dc.DrawLine( (x-minX)*scaleX + offsetpx,0, (x-minX)*scaleX + offsetpx, (y-minY)*scaleY + offsetpy);	
	}
}


/** 
Layer plot handler.
This implementation will plot the locus in the visible area and
put a label according to the aligment specified.
*/
void pPlotterLayer::Plot(wxDC & dc, mpWindow & w)
{
	bool show,drawing,actual;
	int scrwX,scrwY,maxX,maxY,minX,minY,type;
	float factorZoom;
	
 	ifShowPoints(show);
	getDrawing(drawing);
	type=vGetType();
	
	dc.SetPen( m_pen);
	
	/*
	 * Managing the scale and zoom
	 */
	
	dc.GetSize(&scrwX, &scrwY);
	
	getIfActual(actual);
	//getMax(maxX, maxY);
	/***********/
	getMaxShowed(maxX,maxY);
	getMinShowed(minX,minY);
	/***********/
	getFactorZoom(factorZoom);
	getOffsets(offsetX,offsetY);
	/*
	maxX=w.getMaxScrX();
	maxY=w.getMaxScrY();
	minX=w.getMinScrX();
	minY=w.getMinScrY();
	*/
	if((maxX-minX)!=0 && (maxY-minY)!=0)
	{
		
		scaleX=(((double)scrwX-100)/(maxX-minX))*factorZoom;
		scaleY=(((double)scrwY-50)/(maxY-minY))*factorZoom;
		
		if(actual)
		{
			w.SetScaleX(scaleX);
			w.SetScaleY(scaleY);
			//w.setMinScrX(offsetX);
			//w.setMinScrY(offsetY);
		}
		
	}
	/*
		Managing the drawing
	*/
	int orgx=70;

	
//EED 14Mai2009
//	int orgy=w.GetScrY()-40;
//	dc.SetDeviceOrigin( orgx ,orgy);
//	dc.SetAxisOrientation(true,true);
	
	int orgy = 40;	
	//dc.SetDeviceOrigin( orgx ,orgy);
	dc.SetDeviceOrigin( orgx ,0);
	int sizedc = dc.GetSize().GetHeight()-orgy;
	//dc.SetAxisOrientation(true,false);

	

	//if the user dont want to see the points of the function and if he stops drawing
	//we have to draw the function
	if(!show && !drawing && type==1)
		drawFunction(dc,w,orgy);
	else if(!show && !drawing && type==2)
		drawSplineCurve(dc,w,orgy);
	//we just draw the point that the user just clicked
	else if(drawing && type==1)
	{ 
		drawFunction(dc,w,orgy);
		drawLineToMousePoint(dc,w,orgy);
		drawPoints(dc,w,orgy);
	}
	else if(drawing && type==1)
	{
		drawSplineCurve(dc,w,orgy);
		drawLineToMousePoint(dc,w,orgy);
		drawPoints(dc,w,orgy);
	}
	else if(show && type==1)
	{
		drawFunction(dc,w,orgy);
		drawPoints(dc,w,orgy);
	}
	else if(show && type==2)
	{
		drawSplineCurve(dc,w,orgy);
		drawPoints(dc,w,orgy);
	}

	// Drawing the guides according to real values entered according to the integrated interaction (IS NOT WORKING!!!)
	if ( actual )
	{
		dc.SetPen(wxPen(  wxColour(255,0,0),1,wxDOT ));
		int offsetpx = getOffsetPixelsXv();
//		int offsetpy = getOffsetPixelsYv();  //EED

		int realX_guide = w.getRealGuideX();
		if( realX_guide!=-1 )
		{
		dc.DrawLine( (realX_guide/*-w.getMinScrX()*/-offsetX)*scaleX + offsetpx, 
			GetYTranslated(sizedc,0), 
			(realX_guide/*-w.getMinScrX()*/-offsetX)*scaleX + offsetpx, 
			GetYTranslated(sizedc,scrwY));			
		}
			
		int realY_guide = w.getRealGuideY();
		if( realY_guide!=-1 )
		{
			dc.DrawLine( 0,
				GetYTranslated(sizedc,(realY_guide/*-w.getMinScrY()*/-offsetX)*scaleX + offsetpx), 
				scrwX, 
				GetYTranslated(sizedc,(realY_guide/*-w.getMinScrY()*/-offsetX)*scaleX + offsetpx));
		} // if realY_guide
	} // if actual
}

