/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __pPlotterScaleX_h__
#define __pPlotterScaleX_h__
// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//----------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------

#include "pPlotterLayer.h"
#include "marTypes.h"

//----------------------------------------------------------------------------
// Class definition
//----------------------------------------------------------------------------
class creaMaracasVisu_EXPORT pPlotterScaleX: public pPlotterLayer
{
public:
	/**
	* This is the constructor of the class
	*/
	pPlotterScaleX(wxString aName = wxT("X"),int flags = mpALIGN_NE);
	/**
	* This is how the x-axis draw itself
	*/
	virtual void Plot(wxDC& dc, mpWindow& w);
	/** Check whether this layer has a bounding box.
	This implementation returns \a FALSE thus making the ruler invisible
	to the plot layer bounding box calculation by mpWindow.
	*/
	virtual bool HasBBox() { return FALSE; }

	DECLARE_CLASS (pPlotterScaleX)
};

#endif



