/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------
#include "pPlotterScaleY.h"

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

#define mpLN10 2.3025850929940456840179914546844

IMPLEMENT_CLASS(pPlotterScaleY, pPlotterLayer)
//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------
pPlotterScaleY::pPlotterScaleY(wxString aName,int flags) {

	SetName(aName);/*
	SetFont(*wxSMALL_FONT);
	SetPen(*wxGREY_PEN);*/
	wxFont ff( *wxSMALL_FONT);
	wxPen pp( *wxGREY_PEN);
	SetPen( pp );
	SetFont( ff );
}

void pPlotterScaleY::Plot(wxDC& dc, mpWindow& w) 
{

	int divisions=20;
	
	dc.SetPen( m_pen);
	dc.SetFont( m_font);
	
	//data
	float min= (float)w.getMinScrY();
	float max=(float)w.getMaxScrY();
	float scrY=(float)w.GetScrY()-50;
	double scaleY=(scrY/(max-min))*w.getZoomFactor();
	int offsetpy=w.getOffsetPixelsY();
	int offsetY=w.getOffsetY();


	//setting origins
	
//EED 14Mai2009
//	const int orgy   = w.GetScrY()-40;
//	dc.SetDeviceOrigin(70,orgy);
//	dc.SetAxisOrientation(true,true);  //EED  MacOx ??? 
	
	const int orgy   = 40;
	//dc.SetDeviceOrigin(70,orgy);
	dc.SetDeviceOrigin(70,0);
	double sizedc = dc.GetSize().GetY()-orgy;
	//dc.SetAxisOrientation(true,false);  

	//	const int extend = w.GetScrY()-50;   //EED
	
	//draw the axe
	dc.DrawLine( 0,GetYTranslated(sizedc, 0), 0, GetYTranslated(sizedc, (max-min)*scaleY));

	//maximum value in Y
	int d=max-min;
	if(d<20)
		{
			int k=d/divisions;
			while(k==0)
				{
					divisions--;
					k=d/divisions;
				}
		}
	float step=(max-min)/divisions;
	

	//drawing the axe with the numbers
	wxString s;
	//drawing the first line
	dc.DrawLine(0,GetYTranslated(sizedc, 0),-10,GetYTranslated(sizedc, 0));
	s.Printf(_T("%d"),(int)(min));
	dc.DrawText(s,(wxCoord)-20,GetYTranslated(sizedc, (wxCoord)0));
	
	
	for(float i=0;i<=(max);i+=step)
	{
		
		int p=(i-min-offsetY)*scaleY+offsetpy;
		if(p>=0)
		{	
			dc.DrawLine(0,GetYTranslated(sizedc, p),-10,GetYTranslated(sizedc, p));
			s.Printf(_T("%d"),(int)(i));
			dc.DrawText(s,(wxCoord)-20,GetYTranslated(sizedc, (wxCoord)p));
		}
	}	
	//drawing the last line
	int p=(max-min-offsetY)*scaleY+offsetpy;
	dc.DrawLine(0,GetYTranslated(sizedc, p),-10,GetYTranslated(sizedc, p));
	s.Printf(_T("%d"),(int)(max));
	dc.DrawText(s,(wxCoord)-20,GetYTranslated(sizedc, (wxCoord)p));
}



