/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------
#include "pPlotterWindow.h"
#include "MaximumsDialog.h"
#include <iostream>
#include <fstream>
#include <string>

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "wx/colordlg.h"
//----------------------------------------------------------------------------
//DECLARING THE NEW EVENT
//wxEVT_TSBAR= event of the two side bar
//----------------------------------------------------------------------------
BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_CHANGED_FUNCTION, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_MOVE, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_ADD, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_DELETE, -1)
DECLARE_EVENT_TYPE(wxEVT_PPLOTTER_GUIDELINES, -1)
END_DECLARE_EVENT_TYPES()

//definitions
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER)
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER_CHANGED_FUNCTION)
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_MOVE)
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_ADD)
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER_POINT_DELETE)
DEFINE_EVENT_TYPE(wxEVT_PPLOTTER_GUIDELINES)


//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

IMPLEMENT_CLASS(pPlotterWindow, mpWindow)

//----------------------------------------------------------------------------
// Event Table
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(pPlotterWindow,mpWindow)
 EVT_MOTION (pPlotterWindow::onMouseMove)
 EVT_LEFT_DCLICK(pPlotterWindow::onChangeActual)
 EVT_LEFT_DOWN(pPlotterWindow::onAddPoint)
 EVT_MENU(pwID_DELPOINT, pPlotterWindow::onDeletePoint)
 EVT_MENU(pwID_SHOWPOINTS, pPlotterWindow::onShowPoints)
 EVT_MENU(pwID_STARTDRAWING, pPlotterWindow::onStartDrawing)
 //EVT_MENU(pwID_DELFUNCTION,pPlotterWindow::onDeleteFunction)
 EVT_MENU(pwID_STOPDRAWING, pPlotterWindow::onStopDrawing)
 EVT_MENU(pwID_ADDNEWPOINT, pPlotterWindow::onAddNewPoint)
 EVT_MENU(pwID_NOSHOWPOINTS, pPlotterWindow::onNoShowPoints)
 EVT_MENU(pwID_MYZOOMOUT,pPlotterWindow::onMyZoomOut)
 EVT_MENU(pwID_MYZOOMIN,pPlotterWindow::onMyZoomIn)
 EVT_MENU(pwID_SPLINE,pPlotterWindow::onSplinePoints)
 EVT_MENU(pwID_LINE,pPlotterWindow::onLine)
 EVT_MENU(pwID_SAVE,pPlotterWindow::onSave)
 EVT_MENU(pwID_LOAD,pPlotterWindow::onLoad)
 EVT_MENU(pwID_CHANGECOLOR,pPlotterWindow::onChangeColor)
 EVT_MENU( mpID_LINE_GUIDES, pPlotterWindow::OnGuideLines)
 EVT_MENU( pwID_TRASLATEACTUALFUNCTION, pPlotterWindow::onMoveFunction)
 EVT_LEFT_UP(pPlotterWindow::onLeftUp)
END_EVENT_TABLE()

//----------------------------------------------------------------------------
// Constructors
//----------------------------------------------------------------------------

pPlotterWindow::pPlotterWindow( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag )
: mpWindow( parent, id, pos, size, flag)
{
	drawing=false;
	movingPointIndex=-1;
	actual=NULL;
	scaleWay=DEFAULT_SCALE;
	zoomFactor=1;
	//drawGuideLines=true;
	type=DEFAULT_PLOTTER;
	drawGuides=false;
	movingFunction=false;
	initialMovingCLick=-1;
	movingPoints=false;
	
	/*
	PopMenu options
	*/
	m_popmenu.Remove( mpID_ZOOM_IN);
	m_popmenu.Remove( mpID_ZOOM_OUT);
	m_popmenu.Remove( mpID_CENTER);
	m_popmenu.Remove( mpID_FIT);
	m_popmenu.Remove( mpID_LOCKASPECT);

	m_popmenu.Append(pwID_STARTDRAWING ,   _("Start Drawing"),    _("Starts to draw a new function"));//it changes the actual function
	m_popmenu.Append(pwID_STOPDRAWING ,   _("Stop drawing"),    _("Stops of drawing the new function"));
	m_popmenu.Append(pwID_LOAD,   _("Load"),    _("Load the actual function from a plane file"));
	m_popmenu.Append(pwID_SHOWPOINTS ,   _("Show Points"),    _("shows the discrete points of the function"));
	m_popmenu.Append(pwID_NOSHOWPOINTS,  _("No show Points"),    _("Dont show the points of the function"));
	m_popmenu.Append(pwID_ADDNEWPOINT,   _("Add point"),    _("Add New point to the actual function"));
	m_popmenu.Append(pwID_DELPOINT ,   _("Delete point"),    _("Deletes a point from the actual function."));
	m_popmenu.Append(pwID_MYZOOMIN,   _("Zoom in"),    _("Zoom in the points of the function"));
	m_popmenu.Append(pwID_MYZOOMOUT,   _("Zoom out"),    _("Zoom out the points of the function"));
	m_popmenu.Append(pwID_SPLINE,   _("Smooth"),    _("Splines the points ofthe actual curve"));
	m_popmenu.Append(pwID_LINE,   _("Line"),    _("Piecewise the points ofthe actual curve"));	
	m_popmenu.Append(pwID_SAVE,   _("Save"),    _("Save the actual function in plane file"));	
	m_popmenu.Append(pwID_CHANGECOLOR,   _("Change Color"),    _("Change the color of the function"));		
	m_popmenu.Append(pwID_TRASLATEACTUALFUNCTION, _("Start Moving Function"),  _("Move the actual Function"));
	
	m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
	m_popmenu.Enable(pwID_ADDNEWPOINT,false);
	m_popmenu.Enable(pwID_SHOWPOINTS,false);
	m_popmenu.Enable(pwID_DELPOINT,false);
	m_popmenu.Enable(pwID_STOPDRAWING,false);
	m_popmenu.Enable(pwID_MYZOOMIN,false);
	m_popmenu.Enable(pwID_MYZOOMOUT,false);
	m_popmenu.Enable(pwID_SPLINE,false);
	m_popmenu.Enable(pwID_LINE,false);
	m_popmenu.Enable(pwID_SAVE,false);
	m_popmenu.Enable(pwID_LOAD,true);
	m_popmenu.Enable(pwID_CHANGECOLOR,false);
	m_popmenu.Enable(pwID_STARTDRAWING,true);
	m_popmenu.Enable(pwID_LOAD,true);
	//m_popmenu.Enable(pwID_STARTDRAWING,false);
	m_popmenu.Enable(mpID_LINE_GUIDES,false);
	m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,false);
	
	 
}


pPlotterWindow::~pPlotterWindow()
{
}
//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------

/**
* Sets the actual function
*/
void  pPlotterWindow::setActualFunction(pGraphicalFunction* newActual)
{
	if(actual!=NULL)
		actual->setActual(false);
	newActual->setActual(true);
	actual=newActual;
}

/**
* Gets the actual function
*/
pGraphicalFunction* pPlotterWindow:: getActualFunction()
{
	return actual;
}

/**
* Transform the point clicked  from window
* to the real value,given by the scale
* Pre: m_scaleX and m_scaleY are already actualized
* with setActualScales() method
*/
wxPoint pPlotterWindow:: getRealPoint(wxPoint pixelPoint)
{
	int x,y;	
	x=pixelPoint.x-70;
	y=pixelPoint.y-40;			
	//real point on the function
	wxPoint realPoint;
	int xS=(x-offsetPixelX)/m_scaleX + offsetX + minScrX;
	int yS=(y-offsetPixelY)/m_scaleY + offsetY + minScrY;
	
	if(xS<=maxScrX && yS<=maxScrY )
	{
		//setActualScales();
		realPoint.x= xS;
		realPoint.y= yS;		
	}
	else
	{
		realPoint.x= -1;
		realPoint.y= -1;		
	}
	return realPoint;
}
/*
 Set the scales according to the size of the window
 and the maximum given by the user
*/

void pPlotterWindow::setActualScales()
{
	// int maxX,maxY,minX,minY; // JPRx
	int maxX,maxY;//,minX,minY; // JPRx  //EED
	/*
	if the function is drawed interactively the maxX and the 
	maxY in actual are sets by the user
	*/
	/*
	maxX=actual->getMaxX();
	maxY=actual->getMaxY();

	int dx=maxX;
	int dy=maxY;
	
	*/
	int dx=actual->getMaxXShowed()-actual->getMinXShowed();
	int dy=actual->getMaxYShowed()-actual->getMinYShowed();
	
	if(dx!=0 && dy!=0)
	{
		m_scaleX= (((float)m_scrX-100)/dx)*zoomFactor;
		m_scaleY= (((float)m_scrY-50)/dy)*zoomFactor;
	}
	//setting the maximums and minimums showed in the window
	/*
	setMaxScrX(maxX);
	setMaxScrY(maxY);
	*/
	setMaxScrX(actual->getMaxXShowed());
	setMinScrX(actual->getMinXShowed());
	setMaxScrY(actual->getMaxYShowed());
	setMinScrY(actual->getMinYShowed());
	actual->setScreens(m_scrX,m_scrY);
	actual->setScales();
}
//-------------------------
// Methods for interaction
//-------------------------

	//------------------------------------
	//	Manipulating clicks on the plotter
	//-------------------------------------
	

	/*
		Manipulating clicks on the plotter
	*/
	void pPlotterWindow::onLeftUp(wxMouseEvent& event)
	{
		movingPoints=false;
		movingPointIndex=-1;
	}



	//-------------------------------
	//Traslating the actual function
	//-------------------------------
	/*
	 Move the actual function  when the user
	 is moving the mouse
	*/
	void pPlotterWindow::onMoveFunction(wxCommandEvent& aEvent)
	{
		if(movingFunction)
		{
			movingFunction=false;
			m_popmenu.SetLabel(pwID_TRASLATEACTUALFUNCTION, _("Start Moving Function"));
		}
		else
		{
			movingFunction=true;
			m_popmenu.SetLabel(pwID_TRASLATEACTUALFUNCTION, _("Stop Moving Function"));
		}
	}

//-----------------------
// Color Function
//-----------------------


	/**
	* Change the color of the function
	*/
void pPlotterWindow::onChangeColor(wxCommandEvent& aEvent)
	{
			
		wxColour colour;
		wxColourData data;
		wxColourDialog dialog(this, &data);

		if ( dialog.ShowModal() == wxID_OK )
		{
			colour = dialog.GetColourData().GetColour();
		}
	
		wxPen mypen(colour);
		mypen.SetWidth(2);
		actual->SetPen( mypen);
		UpdateAll();
	}


//----------------------
//Persistence
//----------------------
	

	/**
	* Load the function from a .txt file
	*/
	void pPlotterWindow::onLoad(wxCommandEvent& aEvent)
	{
		
		actual=new pGraphicalFunction(wxT("f(x) = function1(x)"),mpALIGN_NE);
		actual->setActual(true);
		actual->setFromWindow(false);
		actual->SetDrawing(drawing);
		actual->setFactorZoom(zoomFactor);
		
		wxPen mypen(*wxRED, 5, wxSOLID);
		mypen.SetWidth(2);
		actual->SetPen( mypen);
				
		wxString nameF=wxFileSelector(_T("Save Function"));
		actual->load(nameF);
		AddLayer(actual);
		
		functions.Append(actual);
		addFunctionToMove(actual);
		
		m_popmenu.Enable(pwID_STARTDRAWING,true);
		
		UpdateAll();

		//------------------------------------------
		//Sending the paarticular event of changed actual function
		//-------------------------------------------
		wxCommandEvent cevent( wxEVT_PPLOTTER_CHANGED_FUNCTION, GetId() );
		cevent.SetEventObject(this);
        GetEventHandler()->ProcessEvent( cevent );
	}


	/**
	* Save the points of the function in a .txt file
	*/
	void pPlotterWindow::onSave(wxCommandEvent& aEvent)
	{
		wxString nameF=wxFileSelector(_T("Save Function"));
		actual->save(nameF);
	}

//-----------------------
// Spline
//----------------------
/**
* Spline the points of the actual curve
*/

void pPlotterWindow::onSplinePoints(wxCommandEvent& aEvent)
{
	actual->setType(2);
	actual->initializeSplines();
	actual->initializeSplineVectors();
	UpdateAll();
	m_popmenu.Enable(pwID_SPLINE,false);
	m_popmenu.Enable(pwID_LINE,true);
}

/**
* Change the type of drawing of the actual function
* to a piecewise function
*/
void pPlotterWindow::onLine(wxCommandEvent& aEvent)
{
	actual->clearSplineVectors();
	actual->setType(1);
	UpdateAll();
	m_popmenu.Enable(pwID_SPLINE,true);
	m_popmenu.Enable(pwID_LINE,false);

}

//--------------------------
// Zooming
//---------------------------

/**
* Zoom out the functions
*/
void pPlotterWindow::onMyZoomOut(wxCommandEvent& aEvent)
{
	wxNode* node=functions.GetFirst();
	zoomFactor=zoomFactor*(float)(1/(float)ZOOM_FACTOR);
	while(node)
	{
		pGraphicalFunction* f= (pGraphicalFunction*)node->GetData();
		
		f->setScreenX(m_scrX);
		f->setScreenY(m_scrY);

		
		if(zoomFactor>1.01)
		{	
			f->setOffsets(m_clickedX-70,m_scrY-m_clickedY-40);
			f->setFactorZoom(zoomFactor);
		}
		
		else
		{
			f->setOffsetPixelX(0);
			f->setOffsetPixelY(0);
			f->setOffsetX(0);
			f->setOffsetY(0);
			f->setFactorZoom(zoomFactor);
		}
		

		if(f->getActual())
		{
			//TODO: send a event of resize
			//setMinScrX(f->getMinXShowed());
			//setMinScrY(f->getMinYShowed());
			setOffsetPixelX(f->getOffsetPixelsX());
			setOffsetPixelY(f->getOffsetPixelsY());
			setOffsetX(f->getOffsetX());
			setOffsetY(f->getOffsetY());
		}
		node=node->GetNext();
	}
	UpdateAll();
}
/**
* Zoom in the functions
*/
void pPlotterWindow::onMyZoomIn(wxCommandEvent& aEvent)
{
		
	zoomFactor=zoomFactor*(float)ZOOM_FACTOR;
	wxNode* node=functions.GetFirst();
	while(node)
	{
		pGraphicalFunction* f= (pGraphicalFunction*)node->GetData();
		if(zoomFactor > 1.01)
		{	
			f->setScreenX(m_scrX);
			f->setScreenY(m_scrY);
			f->setOffsets(m_clickedX-70,m_scrY-m_clickedY-40);
			f->setFactorZoom(zoomFactor);
		}
		else 
		{
			f->setOffsetPixelX(0);
			f->setOffsetPixelY(0);
			f->setOffsetX(0);
			f->setOffsetY(0);
			f->setFactorZoom(zoomFactor);
		}
		if(f->getActual())
		{
			//TODO: send an event of resize
			//setMinScrX(f->getMinXShowed());
			//setMinScrY(f->getMinYShowed());
			setOffsetPixelX(f->getOffsetPixelsX());
			setOffsetPixelY(f->getOffsetPixelsY());
			setOffsetX(f->getOffsetX());
			setOffsetY(f->getOffsetY());

		}
		
		node=node->GetNext();
	}

	UpdateAll();
}


//-------------------------
// Drawing
//-------------------------


/**
* Let to the user to start drawing
*/
void pPlotterWindow::onStartDrawing(wxCommandEvent& aEvent)
{

	if(actual!=NULL)
	{
		actual->setActual(false);
		if(actual->getShowPoints())
			actual->SetShowPoints(false);
	}	
	m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
	m_popmenu.Enable(pwID_ADDNEWPOINT,false);
	m_popmenu.Enable(pwID_SHOWPOINTS,false);
	m_popmenu.Enable(pwID_DELPOINT,false);
	m_popmenu.Enable(pwID_MYZOOMIN,false);
	m_popmenu.Enable(pwID_MYZOOMOUT,false);
	m_popmenu.Enable(pwID_STARTDRAWING,false);
	m_popmenu.Enable(pwID_SPLINE,false);
	m_popmenu.Enable(pwID_LINE,false);
	m_popmenu.Enable(pwID_STOPDRAWING,true);
	m_popmenu.Enable(pwID_SAVE,false);
	m_popmenu.Enable(pwID_LOAD,false);
	m_popmenu.Enable(pwID_CHANGECOLOR,false);
	m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,false);

	if(!drawing)
	{
		drawing=true;
		
		
		actual=new pGraphicalFunction(wxT("f(x) = function1(x)"),mpALIGN_NE);
		actual->setActual(true);
		actual->setFromWindow(true);
		actual->setScaleWay(USER_SCALE);
		actual->SetDrawing(drawing);
		actual->setFactorZoom(zoomFactor);
		
		//we change the offsets
		setOffsetPixelX(actual->getOffsetPixelsX());
		setOffsetPixelY(actual->getOffsetPixelsY());
		setOffsetX(actual->getOffsetX());
		setOffsetY(actual->getOffsetY());
	
		AddLayer(actual);
		wxPen mypen(*wxRED, 5, wxSOLID);
		mypen.SetWidth(2);
		actual->SetPen( mypen);
		
		/*
		int result = wxMessageBox("Do you Want a Smooth Curve?", "Spline Points", wxYES_NO | wxCANCEL);
		if(result==wxYES)
		{
			actual->setType(2);
		}
		*/
		
		/**************************************************************************/
		// Setting Maximums
		/**************************************************************************/
	
		//opening  the dialog of maximums
		float maxX=0,maxY=0;
		MaximumsDialog *dlg=new MaximumsDialog(this,_T("Set Maximums"));
		
		if(dlg->ShowModal()== wxID_OK )
		{
			maxX=dlg->getXValue();
			maxY=dlg->getYValue();
			if(maxX>0 && maxY>0 && actual->getFromWindow())
			{
				setMaxScrX(maxX);
				setMaxScrY(maxY);
				
				actual->setMaxX(maxScrX);				
				actual->setMinX(minScrX);
				actual->setMaxY(maxY);
				actual->setMinY(0);
				
				actual->setMinShowedX(0);
				actual->setMinShowedY(0);
				actual->setMaxShowedX(maxX);
				actual->setMaxShowedY(maxY);
				
				setActualScales();
			}
			else if(maxX<0 || maxY<0)
			{
				 wxMessageBox(_T("Both numbers have to be positive, please enter valid numbers"), _T("Error"),
                            wxOK);
				 
				 DelLayer(actual);
				 actual=NULL;
						
				m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
				m_popmenu.Enable(pwID_ADDNEWPOINT,false);
				m_popmenu.Enable(pwID_SHOWPOINTS,false);
				m_popmenu.Enable(pwID_DELPOINT,false);
				m_popmenu.Enable(pwID_MYZOOMIN,false);
				m_popmenu.Enable(pwID_MYZOOMOUT,false);
				m_popmenu.Enable(pwID_STARTDRAWING,true);
				m_popmenu.Enable(pwID_SPLINE,false);
				m_popmenu.Enable(pwID_LINE,false);
				m_popmenu.Enable(pwID_STOPDRAWING,false);
				m_popmenu.Enable(pwID_SAVE,false);
				m_popmenu.Enable(pwID_LOAD,true);
				m_popmenu.Enable(pwID_CHANGECOLOR,false);
				m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,false);
				drawing=false;
				//actual->SetDrawing(false);

			}

			else if(maxX==0 && maxY==0)
			{
				actual->setMaxX(100);
				actual->setMinX(0);
				actual->setMaxY(100);
				actual->setMinY(0);
					
				actual->setMinShowedX(0);
				actual->setMinShowedY(0);
				actual->setMaxShowedX(100);
				actual->setMaxShowedY(100);

				maxScrX=100;
				maxScrY=100;
				minScrX=0;
				minScrY=0;

				setActualScales();
			}
			
		}
		
        else if(dlg->ShowModal()== wxID_CANCEL)
		{
			DelLayer(actual);
			actual=NULL;
					
			m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
			m_popmenu.Enable(pwID_ADDNEWPOINT,false);
			m_popmenu.Enable(pwID_SHOWPOINTS,false);
			m_popmenu.Enable(pwID_DELPOINT,false);
			m_popmenu.Enable(pwID_MYZOOMIN,false);
			m_popmenu.Enable(pwID_MYZOOMOUT,false);
			m_popmenu.Enable(pwID_STARTDRAWING,true);
			m_popmenu.Enable(pwID_SPLINE,false);
			m_popmenu.Enable(pwID_LINE,false);
			m_popmenu.Enable(pwID_STOPDRAWING,false);
			m_popmenu.Enable(pwID_SAVE,false);
			m_popmenu.Enable(pwID_LOAD,true);
			m_popmenu.Enable(pwID_CHANGECOLOR,false);
			m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,false);
			drawing=false;
			//actual->SetDrawing(false);

		}
		dlg->Destroy();
		if(drawing)
		{
			//------------------------------------------
			//Sending the paarticular event of changed actual function
			//-------------------------------------------
			wxCommandEvent cevent( wxEVT_PPLOTTER_CHANGED_FUNCTION, GetId() );
			cevent.SetEventObject(this);
			GetEventHandler()->ProcessEvent( cevent );
		}
	}
	
}
/**
Stop the drawing of the actual function
*/
void pPlotterWindow::onStopDrawing(wxCommandEvent& aEvent)
{
	drawing=false;
	actual->SetDrawing(drawing);
	functions.Append(actual);
	addFunctionToMove(actual);
	m_popmenu.Enable(pwID_ADDNEWPOINT,true);
	m_popmenu.Enable(pwID_DELPOINT,true);
	m_popmenu.Enable(pwID_SHOWPOINTS,true);
	m_popmenu.Enable(pwID_MYZOOMIN,true);
	m_popmenu.Enable(pwID_MYZOOMOUT,true);
	m_popmenu.Enable(pwID_STARTDRAWING,true);
	m_popmenu.Enable(pwID_SPLINE,true);
	m_popmenu.Enable(pwID_STOPDRAWING,false);
	m_popmenu.Enable(pwID_LINE,false);
	m_popmenu.Enable(pwID_CHANGECOLOR,true);
	m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,true);

	if(actual->getSizePoints()==0||actual->getSizePoints()==1)
	{	  
	
	  m_popmenu.Enable(pwID_ADDNEWPOINT,false);
	  //functions.DeleteObject(actual);
	  DelLayer(actual);
	  actual=NULL;	 
	 
	}
	
	UpdateAll();
}
/**
* The user wants to see the points(given) of the function
*/
void pPlotterWindow::onShowPoints(wxCommandEvent& aEvent)
{
	actual->SetShowPoints(true);
	m_popmenu.Enable(pwID_NOSHOWPOINTS,true);
	m_popmenu.Enable(pwID_SHOWPOINTS,false);	
	UpdateAll();
}
/**
* The user doesnt want see the points of the function
*/
void pPlotterWindow::onNoShowPoints(wxCommandEvent& aEvent)
{	
	actual->SetShowPoints(false);
	m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
	m_popmenu.Enable(pwID_SHOWPOINTS,true);
	UpdateAll();	
}
/**
* if the user is going to add a point to the function
*/
void pPlotterWindow::onAddPoint(wxMouseEvent& aEvent)
{
	
	wxPoint point=aEvent.GetPosition();
	
	point.y=m_scrY-point.y;
	wxPoint realPoint=getRealPoint(point);

	bool isAValidPoint=realPoint.x>=0 && realPoint.y>=0;

	if(isAValidPoint && drawing)
	{
		if(actual->AddPoint(realPoint.x,realPoint.y))
		{
			text = wxString::Format(_T("added  point ( %d, %d)\n"), realPoint.x, realPoint.y);
			
			//m_log->AppendText(text);

			//if the function is smooth
			if(actual->getType()==2)
			{
				actual->clearSplineVectors();
				actual->addSplinesPoints();
				actual->initializeSplineVectors();				
			}
			
			UpdateAll();
		}
	}
	else if(isAValidPoint && !drawing && aEvent.m_shiftDown && actual!=NULL)
	{
		if(actual->AddNewPoint(realPoint.x,realPoint.y))
		{
			text = wxString::Format(_T("added  point ( %d, %d)\n"), realPoint.x, realPoint.y);
			//if the function is smooth
			if(actual->getType()==2)
			{
				actual->clearSplineVectors();
				actual->addSplinesPoints();
				actual->initializeSplineVectors();				
			}
			
			UpdateAll();
		}
	}
	//made a click for moving the points
	else if(!movingPoints)
	{
		if(actual)	
			movingPointIndex=actual->validPointOnFunction(realPoint);
		if(movingPointIndex>=0)
			movingPoints=true;
	}
					
	//------------------------------------------
	//Sending the  event
	//-------------------------------------------
	wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_ADD, GetId() );
	cevent.SetEventObject(this);

	//------------------------------------------
	//Sending the  general event
	//-------------------------------------------
	wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
	pevent.SetEventObject(this);
	//send the events
	GetEventHandler()->ProcessEvent( cevent );
	GetEventHandler()->ProcessEvent( pevent );
}

/**
* Adds a point  to the function after the definition of the initial points of the function
* know this point is  a point of the function
*
*/
void pPlotterWindow::onAddNewPoint(wxCommandEvent& aEvent)
{
	wxPoint point;
	point.x=m_clickedX;
	point.y=m_scrY-m_clickedY;

	wxPoint realPoint=getRealPoint(point);
	bool isAValidPoint=realPoint.x>=0 && realPoint.y>=0;

	
	if(isAValidPoint && actual->AddNewPoint(realPoint.x,realPoint.y))
	{
		text = wxString::Format(_T("added  point ( %d, %d)\n"), realPoint.x, realPoint.y);
		//if the function is smooth
		if(actual->getType()==2)
		{
			actual->clearSplineVectors();
			actual->addSplinesPoints();
			actual->initializeSplineVectors();
			
		}
		UpdateAll();
		//------------------------------------------
		//Sending the  event
		//-------------------------------------------
		wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_ADD, GetId() );
		cevent.SetEventObject(this);

		//------------------------------------------
		//Sending the  general event
		//-------------------------------------------
		wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
		pevent.SetEventObject(this);
		//send the events
		GetEventHandler()->ProcessEvent( cevent );
		GetEventHandler()->ProcessEvent( pevent );

	}
}

/**
* if the user is going to delete a point of the function
*/
void pPlotterWindow::onDeletePoint(wxCommandEvent& aEvent)
{
	wxPoint point;
	point.x=m_clickedX;
	point.y=m_scrY-m_clickedY;

	//actual->setScreenX(m_scrX);
	//actual->setScreenY(m_scrY);

	wxPoint realPoint=getRealPoint(point);
	
	bool isAValidPoint=realPoint.x>=0 && realPoint.y>=0;

	//this method verify a sensible region in every point of actual
	int pointIndex=actual->validPointOnFunction(realPoint);
	if(isAValidPoint && actual->deletePointAt(pointIndex))
	{
		setActualScales();
		if(actual->getSizePoints()==0)
		{
			//functions.DeleteObject(actual);
			//DelLayer(actual);
			//actual=NULL;
		}
		//if the function is smooth
		if(actual->getType()==2)
		{
			actual->clearSplineVectors();
			actual->addSplinesPoints();
			actual->initializeSplineVectors();
			
		}
		text = wxString::Format(_T("deleted  point ( %d, %d)\n"), realPoint.x, realPoint.y);
		UpdateAll();
		//------------------------------------------
		//Sending the  event
		//-------------------------------------------
		wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_DELETE, GetId() );
		cevent.SetEventObject(this);
		//------------------------------------------
		//Sending the  general event
		//-------------------------------------------
		wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
		pevent.SetEventObject(this);
		//send the events
		GetEventHandler()->ProcessEvent( cevent );
		GetEventHandler()->ProcessEvent( pevent );
	}  
}


/**
* If the mouse is moving in the plot area
* is because the user is moving a point of the current curve
* the user has to call before show points, to see the points of the 
* function
*/

void pPlotterWindow::onMouseMove(wxMouseEvent& event)
{
	wxPoint point=event.GetPosition();
	bool change=false;
	point.y=m_scrY-point.y;
	
	wxPoint realPoint=getRealPoint(point);
	bool isAValidPoint=realPoint.x>=0 && realPoint.y>=0;

	if(isAValidPoint && !drawing && actual!=NULL && !movingFunction && movingPoints)
	{
		//never is going to get in
		if(movingPointIndex==-1)
		{	
			//this method verify a sensible region in every point of _actualFunction
			movingPointIndex=actual->validPointOnFunction(realPoint);
					
		}
		else if(event.LeftIsDown())
		{				
			
			/*if((movingPointIndex-1)>=0 && (movingPointIndex+1)<actual->getSizePoints() && actual->getEditable())
			{
				wxNode* next= actual->GetPointAt(movingPointIndex+1);
				wxNode* before=actual->GetPointAt(movingPointIndex-1);
				if(next)
				{	
					pFunctionPoint* np=(pFunctionPoint*)(next->GetData());
					if(np)
						{
							int n=np->getRealX();
							if(realPoint.x>n)
							{
								wxPoint p;
								p.x=np->getRealX()-1;
								p.y=realPoint.y;
								change=actual->changePoint(p,movingPointIndex);
								if(change)
								{
									setActualScales();
															
									//if the function is smooth
									if(actual->getType()==2)
									{
										actual->clearSplineVectors();
										actual->addSplinesPoints();
										actual->initializeSplineVectors();
										
									}
									
									text = wxString::Format(_T("Moved  point ( %d, %d)\n"), p.x, p.y);
									UpdateAll();
									//------------------------------------------
									//Sending the particular event
									//-------------------------------------------
									wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_MOVE, GetId() );
									cevent.SetEventObject(this);

									//------------------------------------------
									//Sending the  general event
									//-------------------------------------------
									wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
									pevent.SetEventObject(this);

									//send the events
									GetEventHandler()->ProcessEvent( cevent );
									GetEventHandler()->ProcessEvent( pevent );
								}
							}
						}
				}
				if(before)
				{
					pFunctionPoint* bp=(pFunctionPoint*)(before->GetData());	
					if(bp)
					 { 
						 int b=bp->getRealX();
						 if(realPoint.x<b)
						{
							wxPoint p;
							p.x=bp->getRealX()+1;
							p.y=realPoint.y;
							change=actual->changePoint(p,movingPointIndex);
							if(change)
							{
								setActualScales();
								//if the function is smooth
								if(actual->getType()==2)
								{
									actual->clearSplineVectors();
									actual->addSplinesPoints();
									actual->initializeSplineVectors();
									
								}
								text = wxString::Format(_T("Moved  point ( %d, %d)\n"), p.x, p.y);
								UpdateAll();
								//------------------------------------------
								//Sending the particular event
								//-------------------------------------------
								wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_MOVE, GetId() );
								cevent.SetEventObject(this);

								//------------------------------------------
								//Sending the  general event
								//-------------------------------------------
								wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
								pevent.SetEventObject(this);

								//send the events
								GetEventHandler()->ProcessEvent( cevent );
								GetEventHandler()->ProcessEvent( pevent );
							}

						}
					  }
				}	
			}	*/
			// SIL ******************************************************************* // SIL
			if((movingPointIndex-1)>=0 && (movingPointIndex+1)<actual->getSizePoints() && actual->getEditable())
			{
				change=actual->changePoint(realPoint,movingPointIndex);
			}
			if(change)
			{
				setActualScales();
				//if the function is smooth
				if(actual->getType()==2)
				{
					actual->clearSplineVectors();
					actual->addSplinesPoints();
					actual->initializeSplineVectors();					
				}
				text = wxString::Format(_T("Moved  point ( %d, %d)\n"), realPoint.x, realPoint.y);
				UpdateAll();
				//------------------------------------------
				//Sending the particular event
				//-------------------------------------------
				wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_MOVE, GetId() );
				cevent.SetEventObject(this);

				//------------------------------------------
				//Sending the  general event
				//-------------------------------------------
				wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
				pevent.SetEventObject(this);

				//send the events
				GetEventHandler()->ProcessEvent( cevent );
				GetEventHandler()->ProcessEvent( pevent );
			}
			// SIL ******************************************************************* // SIL

			//change the point that is in the index, returns true if could be changed.
			if(!change && actual->changePoint(realPoint,movingPointIndex)&& actual->getEditable())
			{
				setActualScales();
				//if the function is smooth
				if(actual->getType()==2)
				{
					actual->clearSplineVectors();
					actual->addSplinesPoints();
					actual->initializeSplineVectors();
					
				}
				text = wxString::Format(_T("Moved  point ( %d, %d)\n"), realPoint.x,realPoint.y);
				
				UpdateAll();

				//------------------------------------------
				//Sending the particular event
				//-------------------------------------------
				wxCommandEvent cevent( wxEVT_PPLOTTER_POINT_MOVE, GetId() );
				cevent.SetEventObject(this);

				//------------------------------------------
				//Sending the  general event
				//-------------------------------------------
				wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
				pevent.SetEventObject(this);

				//send the events
				GetEventHandler()->ProcessEvent( cevent );
				GetEventHandler()->ProcessEvent( pevent );
			}
		}
		else
		{
			movingPointIndex=-1;
			movingPoints=false;
		}
	}
	//if the user is drawing
	else if(isAValidPoint && drawing)
	{

		actual->SetMousePoint(realPoint);		
		UpdateAll();
	}
	//is moving the function
	else if(isAValidPoint && movingFunction && actual!=NULL)
	{
		actual->setScreenX(m_scrX);
		actual->setScreenY(m_scrY);
		//int j=0; // JPRx
		if((initialMovingCLick==-1) && event.LeftIsDown()  )
		 {
			if(actual->isInFunction(realPoint.x,realPoint.y))
			{
				initialMovingCLick=event.GetPosition().x;
				int numPoints=actual->getSizePoints();
				int i=0;
				backUpActualVector.clear();
				while(i<numPoints)
				{
					//if(i>0 && i< (numPoints-1))
					//{
						wxNode* pointNode=actual->GetPointAt(i);
						pFunctionPoint* point= (pFunctionPoint*)pointNode->GetData();
						backUpActualVector.push_back(point->getRealX());
						
					//}
					i++;
				}
			}
		 }	
		else if(event.LeftIsDown())
		{
			wxPoint aux(initialMovingCLick,0);

			wxPoint p1r=getRealPoint(event.GetPosition());
			wxPoint p2r=getRealPoint(aux);

			double delta = p1r.x-p2r.x;
			int numPoints=actual->getSizePoints();
			int i=0;
			wxPoint p;
			if(type==HISTOGRAM)
			{
				while(i<numPoints)
				{
					if(i>0 && i<(numPoints-1))
					{
						wxNode* pointNode=actual->GetPointAt(i);
						pFunctionPoint* point= (pFunctionPoint*)pointNode->GetData();
						int xNew=backUpActualVector[i]+delta;
						//it has to preserve the state of functin				
						if(backUpActualVector[0]<xNew && backUpActualVector[numPoints-1]>xNew)
								point->setRealX(xNew);
					}
					i++;
				}
			}
			else
			{
				i=0;
				while(i<numPoints)
				{
				
					wxNode* pointNode=actual->GetPointAt(i);
					pFunctionPoint* point= (pFunctionPoint*)pointNode->GetData();
					int xNew=backUpActualVector[i]+delta;
					point->setRealX(xNew);
					i++;
				}
			}
			//If is a spline
			if(actual->getType()==2)
			{
				actual->clearSplineVectors();
				actual->addSplinesPoints();
				actual->initializeSplineVectors();

			}
			UpdateAll();

		}
		else 
		{	
			initialMovingCLick=-1;
		}
		
	}
}
/**
* if the user give us a double click is because he wants to change
* the actual function to the function that has that point
*/
void pPlotterWindow::onChangeActual(wxMouseEvent& event)
{
	wxString text = _T("\n points \n");
	
	
	if(!drawing)
	{
		//we have to call showpoints before changing the function
		wxPoint point=event.GetPosition();
		/*****************************/
		point.y=m_scrY-point.y;
		/*****************************/
       
	
		
		//real point on the function
		wxPoint realPoint;//=getRealPoint(point);
		bool isAValidPoint=realPoint.x>=0 && realPoint.y>=0;
		if(isAValidPoint)
		{
			wxNode * node= functions.GetFirst();
			while (node)
			{
				pGraphicalFunction* fnode=(pGraphicalFunction*)node->GetData();
				
				
				int maxX=fnode->getMaxXShowed();
				int maxY=fnode->getMaxYShowed();
				int minX=fnode->getMinXShowed();
				int minY=fnode->getMinYShowed();
				
				
				/*
				float sx=(((float)m_scrX-100)/(maxScrX-minScrX))*zoomFactor;
				float sy=(((float)m_scrY-50)/(maxScrY-minScrY))*zoomFactor;
				*/
				
				
				float sx=(((float)m_scrX-100)/(maxX-minX))*zoomFactor;
				float sy=(((float)m_scrY-50)/(maxY-minY))*zoomFactor;
				

				realPoint.x=((point.x-70-fnode->getOffsetPixelsX())/sx)+ fnode->getOffsetX()+ minX;
				realPoint.y=((point.y-40-fnode->getOffsetPixelsY())/sy)+ fnode->getOffsetY()+ minY;
				/*
				LOG
				*/
				if(fnode->getActual())
					text = wxString::Format(_T("Selected point ( %d, %d)\n"), realPoint.x, realPoint.y);
				//m_log->AppendText(text);
				
				bool hasIt=fnode->isInFunction(realPoint.x,realPoint.y);
					/*
					if(fnode->getEditable())	
						hasIt=fnode->isInFunction(realPoint.x,realPoint.y);
					else
						hasIt=false;
					*/
				if(hasIt)
				{
					if(actual!=fnode)
					{
						setActualFunction(fnode);
						//we change the offsets
						setOffsetPixelX(fnode->getOffsetPixelsX());
						setOffsetPixelY(fnode->getOffsetPixelsY());
						setOffsetX(fnode->getOffsetX());
						setOffsetY(fnode->getOffsetY());


						setActualScales();
						if(!actual->getFromWindow() && actual->getEditable()||actual->getFromWindow() && actual->getEditable())
						{
							m_popmenu.Enable(pwID_ADDNEWPOINT,true);
							m_popmenu.Enable(pwID_DELPOINT,true);
							if(actual->getShowPoints())
							{
								m_popmenu.Enable(pwID_SHOWPOINTS,false);
								m_popmenu.Enable(pwID_NOSHOWPOINTS,true);
							}
							else
							{
								m_popmenu.Enable(pwID_SHOWPOINTS,true);
								m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
							}
							m_popmenu.Enable(pwID_MYZOOMIN,true);
							m_popmenu.Enable(pwID_MYZOOMOUT,true);
							if(actual->getType()==2)//Smoothed function
							{
								m_popmenu.Enable(pwID_SPLINE,false);
								m_popmenu.Enable(pwID_LINE,true);
							}
							else
							{
								m_popmenu.Enable(pwID_SPLINE,true);
								m_popmenu.Enable(pwID_LINE,false);

							}
							if(type==2)
							{
								m_popmenu.Enable(pwID_LOAD,false);
								m_popmenu.Enable(pwID_STARTDRAWING,false);
							}	
							else
							{
							    m_popmenu.Enable(pwID_LOAD,true);
								m_popmenu.Enable(pwID_STARTDRAWING,true);
							}

							m_popmenu.Enable(pwID_SAVE,true);
							m_popmenu.Enable(pwID_LOAD,false);
							m_popmenu.Enable(pwID_STOPDRAWING,false);
							m_popmenu.Enable(pwID_CHANGECOLOR,true);
							m_popmenu.Enable(mpID_LINE_GUIDES,true);
							m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,true);
						}
						//for the functions that came from data and arent editables
						else if(!actual->getFromWindow() && !actual->getEditable()||actual->getFromWindow() && !actual->getEditable())
						{
							if(actual->getShowPoints())
							{
								m_popmenu.Enable(pwID_SHOWPOINTS,false);
								m_popmenu.Enable(pwID_NOSHOWPOINTS,true);
							}
							else
							{
								m_popmenu.Enable(pwID_SHOWPOINTS,true);
								m_popmenu.Enable(pwID_NOSHOWPOINTS,false);
							}
							if(actual->getType()==2)//Smoothed function
							{
								m_popmenu.Enable(pwID_SPLINE,false);
								m_popmenu.Enable(pwID_LINE,true);
							}
							else
							{
								m_popmenu.Enable(pwID_SPLINE,true);
								m_popmenu.Enable(pwID_LINE,false);

							}
							if(type==2)
							{
								m_popmenu.Enable(pwID_LOAD,false);
								m_popmenu.Enable(pwID_STARTDRAWING,false);
							}	
							m_popmenu.Enable(pwID_SAVE,false);
							m_popmenu.Enable(pwID_LOAD,false);
							m_popmenu.Enable(pwID_STOPDRAWING,false);
							m_popmenu.Enable(pwID_MYZOOMIN,true);
							m_popmenu.Enable(pwID_MYZOOMOUT,true);
							m_popmenu.Enable(pwID_CHANGECOLOR,true);
							m_popmenu.Enable(mpID_LINE_GUIDES,true);
							m_popmenu.Enable(pwID_SAVE,true);
							m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,true);

						}
						//if the function is smooth
						if(actual->getType()==2)
						{
							actual->clearSplineVectors();
							actual->addSplinesPoints();
							actual->initializeSplineVectors();
							
						}
		
						UpdateAll();
						//------------------------------------------
						//Sending the particular event
						//-------------------------------------------
						wxCommandEvent cevent( wxEVT_PPLOTTER_CHANGED_FUNCTION, GetId() );
						cevent.SetEventObject(this);

						//------------------------------------------
						//Sending the  general event
						//-------------------------------------------
						wxCommandEvent pevent( wxEVT_PPLOTTER, GetId() );
						pevent.SetEventObject(this);
						//send the events
						GetEventHandler()->ProcessEvent( cevent );
						GetEventHandler()->ProcessEvent( pevent );
					}
				}
				node=node->GetNext();
			}
		  }
		}
		//the user is finishing the drawing of the function
		else
		{
			drawing=false;
			functions.Append(actual);
		}
}

/**
* The user wants to change the type of function: line, smooth
* TODO is an extension
*/
void pPlotterWindow::changeFuntionType(int aTheType, bool aForAll)
{

}
//------------------------------------------
//If the data doesnt come from interaction
//-------------------------------------------
/**
*  Add a function to the window, given its points
*/
int pPlotterWindow:: addFunction(pGraphicalFunction * function)
{
	if(function->getType()==2)
	{
		function->initializeSplines();
		function->initializeSplineVectors();
		UpdateAll();
	}
	
//	bool added1= functions.Append(function)!=NULL; // JPRx
	functions.Append(function);  //EED	
	
	int id=functions.IndexOf(function);
	
	// bool added2=  AddLayer(function);// JPRx
	AddLayer(function); //EED
	 
	UpdateAll();
	return id;//added1 && added2;
}
/**
*  Delete a point of a function
*  @param point: is the real value that the functon takes, and is gointg to be deleted  
*/

bool pPlotterWindow::DeletePointFunction(pGraphicalFunction* function,wxPoint point)
{

	wxNode* node= functions.GetFirst();
	while(node)
	{
		pGraphicalFunction* f= (pGraphicalFunction*)node->GetData();
		if(f==function)
		{
			return function->DeletePoint(point.x,point.y);
		}
		node=node->GetNext();
	}
	return false;
}
/**
* Delete a function of the plotter
*/
bool pPlotterWindow::deleteFunction(pGraphicalFunction * f)
{
	functions.DeleteObject(f);
	functionsToMove.DeleteObject(f);
	return true;
}
/**
* Creates and returns a graphical funcion according to the indicated vectors.
*/
pGraphicalFunction * pPlotterWindow::getFunctionForVectors( std::vector<double> *vectorX, std::vector<double> *vectorY )
{
	double coordX = -1 ;	
	double coordY = -1;

	pGraphicalFunction * ff = new pGraphicalFunction( _T(" "), 1);

	int i=0;
	int sizeX = vectorX->size();
	int sizeY = vectorY->size();
	if( sizeX == sizeY )
	{
		while ( i < sizeX )
		{
			coordX = (*vectorX)[i];			
			coordY = (*vectorY)[i];
			ff -> AddPoint( coordX, coordY);		
			i++;
		}
	}

   InitFunctionForVectors( ff );
   return ff;
}

pGraphicalFunction * pPlotterWindow::getFunctionForVectors( double * vectorX, int sizeX, double * vectorY, int sizeY )
{
	double coordX = -1 ;	
	double coordY = -1;

	pGraphicalFunction * ff = new pGraphicalFunction( _T(" "), 1);

	/*wxString text = "\n Including points from two vectors \n";
	m_log->AppendText(text);*/

	int i=0;
	if(sizeX == sizeY)
	{
		while ( i < sizeX )
		{
			coordX = *vectorX;			
			coordY = *vectorY;
			ff -> AddPoint( coordX, coordY);		
	/*		text = wxString::Format("Included point ( %d, %d)\n", coordX, coordY);
			m_log->AppendText(text);*/

			vectorX++;
			vectorY++;		
			i++;
		}
	}

   InitFunctionForVectors( ff );
   return ff;
}



void pPlotterWindow::InitFunctionForVectors( pGraphicalFunction *ff )
{
	int maxX,maxY,minX,minY;
	/*
	if the function is  not drawed interactively the maxX and the 
	maxY are the from the points of the function
	*/
	maxX=ff->getMaxX();
	maxY=ff->getMaxY();
	minX= ff->getMinX();
	minY= ff->getMinY();

		
	ff->setMinShowedX(minX);
	ff->setMinShowedY(minY);
	ff->setMaxShowedX(maxX);
	ff->setMaxShowedY(maxY);
	
	GetClientSize(&m_scrX,&m_scrY);
	//set

	if((maxX-minX)!=0 && (maxY-minY)!=0)
	{
		m_scaleX= ((float)m_scrX-100)/(maxX-minX);
		m_scaleY= ((float)m_scrY-50)/(maxY-minY);
	}
	maxScrX=maxX;
	maxScrY=maxY;
	minScrX=minX;
	minScrY=minY;
	
	
	if(type==HISTOGRAM)
	{	
		actual=ff;
		setActualScales();
		m_popmenu.Enable(pwID_NOSHOWPOINTS,true);
		m_popmenu.Enable(pwID_ADDNEWPOINT,true);
		m_popmenu.Enable(pwID_SHOWPOINTS,false);
		m_popmenu.Enable(pwID_DELPOINT,true);
		//m_popmenu.Enable(pwID_SPLINE,false);
		//m_popmenu.Enable(pwID_LINE,true);
		m_popmenu.Enable(pwID_SAVE,true);
		m_popmenu.Enable(pwID_LOAD,false);
		m_popmenu.Enable(pwID_CHANGECOLOR,true);
		//m_popmenu.Enable(pwID_STARTDRAWING,false);
		m_popmenu.Enable(mpID_LINE_GUIDES,true);
		m_popmenu.Enable(pwID_TRASLATEACTUALFUNCTION,true);
		//------------------------------------------
		//Sending the particular event of changed actual function
		//-------------------------------------------
		wxCommandEvent cevent( wxEVT_PPLOTTER_CHANGED_FUNCTION, GetId() );
		cevent.SetEventObject(this);
		GetEventHandler()->ProcessEvent( cevent );
	}
	
	/*
	maxScrX=100;
	minScrX=50;
	offsetX=50;
	ff->setOffsetX(50);
	*/
	//actual->setScreens(scrX,scrY);
	//actual->setScales();
	//setActualScales();
}
/*
bool pPlotterWindow::AddFunction(wxPoint realPoints[],int numberOfPoints,wxString name,int flags)
{
pGraphicalFunction* function= new pGraphicalFunction(name,flags);

for(int i= 0; i<numberOfPoints;i++)
{
int x=realPoints[i].x;
int y=realPoints[i].y;
bool added=function->AddPoint(x,y);
if(!added )
return added;
}
functions.Append(function);
bool addL=mpWindow::AddLayer(function);
if(addL)
{
mpWindow::UpdateAll();
}
return addL;
}
*/

/*
* Actualizes the view range of the plotter and the actual function
* @param newMinX Is the min-value to be shown in the x-scale
* @param newMaxX Is the max-value to be shown in the x-scale
*/
/*
DEPRECATED
*/
void pPlotterWindow :: actualizeViewRange(int newMinX, int newMaxX)
{
	int minPixX,maxPixX/*, min, max*/;  // JPRx
	double sx;
	/*
		getiing pixels
	*/
	int dx=newMaxX-newMinX;
	
	if(dx!=0)
	{
		sx= (((float)m_scrX-100)/dx)*zoomFactor;
	}
	
	 minPixX=newMinX*sx;
	 maxPixX=newMaxX*sx;

		//vx.at(i)-offsetX)*scaleX+offsetpx
	if(minScrX!=newMinX)
	{
		setOffsetX(newMinX);
		setMinScrX(newMinX);
		actual->setOffsetX(newMinX);
		actual->setMinShowedX(newMinX);				
		/*
		wxNode * node= functions.GetFirst();
		while (node)
			{
				pGraphicalFunction* fnode=(pGraphicalFunction*)node->GetData();
				if(fnode)
				{
					if(!fnode->getActual())
					{
						fnode->setScreens(m_scrX,m_scrY);
						fnode->setScales();
						//max=minPixX/fnode->getScaleX();
						min=minPixX/fnode->getScaleX();
						fnode->setOffsetX(min);
						fnode->setMinShowedX(min);
						
					}
				}
				node=node->GetNext();
			}
		*/
	    
	}
	if(maxScrX!=newMaxX)
	{
		setMaxScrX(newMaxX);
	    actual->setMaxShowedX(newMaxX);
		/*
		wxNode * node= functions.GetFirst();
		while (node)
			{
				
				pGraphicalFunction* fnode=(pGraphicalFunction*)node->GetData();
				if(fnode)
				{
					if(!fnode->getActual())
					{
						fnode->setScreens(m_scrX,m_scrY);
						fnode->setScales();
						max=maxPixX/fnode->getScaleX();
						//min=maxPixX/fnode->getScaleX();
						//fnode->setOffsetX(max);
						//fnode->setMinShowedX(min);
						fnode->setMaxShowedX(max);
					}
				}

				node=node->GetNext();
			}
		*/
	}
	/*
	if(actual->getMinXShowed()!=actual->getMinX() || actual->getMinYShowed()!=actual->getMinY()||
		actual->getMaxXShowed()!=actual->getMaxX() || actual->getMaxYShowed()!=actual->getMaxY())
	{
		m_popmenu.Enable(pwID_MYZOOMIN,false);
		m_popmenu.Enable(pwID_MYZOOMOUT,false);
	}
	else if(actual->getMinXShowed()==actual->getMinX() && actual->getMaxXShowed()==actual->getMaxX())
	{
		
		m_popmenu.Enable(pwID_MYZOOMIN,true);
		m_popmenu.Enable(pwID_MYZOOMOUT,true);
	}
	*/
		 
	UpdateAll();
}
/*
* Guide lines menu handler method that reacts to the mpID_LINE_GUIDES command event
* event The corresponding event to handle
*/
void pPlotterWindow :: OnGuideLines (wxCommandEvent   &event)
{
	wxString nextAction_text;
	if( drawGuides )
	{
		setLineGuidesCondition(false);
//		nextAction_text << "Turn on guide lines";
		nextAction_text = _T("Turn on guide lines");
		UpdateAll();
	}
	else
	{
		setLineGuidesCondition(true);
//		nextAction_text << "Turn off guide lines";
		nextAction_text = _T("Turn off guide lines");
		UpdateAll();
	}
	//------------------------------------------
	//Sending the paarticular event of changed actual function
	//-------------------------------------------
	wxCommandEvent cevent( wxEVT_PPLOTTER_GUIDELINES, GetId() );
	cevent.SetEventObject(this);
    GetEventHandler()->ProcessEvent( cevent );
	
	//SETTING LABEL
	m_popmenu.SetLabel ( mpID_LINE_GUIDES, nextAction_text ); 
}
/*
	Get a function in the plotter given the index
*/
pGraphicalFunction* pPlotterWindow::getFunction(int index)
{
	wxNode* node=NULL;
	if (functions.size()>index)
	{
		node=functions.Item(index);
	} // if

	if(node==NULL)
	{
		return NULL;
	} // if node
	return (pGraphicalFunction*)node->GetData();
}


/*
	  move the functions that the user wants to move
	  and that were set in functionsToMove
	  @param porcentageMinX:the percentage that the minShowed
	  of the functions have to be move
		0<=porcentageMinX<=1
	  @param porcentageMaxX:the percentage that the maxShowed
	  of the functions have to be move
		0<=porcentageMaxX<=1
	*/
void pPlotterWindow::moveFunctions( float porcentageMinX,float porcentageMaxX)
	{
		//Adding the actual function
	
		//functionsToMove.Append(actual);

		//
		//float minShowed,maxShowed,fMaxXShowed,fMinXShowed;
		float x,y;
		 
		
		int minShowed,maxShowed,fMaxXShowed,fMinXShowed;
		wxNode* fnode=functionsToMove.GetFirst();
		while(fnode)
		{
			pGraphicalFunction* fg=(pGraphicalFunction*)fnode->GetData();
			x=porcentageMaxX*(fg->getMaxX()-fg->getMinX());
			y=porcentageMinX*(fg->getMaxX()-fg->getMinX());
			
			maxShowed=fg->getMinX()+ x;
			minShowed=fg->getMinX()+ y;

			fMinXShowed=fg->getMinXShowed();
			fMaxXShowed=fg->getMaxXShowed();
			
			if(fMinXShowed!=minShowed)
			{
				if(fg->getActual())
				{
					setOffsetX(minShowed);
					setMinScrX(minShowed);
				}
				fg->setOffsetX(minShowed);
				fg->setMinShowedX(minShowed);				  
			}
			if(fMaxXShowed!=maxShowed)
			{
				if(fg->getActual())
				{
					setMaxScrX(maxShowed);
				}
				fg->setMaxShowedX(maxShowed);	
			}
			if(fg->getActual()&& (fg->getMinXShowed()!=fg->getMinX() || fg->getMinYShowed()!=fg->getMinY()||
								  fg->getMaxXShowed()!=fg->getMaxX() || fg->getMaxYShowed()!=fg->getMaxY()))
			{
				if(type!=HISTOGRAM)
				{
					m_popmenu.Enable(pwID_MYZOOMIN,false);
					m_popmenu.Enable(pwID_MYZOOMOUT,false);
				}
			}
			else if(fg->getActual()&& fg->getMinXShowed()==fg->getMinX() && fg->getMaxXShowed()==fg->getMaxX())
			{
				if(type!=HISTOGRAM)
				{
					m_popmenu.Enable(pwID_MYZOOMIN,true);
					m_popmenu.Enable(pwID_MYZOOMOUT,true);
				}
			}


					fnode=fnode->GetNext();
		}
}

/*
 adds a function such that when the min or max of the bar
 changes it is going to that function
*/
int pPlotterWindow::addFunctionToMove(pGraphicalFunction *function)
{
	//bool added1=  functionsToMove.Append(function)!=NULL; // JPRx
	functionsToMove.Append(function); // EED
	
	int id=functionsToMove.IndexOf(function);
	UpdateAll();
	return id;
}
//----------------------------
//Handling Options Menu
//----------------------------
void pPlotterWindow::setPopUpMenu(bool startD,bool stopD,bool smooth,bool line, bool zoomIn,
					  bool zoomOut,bool showPoints,bool noShowPoints,bool changeColor, bool addP,
					  bool delPoint,bool load,bool save)
{
	/*
	pwID_ADDPOINT = 2010,    //!< add a point to the function
	pwID_DELPOINT,       //!< delete a point of the function
	pwID_SHOWPOINTS,  //!<shows the points that the function has
	pwID_STARTDRAWING, //!<let to the user to start drawing the curve
	pwID_DELFUNCTION, //!<delete a function that is in the plotter
	pwID_STOPDRAWING,//!<Stops the drawing of the function
	pwID_ADDNEWPOINT,//!<add a new point to the function.
	pwID_NOSHOWPOINTS, //!<No show the points of the function.
	pwID_MYZOOMIN,//!<Zoom in the function
	pwID_MYZOOMOUT,//!<Zoom out the points of the function.
	pwID_SPLINE,//!<Spline the actual curve.
	pwID_LINE,//!<Piecewise the actual curve.
	pwID_SAVE,//!<Save the function in a .txt file.
	pwID_LOAD, //!<Load the function from a .txt file.
	pwID_CHANGECOLOR, //!<Change the color of the function
	pwID_TRASLATEACTUALFUNCTION //!<move the actual function
*/
	if(startD)
		m_popmenu.Remove( pwID_STARTDRAWING);
	if(stopD)
		m_popmenu.Remove( pwID_STOPDRAWING);
	if(load)
		m_popmenu.Remove( pwID_LOAD);
	if(save)
		m_popmenu.Remove( pwID_SAVE);
	if(showPoints)
		m_popmenu.Remove( pwID_SHOWPOINTS);
	if(noShowPoints)
		m_popmenu.Remove( pwID_NOSHOWPOINTS);
	if(smooth)
		m_popmenu.Remove( pwID_SPLINE);
	if(line)
		m_popmenu.Remove( pwID_LINE);
	if(zoomIn)
		m_popmenu.Remove( pwID_MYZOOMIN);
	if(zoomOut)
		m_popmenu.Remove( pwID_MYZOOMOUT);
	if(changeColor)
		m_popmenu.Remove( pwID_CHANGECOLOR);
	if(addP)
		m_popmenu.Remove( pwID_ADDPOINT);
	if(delPoint)
		m_popmenu.Remove( pwID_DELPOINT);
}


