/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkBaseData.h"

//-------------------------------------------------------------------
vtkBaseData::vtkBaseData()
{
	_z            			= 0;
	_t            			= 0;
	_marImageData 			= 0;
	_interpolate			= true;
	_fixAxis2D				= false;
	_opacityAxis			= 1.0;
	_observable 			= vtkObject::New();
	_cameraparallelScale 	= 100.0;
    _pointMouseX            = 0;
    _pointMouseY            = 0;
    _pointMouseZ            = 0;
}

//-------------------------------------------------------------------
vtkBaseData::~vtkBaseData()
{
}

//-------------------------------------------------------------------
void vtkBaseData::SetMarImageData(marImageData *marimagedata)
{
	_marImageData = marimagedata;
	//Configure();
}

//-------------------------------------------------------------------
vtkImageData* vtkBaseData::GetImageData()
{
	if(_marImageData)
	{
		return _marImageData->GetImageDataT(_t);
	}else{
		return 0;
	}
	
}

//-------------------------------------------------------------------
marImageData* vtkBaseData::GetMarImageData()
{
	return _marImageData;
}

//-------------------------------------------------------------------

void vtkBaseData::Configure()  // virtual
{
	vtkImageData* imageData = _marImageData->GetImageData();
	if(imageData !=NULL)
	{
		double range[2];
		imageData->GetScalarRange(range);
		if (range[1]<20000){
			//EED Borrame 
			//_imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow( (range[1]-range[0])/2 );
			//_imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel( (range[1]+range[0])/4 );
			SetColorWindow( (range[1]-range[0])/2 );
			SetColorLevel( (range[1]+range[0])/4 );
		} else {
			//EED Borrame
			//_imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow( 1000 );
			//_imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel( 500 );
			SetColorWindow( 1000 );
			SetColorLevel( 500 );

		} // range
	}	// img
}

//-------------------------------------------------------------------
void vtkBaseData::SetZ(double z)
{

	//int maxZ;

//	int dim[3];
//	_marImageData->GetDimensions(dim);
//	maxZ=dim[2];

	int ext[6];
	double *origin;
	
	
	vtkImageData* img = _marImageData->GetImageData();
	if(img!=NULL){
		/*img->GetWholeExtent(ext);
		maxZ=ext[5]-ext[4]+1;

		if (z>=maxZ)
		{
			//z=maxZ-1;
		}
		if (z<=0)
		{
			z=0;
		}

		_z=z;*/
		img->GetExtent(ext);
		origin = img->GetOrigin();
		if (z > ext[5])
		{
			z = ext[5] + origin[2];
		}
		if (z < ext[4])
		{
			z = ext[4] + origin[2];
		}

		_z=z;
		_observable->InvokeEvent(3);	
	}
}

//-------------------------------------------------------------------
double vtkBaseData::GetZ()
{
	return _z;
}

//-------------------------------------------------------------------
int vtkBaseData::GetT()
{
	return _t;
}

//-------------------------------------------------------------------
double vtkBaseData::GetX()  // virtual
{
	return 0;
}
//-------------------------------------------------------------------
double vtkBaseData::GetY()  // virtual
{
	return 0;
}


//-------------------------------------------------------------------
void vtkBaseData::SetT(double t)
{
	int maxT = _marImageData->GetMaxT();
	if (t>=maxT)
	{
		t=maxT-1;
	}
	if (t<=0)
	{
		t=0;
	}
	_t=(int)t;
}

//-------------------------------------------------------------------
void vtkBaseData::SetColorWindow(double colorWindow)
{
	_colorWindow = colorWindow;
}

//-------------------------------------------------------------------
void vtkBaseData::SetColorLevel(double colorLevel)	
{
	_colorLevel=colorLevel;
}

//-------------------------------------------------------------------
double vtkBaseData::GetColorWindow()	
{
	return _colorWindow;
}

//-------------------------------------------------------------------
double vtkBaseData::GetColorLevel()	
{
	return _colorLevel;
}


//-------------------------------------------------------------------
void vtkBaseData::AddObserver(int eventNumber, vtkCommand *observer)
{
	_observable->AddObserver( eventNumber , observer );
	//Configure();
}

//-------------------------------------------------------------------
bool vtkBaseData::GetInterpolate()	
{
	return _interpolate;
}

//-------------------------------------------------------------------
void vtkBaseData::SetInterpolate(bool value)	
{
	_interpolate = value;
}

//-------------------------------------------------------------------
bool vtkBaseData::GetFixAxis2D()	
{
	return _fixAxis2D;
}

//-------------------------------------------------------------------
void vtkBaseData::SetFixAxis2D(bool value)	
{
	_fixAxis2D = value;
}

//-------------------------------------------------------------------
double vtkBaseData::GetOpacityAxis()	
{
	return _opacityAxis;
}

//-------------------------------------------------------------------
void vtkBaseData::SetOpacityAxis(double value)	
{
	_opacityAxis = value;
}

//-------------------------------------------------------------------
double vtkBaseData::GetCameraParallelScale()
{
	return _cameraparallelScale;
}

//-------------------------------------------------------------------
void vtkBaseData::SetCameraParallelScale(double value)
{
	_cameraparallelScale=value;
}

//-------------------------------------------------------------------
void vtkBaseData::SetPointMouse(int x, int y , int z)
{
    _pointMouseX = x;
    _pointMouseY = y;
    _pointMouseZ = z;
}

//-------------------------------------------------------------------
void vtkBaseData::GetPointMouse(int &x, int &y , int &z)
{
    x = _pointMouseX;
    y = _pointMouseY;
    z = _pointMouseZ;
}

