/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKBASEDATA_H_
#define VTKBASEDATA_H_

#include "marTypes.h"
#include "vtkCommand.h"
#include "vtkImageData.h"
#include "marImageData.h"


class creaMaracasVisu_EXPORT vtkBaseData {
public:
	vtkBaseData();
	virtual 		~vtkBaseData();
	vtkImageData*	GetImageData();
	marImageData*	GetMarImageData();
	void			SetMarImageData(marImageData *marimagedata);
	virtual void	Configure();
	double			GetZ();
	void			SetZ(double z);
	int				GetT();
	void			SetT(double t);
	virtual 		double GetX();
	virtual 		double GetY();
	void 			SetColorWindow(double colorWindow);
	void 			SetColorLevel(double colorLevel);	
	double 			GetColorWindow();
	double 			GetColorLevel();	
	void 			AddObserver(int eventNumber, vtkCommand *observer);
	bool			GetInterpolate();
	void			SetInterpolate(bool value);
	bool			GetFixAxis2D();
	void			SetFixAxis2D(bool value);
	double			GetOpacityAxis();
	void			SetOpacityAxis(double value);	
	double			GetCameraParallelScale();
	void			SetCameraParallelScale(double value);
    void            SetPointMouse( int x, int y, int z);
    void            GetPointMouse( int &x, int &y, int &z);

protected:
	marImageData	*_marImageData;
	double			_z;
	int				_t;
	double			_colorWindow;
	double			_colorLevel;
	bool			_interpolate;
	bool			_fixAxis2D;
	double			_opacityAxis;
	vtkObject*		_observable;
	double			_cameraparallelScale;
    int             _pointMouseX;
    int             _pointMouseY;
    int             _pointMouseZ;
private:

};

#endif /*VTKBASEDATA_H_*/
