/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkClosePolyData.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.3 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkClosePolyData.h"

#include "vtkPolyData.h"
#include "vtkFeatureEdges.h"
#include "vtkStripper.h"
#include "vtkTriangleFilter.h"
//#include "vtkGLUTesselatorTriangleFilter.h"
#include "vtkAppendPolyData.h"
#include "vtkCleanPolyData.h"


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
  vtkCxxRevisionMacro(vtkClosePolyData, "$Revision: 1.3 $");
#else
  #include "vtkDataObject.h"
  #include "vtkInformation.h"
  #include "vtkDemandDrivenPipeline.h"
  #include "vtkInformationVector.h"
#endif

vtkStandardNewMacro(vtkClosePolyData);

//----------------------------------------------------------------------------
vtkClosePolyData::vtkClosePolyData()
{
}

//----------------------------------------------------------------------------
vtkClosePolyData::~vtkClosePolyData()
{
}


//----------------------------------------------------------------------------

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	// This method is much too long, and has to be broken up!
	// Furthermore we are loosing the normals !!!
	void vtkClosePolyData::Execute()
	{
	  vtkPolyData *input = this->GetInput();
	  vtkPolyData *output = this->GetOutput();
	  
	   //#closing the polydata see : close.py for details
	  vtkFeatureEdges *boundary = vtkFeatureEdges::New();
	  boundary->SetInput( input );
	  boundary->BoundaryEdgesOn ();
	  boundary->FeatureEdgesOff ();
	  boundary->NonManifoldEdgesOff ();
	  boundary->ManifoldEdgesOff ();
	  //boundary->ColoringOff ();

	  vtkStripper *stripper = vtkStripper::New();
	  stripper->SetInput( boundary->GetOutput() );
	  stripper->Update(); //important
	  boundary->Delete();

	  vtkPolyData *pd = vtkPolyData::New();
	  pd->SetPoints ( stripper->GetOutput()->GetPoints() );
	  pd->SetPolys  ( stripper->GetOutput()->GetLines() );
	  stripper->Delete();
	    
	  //vtkGLUTesselatorTriangleFilter *triangle = vtkGLUTesselatorTriangleFilter::New();
	  vtkTriangleFilter *triangle = vtkTriangleFilter::New();
	  triangle->SetInput( pd );
	  pd->Delete();
	    
	  vtkAppendPolyData *append = vtkAppendPolyData::New();
	  append->AddInput( input );
	  append->AddInput( triangle->GetOutput());
	  triangle->Delete();
	      vtkInformation
	  vtkCleanPolyData *clean = vtkCleanPolyData::New();
	  clean->SetInput( append->GetOutput());
	  append->Delete();
	    
	  // When all optimizations are complete, this squeeze will be unecessary.
	  // (But it does not seem to cost much.)
	  clean->Update();  //important before ShallowCopy
	  output->ShallowCopy( clean->GetOutput() );
	  clean->Delete();
	}

#else

int vtkClosePolyData::RequestData( vtkInformation *vtkNotUsed(request), vtkInformationVector **inputVector, vtkInformationVector *outputVector)
{
	// get the info objects
	vtkInformation *inInfo 		= inputVector[0]->GetInformationObject(0);
	vtkInformation *outInfo 	= outputVector->GetInformationObject(0);
	// get the input and output
	vtkPolyData *input 			= vtkPolyData::SafeDownCast(    inInfo->Get(vtkDataObject::DATA_OBJECT()));
	vtkPolyData *output 		= vtkPolyData::SafeDownCast(    outInfo->Get(vtkDataObject::DATA_OBJECT()));
	//#closing the polydata see : close.py for details

	vtkFeatureEdges *boundary 	= vtkFeatureEdges::New();
	boundary->SetInputData( input );
	boundary->BoundaryEdgesOn ();
	boundary->FeatureEdgesOff ();
	boundary->NonManifoldEdgesOff ();
	boundary->ManifoldEdgesOff ();
	// boundary->ColoringOff ();
	boundary->Update();

	vtkStripper *stripper = vtkStripper::New();
	stripper->SetInputConnection( boundary->GetOutputPort() );
	stripper->Update(); //important

	vtkPolyData *pd = vtkPolyData::New();
	pd->SetPoints ( stripper->GetOutput()->GetPoints() );
	pd->SetPolys  ( stripper->GetOutput()->GetLines()  );
	//vtkGLUTesselatorTriangleFilter *triangle = vtkGLUTesselatorTriangleFilter::New();

	vtkTriangleFilter *triangle = vtkTriangleFilter::New();
	triangle->SetInputData( pd );
	triangle->Update( );

	vtkAppendPolyData *append = vtkAppendPolyData::New();
	append->AddInputData( input );
	append->AddInputConnection( triangle->GetOutputPort() );
	append->Update();

	vtkCleanPolyData *clean = vtkCleanPolyData::New();
	clean->SetInputConnection( append->GetOutputPort());
	// When all optimizations are complete, this squeeze will be unecessary.
	// (But it does not seem to cost much.)
	clean->Update();  //important before ShallowCopy

	output->ShallowCopy( clean->GetOutput() );

	append	 -> Delete();
	clean	 -> Delete();
	boundary -> Delete();
	stripper -> Delete();
	pd		 -> Delete();
	triangle -> Delete();

	return 1;
}

#endif

//----------------------------------------------------------------------------
void vtkClosePolyData::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}
