/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <vtkVersionMacros.h>
#include "vtkImageViewer2_XYZ.h"
#include "vtkRenderer.h"
#include "vtkImageActor.h"
#include "vtkImageData.h"





//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
vtkImageViewer2_XYZ::vtkImageViewer2_XYZ()
{
	_colortable 		= NULL;
	_vtkimageviewer2 	= vtkImageViewer2::New();
	_vtkimageviewer2->GetRenderer()->GradientBackgroundOn();
	_vtkimageviewer2->GetRenderer()->SetBackground( 0.33 , 0.33 , 0.33 );
	_vtkimageviewer2->GetRenderer()->SetBackground2( 0.66 , 0.66 , 0.66 );
}

//-------------------------------------------------------------------
vtkImageViewer2_XYZ::~vtkImageViewer2_XYZ()
{
	//_vtkimageviewer2->Delete();
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::SetExtentDimension(int x1,int x2,
											 int y1,int y2,
											 int z1,int z2)
{
	_x1 = x1;
	_x2 = x2;
	_y1 = y1;
	_y2 = y2;
	_z1 = z1;
	_z2 = z2;
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::SetXSlice(int slice)
{
	vtkImageActor *imageActor = _vtkimageviewer2->GetImageActor();
	imageActor->SetDisplayExtent(slice, slice, _y1, _y2, _z1, _z2 );  
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::SetYSlice(int slice)
{
	vtkImageActor *imageActor = _vtkimageviewer2->GetImageActor();
	imageActor->SetDisplayExtent(_x1, _x2, slice, slice, _z1, _z2 );  
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::SetZSlice(int slice)
{
#if (VTK_MAJOR_VERSION >= 5)
//		_vtkimageviewer2->SetSlice( slice );
	vtkImageActor *imageActor = _vtkimageviewer2->GetImageActor();
	imageActor->SetDisplayExtent(_x1, _x2, _y1, _y2, slice, slice );  
#else
		_vtkimageviewer2->SetZSlice( slice );
#endif
}
//-------------------------------------------------------------------
int vtkImageViewer2_XYZ::GetXSlice()
{
	vtkImageActor *imageActor = _vtkimageviewer2->GetImageActor();
	return imageActor->GetDisplayExtent()[0];
}

//-------------------------------------------------------------------
int vtkImageViewer2_XYZ::GetYSlice()
{
	vtkImageActor *imageActor = _vtkimageviewer2->GetImageActor();
	return imageActor->GetDisplayExtent()[2];
}

//-------------------------------------------------------------------
int vtkImageViewer2_XYZ::GetZSlice()
{
	 int result;
#if (VTK_MAJOR_VERSION >= 5)
		result= _vtkimageviewer2->GetSlice( );
#else
		result= _vtkimageviewer2->GetZSlice( );
#endif	
	return result;
}

//-------------------------------------------------------------------
vtkImageViewer2 *vtkImageViewer2_XYZ::GetVtkImageViewer2()
{
	return _vtkimageviewer2;
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::setColorTransferFunction(vtkColorTransferFunction* colortable)
{	
	if(colortable!=NULL && colortable->GetSize()>0 && _colortable!=colortable)
	{
		_colortable = colortable;
		vtkImageMapToWindowLevelColors* imagemaptowindowlevel = _vtkimageviewer2->GetWindowLevel();
		imagemaptowindowlevel->SetLookupTable(_colortable);
	} // if colortable
}

//-------------------------------------------------------------------
void vtkImageViewer2_XYZ::setScalarsToColors(vtkScalarsToColors* colortable, int outputformat)
{
/* outputformat      VTK-8.1.1/Common/Core/vtkSystemIncludes.h
	VTK_LUMINANCE       1
	VTK_LUMINANCE_ALPHA 2
	VTK_RGB             3  OK
	VTK_RGBA            4
*/
	if( _colortable!=colortable)
	{
		_colortable = colortable;
		_vtkimageviewer2->GetWindowLevel()->SetOutputFormat( outputformat );
		_vtkimageviewer2->GetWindowLevel()->SetLookupTable(colortable);
		_vtkimageviewer2->GetWindowLevel()->SetOutputFormatToRGB();
//	vtkLookupTableDirectionVector2 *_LutEED = vtkLookupTableDirectionVector2::New();
//	_LutEED->SetVectorModeToRGBColors();
//	_vtkimageviewer2->GetWindowLevel()->SetLookupTable(_LutEED);
	} // if colortable
}


