/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInfoTextImage.h"

#include "vtkProperty2D.h"
#include "vtkTextProperty.h"
#include <vtkImageMapToWindowLevelColors.h>
//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

vtkInfoTextImage::vtkInfoTextImage()
{
	_vtkText_WindowLevel	= NULL;
	_vtkText_ColorLevel		= NULL;
	_vtkText_position		= NULL;
	_vtkText_pixelIntensity	= NULL;
	_vtkText_plane			= NULL;
	_marimagedata			= NULL;
}

//-------------------------------------------------------------------

vtkInfoTextImage::~vtkInfoTextImage()
{
}

//-------------------------------------------------------------------

void vtkInfoTextImage::Configure()
{
	if(_vtkText_WindowLevel == NULL){
		_vtkText_WindowLevel	= Create_Text_Label( 10	, 60 );
		_vtkText_ColorLevel		= Create_Text_Label( 10	, 45 );
		_vtkText_position		= Create_Text_Label( 10 , 30 );
		_vtkText_pixelIntensity	= Create_Text_Label( 10 , 15 );
		_vtkText_plane			= Create_Text_Label( 10 , 0 );
	} // if vtkText_WindowLevel
}

void vtkInfoTextImage::SetOpacity(double opacity)
{
	if (_vtkText_WindowLevel!=NULL) 
	{
		_vtkText_WindowLevel->GetProperty()->SetOpacity( opacity );
	}
	if (_vtkText_ColorLevel!=NULL) 
	{
		_vtkText_ColorLevel->GetProperty()->SetOpacity( opacity );
	}
	if (_vtkText_position!=NULL) 
	{
		_vtkText_position->GetProperty()->SetOpacity( opacity );
	}
	if (_vtkText_pixelIntensity!=NULL) 
	{
		_vtkText_pixelIntensity->GetProperty()->SetOpacity( opacity );
	}
	if (_vtkText_plane!=NULL) 
	{
		_vtkText_plane->GetProperty()->SetOpacity( opacity );
	}
}

//-------------------------------------------------------------------

void vtkInfoTextImage::SetMarImageData(marImageData *marimagedata)
{
	_marimagedata = marimagedata;
}

//-------------------------------------------------------------------

void vtkInfoTextImage::SetWxVtk2DBaseView(wxVtk2DBaseView *wxvtk2Dbaseview)
{
	_wxvtk2Dbaseview = wxvtk2Dbaseview;
}

//-------------------------------------------------------------------

vtkTextActor *vtkInfoTextImage::Create_Text_Label(int px, int py )
{
	// Text Window Level
	vtkTextActor *textActor = vtkTextActor::New();
	textActor->SetDisplayPosition(px, py);
	textActor->SetInput("0");
	// Set coordinates to match the old vtkScaledTextActor default value
	textActor->GetPosition2Coordinate()->SetCoordinateSystemToNormalizedViewport();
	textActor->GetPosition2Coordinate()->SetValue( 0.2 , 0.2 );
	vtkTextProperty *tprop = textActor->GetTextProperty();
	tprop->SetFontSize(14);
	tprop->SetFontFamilyToArial();
	tprop->SetColor(1, 1, 0);
	_wxvtk2Dbaseview->GetRenderer()->AddActor2D(textActor);
	return textActor;
}

//-------------------------------------------------------------------

void vtkInfoTextImage::PutWindowLevel()
{
	double value =  _wxvtk2Dbaseview->_imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel()->GetWindow() ;
	char zTzxt[20];
	char resultText[50];
	strcpy(resultText,"w:");
	sprintf(zTzxt,"%3.4f",value);
	strcat(resultText,zTzxt);
	_vtkText_WindowLevel		-> SetInput(resultText);
}

//-------------------------------------------------------------------

void vtkInfoTextImage::PutColorLevel()
{
	double value = _wxvtk2Dbaseview->_imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel()->GetLevel();
	char zTzxt[20];
	char resultText[50];
	strcpy(resultText,"c:");
//	itoa (value,zTzxt,10);
	sprintf(zTzxt,"%3.2f",value);
	strcat(resultText,zTzxt);
	_vtkText_ColorLevel		-> SetInput(resultText);
}

//-------------------------------------------------------------------
void vtkInfoTextImage::PutPlane()
{
	int plane = _wxvtk2Dbaseview->GetDirection();
	char zTzxt[20];
	char resultText[50];
	if (plane==0) { strcpy(resultText,"plane:YZ"); }
	if (plane==1) { strcpy(resultText,"plane:XZ"); }
	if (plane==2) { strcpy(resultText,"plane:XY"); }
	_vtkText_plane		-> SetInput(resultText);
}

//-------------------------------------------------------------------

void vtkInfoTextImage::PutPosition(int xx,int yy, int zz)
{
	char zTzxt[50];
	char resultText[50];
	strcpy(resultText,"p: ");
	sprintf(zTzxt,"%d",xx);
	strcat(resultText,zTzxt);
	strcat(resultText," , ");
	sprintf(zTzxt,"%d",yy);
	strcat(resultText,zTzxt);
	strcat(resultText," , ");
	sprintf(zTzxt,"%d",zz);
	strcat(resultText,zTzxt);
	int nX = _marimagedata->GetXOriginal(xx);
	int nY = _marimagedata->GetYOriginal(yy);
	int nZ = _marimagedata->GetZOriginal(zz);
	strcat(resultText,"   (");
	sprintf(zTzxt,"%d",nX);
	strcat(resultText,zTzxt);
	strcat(resultText,",");
	sprintf(zTzxt,"%d",nY);
	strcat(resultText,zTzxt);
	strcat(resultText,",");
	sprintf(zTzxt,"%d",nZ);
	strcat(resultText,zTzxt);
	strcat(resultText,")");
	_vtkText_position		-> SetInput(resultText);
}

//-------------------------------------------------------------------

void vtkInfoTextImage::PutPixelIntensity(int xx, int yy, int zz)
{
	bool ok=true;
	int dim[3];
	double spa[3];
	vtkImageData *imagedata = _marimagedata->GetImageData();
	imagedata->GetDimensions(dim);
	imagedata->GetSpacing(spa);
	if ( (xx<0) || (xx>=dim[0]) || (yy<0) || (yy>=dim[1]) || (zz<0) || (zz>=dim[2]) )
	{
		ok=false;
	}
	char zTzxt[20];
	char resultText[50];
	strcpy(resultText,"GL: ");
	if (ok==true) 
	{
		if (imagedata->GetScalarType()==VTK_BIT)
		{
			char *pOrg=(char*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
			if(*pOrg==0)
			{
				sprintf(zTzxt,"%d",0);
			} else {
				sprintf(zTzxt,"%d",1);
			} // if pOrg
		} else if (imagedata->GetScalarType()==VTK_CHAR) {
			char *pOrg=(char*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_SIGNED_CHAR) {
			signed char *pOrg=(signed char*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_UNSIGNED_CHAR) {
			unsigned char *pOrg=(unsigned char*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_SHORT) {
			short *pOrg=(short*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_UNSIGNED_SHORT) {
			unsigned short *pOrg=(unsigned short*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_INT) {
			int *pOrg=(int*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			sprintf(zTzxt,"%d",*pOrg);
		} else if (imagedata->GetScalarType()==VTK_UNSIGNED_INT) {
			unsigned int *pOrg=(unsigned int*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			int tmp=*pOrg;
			sprintf(zTzxt,"%d",tmp);
		} else if (imagedata->GetScalarType()==VTK_LONG) {
			long *pOrg=(long*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			double tmp=*pOrg;
			sprintf(zTzxt,"%3.4f",tmp);
		} else if (imagedata->GetScalarType()==VTK_UNSIGNED_LONG) {
			unsigned long *pOrg=(unsigned long*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			double tmp=*pOrg;
			sprintf(zTzxt,"%3.4f",tmp);
		} else if (imagedata->GetScalarType()==VTK_FLOAT) {
			float *pOrg=(float*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			double tmp=(double)*pOrg;
			sprintf(zTzxt,"%3.4f",tmp);
		} else if (imagedata->GetScalarType()==VTK_DOUBLE) {
			double *pOrg=(double*)imagedata->GetScalarPointer ((int)xx,(int)yy,(int)zz);
	//		itoa (*pOrg,zTzxt,10);
			double tmp=*pOrg;
			sprintf(zTzxt,"%3.4f",tmp);
		} // if imagedata  Type
	}  else  {
		strcpy(zTzxt,"---");
	} // if ok
	strcat(resultText,zTzxt);
	_vtkText_pixelIntensity	-> SetInput(resultText);
}
