/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInfoTextImageInteractor.h"

#include "wxVtk2DBaseView.h"

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

vtkInfoTextImageInteractor::vtkInfoTextImageInteractor()
{
}

//-------------------------------------------------------------------
vtkInfoTextImageInteractor::~vtkInfoTextImageInteractor()
{
}

//-------------------------------------------------------------------

void vtkInfoTextImageInteractor::SetModelVtkInfoTextImage(vtkInfoTextImage *vtkinfotextimage)
{
	_vtkinfotextimage	= vtkinfotextimage;
}

//-------------------------------------------------------------------
bool vtkInfoTextImageInteractor::OnMouseMove()
{
	int X,Y;
	crea::wxVTKRenderWindowInteractor *wxVTKiren;
	wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
	wxVTKiren->GetEventPosition(X,Y);

	/*JCP 14/05/2009
	 * int z = (int)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetVtkBaseData()->GetZ());*/
	
	double dxx,dyy,dzz;
	double ixx,iyy,izz;

    int z   = (int)((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetVtkBaseData()->GetZ();
        dxx = X;
		dyy = Y;
		dzz = z;
	
	_vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->TransFromCoordScreenToWorld(dxx,dyy,dzz,true);

	
	GetVtkInfoTextImage()->PutWindowLevel();
	GetVtkInfoTextImage()->PutColorLevel();
	GetVtkInfoTextImage()->PutPlane();

	int tempext[6];
	((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetVtkBaseData()->GetImageData()->GetExtent(tempext);

	if(tempext[0] <= dxx && dxx <= tempext[1] && tempext[2] <= dyy && dyy <= tempext[3])
	{
		ixx=(int)(dxx+0.5);
		iyy=(int)(dyy+0.5);
		izz=(int)(dzz+0.0);
    
//EED 2022-01-24
        ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetVtkBaseData()->SetPointMouse(ixx,iyy,izz);
    
		GetVtkInfoTextImage()->PutPosition( ixx , iyy , izz );
		GetVtkInfoTextImage()->PutPixelIntensity( ixx , iyy , izz );
	}

	this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	return true;
}

//-------------------------------------------------------------------
vtkInfoTextImage *vtkInfoTextImageInteractor::GetVtkInfoTextImage()
{
	return _vtkinfotextimage;
}
