/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInfoTextImageInteractorPlane2D.h"

#include "vtkPlane2DView.h"
#include "wxVtk2DBaseView.h"

vtkInfoTextImageInteractorPlane2D::vtkInfoTextImageInteractorPlane2D()
{
}
//-------------------------------------------------------------------
vtkInfoTextImageInteractorPlane2D::~vtkInfoTextImageInteractorPlane2D()
{
}
//-------------------------------------------------------------------
bool vtkInfoTextImageInteractorPlane2D::OnMouseMove()
{
	int X,Y;
	crea::wxVTKRenderWindowInteractor *wxVTKiren;
	wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
	wxVTKiren->GetEventPosition(X,Y);

	int z = (int) ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetVtkBaseData()->GetZ();
	double xx=X,yy=Y,zz=z;

// --> dif
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView();
	vtkplane2Dview->TransfromCoordViewWorld2(xx,yy,zz);

	GetVtkInfoTextImage()->PutWindowLevel();
	GetVtkInfoTextImage()->PutColorLevel();
	GetVtkInfoTextImage()->PutPosition( (int)xx , (int)yy , (int)zz );
	GetVtkInfoTextImage()->PutPixelIntensity( (int)xx , (int)yy , (int)zz );

	this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	return true;
}
