/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkInteractorScrollZ.h"
#include "wxVtk2DBaseView.h"
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

vtkInteractorScrollZ::vtkInteractorScrollZ()
{
	_stateFordware=false;
}

//---------------------------------------------------------------------------
vtkInteractorScrollZ::~vtkInteractorScrollZ()
{
}

//---------------------------------------------------------------------------
bool vtkInteractorScrollZ::OnRightButtonDown()
{
	vtkRenderWindowInteractor *interactor = _vtkInteractorStyleBaseView->GetInteractor();
	if ((interactor->GetControlKey()==0) && (interactor->GetShiftKey()==0) ){
		_stateFordware	= true;
		_fordwareX 	= interactor->GetEventPosition()[0];
		_fordwareY 	= interactor->GetEventPosition()[1];
		/*JCP 14/05/2009
		_sliceZ 	= _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetActualSlice();
		*/
		_sliceZ 	= ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetActualSlice();
	}
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorScrollZ::OnRightButtonUp()
{
	_stateFordware=false;
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorScrollZ::OnMouseMove ()
{
	if (_stateFordware==true)
	{
        int fy			= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
		double delta	= (_fordwareY - fy)/(20.0);
		int direction	= ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetDirection( );
		if ( (direction==0) || (direction==2) )
		{
			delta=(-1)*delta;
		} // if direction
		((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->SetActualSlice( _sliceZ + (int)delta );
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	} // if _stateFordware
	return true;
}



