/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInteractorStyle3DView.h"
#include "matrix.h"
#include "vtkPointPicker.h"
#include "UtilVtk3DGeometriSelection.h"

vtkInteractorStyle3DView::vtkInteractorStyle3DView()
{
}
//---------------------------------------------------------------------------
vtkInteractorStyle3DView::~vtkInteractorStyle3DView()
{
}
//---------------------------------------------------------------------------
bool vtkInteractorStyle3DView::OnLeftDClick()
{
	SelectMarchibCubePoint();
	return true;
}
//---------------------------------------------------------------------------
bool vtkInteractorStyle3DView::SelectMarchibCubePoint()
{
	bool ok=false;
    gtm::TVector< double > pO( 3 ), pF( 3 ), pp( 3 ), cp( 3 );
    gtm::TVector< double > xc( 3 );
    gtm::TVector< double > x1( 3 ), n1( 3 );
    gtm::TVector< double > x2( 3 ), n2( 3 );

	double pickPoint[ 3 ], cameraPos[ 3 ];
	int eventrwi[2];
	vtkPointPicker* picker = vtkPointPicker::New( );	
	eventrwi[0]= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	eventrwi[1]= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	vtkRenderer *pRenderer = _vtkInteractorStyleBaseView->GetWxVtk3DBaseView()->GetRenderer();
	picker->Pick( eventrwi[0], eventrwi[1], 0.0, pRenderer );
	pRenderer->GetActiveCamera( )->GetPosition( cameraPos );
	picker->GetPickPosition( pickPoint );
	picker->Delete( );

	pp( 0 ) = pickPoint[ 0 ]; pp( 1 ) = pickPoint[ 1 ]; pp( 2 ) = pickPoint[ 2 ];
    cp( 0 ) = cameraPos[ 0 ]; cp( 1 ) = cameraPos[ 1 ]; cp( 2 ) = cameraPos[ 2 ];


//EED 27 sep 2006  (1/2)
//	wxVtkMPR3DView *wxvtkmpr3Dview = (wxVtkMPR3DView *)_vtkInteractorStyleBaseView->GetWxVtk3DBaseView();
//	double spc[3];
//	wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetSpacing(spc);


	vtkImageData *imageData = GetWxVtkMPR3DView()->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	int dim[3];
	double spc[3];
	imageData->GetDimensions(dim);
	imageData->GetSpacing(spc);


	vtkMarchingCubes *mcubes = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetMCubes(0);
	

	UtilVtk3DGeometriSelection utilVtk3DGeometriSelection;
	utilVtk3DGeometriSelection.SetDimentions(dim[0],dim[1],dim[2]);

	utilVtk3DGeometriSelection.SetMarchingCube(mcubes);

    double fac;
    fac = GTM_MAX( dim[0], dim[2] );


    if( utilVtk3DGeometriSelection.FindCubePointsFromPoints(
      pO.GetAnsiRef( ), pF.GetAnsiRef( ),
      pp.GetAnsiRef( ), cp.GetAnsiRef( ) )  ) 
	{

		if( utilVtk3DGeometriSelection.GetPointAndNormalIntersection(
			    x1.GetAnsiRef( ), n1.GetAnsiRef( ),
				pO.GetAnsiRef( ), pF.GetAnsiRef( ) ) ) 
		{
		    if( utilVtk3DGeometriSelection.GetPointAndNormalIntersection(
			      x2.GetAnsiRef( ), n2.GetAnsiRef( ),
				 ( x1 - n1 ).GetAnsiRef( ), ( x1 - ( n1 * fac ) ).GetAnsiRef( )   ) ) 
			{
				xc = ( x2 + x1 ) * 0.5;
//EED 27 sep 2006  (2/2)
				this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetX(xc(0)/spc[0]);
				this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetY(xc(1)/spc[1]);
				this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetZ(xc(2)/spc[2]);
				wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
				this->_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
				this->_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

				ok=true;
			}
		}
	}


	return ok;
}
//-------------------------------------------------------------------
void vtkInteractorStyle3DView::SetWxVtkMPR3DView( wxVtkMPR3DView *wxvtkmpr3Dview )
{
	_wxvtkmpr3Dview = wxvtkmpr3Dview;
}
//-------------------------------------------------------------------
wxVtkMPR3DView *vtkInteractorStyle3DView::GetWxVtkMPR3DView()
{
	return _wxvtkmpr3Dview;
}
//-------------------------------------------------------------------
wxVtkClipping3DView *vtkInteractorStyle3DView::GetWxVtkClipping3DView()
{
	return _wxvtkclipping3Dview;
}
//-------------------------------------------------------------------
void vtkInteractorStyle3DView::SetWxVtkClipping3DView( wxVtkClipping3DView *wxvtkclipping3Dview)
{
	_wxvtkclipping3Dview = wxvtkclipping3Dview;
}

