/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInteractorStyleBaseView.h"

#include "wxVtk3DBaseView.h"
#include "wxVtk2DBaseView.h"

#include "vtkObjectFactory.h"

#include "InteractorStyleMaracas.h"

vtkStandardNewMacro(vtkInteractorStyleBaseView);
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

vtkInteractorStyleBaseView::vtkInteractorStyleBaseView()
{
	_refresh_waiting		= false;
	_parent_refresh_waiting	= false;
	_blockRefresh			= false;
	
	//EED27Juillet2011
	SetMouseWheelMotionFactor(0.5);
}
//---------------------------------------------------------------------------
vtkInteractorStyleBaseView::~vtkInteractorStyleBaseView()
{
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnMouseMove() // virtual 
{
	CallLstInteractorStyleMaracas(3);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnLeftButtonDown()  // virtual 
{
	CallLstInteractorStyleMaracas(4);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnLeftButtonUp() // virtual 
{
	CallLstInteractorStyleMaracas(5);
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnLeftDClick()  // virtual
{
	CallLstInteractorStyleMaracas( 11 );
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnMiddleButtonDown()  // virtual 
{
	CallLstInteractorStyleMaracas(6);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnMiddleButtonUp() // virtual 
{
	CallLstInteractorStyleMaracas(7);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnMiddleDClick()  // virtual
{
	CallLstInteractorStyleMaracas( 13 );
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnRightButtonDown() // virtual 
{
	CallLstInteractorStyleMaracas(1);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnRightButtonUp() // virtual 
{
	CallLstInteractorStyleMaracas(2);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::OnRightDClick()  // virtual
{
	CallLstInteractorStyleMaracas( 12 );
}


void  vtkInteractorStyleBaseView::OnMouseWheelForward()  // virtual
{
	CallLstInteractorStyleMaracas( 15 );
}

void vtkInteractorStyleBaseView::OnMouseWheelBackward() // virtual
{
	CallLstInteractorStyleMaracas( 16 );
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::AddInteractorStyleMaracas(InteractorStyleMaracas* interactorStyleMaracas)
{
	interactorStyleMaracas->SetVtkInteractorStyleBaseView(this);
	_lstInteractorStyleMaracas.push_back(interactorStyleMaracas);
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView::RemoveInteractorStyleMaracas(InteractorStyleMaracas* interactorStyleMaracas)
{
	interactorStyleMaracas->RemoveVtkInteractorStyleBaseView();
	int i, size = _lstInteractorStyleMaracas.size();
	std::vector< InteractorStyleMaracas* >::iterator iter = _lstInteractorStyleMaracas.begin();
	bool removed = false;
	for (i=0; !removed && i<size; i++)
	{
		if ( _lstInteractorStyleMaracas[i] == interactorStyleMaracas )
		{
			_lstInteractorStyleMaracas.erase(iter);
			removed = true;
		} else {
		  iter++;
		}		
	}		
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::InsertInteractorStyleMaracas(int pos, InteractorStyleMaracas* interactorStyleMaracas)
{
	interactorStyleMaracas->SetVtkInteractorStyleBaseView(this);
	_lstInteractorStyleMaracas.insert(_lstInteractorStyleMaracas.begin()+pos,interactorStyleMaracas);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::CallLstInteractorStyleMaracas(int type)
{
	InteractorStyleMaracas *intStyMar;

	int i,size=_lstInteractorStyleMaracas.size();


	for (i=0;i<size;i++)
	{
		if (i < (int)_lstInteractorStyleMaracas.size() )
		{
			intStyMar = _lstInteractorStyleMaracas[i];
		} else {
			intStyMar=NULL;
		}
		if (intStyMar!=NULL && intStyMar->GetActive()==true){
			if (type ==1)
			{  // OnRightButtonDown
				if (intStyMar->OnRightButtonDown()==false)
				{
					i=size;
				}
			}
			if (type ==2)
			{  // OnRightButtonUp
				if (intStyMar->OnRightButtonUp()==false)
				{
					i=size;
				}
			}
			if (type==3)
			{  // OnMouseMouve
				if (intStyMar->OnMouseMove()==false)
				{
					i=size;
				}
			}
			if (type==4)
			{  // OnLeftButtonDown
				if (intStyMar->OnLeftButtonDown()==false)
				{
					i=size;
				}
			}
			if (type==5)
			{  // OnLeftButtonUp
				if (intStyMar->OnLeftButtonUp()==false)
				{
					i=size;
				}
			}
			if (type==6)
			{  // OnMiddleButtonDown
				if (intStyMar->OnMiddleButtonDown()==false)
				{
					i=size;
				}
			}
			if (type==7)
			{  // OnMiddleButtonUp
				if (intStyMar->OnMiddleButtonUp()==false)
				{
					i=size;
				}
			}
			if (type==10)
			{  // OnMiddleButtonUp
				if (intStyMar->OnChar()==false)
				{
					i=size;
				}
			}
			if (type==11)
			{  // OnLeftDClick
				if (intStyMar->OnLeftDClick()==false)
				{
					i=size;
				}
			}
			if (type==12)
			{  // OnRightDClick
				if (intStyMar->OnRightDClick()==false)
				{
					i=size;
				}
			}
			if (type==13)
			{  // OnMiddleDClick
				if (intStyMar-> OnMiddleDClick()==false)
				{
					i=size;
				}
			}
			// 14 ... old OnMouseWheelFordward
			if (type==15)
			{  // OnMouseWheelForward
				if (intStyMar->OnMouseWheelForward()==false)
				{
					i=size;
				}
			}
			if (type==16)
			{  // OnMouseWheelBackward
				if (intStyMar->OnMouseWheelBackward()==false)
				{
					i=size;
				}
			}
			
			
		} // if active
	} // for

	EvaluateToRefresh();
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView::OnChar()  // virtual 
{    
//	char a=GetInteractor()->GetKeyCode();
	CallLstInteractorStyleMaracas(10);
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::TransformCoordinate(double &X, double &Y, double &Z)
{
	if(((wxVtk2DBaseView*)GetWxVtk2DBaseView())->_imageViewer2XYZ){
		vtkImageViewer2 *imageViewer = ((wxVtk2DBaseView*)GetWxVtk2DBaseView())->_imageViewer2XYZ->GetVtkImageViewer2();

		imageViewer->GetRenderer()->SetDisplayPoint((int)X, (int)Y, (int)Z);
		imageViewer->GetRenderer()->DisplayToWorld();
		double fP[4];
		imageViewer->GetRenderer()->GetWorldPoint( fP );

		if ( fP[3] )
		{
			fP[0] /= fP[3];
			fP[1] /= fP[3];
			fP[2] /= fP[3];
		}

	// EEDx5
		((wxVtk2DBaseView*)GetWxVtk2DBaseView())->TransformCoordinate_spacing_ViewToModel(fP[0],fP[1],fP[2]);

		X=fP[0];
		Y=fP[1];
		Z=fP[2];
	}
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::SetwxVtkBaseView(wxVtkBaseView *wxvtkbaseview)
{
	_wxvtkbaseview = wxvtkbaseview;
}
//---------------------------------------------------------------------------
/*JCP 13/05/2009
wxVtk2DBaseView* vtkInteractorStyleBaseView::GetWxVtk2DBaseView()
{
	return (wxVtk2DBaseView*)_wxvtkbaseview;
}
//---------------------------------------------------------------------------
wxVtk3DBaseView* vtkInteractorStyleBaseView::GetWxVtk3DBaseView()
{
	return (wxVtk3DBaseView*)_wxvtkbaseview;
}JCP 13/05/2009*/
wxVtkBaseView* vtkInteractorStyleBaseView::GetWxVtk2DBaseView()
{
	return _wxvtkbaseview;
}
//---------------------------------------------------------------------------
wxVtkBaseView* vtkInteractorStyleBaseView::GetWxVtk3DBaseView()
{
	return _wxvtkbaseview;
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::SetActiveAllInteractors(bool ok)
{
	InteractorStyleMaracas *intStyMar;
	int i,size=_lstInteractorStyleMaracas.size();
	for (i=0;i<size;i++)
	{
		intStyMar = _lstInteractorStyleMaracas[i];
		intStyMar->SetActive(ok);
	}

}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::SetRefresh_waiting()
{
	_refresh_waiting=true;
}
//---------------------------------------------------------------------------
bool vtkInteractorStyleBaseView::GetRefresh_waiting()
{
	return _refresh_waiting;
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::SetParent_refresh_waiting()
{
	_parent_refresh_waiting=true;
}
//---------------------------------------------------------------------------
bool vtkInteractorStyleBaseView::GetParent_refresh_waiting()
{
	return _parent_refresh_waiting;
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::EvaluateToRefresh()
{
	if  ( _blockRefresh==false )
	{
		if ( (_refresh_waiting==true) && (_parent_refresh_waiting==false))
		{
			_refresh_waiting		= false;
			this->_wxvtkbaseview->Refresh();
		}
		if (_parent_refresh_waiting==true)
		{
			_parent_refresh_waiting	= false;
			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//CPR 13/01/2010
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			this->_wxvtkbaseview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
			this->_wxvtkbaseview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

			int i;
			int size = _lstParentToReport.size();
			for(i = 0; i<size; i++)
			{	
				_lstParentToReport[i]->ProcessEvent(newevent1);
			}//for
		}//if
	}//if _blockRefresh
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::BlockRefresh()
{
	_blockRefresh=true;
}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView::UnBlockRefresh()
{
	_blockRefresh=false;
}

wxEvtHandler* vtkInteractorStyleBaseView::GetParentToReport(int i)
{
	wxEvtHandler* parentToReport = NULL;
	if(i>=0 && i<_lstParentToReport.size())
	{	
		parentToReport = _lstParentToReport[i];
	}
	return parentToReport;

}

void vtkInteractorStyleBaseView::AddParentToReport(wxEvtHandler* parentToReport)
{
	_lstParentToReport.push_back(parentToReport);
}
