/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include "vtkInteractorStyleBaseView2D.h"
#include <vtkObjectFactory.h>

vtkStandardNewMacro(vtkInteractorStyleBaseView2D);

//---------------------------------------------------------------------------
vtkInteractorStyleBaseView2D::vtkInteractorStyleBaseView2D()
{
	////////////
	// RaC 04-2010 This mechanism of adding new functionalities has to be made externally in order 
	// to maintain a plugin architecture. 
	// Remember: The manualInteractorWindowLevel changes the window level over the image
	//           The vtkInteractorScrollZ changes the slice with right click interaction
	//			 This vtkInteractorStyleBaseView2D gives the minimal interaction with a 2D scene
	//
	// _manualinteractorwindowlevel= new manualInteractorWindowLevel();
	// AddInteractorStyleMaracas( _manualinteractorwindowlevel );
	//
	// _vtkInteractorScrollZ = new vtkInteractorScrollZ();
	// AddInteractorStyleMaracas(_vtkInteractorScrollZ);
	//
	//_vtkInteractorZoomCamera = interactorZoomcamera;
	//AddInteractorStyleMaracas(_vtkInteractorZoomCamera);
	//
	//
	////////////
}
//---------------------------------------------------------------------------
vtkInteractorStyleBaseView2D::~vtkInteractorStyleBaseView2D()
{
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::SetInteractorScrollZ(vtkInteractorScrollZ* interactorScroll)
{    
	_vtkInteractorScrollZ = interactorScroll;
	AddInteractorStyleMaracas(_vtkInteractorScrollZ);
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::SetInteractorWindowLevel(manualInteractorWindowLevel* interactorWindowLevel)
{    
	_manualinteractorwindowlevel = interactorWindowLevel;
	AddInteractorStyleMaracas(_manualinteractorwindowlevel);
}


//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::SetInteractorZoomCamera(vtkInteractorZoomCamera* interactorZoomcamera)
{    
	_vtkInteractorZoomCamera = interactorZoomcamera;
	AddInteractorStyleMaracas(_vtkInteractorZoomCamera);
}


//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnRightButtonDown()  // virtual
{    
	vtkInteractorStyleBaseView::OnRightButtonDown();

	if ((GetInteractor()->GetControlKey()==1) && (GetInteractor()->GetShiftKey()==0) )
	{
		this->vtkInteractorStyleImage::OnRightButtonDown();
	}
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnRightButtonUp()  // virtual
{
	vtkInteractorStyleBaseView::OnRightButtonUp();
	this->vtkInteractorStyleImage::OnRightButtonUp();
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnMouseMove () // virtual
{
	vtkInteractorStyleBaseView::OnMouseMove();
	this->vtkInteractorStyleImage::OnMouseMove();
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnLeftButtonDown() // virtual
{
	vtkInteractorStyleBaseView::OnLeftButtonDown();

	if ((GetInteractor()->GetControlKey()==0) && (GetInteractor()->GetShiftKey()==1) )
	{
		this->vtkInteractorStyleImage::OnLeftButtonDown();
	}
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnLeftButtonUp () // virtual
{
	vtkInteractorStyleBaseView::OnLeftButtonUp();

	this->vtkInteractorStyleImage::OnLeftButtonUp();
}

//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView2D::OnMiddleButtonDown () // virtual
{
	vtkInteractorStyleBaseView::OnMiddleButtonDown();

	if ((GetInteractor()->GetControlKey()==1) || (GetInteractor()->GetShiftKey()==1) )
	{
		this->vtkInteractorStyleImage::OnLeftButtonDown();
	}
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView2D::OnMiddleButtonUp () // virtual
{
	vtkInteractorStyleBaseView::OnMiddleButtonUp();

	if ((GetInteractor()->GetControlKey()==1) || (GetInteractor()->GetShiftKey()==1) )
	{
		this->vtkInteractorStyleImage::OnLeftButtonUp();
	}
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView2D::OnMouseWheelForward () // virtual
{
	vtkInteractorStyleBaseView::OnMouseWheelForward();	
	if ((GetInteractor()->GetControlKey()==0) || (GetInteractor()->GetShiftKey()==0) )
	{
		this->vtkInteractorStyleImage::OnMouseWheelForward();
	}
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView2D::OnMouseWheelBackward () // virtual
{
	vtkInteractorStyleBaseView::OnMouseWheelBackward();	
	if ((GetInteractor()->GetControlKey()==0) || (GetInteractor()->GetShiftKey()==0) )
	{
		this->vtkInteractorStyleImage::OnMouseWheelBackward();
	}
}


