/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkInteractorStyleBaseView3D.h"

#include "vtkObjectFactory.h"

vtkStandardNewMacro(vtkInteractorStyleBaseView3D);

//---------------------------------------------------------------------------
vtkInteractorStyleBaseView3D::vtkInteractorStyleBaseView3D(){
}
//---------------------------------------------------------------------------
vtkInteractorStyleBaseView3D::~vtkInteractorStyleBaseView3D(){
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnRightButtonDown ()
{    
	vtkInteractorStyleBaseView::OnRightButtonDown();

/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnRightButtonDown();
		}
*/
  this->FindPokedRenderer(this->Interactor->GetEventPosition()[0], 
                          this->Interactor->GetEventPosition()[1]);

  if (this->CurrentRenderer == NULL)
    {
    return;
    }

  if (this->Interactor->GetControlKey()) {
      this->StartDolly();
  }

}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnRightButtonUp () 
{
	vtkInteractorStyleBaseView::OnRightButtonUp();

/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnRightButtonUp();
		}
*/

		
  switch (this->State) 
    {
    case VTKIS_DOLLY:
      this->EndDolly();
      break;
    }
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnMouseMove () 
{
	vtkInteractorStyleBaseView::OnMouseMove();

//		this->vtkInteractorStyleTrackballCamera::OnMouseMove();

 // int x = this->Interactor->GetEventPosition()[0]; // JPRx
 // int y = this->Interactor->GetEventPosition()[1]; // JPRx


 // vtkRenderWindowInteractor *rwi = this->Interactor;

 // int lx =  rwi->GetLastEventPosition()[0]; // JPRx
 // int ly =  rwi->GetLastEventPosition()[1]; // JPRx
 // int dx = rwi->GetEventPosition()[0] ; // JPRx
 // int dy = rwi->GetEventPosition()[1] ; // JPRx


  switch (this->State) 
    {
    case VTKIS_ROTATE:
 //     this->FindPokedRenderer(x, y);
      this->Rotate();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_PAN:
 //     this->FindPokedRenderer(x, y);
      this->Pan();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_DOLLY:
 //     this->FindPokedRenderer(x, y);
      this->Dolly();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_SPIN:
 //     this->FindPokedRenderer(x, y);
      this->Spin();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;
    }



}
//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView3D::OnLeftButtonDown()
{
//	printf("EED creaMaracasVisu::vtkInteractorStyleBaseView3D::OnLeftButtonDown \n");
	vtkInteractorStyleBaseView::OnLeftButtonDown();
/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnMiddleButtonDown();
		} else {
			this->vtkInteractorStyleTrackballCamera::OnLeftButtonDown();
		}
*/


  this->FindPokedRenderer(this->Interactor->GetEventPosition()[0], 
                          this->Interactor->GetEventPosition()[1]);
  if (this->CurrentRenderer == NULL)
    {
    return;
    }

	
	if ((GetInteractor()->GetControlKey()==0) && (GetInteractor()->GetShiftKey()==1) )
	{
		this->vtkInteractorStyleImage::OnLeftButtonDown();
	}
	
	
  if (this->Interactor->GetControlKey()) {
      this->StartPan();
  } else {
      this->StartRotate();
  }

	
	

 /* 
  if (this->Interactor->GetShiftKey()) 
    {
    if (this->Interactor->GetControlKey()) 
      {
      this->StartDolly();
      }
    else 
      {
      this->StartPan();
      }
    } 
  else 
    {
    if (this->Interactor->GetControlKey()) 
      {
      this->StartSpin();
      }
    else 
      {
      this->StartRotate();
      }
    }
*/


}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnLeftButtonUp () 
{
	vtkInteractorStyleBaseView::OnLeftButtonUp();

/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnMiddleButtonUp();
		} else {
			this->vtkInteractorStyleTrackballCamera::OnLeftButtonUp();
		}
*/
  switch (this->State) 
    {

    case VTKIS_PAN:
      this->EndPan();
      break;

    case VTKIS_ROTATE:
      this->EndRotate();
      break;
    }
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnMiddleButtonDown () 
{
	vtkInteractorStyleBaseView::OnMiddleButtonDown();
	//		this->vtkInteractorStyleTrackballCamera::OnMiddleButtonDown();
}
//---------------------------------------------------------------------------
void  vtkInteractorStyleBaseView3D::OnMiddleButtonUp () 
{
	vtkInteractorStyleBaseView::OnMiddleButtonUp();

	//		this->vtkInteractorStyleTrackballCamera::OnMiddleButtonUp();
}


//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView3D::OnMouseWheelForward () // virtual
{
	vtkInteractorStyleBaseView::OnMouseWheelForward();	
	if ((GetInteractor()->GetControlKey()==0) || (GetInteractor()->GetShiftKey()==0) )
	{
		this->vtkInteractorStyleImage::OnMouseWheelForward();
	}
}

//---------------------------------------------------------------------------
void vtkInteractorStyleBaseView3D::OnMouseWheelBackward () // virtual
{
	vtkInteractorStyleBaseView::OnMouseWheelBackward();	
	if ((GetInteractor()->GetControlKey()==0) || (GetInteractor()->GetShiftKey()==0) )
	{
		this->vtkInteractorStyleImage::OnMouseWheelBackward();
	}
}
