/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInteractorStyleMPRView.h"

#include "wxVtkMPR2DView.h"

vtkInteractorStyleMPRView::vtkInteractorStyleMPRView()
{
	_stateMoveAxisX = false;
	_stateMoveAxisY = false;
	_stateMoveAxisZ	= false;
}
//---------------------------------------------------------------------------
vtkInteractorStyleMPRView::~vtkInteractorStyleMPRView()
{
}


//---------------------------------------------------------------------------
bool  vtkInteractorStyleMPRView::OnLeftDClick () // virtual
{
	wxVtkMPR2DView *wxvtkmpr2Dview = (wxVtkMPR2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
	double x = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	double y = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	double z = 1;
	_vtkInteractorStyleBaseView->TransformCoordinate(x,y,z);	    
	wxvtkmpr2Dview->MoveX(x,y,z);
	wxvtkmpr2Dview->MoveY(x,y,z);
	wxvtkmpr2Dview->MoveZ(x,y,z);
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
	wxCommandEvent newevent2(wxEVT_COMMAND_MENU_SELECTED,12122);  // Doble click

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
	wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent2);
#else
 	wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
	wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent2);
#endif



	return true;
}
//---------------------------------------------------------------------------
bool  vtkInteractorStyleMPRView::OnLeftButtonDown () 
{
	wxVtkMPR2DView *wxvtkmpr2Dview = (wxVtkMPR2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
	double x	= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	double y	= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	double z	= 1;
	//double xx	= x;  // JPRx
	//double yy	= y;  // JPRx
	_vtkInteractorStyleBaseView->TransformCoordinate(x,y,z);	    

/*EED Borrame
	if ((_xBack==xx) && (_yBack==yy))
	{
		wxvtkmpr2Dview->MoveX(x,y,z);
		wxvtkmpr2Dview->MoveY(x,y,z);
		wxvtkmpr2Dview->MoveZ(x,y,z);
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
 		wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
		wxCommandEvent newevent2(wxEVT_COMMAND_MENU_SELECTED,12122);  // Doble click
		wxvtkmpr2Dview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent2);
	}

	_xBack=xx;	
	_yBack=yy;
*/

	_stateMoveAxisX = wxvtkmpr2Dview->IfMouseTouchX(x,y,z);
	_stateMoveAxisY = wxvtkmpr2Dview->IfMouseTouchY(x,y,z);
	_stateMoveAxisZ = wxvtkmpr2Dview->IfMouseTouchZ(x,y,z);

	return true;
}
//---------------------------------------------------------------------------
bool  vtkInteractorStyleMPRView::OnLeftButtonUp () 
{
	if (_stateMoveAxisX==true) 
	{
		_stateMoveAxisX=false;
	}
	if (_stateMoveAxisY==true) 
	{
		_stateMoveAxisY=false;
	}
	if (_stateMoveAxisZ==true) 
	{
		_stateMoveAxisZ=false;
	}
	return true;
}
//---------------------------------------------------------------------------
bool  vtkInteractorStyleMPRView::OnMouseMove () 
{
	double x = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	double y = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];

	double z=1;
	_vtkInteractorStyleBaseView->TransformCoordinate(x,y,z);	    
	wxVtkMPR2DView *wxvtkmpr2Dview = (wxVtkMPR2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
//	wxvtkmpr2Dview->TransfromCoordViewWorld(x,y,z);	    

	wxvtkmpr2Dview->ChangeAxisColor(x,y,z);

	if ((_stateMoveAxisX==true) || (_stateMoveAxisY==true)  || (_stateMoveAxisZ==true) )
	{
		if (_stateMoveAxisX==true) 
		{
			wxvtkmpr2Dview-> MoveX(x,y,z);
		}
		if (_stateMoveAxisY==true) 
		{
			wxvtkmpr2Dview->MoveY(x,y,z);
		}
		if (_stateMoveAxisZ==true) 
		{
			wxvtkmpr2Dview->MoveZ(x,y,z);
		}

		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}
	return true;
}

