/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include "vtkInteractorStylePlane2D.h"
#include "vtkPlane2DView.h"

vtkInteractorStylePlane2D::vtkInteractorStylePlane2D()
{
	_stateRotate=false;
}
//---------------------------------------------------------------------------
vtkInteractorStylePlane2D::~vtkInteractorStylePlane2D()
{
}

//---------------------------------------------------------------------------
bool vtkInteractorStylePlane2D::GetStateRotate()
{
	return _stateRotate;
}

//---------------------------------------------------------------------------
bool  vtkInteractorStylePlane2D::OnLeftButtonDown()  // vitual
{
	_stateRotate = true;
	_fordwareX = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	_fordwareY = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
	vtkplane2Dview->RotationStart();
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorStylePlane2D::OnLeftButtonUp() // virtual
{
	if (_stateRotate==true)
	{
		_stateRotate = false;
		vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
		vtkplane2Dview->ResetBack();
//		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}
	return true;
}

//---------------------------------------------------------------------------
bool  vtkInteractorStylePlane2D::OnRightButtonUp()  // virtual
{
	if (_stateRotate==true){
		//vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView()); // JPRx

// EED Borrame
//		vtkplane2Dview->RotationEnd();

		_stateRotate = false;
	}

	return true;
}
//---------------------------------------------------------------------------
bool  vtkInteractorStylePlane2D::OnMouseMove () // virtual 
{
	bool ok_v, ok_ang;
	if (_stateRotate==true){
		ok_v=false;
		ok_ang=false;
		if (_vtkInteractorStyleBaseView->GetInteractor()->GetControlKey()==1)
		{
			ok_v=true;
		}
		if (_vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey()==1)
		{
			ok_ang=true;
		}
	    int fx = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
        int fy = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
		vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
		vtkplane2Dview->RotationDrag( fx - _fordwareX , fy - _fordwareY , ok_v , ok_ang);
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	} 
	return true;
}
//-------------------------------------------------------------------
bool vtkInteractorStylePlane2D::OnLeftDClick() // virtual
{
	int fx = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	int fy = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	double xx=fx;
	double yy=fy;
	double zz=0;

	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
	vtkMPRBaseData *vtkmprbasedata = vtkplane2Dview->GetVtkmprbasedata();

	vtkplane2Dview->TransfromCoordViewWorld2(xx,yy,zz);

	vtkmprbasedata->SetX( xx );
	vtkmprbasedata->SetY( yy );
	vtkmprbasedata->SetZ( zz );
	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();

	return true;
}

