/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkInteractorStyleSphere.h"

#include "wxSphereView.h"

vtkInteractorStyleSphere::vtkInteractorStyleSphere()
{
	_stateRadio  = false;
	_stateRotate = false;
}

//---------------------------------------------------------------------------
vtkInteractorStyleSphere::~vtkInteractorStyleSphere()
{
}

//--------------------------------------------------------------------------
bool  vtkInteractorStyleSphere::OnRightButtonDown()
{
	if ((_vtkInteractorStyleBaseView->GetInteractor()->GetControlKey()==0) && (_vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey()==0) )
	{
		_stateRadio	= true;
		//_fordwareX	= this->Interactor->GetEventPosition()[0];
		_fordwareY	= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
		wxSphereView *wxsphereview = (wxSphereView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
		_radio = wxsphereview->GetRadio();
	}
	return true;
}

//---------------------------------------------------------------------------
bool  vtkInteractorStyleSphere::OnRightButtonUp() 
{
	if (_stateRadio==true)
	{
		wxSphereView *wxsphereview = (wxSphereView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
		wxsphereview->SetDeltaVoxel(1);
		double radio=wxsphereview->GetRadio();
		wxsphereview->GetIdOfImage(radio+0.1);
		wxsphereview->GetIdOfImage(radio+0.2);
		wxsphereview->GetIdOfImage(radio-0.1);
		wxsphereview->GetIdOfImage(radio-0.2);
		wxsphereview->RefreshView();
		_stateRadio = false;
	}
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorStyleSphere::OnLeftButtonDown()
{
	_stateRotate	= true;
	_fordwareX		= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
	_fordwareY		= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
	return true;
}

//---------------------------------------------------------------------------
bool  vtkInteractorStyleSphere::OnLeftButtonUp() 
{
	wxSphereView *wxsphereview = (wxSphereView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());
	if (_stateRotate==true){
		int fx	= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
		int fy	= _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];

		if ((_fordwareX==fx)&&(_fordwareY==fy)){
			double x=fx,y=fy,z=1;
			_vtkInteractorStyleBaseView->TransformCoordinate(x,y,z);	    
			wxsphereview->SetXYZtoParent(x,y);
			wxCommandEvent newevent(wxEVT_COMMAND_MENU_SELECTED,12121);
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			wxsphereview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent);
#else
			wxsphereview->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent);
#endif

		} else {
			wxsphereview->RotationEnd();
		}
		wxsphereview->RefreshView();
		_stateRotate = false;
	}
	return true;
}


//---------------------------------------------------------------------------
bool  vtkInteractorStyleSphere::OnMouseMove () 
{
	wxSphereView *wxsphereview = (wxSphereView*)(_vtkInteractorStyleBaseView->GetWxVtk2DBaseView());

	if (_stateRotate==true)
	{
		bool ok_v, ok_ang;
		ok_v=false;
		ok_ang=false;
		if (_vtkInteractorStyleBaseView->GetInteractor()->GetControlKey()==1)
		{
			ok_v = true;
		}
		if (_vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey()==1)
		{
			ok_ang = true;
		}
	    int fx = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[0];
        int fy = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
		wxsphereview->RotationStart( fx - _fordwareX , -(fy - _fordwareY) , ok_v, ok_ang);
		wxsphereview->RefreshView();
	} 
	if (_stateRadio==true)
	{	    

		//int fx = this->Interactor->GetEventPosition()[0];
        int fy = _vtkInteractorStyleBaseView->GetInteractor()->GetEventPosition()[1];
		double dif=(fy-_fordwareY) / 10.0;
		wxsphereview->SetRadio( _radio + dif );
		wxsphereview->SetDeltaVoxel(3);

		wxsphereview->RefreshView();
	}
	return true;
}









