/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkInteractorZoomCamera.h"
#include "wxVtk2DBaseView.h"
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

vtkInteractorZoomCamera::vtkInteractorZoomCamera()
{
}

//---------------------------------------------------------------------------
vtkInteractorZoomCamera::~vtkInteractorZoomCamera()
{
}

//---------------------------------------------------------------------------
bool vtkInteractorZoomCamera::OnRightButtonDown()
{
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorZoomCamera::OnRightButtonUp()
{
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorZoomCamera::OnMouseMove ()
{
	SetZoomCamera();
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorZoomCamera::OnMouseWheelForward()
{
	SetZoomCamera();
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorZoomCamera::OnMouseWheelBackward()
{
	SetZoomCamera();
	return true;
}

//---------------------------------------------------------------------------
void vtkInteractorZoomCamera::SetZoomCamera()
{
	wxVtk2DBaseView *wxvtk2Dbaseview	= (wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView();
	vtkBaseData *vtkbasedata			= wxvtk2Dbaseview->GetVtkBaseData();
	double parallelscaling=wxvtk2Dbaseview->GetRenderer()->GetActiveCamera()->GetParallelScale();
	vtkbasedata->SetCameraParallelScale( parallelscaling );
	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
}

