/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkMPR3DDataViewer.h"


vtkMPR3DDataViewer::vtkMPR3DDataViewer()
{
	_visiblePosition[0]=false;
	_visiblePosition[1]=false;
	_visiblePosition[2]=false;
	_ctfun 			= NULL;
	_vtkmprbasedata	= NULL;
	_ctfun			= NULL;
	_saggitalColors	= NULL;
	_saggital		= NULL;
	_axialColors	= NULL;
	_axial			= NULL;
	_coronalColors	= NULL;
	_coronal		= NULL;
	_mapOutline		= NULL;
	_outline		= NULL;
	_outlineData	= NULL;
}
//-------------------------------------------------------------------
vtkMPR3DDataViewer::~vtkMPR3DDataViewer()
{
	if(_outlineData) 		{_outlineData		-> Delete();}
	if(_mapOutline)  		{_mapOutline		-> Delete();}
	if(_outline)	 		{_outline			-> Delete();}
//	if (_bwLut)				{_bwLut				-> Delete();}
//	if (_hueLut)			{_hueLut			-> Delete();}
//	if (_satLut)			{_satLut			-> Delete();}
	if (_ctfun)				{_ctfun				-> Delete();}
	if (_saggitalColors)	{_saggitalColors	-> Delete();}
	if (_saggital)			{_saggital			-> Delete();}
	if (_axialColors)		{_axialColors		-> Delete();}
	if (_axial)				{_axial				-> Delete();}
	if (_coronalColors)		{_coronalColors		-> Delete();}
	if (_coronal)			{_coronal			-> Delete();}
}

//-------------------------------------------------------------------
vtkActor* vtkMPR3DDataViewer::GetOutlineActor()
{
	return _outline;
}

//-------------------------------------------------------------------
vtkImageActor* vtkMPR3DDataViewer::GetImageActor(int id)
{
	vtkImageActor *tmpVtkActor=NULL;
	if (id==0)
	{
		tmpVtkActor = GetvtkActor_saggital();
	}
	if (id==1)
	{
		tmpVtkActor = GetvtkActor_coronal();
	}
	if (id==2)
	{
		tmpVtkActor = GetvtkActor_axial();
	}
	return tmpVtkActor;
}

//-------------------------------------------------------------------
void vtkMPR3DDataViewer::Refresh()
{
	int x = (int)(_vtkmprbasedata->GetX());
	int y = (int)(_vtkmprbasedata->GetY());
	int z = (int)(_vtkmprbasedata->GetZ());
	SetPositionX( x );
	SetPositionY( y );
	SetPositionZ( z );
}
//-------------------------------------------------------------------
void vtkMPR3DDataViewer::SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata)
{
	_vtkmprbasedata=vtkmprbasedata;
}
//-------------------------------------------------------------------
vtkMPRBaseData* vtkMPR3DDataViewer::GetVtkMPRBaseData()
{
	return _vtkmprbasedata;
}
//-------------------------------------------------------------------

vtkColorTransferFunction *vtkMPR3DDataViewer::GetvtkColorTransferFunction()
{
	return _ctfun;
}
//-------------------------------------------------------------------

std::vector<double>* vtkMPR3DDataViewer::GetctFunVectorPoint()
{
	return &_ctFunVectorPoint;
}
//-------------------------------------------------------------------
std::vector<double>*     vtkMPR3DDataViewer::GetctFunVectorRed()
{
	return &_ctFunVectorRed;
}

//-------------------------------------------------------------------
std::vector<double>*     vtkMPR3DDataViewer::GetctFunVectorGreen()
{
	return &_ctFunVectorGreen;
}

//-------------------------------------------------------------------
std::vector<double>*     vtkMPR3DDataViewer::GetctFunVectorBlue()
{
	return &_ctFunVectorBlue;
}

//-------------------------------------------------------------------
void vtkMPR3DDataViewer::SetImage()
{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_saggitalColors	-> SetInput( _vtkmprbasedata->GetImageData() );
	_axialColors	-> SetInput( _vtkmprbasedata->GetImageData() );
	_coronalColors	-> SetInput( _vtkmprbasedata->GetImageData() );
	_outlineData	-> SetInput((vtkDataSet *) _vtkmprbasedata->GetImageData() );
#else
	_saggitalColors	-> SetInputData( _vtkmprbasedata->GetImageData() );
	_axialColors	-> SetInputData( _vtkmprbasedata->GetImageData() );
	_coronalColors	-> SetInputData( _vtkmprbasedata->GetImageData() );

//EED 2020-01-27  this is to slow ??? how can we accelerated
//	_saggitalColors	-> Update();
//	_axialColors	-> Update();
//	_coronalColors	-> Update();

	_outlineData	-> SetInputData((vtkDataSet *) _vtkmprbasedata->GetImageData() );
#endif
}


//-------------------------------------------------------------------
void vtkMPR3DDataViewer::Configure()
{
/*
  // Start by creatin a black/white lookup table.
	_bwLut = vtkLookupTable::New();
    _bwLut->SetTableRange (0, 2000);
    _bwLut->SetSaturationRange (0, 0);
    _bwLut->SetHueRange (0, 0);
    _bwLut->SetValueRange (0, 1);

  // Now create a lookup table that consists of the full hue circle
  // (from HSV).
	_hueLut = vtkLookupTable::New();
    _hueLut->SetTableRange (0, 2000);
    _hueLut->SetHueRange (0, 1);
    _hueLut->SetSaturationRange (1, 1);
    _hueLut->SetValueRange (1, 1);

  // Finally, create a lookup table with a single hue but having a range
  // in the saturation of the hue.
	_satLut = vtkLookupTable::New();
    _satLut->SetTableRange (0, 2000);
    _satLut->SetHueRange (.6, .6);
    _satLut->SetSaturationRange (0, 1);
    _satLut->SetValueRange (1, 1);
*/

	double range[2];
	double delta;
	if(_vtkmprbasedata->GetImageData())
	{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_vtkmprbasedata->GetImageData()->Update();
#else
		// ..
#endif
		_vtkmprbasedata->GetImageData()->Modified();
		_vtkmprbasedata->GetImageData()->GetScalarRange(range);
		delta = range[1]-range[0];
		if (delta==0)
		{
			printf("EED vtkMPR3DDataViewer::Configure Warning!  image Range [0,0] -> changed to [0,1000] \n" );
			delta=1000;
		} // if delta				

		_ctFunVectorPoint.clear();
		_ctFunVectorPoint.push_back( range[0] + delta*0/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*1/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*2/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*3/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*4/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*5/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*6/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*7/8 );
		_ctFunVectorPoint.push_back( range[0] + delta*8/8 );

		_ctFunVectorRed.clear();
		_ctFunVectorRed.push_back(0.0);
		_ctFunVectorRed.push_back(0.0);
		_ctFunVectorRed.push_back(0.0);
		_ctFunVectorRed.push_back(0.0);
		_ctFunVectorRed.push_back(0.5);
		_ctFunVectorRed.push_back(1.0);
		_ctFunVectorRed.push_back(1.0);
		_ctFunVectorRed.push_back(1.0);
		_ctFunVectorRed.push_back(0.5);

		_ctFunVectorGreen.clear();
		_ctFunVectorGreen.push_back(0.0);
		_ctFunVectorGreen.push_back(0.0);
		_ctFunVectorGreen.push_back(0.5);
		_ctFunVectorGreen.push_back(1.0);
		_ctFunVectorGreen.push_back(1.0);
		_ctFunVectorGreen.push_back(1.0);
		_ctFunVectorGreen.push_back(0.5);
		_ctFunVectorGreen.push_back(0.0);
		_ctFunVectorGreen.push_back(0.0);

		_ctFunVectorBlue.clear();
		_ctFunVectorBlue.push_back(0.5);
		_ctFunVectorBlue.push_back(1.0);
		_ctFunVectorBlue.push_back(1.0);
		_ctFunVectorBlue.push_back(1.0);
		_ctFunVectorBlue.push_back(0.5);
		_ctFunVectorBlue.push_back(0.0);
		_ctFunVectorBlue.push_back(0.0);
		_ctFunVectorBlue.push_back(0.0);
		_ctFunVectorBlue.push_back(0.0);

		if(_ctfun==NULL)
		{
			_ctfun = vtkColorTransferFunction::New();
		}
		_ctfun->RemoveAllPoints();

		int i,size=_ctFunVectorPoint.size();
		for (i=0;i<size;i++)
		{
			_ctfun->AddRGBPoint( _ctFunVectorPoint[i] , _ctFunVectorRed[i],_ctFunVectorGreen[i],_ctFunVectorBlue[i]);
			
		}
	/*
		_ctfun->AddRGBPoint( 100 ,0 ,0,0);
		_ctfun->AddRGBPoint( 200 ,1 ,0,0);
		_ctfun->AddRGBPoint( 300 ,0 ,1,0);
		_ctfun->AddRGBPoint( 400 ,0 ,0,1);
	*/
	//	void *p=this; // JPRx

	// Create the first of the three planes. The filter vtkImageMapToColors
	// maps the data through the corresponding lookup table created above.  The
	// vtkImageActor is a type of vtkProp and conveniently displays an image on
	// a single quadrilateral plane. It does this using texture mapping and as
	// a result is quite fast. (Note: the input image has to be unsigned char
	// values, which the vtkImageMapToColors produces.) Note also that by
	// specifying the DisplayExtent, the pipeline requests data of this extent
	// and the vtkImageMapToColors only processes a slice of data.
		
		if(_saggitalColors==NULL)
		{
			_saggitalColors = vtkImageMapToColors::New();
		}
		_saggitalColors->RemoveAllInputs();

	//    _saggitalColors->SetLookupTable(_bwLut);
		_saggitalColors->SetLookupTable(_ctfun);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_saggitalColors->SetInput( _vtkmprbasedata->GetImageData() );
#else
		_saggitalColors->SetInputData( _vtkmprbasedata->GetImageData() );
		_saggitalColors->Update();
#endif
		
		
		if(_saggital==NULL)
		{
			_saggital = vtkImageActor::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_saggital->SetInput(_saggitalColors->GetOutput());
#else
			_saggital->SetInputData(_saggitalColors->GetOutput());
#endif
		}	
		//_saggitalColors->Update();
	
	// Create the second (axial) plane of the three planes. We use the
	// same approach as before except that the extent differs.

		if(_axialColors==NULL)
		{
			_axialColors = vtkImageMapToColors::New();
		}
		_axialColors->RemoveAllInputs();
	//    _axialColors->SetLookupTable(_hueLut);
		_axialColors->SetLookupTable(_ctfun);

		
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_axialColors->SetInput( _vtkmprbasedata->GetImageData() );
#else
		_axialColors->SetInputData( _vtkmprbasedata->GetImageData() );
		_axialColors->Update();
#endif

		if(_axial==NULL)
		{
			_axial = vtkImageActor::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_axial->SetInput(_axialColors->GetOutput());
#else
			_axial->SetInputData(_axialColors->GetOutput());
#endif

		}
		
		//_axialColors->Update();
		// Create the third (coronal) plane of the three planes. We use 
	// the same approach as before except that the extent differs.
		if(_coronalColors==NULL)
		{
			_coronalColors = vtkImageMapToColors::New();
		}
		_coronalColors->RemoveAllInputs();
	//    _coronalColors->SetLookupTable(_satLut);
		_coronalColors->SetLookupTable(_ctfun);

		
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_coronalColors->SetInput( _vtkmprbasedata->GetImageData() );
#else
		_coronalColors->SetInputData( _vtkmprbasedata->GetImageData() );
		_coronalColors->Update();
#endif


		if(_coronal==NULL)
		{
			_coronal = vtkImageActor::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_coronal->SetInput(_coronalColors->GetOutput());
#else
			_coronal->SetInputData(_coronalColors->GetOutput());
#endif

		} // if _coronal
		
	// An outline provides context around the data.
	//
		if(_outlineData==NULL)
		{
			_outlineData = vtkOutlineFilter::New();
		} // if _outlineData
		_outlineData->RemoveAllInputs();
		if(_vtkmprbasedata->GetImageData())
		{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_outlineData->SetInput((vtkDataSet *) _vtkmprbasedata->GetImageData() );
#else
			_outlineData->SetInputData((vtkDataSet *) _vtkmprbasedata->GetImageData() );
			_outlineData->Update();    
#endif
		} // if _image

		if(_mapOutline==NULL)
		{
			_mapOutline = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_mapOutline->SetInput(_outlineData->GetOutput());
#else
			_mapOutline->SetInputData(_outlineData->GetOutput());
#endif

		}
		_mapOutline->Update();    
		//_mapOutline->RemoveAllInputs();
	
		if(_outline==NULL)
		{
			_outline = vtkActor::New();
			_outline->SetMapper(_mapOutline);
			_outline->GetProperty()->SetColor(0,0,0);
		}
	}
	//int ext[6];
	//_vtkmprbasedata->GetImageData()->GetExtent(ext);
}

//-------------------------------------------------------------------
vtkImageActor * vtkMPR3DDataViewer::GetvtkActor_saggital()
{
	return _saggital;
}
//-------------------------------------------------------------------
vtkImageActor * vtkMPR3DDataViewer::GetvtkActor_coronal()
{
	return _coronal;
}
//-------------------------------------------------------------------
vtkImageActor * vtkMPR3DDataViewer::GetvtkActor_axial()
{
	return _axial;
}

//------------------------------------------------------------------------
void vtkMPR3DDataViewer::SetPositionX(int pos)
{
	int x1,x2,y1,y2,z1,z2;
	_vtkmprbasedata->GetDimensionExtention(&x1,&x2,&y1,&y2,&z1,&z2);
	if(_saggital)
	{
		_saggital->SetDisplayExtent( pos , pos , y1 ,y2 , z1 , z2 );
//EED 2016/02/19
		_saggital->SetInterpolate(  GetVtkMPRBaseData()->GetInterpolate() );
	}
}

//------------------------------------------------------------------------
void vtkMPR3DDataViewer::SetPositionY(int pos)
{
	int x1,x2,y1,y2,z1,z2;
	_vtkmprbasedata->GetDimensionExtention(&x1,&x2,&y1,&y2,&z1,&z2);
	if(_coronal)
	{
		_coronal->SetDisplayExtent(x1,x2, pos,pos, z1,z2);
//EED 2016/02/19
		_coronal->SetInterpolate(  GetVtkMPRBaseData()->GetInterpolate() );
	}
}
//------------------------------------------------------------------------
void vtkMPR3DDataViewer::SetPositionZ(int pos)
{
	int x1,x2,y1,y2,z1,z2;
	_vtkmprbasedata->GetDimensionExtention(&x1,&x2,&y1,&y2,&z1,&z2);
	if(_axial)
	{
		_axial->SetDisplayExtent(x1,x2, y1,y2, pos,pos);
//EED 2016/02/19
		_axial->SetInterpolate(  GetVtkMPRBaseData()->GetInterpolate() );
	}
}
//-------------------------------------------------------------------
void vtkMPR3DDataViewer::SetVisiblePosition(int idPosition, bool visible)
{
	_visiblePosition[idPosition]=visible;
}
//-------------------------------------------------------------------
bool vtkMPR3DDataViewer::GetVisiblePosition(int idPosition)
{
	return _visiblePosition[idPosition];
}

void vtkMPR3DDataViewer::setColorTransferFunction(vtkColorTransferFunction* colortable)
{
	if(_saggitalColors)
	{
		_saggitalColors->SetLookupTable(colortable);
		_coronalColors->SetLookupTable(colortable);
		_axialColors->SetLookupTable(colortable);
	}
}

