/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VTKMPR3DDATAVIEWER_H_
#define VTKMPR3DDATAVIEWER_H_

#include "wxMPRBaseData.h"
#include "vtkProperty.h"
#include <vtkImageMapToColors.h> 
#include "vtkOutlineFilter.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include <vtkColorTransferFunction.h>
#include "vtkImageActor.h"

#ifdef _DEBUG
#include <crtdbg.h>
#define DEBUG_NEW new(_NORMAL_BLOCK ,__FILE__, __LINE__)
#else
#define DEBUG_NEW new
#endif

class creaMaracasVisu_EXPORT vtkMPR3DDataViewer {
public:
	vtkMPR3DDataViewer();
	virtual 					~vtkMPR3DDataViewer();
	vtkImageActor*				GetImageActor(int id);
	vtkActor*					GetOutlineActor();
	virtual void				Refresh();
	virtual void				Configure();
			void 				SetImage();
	void						SetVisiblePosition(int idPosition, bool visible);
	bool						GetVisiblePosition(int idPosition);
	vtkImageActor*				GetvtkActor_saggital();
	vtkImageActor*				GetvtkActor_axial();
	vtkImageActor*				GetvtkActor_coronal();
	void						SetPositionX(int pos);
	void						SetPositionY(int pos);
	void						SetPositionZ(int pos);
	void						SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata);
	vtkMPRBaseData*				GetVtkMPRBaseData();
	vtkColorTransferFunction   	*GetvtkColorTransferFunction();
	std::vector<double >	   	*GetctFunVectorPoint();
	std::vector<double >	   	*GetctFunVectorRed();
	std::vector<double >	   	*GetctFunVectorGreen();
	std::vector<double >	   	*GetctFunVectorBlue();
	void setColorTransferFunction(vtkColorTransferFunction* colortable);
private:
	bool						_visiblePosition[3];
	// outline
	vtkOutlineFilter			*_outlineData;
	vtkPolyDataMapper			*_mapOutline;
	vtkActor					*_outline;
	//
	vtkColorTransferFunction	*_ctfun;
	std::vector<double>			_ctFunVectorPoint;
	std::vector<double>			_ctFunVectorRed;
	std::vector<double>			_ctFunVectorGreen;
	std::vector<double>			_ctFunVectorBlue;
//	vtkLookupTable				*_bwLut;
//	vtkLookupTable				*_hueLut;
//	vtkLookupTable				*_satLut;
	vtkImageMapToColors			*_saggitalColors;
	vtkImageActor				*_saggital;
	vtkImageMapToColors			*_axialColors;
	vtkImageActor				*_axial;
	vtkImageMapToColors			*_coronalColors;
	vtkImageActor				*_coronal;
	vtkMPRBaseData				*_vtkmprbasedata;
};

#endif /*VTKMPR3DDATAVIEWER_H_*/
