/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkPlane2DView.h"

#include "vtkCellArray.h"

#include "vtkInteractorStyleBaseView2D.h"
#include "vtkPointData.h"


vtkPlane2DView::vtkPlane2DView( wxWindow *parent)
: wxVtk2DBaseView(parent)
{

	_backX					=	-99999;
	_backY					=	-99999;
	_backZ					=	-99999;

	_backOrient[0]			=	-99999;
	_backOrient[1]			=	-99999;
	_backOrient[2]			=	-99999;
	_backOrient[3]			=	-99999;

	_active					=   true;
	_mip_visualization		=	true;
	_mip_width				=	2;

    _transform1				=	vtkTransform::New();
    _transform2				=	vtkTransform::New();
	_transform1->Identity();
	_transform2->Identity();

	_sizeIma				=	200;

	_pSource				=	NULL;
	_3Dslices				=	NULL;
	_stPoints				=	NULL;
	_change					=	NULL;
	_imageResult			=	NULL;

	// line horizontal
    _pts					= 	NULL;
    _lineActor				= 	NULL;
	_lineMapper				= 	NULL;
	_pd						= 	NULL;

	_interactorstyleplane2D =	NULL;
}
//-------------------------------------------------------------------
vtkPlane2DView::~vtkPlane2DView()
{
	ResetPlane();
	// Horizontal Line
    if (_pts		!= NULL)	{	_pts			-> Delete(); }
    if (_lineActor	!= NULL)	{	_lineActor		-> Delete(); }
    if (_lineMapper	!= NULL)	{	_lineMapper		-> Delete(); }
    if (_pd			!= NULL)	{	_pd				-> Delete(); }
	_transform1		-> Delete();
	_transform2		-> Delete();
}

//-------------------------------------------------------------------
void vtkPlane2DView::ResetBack()
{
		_backX=-1;
		_backY=-1;
		_backZ=-1;
		_backOrient[0]=-1;
		_backOrient[1]=-1;
		_backOrient[2]=-1;
		_backOrient[3]=-1;
}

//-------------------------------------------------------------------
void vtkPlane2DView::ResetPlane()
{
	if (_pSource	!=NULL)	{ _pSource	-> Delete();	}
	if (_3Dslices	!=NULL)	{ _3Dslices	-> Delete();	}
	if (_stPoints	!=NULL)	{ _stPoints	-> Delete();	}
	if (_change		!=NULL)	{ _change	-> Delete();	}
}

//-------------------------------------------------------------------
vtkMPRBaseData *vtkPlane2DView::GetVtkmprbasedata()
{
	return (vtkMPRBaseData*)GetVtkBaseData();
}

//-------------------------------------------------------------------
void vtkPlane2DView::SetPSource(int sizeIma){
	int dimIma	= sizeIma; 

	double x = GetVtkmprbasedata()->GetX();
	double y = GetVtkmprbasedata()->GetY();
	double z = GetVtkmprbasedata()->GetZ();

	double spc[3];
	vtkImageData *imagedata = GetVtkmprbasedata()->GetImageData();
	imagedata->GetSpacing(spc);
	x=x*spc[0];
	y=y*spc[1];
	z=z*spc[2];


	vtkMPRBaseData	*mprbasedata = (vtkMPRBaseData*)this->GetVtkBaseData();
	vtkTransform	*transform	 = mprbasedata->GetTransformOrientation();

	double in[3];  // temp
	double pA[3];
	double pB[3];
	in[0]=1;		in[1]=0;			in[2]=0;
	transform->TransformPoint(in,_n);

	in[0]=0;	in[1]=dimIma-1;		in[2] = 0;
	transform->TransformPoint(in,pA);

	in[0]=0;	in[1]=0;		in[2]=dimIma-1;
	transform->TransformPoint(in,pB);

    _pSource -> SetPoint1( pA	);
    _pSource -> SetPoint2( pB	);

	_pSource -> SetOrigin( 0	, 0		, 0		);
    _pSource -> SetResolution( sizeIma-1 , sizeIma -1 );
	_pSource -> Update();
	_pSource -> SetCenter( x, y, z );
    _pSource -> SetNormal( _n );
    _pSource -> Update( );

// EED Borrame
//	transform->Delete();

}

//-------------------------------------------------------------------
void vtkPlane2DView::ExtractPlane() 
{
	double x = GetVtkmprbasedata()->GetX();
	double y = GetVtkmprbasedata()->GetY();
	double z = GetVtkmprbasedata()->GetZ();

	double spc[3];
	vtkImageData *imagedata = GetVtkmprbasedata()->GetImageData();
	imagedata->GetSpacing(spc);
	x=x*spc[0];
	y=y*spc[1];
	z=z*spc[2];

	vtkTransform *transform = GetVtkmprbasedata()->GetTransformOrientation();
	double orientation[4];
	transform->GetOrientationWXYZ(orientation);

	bool okOrientation=true;
	if ((orientation[0]!=_backOrient[0]) || (orientation[1]!=_backOrient[1]) ||
		(orientation[2]!=_backOrient[2]) || (orientation[3]!=_backOrient[3]))
	{
		okOrientation=false;
	}

	bool okPosicion=true;
	if ( (x!=_backX) || (y!=_backY) || (z!=_backZ) )
	{
		okPosicion=false;
	}

	if ((okPosicion==false) || (okOrientation==false) ) {
		if (_active==true){

			bool ok = false;

			if ( _mip_visualization==true )
			{
				if (_interactorstyleplane2D!=NULL)
				{
					if (_interactorstyleplane2D->GetStateRotate()==false )
					{
						ok=true;
					}
				}
			}
//			ok=true;

			if (ok==true)
			{
				Extract_MIP_PlaneVTK();
			} else {
				Extract_One_PlaneVTK();
			} // ok

		} // active
		_backX=x;
		_backY=y;
		_backZ=z;
		_backOrient[0]=orientation[0];
		_backOrient[1]=orientation[1];
		_backOrient[2]=orientation[2];
		_backOrient[3]=orientation[3];
	} //okPosition okOrientation
}

//-------------------------------------------------------------------
void vtkPlane2DView::Extract_One_PlaneVTK()
{
	vtkImageData *imagedata = GetVtkmprbasedata()->GetImageData();
	SetPSource(_sizeIma);

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_3Dslices -> SetInput( ( vtkDataSet* )_pSource->GetOutput( ) );
	_3Dslices -> SetSource( imagedata );
#else
	_3Dslices -> SetInputData( ( vtkDataSet* )_pSource->GetOutput( ) );
	_3Dslices -> SetSourceData( imagedata );
#endif

	_3Dslices -> Update( );
	_stPoints -> GetPointData( )->SetScalars(  _3Dslices->GetOutput()->GetPointData()->GetScalars()  );
	_stPoints -> SetDimensions( _sizeIma, _sizeIma, 1 );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_stPoints -> SetScalarType( imagedata->GetScalarType() );
	_stPoints -> SetScalarTypeToShort();
	_stPoints -> Update();
//	_change	  -> SetInput( _stPoints );  
//	_change	  -> Update();    //important
	_imageViewer2XYZ->GetVtkImageViewer2()->SetInput ( _stPoints );
#else
printf("EED Warning!  vtkPlane2DView::Extract_One_PlaneVTK     VTK 5->7   ???? SetScalarTypeToShort  \n");
printf("EED Warning!  vtkPlane2DView::Extract_One_PlaneVTK     VTK 5->7   ???? SetScalarTypeToShort  \n");
printf("EED Warning!  vtkPlane2DView::Extract_One_PlaneVTK     VTK 5->7   ???? SetScalarTypeToShort  \n");
printf("EED Warning!  vtkPlane2DView::Extract_One_PlaneVTK     VTK 5->7   ???? SetScalarTypeToShort  \n");
printf("EED Warning!  vtkPlane2DView::Extract_One_PlaneVTK     VTK 5->7   ???? SetScalarTypeToShort  \n");
	vtkInformation* info=_stPoints->GetInformation();
	vtkDataObject::SetPointDataActiveScalarInfo(info, VTK_SHORT, 1);
	_imageViewer2XYZ->GetVtkImageViewer2()->SetInputData( _stPoints );

#endif


//	_imageViewer2XYZ->GetVtkImageViewer2()->SetInput ( _change->GetOutput() );
	//	vtkImageActor *imageActor = _imageViewer2XYZ->GetVtkImageViewer2()->GetImageActor();
}

//-------------------------------------------------------------------
void vtkPlane2DView::Extract_MIP_PlaneVTK( /*double heightDefinition*/ )
{
	int mipWidth;
	double sp;
	int sizeWidth = (_mip_width*2)+1 ;
	int deltaPixel;
	int iWidth,itmp,tmpSizeWith;
	double spc[3];
	vtkImageData *imagedata = GetVtkmprbasedata()->GetImageData();
	SetPSource(_sizeIma);
	imagedata->GetSpacing(spc);
	bool heightDefinition=false;
	if (_mip_width<3)
	{
		heightDefinition=true;
	}
	if (heightDefinition==true)
	{
		mipWidth	=	_mip_width;
		sp			=	spc[0];
		deltaPixel	=	1;
	} else {
		mipWidth	=	2;
		tmpSizeWith =   (mipWidth*2) + 1;
		sp			=	(spc[0]*sizeWidth)/tmpSizeWith;
		sizeWidth	=	tmpSizeWith;
		deltaPixel	=	4;
	}
	std::vector< vtkProbeFilter* > slicesLST;
	_pSource->Push( -mipWidth * sp );
	_pSource->Update();
	for ( iWidth=0 ; iWidth<sizeWidth ; iWidth++ )
	{	
		vtkProbeFilter *slice = vtkProbeFilter::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		slice -> SetInput( ( vtkDataSet* )_pSource->GetOutput( ) );
		slice -> SetSource( imagedata );
#else
		slice -> SetInputData( ( vtkDataSet* )_pSource->GetOutput( ) );
		slice -> SetSourceData( imagedata );
#endif
		slice -> Update( );
		slicesLST.push_back( slice );
		_pSource->Push( sp );
	}
	if (_imageResult ==NULL)
	{
		_imageResult = vtkImageData::New();
		_imageResult -> SetDimensions(_sizeIma,_sizeIma,1);
		_imageResult -> SetSpacing(1,1,1);
		_imageResult -> SetExtent(0,_sizeIma-1,0,_sizeIma-1,0,0);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_imageResult -> SetScalarType( imagedata->GetScalarType() );
		_imageResult -> SetWholeExtent(0,_sizeIma-1,0,_sizeIma-1,0,0);
		_imageResult -> AllocateScalars();
		_imageResult -> Update();
#else
		_imageResult -> AllocateScalars(imagedata->GetScalarType(),1);
#endif

	}
	unsigned short *pTemp;
	unsigned short *pResult;
	pResult	= (unsigned short*)_imageResult->GetScalarPointer( 0 , 0 , 0 ); 
	int iPixels , sizePixels = _sizeIma*_sizeIma;
	for(iPixels=0 ; iPixels<sizePixels ; iPixels=iPixels+deltaPixel)
	{
		pTemp = (unsigned short*)slicesLST[0]->GetOutput()->GetPointData()->GetScalars()->GetVoidPointer(0);
		pResult	= (unsigned short*)_imageResult->GetScalarPointer( 0 , 0 , 0 ); 
		pResult[iPixels] = pTemp[iPixels];
		for (iWidth=1;iWidth<sizeWidth;iWidth++)
		{
			pTemp = (unsigned short*)slicesLST[iWidth]->GetOutput()->GetPointData()->GetScalars()->GetVoidPointer(0);

			if (pResult[iPixels]< pTemp[iPixels])
			{
				pResult[iPixels] = pTemp[iPixels];
			}
		}
		if (deltaPixel!=1)
		{
			for (itmp=1;itmp<deltaPixel;itmp++)
			{
				pResult[iPixels+itmp] = pResult[iPixels];
			}
		}
	}
	for (iWidth=0;iWidth<sizeWidth;iWidth++)
	{	
		slicesLST[iWidth]->Delete();
	}
	_imageResult->Modified();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_imageViewer2XYZ->GetVtkImageViewer2()->SetInput( _imageResult );
#else
	_imageViewer2XYZ->GetVtkImageViewer2()->SetInputData( _imageResult );
#endif
}

//-------------------------------------------------------------------
void vtkPlane2DView::Configure( )
{
	wxVtk2DBaseView::Configure(false);

	HorizontalLine();
// Borrame
//	CircleLine();

	_pSource	 = vtkPlaneSource::New( );
    _3Dslices	 = vtkProbeFilter::New( ) ;
	_stPoints	 = vtkStructuredPoints::New( );
 	_change		 = vtkImageChangeInformation::New();

	crea::wxVTKRenderWindowInteractor *iren		= GetWxVTKRenderWindowInteractor();
	ExtractPlane();
//	SetActive(false);
	_imageViewer2XYZ -> GetVtkImageViewer2()	-> SetupInteractor ( iren );

	//////////////
	//RaC 04-2010 Look for the description of new changes in vtkInteractorStyleBaseView2D constructor.
	//
	// Previous version
	// SetInteractorStyleImage( vtkInteractorStyleBaseView2D::New() );
	//
	// Actual version
	vtkInteractorStyleBaseView2D *style2D = vtkInteractorStyleBaseView2D::New();
	manualInteractorWindowLevel *_manualinteractorwindowlevel= new manualInteractorWindowLevel();
	style2D->SetInteractorWindowLevel( _manualinteractorwindowlevel );
	vtkInteractorScrollZ *_vtkInteractorScrollZ = new vtkInteractorScrollZ();
	style2D->SetInteractorScrollZ(_vtkInteractorScrollZ);
	SetInteractorStyleImage( style2D );

	// RaC
	//////////////

	_interactorstyleplane2D = new vtkInteractorStylePlane2D();
	((vtkInteractorStyleBaseView*)GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _interactorstyleplane2D );

	vtkCamera *camera =_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->GetActiveCamera();
	
	camera->SetViewUp		(	0			,	1				,	0	);
	camera->SetPosition		((0+_sizeIma)/2	, (0+_sizeIma)/2	, 10000	); 
	
	camera->SetFocalPoint	((0+_sizeIma)/2	, (0+_sizeIma)/2	,	0	); 
 	camera->SetClippingRange(0.01, 100000);
	camera->ComputeViewPlaneNormal();
	camera->SetParallelScale( _sizeIma/3.0 );

	// text information over the graphic window
	_vtkInfoTextImage						= new vtkInfoTextImage();
	_vtkInfoTextImageInteractorPlane2D		= new vtkInfoTextImageInteractorPlane2D();
	_vtkInfoTextImage->SetWxVtk2DBaseView(this);
	_vtkInfoTextImage->SetMarImageData(  GetVtkmprbasedata()->GetMarImageData() );
	_vtkInfoTextImageInteractorPlane2D->SetModelVtkInfoTextImage(_vtkInfoTextImage);	
	_vtkInfoTextImage->Configure();
	((vtkInteractorStyleBaseView*)this->GetInteractorStyleBaseView())->AddInteractorStyleMaracas(_vtkInfoTextImageInteractorPlane2D);
}

//-------------------------------------------------------------------
void vtkPlane2DView::HorizontalLine()
{
// Axe Horizontal
	_pts = vtkPoints::New();
	_pts->SetNumberOfPoints(2);
	_pts->SetPoint(0, -1000	, -1000	, -1000 );
	_pts->SetPoint(1,  1000	,  1000	,  1000	);
	vtkCellArray *lines = vtkCellArray::New();
	lines->InsertNextCell(2);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(1);
	_pd = vtkPolyData::New();
    _pd->SetPoints( _pts );
    _pd->SetLines( lines );
	lines->Delete();  //do not delete lines ??
	_lineActor					=	vtkActor::New();
    _lineMapper					=	vtkPolyDataMapper::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_lineMapper->SetInput(_pd);
	_lineMapper->ImmediateModeRenderingOn();
#else
	_lineMapper->SetInputData(_pd);
#endif
	_lineActor->SetMapper(_lineMapper);
	_lineActor->GetProperty()->BackfaceCullingOn();
	_lineActor->GetProperty()->SetDiffuseColor(0,0,1);
	_lineActor->GetProperty()->SetLineWidth(2);
	_lineActor->GetProperty()->SetOpacity(0);
    _imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineActor );
}

//-------------------------------------------------------------------
void vtkPlane2DView::RotationStart()
{
	vtkMPRBaseData	*mprbasedata = (vtkMPRBaseData*)this->GetVtkBaseData();
	vtkTransform	*transform	 = mprbasedata->GetTransformOrientation();
	_transform1->SetMatrix( transform->GetMatrix() );
}

//-------------------------------------------------------------------
void vtkPlane2DView::RotationDrag(double vx, double vy, bool ok_v, bool ok_ang)
{ 
	if (ok_ang==false)
	{
		_ang =sqrt( vx*vx + vy*vy ) / 1.5;
	}

	if (ok_v==false){
		_vxb=-vy;
		_vyb=vx;
	}
	_transform2->Identity();
	_transform2->RotateWXYZ(_ang,0,_vxb,_vyb);

	vtkMPRBaseData	*mprbasedata = (vtkMPRBaseData*)this->GetVtkBaseData();
	vtkTransform *transform		 =	vtkTransform::New();
	transform->Identity();
	transform->Concatenate(_transform1);
	transform->Concatenate(_transform2);
	mprbasedata->InitTransformOrientation(transform);
	transform->Delete();

	// Refresh Horizontal Line
	_pts->SetPoint( 0 , (_sizeIma/2) - _vxb*2	, (_sizeIma/2) - _vyb*2	, 1 );
	_pts->SetPoint( 1 , (_sizeIma/2) + _vxb*2	, (_sizeIma/2) + _vyb*2	, 1 );
//	RefreshCircleLine();
}

//-------------------------------------------------------------------
void vtkPlane2DView::Refresh(  )
{
	ExtractPlane();
	UpdateColorWindowLevel();
	wxVtkBaseView::Refresh();
}
//-------------------------------------------------------------------
void vtkPlane2DView::SetImgSize( int imgSize )
{
	_sizeIma = imgSize;
}
//-------------------------------------------------------------------
int vtkPlane2DView::GetImgSize()
{
	return _sizeIma;
}
//-------------------------------------------------------------------
int	vtkPlane2DView::GetActualSlice()  // virtual 
{
	_cx = GetVtkmprbasedata()->GetX();
	_cy = GetVtkmprbasedata()->GetY();
	_cz = GetVtkmprbasedata()->GetZ();
	return 0;
}

//-------------------------------------------------------------------

bool vtkPlane2DView::GetMipVisualization()
{
	return _mip_visualization;
}

//-------------------------------------------------------------------
int vtkPlane2DView::GetMipWidth()
{
	return _mip_width;
}

//-------------------------------------------------------------------
void vtkPlane2DView::SetActualSlice(int slice)  // Virtual
{
	double dir=(double)slice/3.0;
	GetVtkmprbasedata()->SetX( _cx + (_n[0]*dir) );
	GetVtkmprbasedata()->SetY( _cy + (_n[1]*dir) );
	GetVtkmprbasedata()->SetZ( _cz + (_n[2]*dir) );
}
//---------------------------------------------------------------------------
vtkInteractorStylePlane2D	*vtkPlane2DView::GetInteractorstyleplane2D()
{
	return this->_interactorstyleplane2D;
}
//---------------------------------------------------------------------------
void vtkPlane2DView::SetActive(bool active)
{
	_active = active;
}

//---------------------------------------------------------------------------

void vtkPlane2DView::SetMipVisualization(bool ok)
{
	_mip_visualization=ok;
}

//---------------------------------------------------------------------------

void vtkPlane2DView::SetMipWidth(int value)
{
	_mip_width=value;
}

//---------------------------------------------------------------------------
void vtkPlane2DView::SetVisibleLine(bool ok)
{
	double opacity;
	if (ok==true)
	{
		opacity=1;
	} else {
		opacity=0;
	}
	_lineActor->GetProperty()->SetOpacity(opacity);
}

// ----------------------------------------------------------------------------
void vtkPlane2DView::TransfromCoordViewWorld2(double &X, double &Y, double &Z)
{
	double spc[3];
	GetVtkmprbasedata()->GetImageData()->GetSpacing(spc);
	double xx = X;
	double yy = Y;
	double zz = 0;
	TransFromCoordScreenToWorld(xx,yy,zz);
	vtkTransform *transf1 = vtkTransform::New();
	transf1->Identity();
	vtkTransform *transf2 = GetVtkmprbasedata()->GetTransformOrientation();
	transf1->Concatenate(transf2->GetMatrix());
	double in[4], out[4];
	double center = GetImgSize() / 2;
	in[0] = 0;
	in[1] = xx - center;
	in[2] = yy - center;
	in[3] = 0;
	transf1->MultiplyPoint(in,out);
	transf1->Delete();
	X = out[0] + GetVtkmprbasedata()->GetX() ;
	Y = out[1] + GetVtkmprbasedata()->GetY() ;
	Z = out[2] + GetVtkmprbasedata()->GetZ() ;
}

