/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkmyPWCallback_3DPointWidget.h"
#include "vtkInteractorStyleBaseView.h"

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
void vtkmyPWCallback_3DPointWidget::Execute(vtkObject *caller, unsigned long, void*)
{
	double n[3];
	double p[3];
	double delta = 0.000000001;

	vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*)_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetInteractorStyleBaseView();

	if (caller==_pointWidget)
	{
		_pointWidget->GetPosition(p);
	}
	if (caller==_planeWidget)
	{
		_planeWidget->GetCenter(p);
		_planeWidget->GetNormal(n);
		_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetNormal(n[0],n[1],n[2]);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		//..
#else
		_planeWidget->GetPolyData(_vtkplane);
		_probe->Update();
#endif

	}

	double spc[3];
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData()->GetSpacing(spc);
	p[0]=p[0]/spc[0];
	p[1]=p[1]/spc[1];
	p[2]=p[2]/spc[2];

	// Orientation change
	if ( (fabs(n[0]-_backNormal[0])>delta) || (fabs(n[1]-_backNormal[1])>delta) || (fabs(n[2]-_backNormal[2])>delta) )
	{
		_backNormal[0] = n[0];
		_backNormal[1] = n[1];
		_backNormal[2] = n[2];
		isbv->SetParent_refresh_waiting();
	}

	// ----------

	double tx = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX();
	double ty = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY();
	double tz = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ();

	// Position Change
	if ( (fabs(tx-p[0])>delta) || (fabs(ty-p[1])>delta) || (fabs(tz-p[2])>delta) )
	{
		_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetX( p[0] );
		_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetY( p[1] );
		_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetZ( p[2] );
		vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*)_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetInteractorStyleBaseView();
		isbv->BlockRefresh();
		isbv->vtkInteractorStyleBaseView::OnLeftButtonDown();
		isbv->SetParent_refresh_waiting();
		isbv->vtkInteractorStyleBaseView::OnMouseMove();
		isbv->UnBlockRefresh();
	} 
	isbv->EvaluateToRefresh();
}
//-------------------------------------------------------------------
void vtkmyPWCallback_3DPointWidget::SetWxVtkMPR3DView( wxVtkMPR3DView *wxvtkmpr3Dview )
{
	_wxvtkmpr3Dview=wxvtkmpr3Dview;
}
//-------------------------------------------------------------------
void vtkmyPWCallback_3DPointWidget::SetVtkPointWidget( vtkPointWidget *pointWidget )
{
	_pointWidget=pointWidget;
}
//-------------------------------------------------------------------
void vtkmyPWCallback_3DPointWidget::SetVtkPlaneWidget( vtkPlaneWidget *planeWidget )
{
	_planeWidget=planeWidget;
}

//-------------------------------------------------------------------
 void vtkmyPWCallback_3DPointWidget::SetVtkPolyData( vtkPolyData *vtkplane)
{
	_vtkplane=vtkplane;
}

//-------------------------------------------------------------------
void vtkmyPWCallback_3DPointWidget::SetVtkProbeFilter( vtkProbeFilter *probe)
{
	_probe=probe;
}



