/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include <vtkPlanes.h>
#include <vtkProperty.h> 
#include <vtkPolyData.h> 
#include <vtkDataSet.h> 
#include <vtkCellArray.h>
#include <vtkTransform.h>
#include <vtkTransformFilter.h>
#include <vtkDataSetReader.h>

#include "wxMPRBaseData.h"
#include "pPlotter/HistogramDialog.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif
//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------


//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
vtkMPRBaseData::vtkMPRBaseData()
{
  _x    = 0;
  _y    = 0;
  _z    = 0;
  _x1   = 0;
  _x2   = 0;
  _y1   = 0;
  _y2   = 0;
  _z1   = 0;
  _z2   = 0;
  _transformOrientation = NULL;
  _marImageData         = NULL;
}

//-------------------------------------------------------------------
vtkMPRBaseData::~vtkMPRBaseData()
{
	if (_marImageData) 			delete _marImageData;
	if (_transformOrientation) 	_transformOrientation ->Delete();
}

//-------------------------------------------------------------------
void vtkMPRBaseData::Configure()
{
	//EED 03nov2012
	vtkBaseData::Configure();
	
	vtkImageData* img = _marImageData->GetImageData();
	if(img !=NULL)
	{
		img->GetExtent (_x1,_x2,_y1,_y2,_z1,_z2);
	//std::cout<<"vtkMPRBaseData::Configure() _x1= "<<_x1<<" _x2= "<<_x2<<" _y1= "<<_y1<<" _y2= "<<_y2<<" _z1= "<<_z1<<" _z2= "<<_z2<<std::endl;		
	}
	
	if(_transformOrientation==NULL)
	{
		_transformOrientation=vtkTransform::New();
	}
	
	_transformOrientation->Identity();
}

//-------------------------------------------------------------------
void vtkMPRBaseData::GetDimensionExtention(int *x1,int *x2,int *y1,int *y2,int *z1,int *z2)
{
	*x1=_x1;
	*x2=_x2;
	*y1=_y1;
	*y2=_y2;
	*z1=_z1;
	*z2=_z2;
}


//------------------------------------------------------------------------
int vtkMPRBaseData::GetMaxPositionX( )
{
	return _x2;
}
//------------------------------------------------------------------------
int vtkMPRBaseData::GetMaxPositionY( )
{
	return _y2;
}
//------------------------------------------------------------------------
int vtkMPRBaseData::GetMaxPositionZ( )
{
	return _z2;
}
//-------------------------------------------------------------------
double vtkMPRBaseData::GetX()
{

	return _x;
}
//-------------------------------------------------------------------
double	vtkMPRBaseData::GetY()
{
	return _y;
}
//-------------------------------------------------------------------
/**
**	Calculates the value of the slider and the layer in the image that is spouse to show
**/
void vtkMPRBaseData::SetX(double x)
{
	//int dim[3];
	int             ext[6];
	double          *origin;
	vtkImageData    *img = _marImageData->GetImageData();
	if(img!=NULL){
		/*img->GetDimensions(dim);
		if (x<0)
		{
			x=0;
		}
		if (x>=dim[0])
		{
			x=dim[0]-1;
		}
		_x=x;*/
		img->GetExtent(ext);
		origin = img->GetOrigin();
		if (x < ext[0])
		{
			x=ext[0] + origin[0];
		}
		if (x > ext[1])
		{
			x=ext[1] + origin[0];
		}
		
		_x=x;
		_observable->InvokeEvent(1);	
	}
}
//-------------------------------------------------------------------
/**
**	Calculates the value of the slider and the layer in the image that is spouse to show
**/
void vtkMPRBaseData::SetY(double y)
{
	//int dim[3];
	int ext[6];
	double* origin;
	vtkImageData* img = _marImageData->GetImageData();
	if(img!=NULL){
		/*img->GetDimensions(dim);
		if (y<0)
		{
			y=0;
		}
		if (y>=dim[1])
		{
			y=dim[1]-1;
		}
		_y=y;*/
		img->GetExtent(ext);
		origin = img->GetOrigin();
		if (y<ext[2])
		{
			y=ext[2] + origin[1];
		}
		if (y > ext[3])
		{
			y=ext[3] + origin[1];
		}
		_y=y;
		_observable->InvokeEvent(2);	
	}
}
//-------------------------------------------------------------------
vtkTransform *vtkMPRBaseData::GetTransformOrientation()
{	
	return _transformOrientation; 
}
//-------------------------------------------------------------------
void vtkMPRBaseData::SetNormal(double nx, double ny, double nz)
{
	double alfa = atan2(ny,nx) * 180.0 / 3.1416;
	double beta = atan2( nz, sqrt( nx*nx + ny*ny )  ) * 180.0 / 3.1416;
	_transformOrientation->Identity();		
	_transformOrientation->RotateWXYZ(alfa,0,0,1);
	_transformOrientation->RotateWXYZ(-beta,0,1,0);
}
//-------------------------------------------------------------------
void vtkMPRBaseData::InitTransformOrientation(vtkTransform *trans)
{
	_transformOrientation->SetMatrix( trans->GetMatrix() );
}



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

