/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMPRWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.17 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include <vtkObjectFactory.h>
#include <vtkInteractorStyleSwitch.h>
#include <vtkCamera.h>
#include <vtkImageActor.h>
#include <vtkRenderer.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRenderWindow.h>

#include <vtkRenderer.h>
#include <vtkImageViewer2.h> 
#include <vtkInteractorStyleImage.h> 

#include <vtkProperty.h> 
#include <vtkPolyData.h> 
#include <vtkDataSet.h> 
#include <vtkStripper.h>
#include <vtkCellArray.h> 
#include <vtkPointData.h> 
#include <vtkInteractorStyleTrackballCamera.h>

#include <vtkPlanes.h>
#include <vtkProbeFilter.h>
#include <vtkPlane.h>
#include <vtkPointPicker.h>


#include "vtkClosePolyData.h"
#include <vtkTriangleFilter.h>
#include <vtkSTLWriter.h>
#include <vtkPolyDataConnectivityFilter.h>

// EED 25 Janvier 2007  -  TestLoic
#include <vtkCutter.h>
#include <vtkWindowLevelLookupTable.h>
#include <vtkLookupTable.h>
#include <vtkMetaImageWriter.h>



#include "wxMPRWidget.h"
#include "creawxVTKRenderWindowInteractor.h"
#include "UtilVtk3DGeometriSelection.h"
#include "../kernel/marDicomBase.h"


#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/colordlg.h>

#include "matrix.h"
#include <string>
#include <stdio.h>



#include "pPlotter/HistogramDialog.h"

#include "vtkInteractorStyle3DView.h"

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

BEGIN_EVENT_TABLE( wxMPRWidget, wxPanel )
	EVT_MENU( 12121, wxMPRWidget::OnRefreshView )
	EVT_MENU( 12122, wxMPRWidget::OnDClickLeft  )
END_EVENT_TABLE( );



wxMPRWidget::wxMPRWidget( wxWindow* parent,
                          marImageData *marimageData )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

	_vtkmpr2Dview[0]				= NULL;
	_vtkmpr2Dview[1]				= NULL;
	_vtkmpr2Dview[2]				= NULL;
	_vtkplane2Dview					= NULL;
	_widgetMesure					= NULL;
	_wxsphereview					= NULL;
	_wxvtk3Dbaseview_MPRClipping3D	= NULL;
	_wxvtkmpr3Dview					= NULL;
	_wxvtkclipping3Dview			= NULL;
	_vtkplane2Dview_B				= NULL;
	_widgetMesure_B					= NULL;

	_vtkmpr2Dview_B[0]				= NULL;
	_vtkmpr2Dview_B[1]				= NULL;
	_vtkmpr2Dview_B[2]				= NULL;
	_vtkplane2Dview_B				= NULL;
	_widgetMesure_B					= NULL;
	_wxsphereview_B					= NULL;
	_wxvtk3Dbaseview_MPR3D_B		= NULL;
	_wxvtkmpr3Dview_B				= NULL;
	_wxvtk3Dbaseview_Clipping3D_BB	= NULL;
	_wxvtkmpr3Dview_BB				= NULL;
	_wxvtkclipping3Dview_BB			= NULL;

	_vtkmprbasedata					= NULL;


	
	_framePanelCutting				= NULL;	
	_panelCutting					= NULL;


	wxBoxSizer			*sizer		= new wxBoxSizer(wxVERTICAL  );
	_marImageData=NULL;

	if(marimageData!=NULL){
		_marImageData					= marimageData;
		_vtkmprbasedata					= new vtkMPRBaseData(); 
		_vtkmprbasedata->SetMarImageData(_marImageData);
		
		
		

		wxSplitterWindow	*pnlSplitter		= new wxSplitterWindow( this , -1);
		pnlSplitter	-> SetMinimumPaneSize( 2 );
		//RaC Nov2012 Correctly resize internal panels with the window resize event
		pnlSplitter->SetSashGravity(0.5);

		wxPanel				*MPRPanel	= CreateMPRPanel(pnlSplitter,_vtkmprbasedata);
		wxPanel				*controlPanel	= CreateControlPanel(pnlSplitter);	
		pnlSplitter	-> SplitVertically( MPRPanel, controlPanel, 550 );

		sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);

	}	   

	//int ww,hh;
	//wxWindow *pp=this;
	//while (pp->GetParent()!=NULL) pp=pp->GetParent();
	//pp->GetSize(&ww,&hh);
    	
	this		-> SetAutoLayout( true );
	this		-> SetSizer(sizer);
//	sizer		->	Fit( this );
	_refreshAPage=0;
	_refreshBPage=0;

}

//----------------------------------------------------------------------------
void wxMPRWidget::setImageData(vtkImageData * img)
{

	if(_marImageData!=NULL){
		_marImageData->removeImageData(0);
		_marImageData->AddImageData(img);		
	}else{
		_marImageData 					= new marImageData(img);
	}
	
	if(_vtkmprbasedata==NULL){
		_vtkmprbasedata					= new vtkMPRBaseData(); 
		_vtkmprbasedata->SetMarImageData(_marImageData);	

		wxSplitterWindow	*pnlSplitter= new wxSplitterWindow( this , -1);
		pnlSplitter	-> SetMinimumPaneSize( 2 );
		//RaC Nov2012 Correctly resize internal panels with the window resize event
				pnlSplitter->SetSashGravity(0.5);

		wxPanel				*MPRPanel		= CreateMPRPanel(pnlSplitter,_vtkmprbasedata);
		wxPanel				*controlPanel	= CreateControlPanel(pnlSplitter);	
		pnlSplitter	-> SplitVertically( MPRPanel, controlPanel, 550 );

		this->GetSizer()		-> Add( pnlSplitter ,1,wxGROW  ,0);
	}	
}

//----------------------------------------------------------------------------
wxMPRWidget::~wxMPRWidget( )
{
//EEDxx2.4 DELETE
	if (_framePanelCutting!=NULL)
	{
		_framePanelCutting->Close();
	}

	if (_vtkmpr2Dview[0]!=NULL)					{ delete _vtkmpr2Dview[0]; }
	if (_vtkmpr2Dview[1]!=NULL)					{ delete _vtkmpr2Dview[1]; }
	if (_vtkmpr2Dview[2]!=NULL)					{ delete _vtkmpr2Dview[2]; }

	if (_vtkmpr2Dview_B[0]!=NULL)				{ delete _vtkmpr2Dview_B[0]; }

	if (_vtkmpr2Dview_B[1]!=NULL)				{ delete _vtkmpr2Dview_B[1]; }
	if (_vtkmpr2Dview_B[2]!=NULL)				{ delete _vtkmpr2Dview_B[2]; }

	if (_vtkmprbasedata!=NULL)					{ delete _vtkmprbasedata; }
	if (_vtkplane2Dview!=NULL)					{ delete _vtkplane2Dview; }
	if (_wxsphereview!=NULL)					{ delete _wxsphereview; }
	if (_wxvtk3Dbaseview_MPRClipping3D!=NULL)	{ delete _wxvtk3Dbaseview_MPRClipping3D; }
	if (_wxvtkmpr3Dview!=NULL)					{ delete _wxvtkmpr3Dview; }
	if (_wxvtkclipping3Dview!=NULL)				{ delete _wxvtkclipping3Dview; }

	if (_vtkplane2Dview_B!=NULL)				{ delete _vtkplane2Dview_B; }
	if (_wxsphereview_B!=NULL)					{ delete _wxsphereview_B; }

	if (_wxvtk3Dbaseview_MPR3D_B!=NULL)			{ delete _wxvtk3Dbaseview_MPR3D_B; }
	if (_wxvtkmpr3Dview_B!=NULL)				{ delete _wxvtkmpr3Dview_B; }

	if (_wxvtk3Dbaseview_Clipping3D_BB!=NULL)	{ delete _wxvtk3Dbaseview_Clipping3D_BB; }
	if (_wxvtkmpr3Dview_BB!=NULL)				{ delete _wxvtkmpr3Dview_BB; }
	if (_wxvtkclipping3Dview_BB!=NULL)			{ delete _wxvtkclipping3Dview_BB; }
}

//----------------------------------------------------------------------------

wxPanel* wxMPRWidget::CreateControlPanel(wxWindow *parent)
{

	wxPanel *panel=new wxPanel(parent,-1);

//EEDxx2.4
//	wxStaticText *tmpText = new wxStaticText(panel,-1,""); 

	wxStaticText *help0Text = new wxStaticText(panel,-1,_T("General: \n  middle click : contrast\n  ctrl + middle click : rotate image\n  shift + middle click: translate image\n  ctrl + right click: zoom")); 

	wxStaticText *help1Text = new wxStaticText(panel,-1,_T("mpr2D: \n  double click : choose a point\n  mouse right : change perpendicular slice\n  drag axis: change slice")); 
	
	wxStaticText *help2Text = new wxStaticText(panel,-1,_T("Plane: \n  drag mouse: rotate\n  ctrl + drag mouse : fix axis rotation\n  \n mouse right: change perpendicular slice \n  see split control \n     - Active/Desactivet plane tool\n     - Center market\n     - Rotation axis market\n     - 2D messure tool (open/close contour)")); 

	wxStaticText *help3Text = new wxStaticText(panel,-1,
_T("Sphere: \n  drag mouse: rotation\n  mouse right: change radio \n  click: 3D point selection in MPR 2D \n  double clicks in MPR: show surface sphere")); 
	
	wxStaticText *help4Text = new wxStaticText(panel,-1,_T("MPR3D:\n  see split control")); 

	wxString text=_T("");
	text=text+_T("Clipping: \n");
	text=text+_T(" see split control \n");
	text=text+_T(" 4 MarchingCubes:  \n");
	text=text+_T("    color, isovalue, opacity \n");
	text=text+_T(" Box:\n");
	text=text+_T("    mouse left drag (box): rotation\n");
	text=text+_T("    mouse left drag (sphere): size,position\n");
	text=text+_T("    mouse right drag (box): box size");
	text=text+_T(" Axis: 3D\n");
	text=text+_T("    mouse drag: translate\n");
	text=text+_T("    shift + mouse drag: translate 2 axis\n");
	text=text+_T("    mouse right: scale\n");
	text=text+_T(" Plane 3D:\n");
	text=text+_T("    mouse drag perpendicular axis: rotate plane\n");
	text=text+_T("    mouse drag spheres: size plane\n");
	text=text+_T("    ctrl +mouse right over the plane: size plane\n");
	text=text+_T("    mouse drag plane: translate\n");
	text=text+_T("    middle click perpendicular axis: translate\n");
	wxStaticText *help5Text = new wxStaticText(panel,-1, text );


    wxFlexGridSizer *sizer  = new wxFlexGridSizer(1);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help0Text	);

	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help1Text	);

	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help2Text	);

	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help3Text	);

	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help4Text	);

	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( new wxStaticText(panel,-1,_T(""))	);
	sizer->Add( help5Text	);
	
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(350,500);

    return panel;
}

//----------------------------------------------------------------------------

void wxMPRWidget::OnPageAChanged(wxNotebookEvent & event)
{
	_refreshAPage=event.GetSelection();
	Refresh();
	RefreshView(true);
}

//----------------------------------------------------------------------------

void wxMPRWidget::OnPageBChanged(wxNotebookEvent & event)
{
	_refreshBPage=event.GetSelection();
//	Refresh(false);
//	RefreshView();
}


//----------------------------------------------------------------------------

wxPanel* wxMPRWidget::CreateView(int type,wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxWindow *wxwindow;
	wxPanel *panel=new wxPanel(parent,-1);

	if (type==0)
	{
		_vtkmpr2Dview_B[0] = new wxVtkMPR2DView(panel,0);
		_vtkmpr2Dview_B[0]->SetVtkBaseData(vtkmprbasedata);
		wxwindow=_vtkmpr2Dview_B[0]->GetWxVTKRenderWindowInteractor();
	}
	if (type==1)
	{
		_vtkmpr2Dview_B[1] = new wxVtkMPR2DView(panel,1);
		_vtkmpr2Dview_B[1]->SetVtkBaseData(vtkmprbasedata);
		wxwindow=_vtkmpr2Dview_B[1]->GetWxVTKRenderWindowInteractor();
	}
	if (type==2)
	{
		_vtkmpr2Dview_B[2] = new wxVtkMPR2DView(panel,2);
		_vtkmpr2Dview_B[2]->SetVtkBaseData(vtkmprbasedata);
		wxwindow=_vtkmpr2Dview_B[2]->GetWxVTKRenderWindowInteractor();
	}
	if (type==3)
	{
		_widgetMesure_B		= new wxWidgetMesure2D_Plane_in_MPR(panel);
		_vtkplane2Dview_B		= new vtkPlane2DView( _widgetMesure_B->GetWindow2());
		_widgetMesure_B->SetVtkPlane2DView( _vtkplane2Dview_B );
		_vtkplane2Dview_B->SetImgSize( 200 );
		_vtkplane2Dview_B->SetVtkBaseData(vtkmprbasedata);
		wxwindow			= _widgetMesure_B;
	}
	if (type==4)
	{
//EED
//		_wxsphereview_B		= new wxSphereView( panel , vtkmprbasedata, vtkmprbasedata->GetImageData() );
		_wxsphereview_B		= new wxSphereView( panel , vtkmprbasedata  );
		wxwindow=_wxsphereview_B->GetWxVTKRenderWindowInteractor();
	}

	if (type==5)
	{
		wxSplitterWindow *panelMPR3D	= new wxSplitterWindow( panel , -1);
		_wxvtk3Dbaseview_MPR3D_B		= new wxVtk3DBaseView( panelMPR3D , vtkmprbasedata );

		_wxvtkmpr3Dview_B					= new wxVtkMPR3DView(_wxvtk3Dbaseview_MPR3D_B);
		vtkMPR3DDataViewer *vtkmpr3Ddataviewer = new vtkMPR3DDataViewer(); 
		vtkmpr3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
		vtkmpr3Ddataviewer->Configure();
		_wxvtkmpr3Dview_B->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

		wxWindow	*window3D				= _wxvtk3Dbaseview_MPR3D_B->GetWxVTKRenderWindowInteractor();
		wxPanel	*controlPanel3D		= _wxvtkmpr3Dview_B->CreateControlPanel(panelMPR3D, false);

//EEDxx2.4
		panelMPR3D	-> SetMinimumPaneSize( 5 );
		panelMPR3D	-> SplitHorizontally( controlPanel3D,window3D,600  );
		//RaC Nov2012 Correctly resize internal panels with the window resize event
		panelMPR3D->SetSashGravity(0.5);

		wxwindow=panelMPR3D;
	}

	if (type==6)
	{
		wxSplitterWindow	*panelClipping3D	= new wxSplitterWindow( panel , -1);
		_wxvtk3Dbaseview_Clipping3D_BB		= new wxVtk3DBaseView( panelClipping3D , vtkmprbasedata );

		_wxvtkclipping3Dview_BB					= new wxVtkClipping3DView(_wxvtk3Dbaseview_Clipping3D_BB);
		vtkClipping3DDataViewer *vtkclipping3Ddataviewer = new vtkClipping3DDataViewer(); 
		vtkclipping3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
		vtkclipping3Ddataviewer->Configure();
		_wxvtkclipping3Dview_BB->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer);

		_wxvtkmpr3Dview_BB						= new wxVtkMPR3DView( _wxvtk3Dbaseview_Clipping3D_BB );
		vtkMPR3DDataViewer *vtkmpr3Ddataviewer	= new vtkMPR3DDataViewer(); 
		vtkmpr3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
		vtkmpr3Ddataviewer->Configure();
		_wxvtkmpr3Dview_BB->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

		wxWindow	*window3D						= _wxvtk3Dbaseview_Clipping3D_BB->GetWxVTKRenderWindowInteractor();

		wxPanel			*panelControl			= new wxPanel(panelClipping3D,-1);	
		wxPanel			*controlPanelMPR3D		= _wxvtkmpr3Dview_BB->CreateControlPanel(panelControl, false);
		wxPanel			*controlPanelClipping3D	= _wxvtkclipping3Dview_BB->CreateSurfControlPanel(panelControl);
		                 _btnCutImageData		= new wxCheckBox(panelControl,-1,_T("Cut Module"));
		Connect(_btnCutImageData->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED  , (wxObjectEventFunction) &wxMPRWidget::OnCutImagaData );

		wxFlexGridSizer  *sizerCtrol             = new wxFlexGridSizer(1);
		sizerCtrol->Add(controlPanelMPR3D		, 1, wxALL|wxEXPAND, 2);
		sizerCtrol->Add(controlPanelClipping3D	, 1, wxALL|wxEXPAND, 2);
		sizerCtrol->Add( _btnCutImageData		, 1, wxALL, 2);

		panelControl->SetAutoLayout(true);
		panelControl->SetSizer(sizerCtrol);
		panelControl->SetSize(400,350);
		panelControl->Layout();
//EEDxx2.4
//		panelControl->FitInside();

//EEDxx2.4
		panelClipping3D	-> SetMinimumPaneSize( 5 );
		panelClipping3D	-> SplitHorizontally( panelControl , window3D , 10  );
		//RaC Nov2012 Correctly resize internal panels with the window resize event
		panelClipping3D->SetSashGravity(0.5);
		wxwindow=panelClipping3D;
	}

    wxBoxSizer *sizerH1							= new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(wxwindow , 1, wxALL|wxGROW, 0);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizerH1);
	panel->SetSize(400,400);
	panel->Layout();

	return panel;
}

//----------------------------------------------------------------------------

wxPanel* wxMPRWidget::CreateMPRPanel(wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxPanel *panel=new wxPanel(parent,-1);

	wxNotebook *notebook = new wxNotebook( panel, -1 );

	notebook->AddPage( CreateMPRPanel4View( notebook ,vtkmprbasedata), _T("4-View") );
	notebook->AddPage( CreateView(0,notebook,vtkmprbasedata) , _T("Axial")		);
	notebook->AddPage( CreateView(1,notebook,vtkmprbasedata) , _T("Sagital")	);
	notebook->AddPage( CreateView(2,notebook,vtkmprbasedata) , _T("Coronal")	);
	notebook->AddPage( CreateView(3,notebook,vtkmprbasedata) , _T("Plane")		);
	notebook->AddPage( CreateView(4,notebook,vtkmprbasedata) , _T("Sphere")		);
	notebook->AddPage( CreateView(5,notebook,vtkmprbasedata) , _T("MPR 3D") 	);
	notebook->AddPage( CreateView(6,notebook,vtkmprbasedata) , _T("Clipping")	);
	Connect(notebook->GetId()	, wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED  , (wxObjectEventFunction) &wxMPRWidget::OnPageAChanged	);

    	wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add(notebook , 1, wxALL|wxGROW, 2);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->SetSize(400,400);
	panel->Layout();

//EEDxx2.4
//	panel->FitInside();

	panel->Refresh();
	return panel;
}

//----------------------------------------------------------------------------

wxPanel* wxMPRWidget::CreateMPRPanel4View(wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxPanel *panel=new wxPanel(parent,-1);

	// view 0
	_vtkmpr2Dview[0] = new wxVtkMPR2DView(panel,0);
	_vtkmpr2Dview[0]->SetVtkBaseData(vtkmprbasedata);
	crea::wxVTKRenderWindowInteractor *iren0 = _vtkmpr2Dview[0]->GetWxVTKRenderWindowInteractor();	

	// view 1
	_vtkmpr2Dview[1] = new wxVtkMPR2DView(panel,1);
	_vtkmpr2Dview[1]->SetVtkBaseData(vtkmprbasedata);
	crea::wxVTKRenderWindowInteractor *iren1 = _vtkmpr2Dview[1]->GetWxVTKRenderWindowInteractor();	

	// view 2
	_vtkmpr2Dview[2] = new wxVtkMPR2DView(panel,2);
	_vtkmpr2Dview[2]->SetVtkBaseData(vtkmprbasedata);
	crea::wxVTKRenderWindowInteractor *iren2 = _vtkmpr2Dview[2]->GetWxVTKRenderWindowInteractor();	

	// view 3
	wxNotebook *notebook = new wxNotebook( panel, -1 );
	notebook->SetSize(400,400);

// EED 27 Oct 2007
	 // view 3.0
	_widgetMesure	= new wxWidgetMesure2D_Plane_in_MPR(notebook);
	_vtkplane2Dview	= new vtkPlane2DView( _widgetMesure->GetWindow2() );
	_widgetMesure->SetVtkPlane2DView( _vtkplane2Dview );
	_vtkplane2Dview->SetImgSize( 200 );
	_vtkplane2Dview->SetVtkBaseData(vtkmprbasedata);
	notebook->AddPage( _widgetMesure, _T("Plane") );

	 // view 3.1
// EED
//	_wxsphereview = new wxSphereView( notebook , vtkmprbasedata, vtkmprbasedata->GetImageData());
	_wxsphereview = new wxSphereView( notebook , vtkmprbasedata );
	crea::wxVTKRenderWindowInteractor *iren3B = _wxsphereview->GetWxVTKRenderWindowInteractor();	
	notebook->AddPage( iren3B, _T("Sphere") );

	 // view 3.2
	wxSplitterWindow *panelMPR3D	= new wxSplitterWindow( notebook , -1);
	_wxvtk3Dbaseview_MPRClipping3D	= new wxVtk3DBaseView( panelMPR3D ,vtkmprbasedata );

	_wxvtkmpr3Dview = new wxVtkMPR3DView( _wxvtk3Dbaseview_MPRClipping3D );
	vtkMPR3DDataViewer *vtkmpr3Ddataviewer = new vtkMPR3DDataViewer(); 
	vtkmpr3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkmpr3Ddataviewer->Configure();
	_wxvtkmpr3Dview->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);


	_wxvtkclipping3Dview = new wxVtkClipping3DView( _wxvtk3Dbaseview_MPRClipping3D );
	vtkClipping3DDataViewer *vtkclipping3Ddataviewer = new vtkClipping3DDataViewer(); 
	vtkclipping3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkclipping3Ddataviewer->Configure();
	_wxvtkclipping3Dview->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer);


	wxWindow	*window3D			= _wxvtk3Dbaseview_MPRClipping3D->GetWxVTKRenderWindowInteractor();
	wxPanel		*panelControl			= new wxPanel(panelMPR3D,-1);
	wxPanel		*controlPanelMPR3D		= _wxvtkmpr3Dview->CreateControlPanel(panelControl, false);
	wxPanel		*controlPanelClipping3D = _wxvtkclipping3Dview->CreateSurfControlPanel(panelControl);

//    wxBoxSizer	 *sizerCtrol             = new wxBoxSizer(wxVERTICAL);
	wxFlexGridSizer  *sizerCtrol             = new wxFlexGridSizer(1);
	sizerCtrol->Add(controlPanelMPR3D		, 1, wxALL|wxEXPAND, 2);
	sizerCtrol->Add(controlPanelClipping3D	, 1, wxALL|wxEXPAND, 2);

	panelControl->SetAutoLayout(true);
	panelControl->SetSizer(sizerCtrol);
	panelControl->SetSize(400,150);
	panelControl->Layout();

//EEDxx2.4
	panelMPR3D	-> SetMinimumPaneSize( 5 );
	//RaC Nov2012 Correctly resize internal panels with the window resize event
	panelMPR3D->SetSashGravity(0.5);
	panelMPR3D	-> SplitHorizontally( panelControl,window3D,200  );
	notebook->AddPage( panelMPR3D, _T("MPR 3D - Clipping") );
	Connect(notebook->GetId()	, wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED  , (wxObjectEventFunction) &wxMPRWidget::OnPageBChanged	);
	wxBoxSizer *sizerV = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *sizerH1= new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer *sizerH2= new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(iren2 , 1, wxALL|wxEXPAND, 2);
	sizerH1->Add(iren0 , 1, wxALL|wxEXPAND, 2);
	sizerH2->Add(iren1 , 1, wxALL|wxEXPAND, 2);
//	sizerH2->Add(iren3 , 1, wxALL|wxEXPAND, 2);
	sizerH2->Add(notebook , 1, wxALL|wxEXPAND, 2);

	sizerV->Add(sizerH1, 1, wxALL|wxEXPAND, 0);
	sizerV->Add(sizerH2, 1, wxALL|wxEXPAND, 0);

	panel->SetAutoLayout(true);
	panel->SetSizer(sizerV);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}

//----------------------------------------------------------------------------
void wxMPRWidget::OnCutImagaData(wxCommandEvent &event) 
{
	if (_btnCutImageData->GetValue()==true){		
       
		_framePanelCutting = new wxFrame(this,-1,_T("Cutting Module"),wxDefaultPosition,wxDefaultSize,wxCAPTION|wxSTAY_ON_TOP| wxRESIZE_BORDER );
		
		_framePanelCutting->SetSize(550,400);

		_panelCutting	= new wxPanelCuttingImageData(_framePanelCutting);		
		if(_wxvtk3Dbaseview_Clipping3D_BB!=NULL){
			_panelCutting->SetWxVtk3DBaseView( _wxvtk3Dbaseview_Clipping3D_BB  );
		}
		_panelCutting->SetVtkMPRBaseData( GetVtkMPRBaseData() );
		_panelCutting->SetVtkClipping3DDataViewer( this->_wxvtkclipping3Dview_BB->GetVtkClipping3DDataViewer() );
		_panelCutting->Configure( );
/*
		wxBoxSizer *topsizer		= new wxBoxSizer(wxHORIZONTAL  );
		topsizer -> Add( _panelCutting ,1,wxALL  ,0);
		_framePanelCutting->SetAutoLayout(true);
		_framePanelCutting->SetSizer( topsizer );      // use the sizer for layout
		_framePanelCutting->Layout(); 
//EEDxx2.4
//		_framePanelCutting->FitInside();
*/
		_framePanelCutting->Show();

		
	} else {
		if (_framePanelCutting!=NULL){
			_panelCutting->RemoveActors();			
			_framePanelCutting->Destroy();
			_framePanelCutting=NULL;
			_panelCutting=NULL;
		}
	}
}

//----------------------------------------------------------------------------
void wxMPRWidget::ConfigureVTK(){
	int x=0,y=0,z=0;

	if (_vtkmprbasedata!=NULL)
	{
		_vtkmprbasedata->Configure();
		x = _vtkmprbasedata->GetMaxPositionX()/2;
		y = _vtkmprbasedata->GetMaxPositionY()/2;
		z = _vtkmprbasedata->GetMaxPositionZ()/2;	
		_vtkmprbasedata->SetX( x );
		_vtkmprbasedata->SetY( y );
		_vtkmprbasedata->SetZ( z );
	
	}

	if(_vtkmpr2Dview[0]!=NULL) 		{ _vtkmpr2Dview[0]->Configure();					}
	if(_vtkmpr2Dview[1]!=NULL) 		{ _vtkmpr2Dview[1]->Configure(); 					}
	if(_vtkmpr2Dview[2]!=NULL) 		{ _vtkmpr2Dview[2]->Configure(); 					}

	if (_vtkmpr2Dview_B[0]!=NULL) 	{ _vtkmpr2Dview_B[0]->Configure(); 					}
	if (_vtkmpr2Dview_B[1]!=NULL) 	{ _vtkmpr2Dview_B[1]->Configure(); 					}
	if (_vtkmpr2Dview_B[2]!=NULL) 	{ _vtkmpr2Dview_B[2]->Configure(); 					}

	if (_vtkplane2Dview!=NULL)		{ _vtkplane2Dview->Configure();						}
	if (_widgetMesure!=NULL)		{ _widgetMesure->ConfigureA(_vtkplane2Dview);		}
	if (_widgetMesure!=NULL)		{ _widgetMesure->SetActiveLink(true);				}
	if (_wxsphereview!=NULL)		{ _wxsphereview->Configure();						}

	if (_wxvtk3Dbaseview_MPRClipping3D!=NULL){_wxvtk3Dbaseview_MPRClipping3D->Configure();}
	if (_wxvtkmpr3Dview!=NULL)		{ _wxvtkmpr3Dview->Configure();						}
	if (_wxvtkclipping3Dview!=NULL)	{ _wxvtkclipping3Dview->Configure();				}

	if (_vtkplane2Dview_B!=NULL)	{ _vtkplane2Dview_B->Configure(); 					}
	if (_widgetMesure_B!=NULL)		{ _widgetMesure_B->ConfigureA( _vtkplane2Dview_B ); }
	if (_widgetMesure_B!=NULL)		{ _widgetMesure_B->SetActiveLink(true); 			}

//EEDx3
//	double spc[3];
//	vtkImageData *imageData = _vtkmprbasedata->GetImageData();
//	imageData->Update();
//	imageData->GetSpacing(spc);
//	_widgetMesure_B->SetMesureScale(spc[0]);


	if (_wxsphereview_B!=NULL)					{_wxsphereview_B				->	Configure();}

	if (_wxvtk3Dbaseview_MPR3D_B!=NULL)			{_wxvtk3Dbaseview_MPR3D_B		->  Configure();}
	if (_wxvtkmpr3Dview_B!=NULL)				{_wxvtkmpr3Dview_B				->	Configure();}

	if ( _wxvtk3Dbaseview_Clipping3D_BB!=NULL)	{_wxvtk3Dbaseview_Clipping3D_BB	->  Configure(); }
	if ( _wxvtkmpr3Dview_BB!=NULL)				{_wxvtkmpr3Dview_BB				->	Configure(); }
	if ( _wxvtkclipping3Dview_BB!=NULL)			{_wxvtkclipping3Dview_BB		->	Configure(); }


	vtkInteractorStyle3DView *vtkinteractorstyle3Dview;
	if (_wxvtkmpr3Dview_BB!=NULL)
	{
		vtkinteractorstyle3Dview	= new vtkInteractorStyle3DView();
		vtkinteractorstyle3Dview->SetWxVtkMPR3DView(_wxvtkmpr3Dview_BB);
		vtkinteractorstyle3Dview->SetWxVtkClipping3DView(_wxvtkclipping3Dview_BB);
	}

	if (_wxvtk3Dbaseview_Clipping3D_BB!=NULL)
	{
		((vtkInteractorStyleBaseView*)_wxvtk3Dbaseview_Clipping3D_BB->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( vtkinteractorstyle3Dview );
	}
	
//EED 29Mars2009
//	RefreshView(true);
	
}

//----------------------------------------------------------------------------

void wxMPRWidget::OnRefreshView(wxCommandEvent & event)
{
	RefreshView();
}
//----------------------------------------------------------------------------
void wxMPRWidget::OnDClickLeft(wxCommandEvent & event)
{
	if (_wxsphereview!=NULL) {
		_wxsphereview	-> RefreshPoint();
	}
	if (_wxsphereview_B!=NULL) {
		_wxsphereview_B -> RefreshPoint();
	}
}
//----------------------------------------------------------------------------
void wxMPRWidget::RefreshView(bool firsttime){

	if (_refreshAPage == 0 )
	{

		if ((_vtkmpr2Dview[0]!=NULL) && (_vtkmpr2Dview[1]!=NULL) && (_vtkmpr2Dview[2]!=NULL) )
		{
			_vtkmpr2Dview[2] -> Refresh();
			_vtkmpr2Dview[1] -> Refresh();
			_vtkmpr2Dview[0] -> Refresh();

			if (firsttime==false)
			{
				_vtkmpr2Dview[2] -> RefreshView();
				_vtkmpr2Dview[1] -> RefreshView();
				_vtkmpr2Dview[0] -> RefreshView();
			}

			if (_refreshBPage == 0 )
			{
				if (_vtkplane2Dview!=NULL)
				{
					_vtkplane2Dview	-> Refresh();		
					if (firsttime==false)
					{
						_vtkplane2Dview -> RefreshView();
					}
//					_wxvtk3Dbaseview_MPR3D_B -> Refresh();
				}
			}
			if (_refreshBPage == 1 )
			{
				//sphere
			}
			if (_refreshBPage == 2 )
			{
				if ((_wxvtkmpr3Dview!=NULL)  && (_wxvtk3Dbaseview_MPRClipping3D!=NULL) && (_wxvtkclipping3Dview!=NULL) )
				{
					_wxvtkmpr3Dview			-> RefreshView();
					_wxvtk3Dbaseview_MPRClipping3D	-> Refresh();
					_wxvtkclipping3Dview		-> Refresh();
				}
			}
		}
	}

	if (_refreshAPage == 1 )
	{
		if (_vtkmpr2Dview_B[0] !=NULL){
			_vtkmpr2Dview_B[0] -> Refresh();
		}
	}
	if (_refreshAPage == 2 )
	{
		if (_vtkmpr2Dview_B[1] !=NULL){
			_vtkmpr2Dview_B[1] -> Refresh();
		}
	}
	if (_refreshAPage == 3 )
	{
		if (_vtkmpr2Dview_B[2] !=NULL){
			_vtkmpr2Dview_B[2] -> Refresh();
		}
	}
	if (_refreshAPage == 4 )
	{
		if (_vtkplane2Dview_B!=NULL){
			_vtkplane2Dview_B -> Refresh();
			if (firsttime==false)
			{
				_vtkplane2Dview_B -> RefreshView();
			}
		}
	}

	if (_refreshAPage == 5 )
	{
		// sphere
	}
	if (_refreshAPage == 6 )
	{
		if (_wxvtkmpr3Dview_B!=NULL){
			_wxvtkmpr3Dview_B		-> Refresh();
			_wxvtk3Dbaseview_MPR3D_B 	-> Refresh();
		}
	}
	if (_refreshAPage == 7 )
	{
		if (_wxvtkmpr3Dview_BB!=NULL){
			_wxvtkmpr3Dview_BB		-> RefreshView();
			_wxvtkclipping3Dview_BB		-> Refresh();
			_wxvtk3Dbaseview_Clipping3D_BB	-> Refresh();
			if (_panelCutting!=NULL)
			{
				_panelCutting->RefreshView();
			}
		}
	}

}
//----------------------------------------------------------------------------
vtkMPRBaseData  *wxMPRWidget::GetVtkMPRBaseData(){	
	return _vtkmprbasedata;
}
//----------------------------------------------------------------------------
vtkPlane2DView *wxMPRWidget::GetVtkPlane2DView()
{
	return _vtkplane2Dview;
}
//----------------------------------------------------------------------------
wxVtkMPR3DView  *wxMPRWidget::GetWxvtkmpr3Dview_BB()
{
	return _wxvtkmpr3Dview_BB;
}
//----------------------------------------------------------------------------
wxVtkBaseView *wxMPRWidget::GetWxVtkBaseView(int page, int id)
{
	wxVtkBaseView *result=NULL;
	if (page==0)
	{	
		if ((id>=0) &&(id<=3)){
			result=_vtkmpr2Dview[id];
		}
		if (id==3)
		{
			result=_vtkplane2Dview;
		}
	}
	return result;
}
//----------------------------------------------------------------------------
wxVtkMPR2DView *wxMPRWidget::GetWxvtkMPR2Dview(int direction)
{
	return _vtkmpr2Dview[direction];
}



//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



// EOF - wxMPRWidget.cxx




