/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualTree_MPRWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.5 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include "wxManualTree_MPRWidget.h"

#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/notebook.h>
#include <wx/colordlg.h>

#include "vtkInteractorStyle3DView.h"


//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

BEGIN_EVENT_TABLE( wxManualTree_MPRWidget, wxPanel )
	EVT_MENU( 12121, wxManualTree_MPRWidget::OnRefreshView )
//	EVT_MENU( 12122, wxManualTree_MPRWidget::OnDClickLeft  )
END_EVENT_TABLE( );


wxManualTree_MPRWidget::wxManualTree_MPRWidget( wxWindow* parent,
                          marImageData *marimageData )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

	_marimageData						= marimageData;

	_wxvtk3Dbaseview_Clipping3D_C		= NULL;
	_wxvtkmpr3Dview_C					= NULL;
	_wxvtkclipping3Dview_C				= NULL;

    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	
	int ww,hh;
	_MPRWidget2					= new wxMPRWidget2(pnlSplitter,_marimageData);
	wxPanel *	contour3DView	= Create3DViewContour( pnlSplitter , _MPRWidget2->GetVtkMPRBaseData());
	this->GetSize(&ww,&hh);

    pnlSplitter	-> SplitVertically( _MPRWidget2, contour3DView , 600);
	wxBoxSizer	*sizer	= new wxBoxSizer(wxVERTICAL  );
	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 50 );
	this		-> SetSizer(sizer);
//EEDxx2.4
//	FitInside();

}

//----------------------------------------------------------------------------

wxManualTree_MPRWidget::~wxManualTree_MPRWidget( )
{
	if (_wxvtk3Dbaseview_Clipping3D_C	!= NULL) { delete	_wxvtk3Dbaseview_Clipping3D_C;	}
	if (_wxvtkmpr3Dview_C				!= NULL) { delete	_wxvtkmpr3Dview_C;				}
	if (_wxvtkclipping3Dview_C			!= NULL) { delete	_wxvtkclipping3Dview_C;			}
}


//----------------------------------------------------------------------------
wxPanel* wxManualTree_MPRWidget::Create3DViewContour( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxWindow *wxwindow;
	wxPanel *panel=new wxPanel(parent,-1);

	wxSplitterWindow	*panelClipping3D	= new wxSplitterWindow( panel , -1);
	_wxvtk3Dbaseview_Clipping3D_C = new wxVtk3DBaseView( panelClipping3D, vtkmprbasedata );

	_wxvtkclipping3Dview_C = new wxVtkClipping3DView(_wxvtk3Dbaseview_Clipping3D_C);
	vtkClipping3DDataViewer *vtkclipping3Ddataviewer = new vtkClipping3DDataViewer(); 
	vtkclipping3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkclipping3Ddataviewer->Configure();
	_wxvtkclipping3Dview_C->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer);

	_wxvtkmpr3Dview_C = new wxVtkMPR3DView( _wxvtk3Dbaseview_Clipping3D_C );
	vtkMPR3DDataViewer *vtkmpr3Ddataviewer = new vtkMPR3DDataViewer(); 
	vtkmpr3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkmpr3Ddataviewer->Configure();
	_wxvtkmpr3Dview_C->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

	wxWindow	*window3D				= _wxvtk3Dbaseview_Clipping3D_C->GetWxVTKRenderWindowInteractor();

	wxPanel		*panelControl			= new wxPanel(panelClipping3D,-1);	
	wxPanel		*controlPanelMPR3D		= _wxvtkmpr3Dview_C->CreateControlPanel(panelControl, false);
	wxPanel		*controlPanelClipping3D	= _wxvtkclipping3Dview_C->CreateSurfControlPanel(panelControl);

//	wxBoxSizer  *sizerCtrol             = new wxBoxSizer(wxVERTICAL);
	wxFlexGridSizer  *sizerCtrol             = new wxFlexGridSizer(1);

	sizerCtrol->Add(controlPanelMPR3D , 1, wxALL|wxEXPAND, 2);
	sizerCtrol->Add(controlPanelClipping3D , 1, wxALL|wxEXPAND, 2);
	panelControl->SetAutoLayout(true);
	panelControl->SetSizer(sizerCtrol);
	panelControl->SetSize(400,350);
	panelControl->Layout();

	int ww,hh;
	wxWindow *pp=this;
	while (pp->GetParent()!=NULL) pp=pp->GetParent();
	pp->GetSize(&ww,&hh);

//EEDxx2.4
//		panelClipping3D	-> SetMinimumPaneSize( -50 );
	panelClipping3D	-> SplitHorizontally( panelControl,window3D, (int)(hh*0.20) );
	wxwindow=panelClipping3D;

    wxBoxSizer *sizerH1 = new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(wxwindow , 1, wxALL|wxEXPAND, 0);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizerH1);
	panel->SetSize(400,400);
	panel->Layout();

//EEDxx2.4
//	panel->FitInside();
//	FitInside();

	return panel;
}
//----------------------------------------------------------------------------
void wxManualTree_MPRWidget::ConfigureContour()
{	
	wxVtkBaseView *wxvtkbaseview;
	wxvtkbaseview			= _MPRWidget2->GetWxVtkBaseView(0,2);

//EED 3 oct 2006
	double spc[3];
	wxvtkbaseview->GetSpacing(spc);

	_manContourControl_2	= new manualContour3VControler(2);
	_mContourModel_2		= new manualContourModel();
	_mViewContour_2			= new manualView3VContour(2);
	_mContourModel_2->SetCloseContour(false);
	_mViewContour_2->SetModel( _mContourModel_2 );
	_mViewContour_2->SetWxVtkBaseView( wxvtkbaseview );
	_mViewContour_2->SetRange( 1 );

//EED 3 oct 2006
	_mViewContour_2->SetSpacing(spc);

	((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_2 );

	//
	wxvtkbaseview			= _MPRWidget2->GetWxVtkBaseView(0,0);
	_manContourControl_0	= new manualContour3VControler(0);
	_mViewContour_0			= new manualView3VContour(0);
	_mViewContour_0->SetModel( _mContourModel_2 );
	_mViewContour_0->SetWxVtkBaseView( wxvtkbaseview );
	_mViewContour_0->SetRange( 1 );

//EED 3 oct 2006
	_mViewContour_0->SetSpacing(spc);

	((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_0 );

	//
	wxvtkbaseview			= _MPRWidget2->GetWxVtkBaseView(0,1);
	_manContourControl_1	= new manualContour3VControler(1);
	_mViewContour_1			= new manualView3VContour(1);
	_mViewContour_1->SetModel( _mContourModel_2 );
	_mViewContour_1->SetWxVtkBaseView( wxvtkbaseview );
	_mViewContour_1->SetRange( 1 );

//EED 3 oct 2006
	_mViewContour_1->SetSpacing(spc);

	((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_1 );


	// perpendicular plane
	wxvtkbaseview			= _MPRWidget2->GetWxVtkBaseView(0,3);
	_manContourControl_p	= new manualContourPerpPlaneControler();
	_mViewContour_p			= new manualViewPerpPlaneContour();
	_mViewContour_p		->	SetModel( _mContourModel_2 );
	_mViewContour_p		->	SetWxVtkBaseView( wxvtkbaseview );
	_mViewContour_p		->	SetRange( 1 );

//EED 3 oct 2006
	_mViewContour_p->SetSpacing(spc);

//	wxvtkbaseview->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContourControl_p );
	((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView())->InsertInteractorStyleMaracas( 0, _manContourControl_p );

	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)wxvtkbaseview;
	_manContourControl_p->SetVtkInteractorStylePlane2D( vtkplane2Dview->GetInteractorstyleplane2D() );

	//
	wxvtkbaseview				= _wxvtkclipping3Dview_C->GetWxvtk3Dbaseview();
	_manContourControl_3V3D		= new manualContour3V3DControler();
	_mViewContour_3D			= new manualView3DContour();
	_mViewContour_3D->SetModel( _mContourModel_2 );
	_mViewContour_3D->SetWxVtkBaseView( wxvtkbaseview );
	_mViewContour_3D->SetRange( 1 );

//EED 3 oct 2006
	_mViewContour_3D->SetSpacing(spc);

	int dim[3];
	this->_marimageData->GetImageData()->GetDimensions( dim );  // image t=0
	_mViewContour_3D->SetDimensions( dim[0],dim[1],dim[2] );
	_mViewContour_3D->SetVtkMPRBaseData( _wxvtkmpr3Dview_C->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData() );
	((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_3V3D );

	//
	_manContourControl_0	-> SetVtkMPRBaseData( _MPRWidget2->GetVtkMPRBaseData() );
	_manContourControl_1	-> SetVtkMPRBaseData( _MPRWidget2->GetVtkMPRBaseData() );
	_manContourControl_2	-> SetVtkMPRBaseData( _MPRWidget2->GetVtkMPRBaseData() );
	_manContourControl_p	-> SetVtkMPRBaseData( _MPRWidget2->GetVtkMPRBaseData() );
	_manContourControl_3V3D	-> SetVtkMPRBaseData( _MPRWidget2->GetVtkMPRBaseData() );

	_manContourControl_0	-> SetModelView( _mContourModel_2 , _mViewContour_0 );
	_manContourControl_0	-> AddManualViewBaseContour( _mViewContour_1	);
	_manContourControl_0	-> AddManualViewBaseContour( _mViewContour_2	);
	_manContourControl_0	-> AddManualViewBaseContour( _mViewContour_p	);
	_manContourControl_0	-> AddManualViewBaseContour( _mViewContour_3D	);

	_manContourControl_1	-> SetModelView( _mContourModel_2 , _mViewContour_1);
	_manContourControl_1	-> AddManualViewBaseContour( _mViewContour_2	);
	_manContourControl_1	-> AddManualViewBaseContour( _mViewContour_0	);
	_manContourControl_1	-> AddManualViewBaseContour( _mViewContour_p	);
	_manContourControl_1	-> AddManualViewBaseContour( _mViewContour_3D	);

	_manContourControl_2	-> SetModelView( _mContourModel_2 , _mViewContour_2 );
	_manContourControl_2	-> AddManualViewBaseContour( _mViewContour_0	);
	_manContourControl_2	-> AddManualViewBaseContour( _mViewContour_1	);
	_manContourControl_2	-> AddManualViewBaseContour( _mViewContour_p	);
	_manContourControl_2	-> AddManualViewBaseContour( _mViewContour_3D	);


	//
	wxvtkbaseview				= _wxvtkclipping3Dview_C->GetWxvtk3Dbaseview();
	manualContour3VControler *_manContourControl_3V = new manualContour3VControler(-1);
	_manContourControl_3V	-> SetModelView( _mContourModel_2 , _mViewContour_3D );
	_manContourControl_3V	-> AddManualViewBaseContour( _mViewContour_2	);
	_manContourControl_3V	-> AddManualViewBaseContour( _mViewContour_0	);
	_manContourControl_3V	-> AddManualViewBaseContour( _mViewContour_1	);
	_manContourControl_3V	-> AddManualViewBaseContour( _mViewContour_p	);
	_manContourControl_3V	-> SetVtkInteractorStyleBaseView ((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView() );
	_manContourControl_3V3D	-> SetManualContour3VControler( _manContourControl_3V );
	_manContourControl_3V3D	-> SetModelView( _mContourModel_2 , _mViewContour_3D );

	//
	wxvtkbaseview			= _MPRWidget2->GetWxVtkBaseView(0,3);
	manualContour3VControler *_manContourControl_3V_p = new manualContour3VControler(-1);
	_manContourControl_3V_p	-> SetModelView( _mContourModel_2 , _mViewContour_p );
	_manContourControl_3V_p	-> AddManualViewBaseContour( _mViewContour_2	);
	_manContourControl_3V_p	-> AddManualViewBaseContour( _mViewContour_0	);
	_manContourControl_3V_p	-> AddManualViewBaseContour( _mViewContour_1	);
	_manContourControl_3V_p	-> AddManualViewBaseContour( _mViewContour_3D	);
	_manContourControl_3V_p	-> SetVtkInteractorStyleBaseView ((vtkInteractorStyleBaseView*)wxvtkbaseview->GetInteractorStyleBaseView() );
	_manContourControl_p	-> SetManualContour3VControler( _manContourControl_3V_p );
	_manContourControl_p	-> SetModelView( _mContourModel_2 , _mViewContour_p );


	//
	_manContourControl_0	-> CreateNewManualContour();
	_manContourControl_1	-> CreateNewManualContour();
	_manContourControl_2	-> CreateNewManualContour();
	_manContourControl_p	-> CreateNewManualContour();
	_manContourControl_3V3D	-> CreateNewManualContour();

	_manContourControl_0	-> SetActive(true);
	_manContourControl_1	-> SetActive(true);
	_manContourControl_2	-> SetActive(true);
	_manContourControl_p	-> SetActive(true);
	_manContourControl_3V3D	-> SetActive(true);

	_manContourControl_0	-> SetEasyCreation(false);
	_manContourControl_1	-> SetEasyCreation(false);
	_manContourControl_2	-> SetEasyCreation(false);
	_manContourControl_p	-> SetEasyCreation(false);
	_manContourControl_3V3D	-> SetEasyCreation(false);

	_mViewContour_0			-> RefreshContour();
	_mViewContour_1			-> RefreshContour();
	_mViewContour_2			-> RefreshContour();
	_mViewContour_p			-> RefreshContour();
	_mViewContour_3D		-> RefreshContour();

}

//----------------------------------------------------------------------------
void wxManualTree_MPRWidget::ConfigureVTK(){
	_MPRWidget2->ConfigureVTK();
	_wxvtk3Dbaseview_Clipping3D_C	->  Configure();
	_wxvtkmpr3Dview_C				->	Configure();
	_wxvtkclipping3Dview_C			->	Configure();

	vtkInteractorStyle3DView *vtkinteractorstyle3Dview	= new vtkInteractorStyle3DView();
	vtkinteractorstyle3Dview->SetWxVtkMPR3DView(_wxvtkmpr3Dview_C);
	vtkinteractorstyle3Dview->SetWxVtkClipping3DView(_wxvtkclipping3Dview_C);
	((vtkInteractorStyleBaseView*)_wxvtk3Dbaseview_Clipping3D_C->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( vtkinteractorstyle3Dview );

	ConfigureContour();
}

//----------------------------------------------------------------------------
vtkMPRBaseData  *wxManualTree_MPRWidget::GetVtkMPRBaseData(){
	return _MPRWidget2->GetVtkMPRBaseData();
}
//----------------------------------------------------------------------------
vtkPlane2DView *wxManualTree_MPRWidget::GetVtkPlane2DView()
{
	return _MPRWidget2->GetVtkPlane2DView();
}
//----------------------------------------------------------------------------
manualContourModel *wxManualTree_MPRWidget::GetManualContourModel()
{
	return _mContourModel_2;
}
//----------------------------------------------------------------------------
void wxManualTree_MPRWidget::OnRefreshView(wxCommandEvent & event)
{
	RefreshView();
}
//----------------------------------------------------------------------------
void wxManualTree_MPRWidget::RefreshView()
{
	this->_MPRWidget2->RefreshView();
	_wxvtkmpr3Dview_C				-> RefreshView();
	_wxvtkclipping3Dview_C			-> Refresh();
	_wxvtk3Dbaseview_Clipping3D_C	-> Refresh();
	_mViewContour_p					-> Refresh();
}


// EOF - wxManualTree_MPRWidget.cxx




