/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasDialog_NViewers.h"
//#include <wx/frame.h> 
#include <wx/sizer.h> 
#include <wx/splitter.h>
#include "creaSystem.h"

BEGIN_EVENT_TABLE( wxMaracasDialog_NViewers, wxFrame )
	EVT_MENU( 12121, wxMaracasDialog_NViewers::OnRefreshView )
	EVT_MENU( 12122, wxMaracasDialog_NViewers::OnDClickLeft )
END_EVENT_TABLE( );

/**
** Class constructor
**/
wxMaracasDialog_NViewers::wxMaracasDialog_NViewers(wxWindow* parent, vtkImageData* img, std::vector<int>* type, wxString title)
//: wxFrame(parent, -1, title)
: wxFrame(NULL, -1, title, wxDefaultPosition,wxSize(700,700))
{
	wxSplitterWindow *splitpanel = new wxSplitterWindow(this, -1);
	splitpanel->SetMinimumPaneSize(5);
	//RaC Nov2012 Correctly resize internal panels with the window resize event
	splitpanel->SetSashGravity(0.5);

	viewer = new wxMaracas_N_ViewersWidget(splitpanel, img, type);
//	std::string path = crea::System::GetDllAppPath("bbcreaMaracasVisu.dll"); // JPR
        std::string dllLastName("bbcreaMaracasVisu.dll");	
	std::string path = crea::System::GetDllAppPath(dllLastName);
	cutter = CutModelMainPanel::getInstance(splitpanel, path);
	cutter->setRenderer( viewer->GetwxVtkBaseView(1)->GetRenderer() );
	cutter->setInteractor( viewer->GetwxVtkBaseView(1)->GetWxVTKRenderWindowInteractor() );
	cutter->setImageData(img);
	
	splitpanel->SplitVertically( cutter, viewer, 50);
}

/**
** Class destructor
**/
wxMaracasDialog_NViewers::~wxMaracasDialog_NViewers(){	
}

/**
**
**/
void wxMaracasDialog_NViewers::OnRefreshView(wxCommandEvent & event)
{
	point.clear();
	point.push_back((int)viewer->GetX());
	point.push_back((int)viewer->GetY());
	point.push_back((int)viewer->GetZ());

	viewer->OnRefreshView(event);
}

/**
**
**/
void wxMaracasDialog_NViewers::OnDClickLeft(wxCommandEvent & event)
{
	viewer->OnDClickLeft(event);
}

/**
**
**/
wxMaracas_N_ViewersWidget* wxMaracasDialog_NViewers::getViewer()
{
	return viewer;
}
