/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasMultipleVolumeRendererManager.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.10 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "wxMaracasMultipleVolumeRendererManager.h"

#include "vtkRenderWindow.h"
#include <vtkMetaImageReader.h>
#include <vtkImageCast.h>
/**
**	Start of the manager class
**/
wxMaracasMultipleVolumeRendererManager::wxMaracasMultipleVolumeRendererManager(){
	_renderer = NULL;
	_idCount=0;
}
wxMaracasMultipleVolumeRendererManager::~wxMaracasMultipleVolumeRendererManager(){
}

/**
**	Sets the renderer to manage the prop3D from the view
**/
void wxMaracasMultipleVolumeRendererManager::setRenderer(vtkRenderer*  renderer){
	_renderer = renderer;
}

/**
** Gets the renderer which manage the prop3D from the view
**/
vtkRenderer* wxMaracasMultipleVolumeRendererManager::getRenderer(){
	return _renderer;
}

/**
** Updates Volume
**/
void wxMaracasMultipleVolumeRendererManager::Update(int ppid){
	wxMaracasMultipleVolumeRendererManagerData* data = this->getViewData(ppid);
	data->Update();
	_renderer->GetRenderWindow()->Render();
}

/**
**	Adds a prop3D to the manager and returns the identifier
**/
// EED 2022-08-04	throw
//int wxMaracasMultipleVolumeRendererManager::addVolume(int idTP, vtkImageData* vol, std::string dataname) throw(char*)
int wxMaracasMultipleVolumeRendererManager::addVolume(int idTP, vtkImageData* vol, std::string dataname) 
{
	try {
		checkInvariant();
		image = vol;
		if(vol != NULL){
			wxMaracasMultipleVolumeRendererManagerData* data = new wxMaracasMultipleVolumeRendererManagerData(vol, dataname);
			prop3Dvect.push_back(data);
			_renderer->AddActor(data->getProp3D());
			if(idTP == -1)
			{
				data->setId(_idCount);
				_idCount++;
			}
			else
			{
				data->setId(idTP);
			}
			printf("wxMaracasMultipleVolumeRendererManager::addVolume->idVolumeRenderer: %i\n", data->getId());
			return data->getId();
		}else{
			throw "Check mhd imagefile file or input";
		}
		return -1;
	} catch (...) {
	  throw ;
	}
}
/**
**	adds or removes an actor depending of the bool value
**/

// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManager::addRemoveActor(int propid, bool addremove)  throw(char*)
void wxMaracasMultipleVolumeRendererManager::addRemoveActor(int propid, bool addremove) 
{
	try {
		checkInvariant();
		wxMaracasMultipleVolumeRendererManagerData* data = this->getViewData(propid);		
		if(data->getProp3D()!=NULL){
			if(addremove){
				_renderer->AddViewProp(data->getProp3D());
			}else{
				_renderer->RemoveViewProp(data->getProp3D());
			}
			_renderer->GetRenderWindow()->Render();
		}	
	} catch (...) {
	  throw ;
	}	
}


/**
**	Changes the opacity in a prop3D
**/
// EED 2022-08-04	throw
// void wxMaracasMultipleVolumeRendererManager::setVolumeOpacity(int propid, std::vector<double> greylevel,std::vector<double> value) throw(char*)
void wxMaracasMultipleVolumeRendererManager::setVolumeOpacity(int propid, std::vector<double> greylevel,std::vector<double> value)
{
	try {
		checkInvariant();		
		this->getViewData(propid)->setVolumeOpacity(greylevel, value);
		_renderer->GetRenderWindow()->Render();
	} catch (...) {
	  throw ;
	}	
}

/**
**	Set Volume Color
**/
// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManager::setVolumeColor(int volid, std::vector<double> greylevel,
//								std::vector<double> red,
//								std::vector<double> green,
//								std::vector<double> blue)throw(char*)
void wxMaracasMultipleVolumeRendererManager::setVolumeColor(int volid, std::vector<double> greylevel,
								std::vector<double> red,
								std::vector<double> green,
								std::vector<double> blue)
{
	try {
		checkInvariant();		
		this->getViewData(volid)->setVolumeColor(greylevel, red, green, blue);
		_renderer->GetRenderWindow()->Render();
	} catch (...) {
	  throw ;
	}	
}


vtkImageData* wxMaracasMultipleVolumeRendererManager::getImageData(std::string filename)
{
	if(filename.compare("")!= 0){	
		
		vtkMetaImageReader* reader =  vtkMetaImageReader::New();	
		reader->SetFileName(filename.c_str());
		reader->Update();
		vtkImageData* img = reader->GetOutput();	

		vtkImageCast* cast = vtkImageCast::New(); 
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		cast->SetInput(img);
#else
		cast->SetInputData(img);
#endif

		cast->SetOutputScalarTypeToUnsignedShort();
		cast->Update();			
		//reader->Delete();
		//img->Delete();
		return cast->GetOutput();
		//return img;
	}	
	return NULL;
}

vtkImageData* wxMaracasMultipleVolumeRendererManager::getImageData()
{
	return image;
}

// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManager::checkInvariant()  throw(char*)
void wxMaracasMultipleVolumeRendererManager::checkInvariant() 
{
	try {
		if(this->_renderer==NULL)
		{
			throw "Renderer not set";
		}
	} catch (...) {
	  throw ;
	}	
}

// EED 2022-08-04	throw
//wxMaracasMultipleVolumeRendererManagerData* wxMaracasMultipleVolumeRendererManager::getViewData(int id) throw(char*)
wxMaracasMultipleVolumeRendererManagerData* wxMaracasMultipleVolumeRendererManager::getViewData(int id) 
{
	try {
		int i;
		for(i = 0; i < (int)(prop3Dvect.size());i++){
			if(prop3Dvect[i]->getId() == id){
				return prop3Dvect[i];
			}
		}
		throw "id not found in the data";
		return NULL;
	} catch (...) {
	  throw ;
	}	
}

// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManager::deleteActor(int propid) throw (char *)
void wxMaracasMultipleVolumeRendererManager::deleteActor(int propid) 
{
	try {
		checkInvariant();	
		this->addRemoveActor(propid, false);
		int i,n;
		bool exit = false;
		for(i = 0; i < (int)(prop3Dvect.size())&&!exit;i++){
			if(prop3Dvect[i]->getId() == propid){			
				n=i;
				exit = true;
			}
		}
		if(exit){
			wxMaracasMultipleVolumeRendererManagerData* data = prop3Dvect[n];			
			int j;
			for(j = i; j < (int)(prop3Dvect.size())-1;j++){
				prop3Dvect[j] = prop3Dvect[j+1];
			}		
			delete data;
			prop3Dvect.pop_back();
		}else{
			throw "id not found in the data";
		}
	} catch (...) {
	  throw ;
	}	
}

vtkPiecewiseFunction* wxMaracasMultipleVolumeRendererManager::GetTransferFunction(int volumeid)
{
	return getViewData(volumeid)->GetTransferFunction();
}

vtkColorTransferFunction* wxMaracasMultipleVolumeRendererManager::GetColorFunction(int volumeid)
{
	return getViewData(volumeid)->GetColorFunction();
}


// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManager::changeCompositeMIPFunction(int id, int function) throw (char *)
void wxMaracasMultipleVolumeRendererManager::changeCompositeMIPFunction(int id, int function) 
{
	try {
		getViewData(id)->changeCompositeMIPFunction(function);
		Update(id);
	} catch (...) {
	  throw ;
	}	
}
