/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "wxMaracasMultipleVolumeRendererManagerData.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

wxMaracasMultipleVolumeRendererManagerData::wxMaracasMultipleVolumeRendererManagerData(vtkImageData* vol, std::string dataname){

	_vol 					= vol;	
	_dataname 				= dataname;
	_tfun 					= vtkPiecewiseFunction::New();
	_ctfun 					= vtkColorTransferFunction::New();   
	_volumePlanes  			= vtkPlanes::New();


#if (VTK_MAJOR_VERSION <= 7) 
	_compositeFunction 		= vtkVolumeRayCastCompositeFunction::New();
	_MIPFunction 			= vtkVolumeRayCastMIPFunction::New();
	_volumeMapper 			= vtkVolumeRayCastMapper::New();		
	_volumeMapper->SetVolumeRayCastFunction(_compositeFunction);
#else 
	_volumeMapper 			= vtkFixedPointVolumeRayCastMapper::New();	
#endif

	_volumeMapper->SetClippingPlanes( _volumePlanes );
	_volumeMapper->AutoAdjustSampleDistancesOn();
	_volumeProperty = vtkVolumeProperty::New();	
	_volumeProperty->SetInterpolationTypeToLinear();
	_volumeProperty->ShadeOn();
	_volumeProperty->DisableGradientOpacityOn();	
	_volumeProperty->SetColor(_ctfun);
	_volumeProperty->SetScalarOpacity(_tfun );

	_newvol = vtkVolume::New();
	_newvol->SetMapper(_volumeMapper );
	_newvol->SetProperty(_volumeProperty );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_volumeMapper->SetInput( _vol );
#else
	_volumeMapper->SetInputData( _vol );
#endif

	_volumeMapper->Update();
	_newvol->Update();
}


wxMaracasMultipleVolumeRendererManagerData::~wxMaracasMultipleVolumeRendererManagerData()
{	
	_tfun->Delete();
	_ctfun->Delete();
	_volumePlanes->Delete();
#if (VTK_MAJOR_VERSION <= 7) 
	_compositeFunction->Delete();
#else 
	// ..
#endif
	_volumeMapper->Delete();

	_volumeProperty->Delete();
	_newvol->Delete();
}
/**
**	Set Volume Color
**/
void wxMaracasMultipleVolumeRendererManagerData::setVolumeColor(std::vector<double>& greylevelcolors,
								std::vector<double>& red,
								std::vector<double>& green,
								std::vector<double>& blue)
{	
	
	_ctfun->RemoveAllPoints();
	for(int i = 0; i < greylevelcolors.size();i++){
		_ctfun->AddRGBPoint(greylevelcolors[i], red[i],green[i], blue[i]);
				//std::cout<<"wxMaracasMultipleVolumeRendererManagerData::setVolumeColor "<<greylevelcolors[i]<<" "<<red[i]<<" "<<green[i]<<" "<<blue[i]<<std::endl;
	}		
	_newvol->Update();	
}
				
/**
**	Volume Opacity
**/
void wxMaracasMultipleVolumeRendererManagerData::setVolumeOpacity(std::vector<double> greylevel,std::vector<double> value)
{		
	_tfun->RemoveAllPoints();
	for(int i = 0; i < greylevel.size();i++){
		_tfun->AddPoint(greylevel[i], value[i]);
			//std::cout<<"wxMaracasMultipleVolumeRendererManagerData::setVolumeOpacity "<<greylevel[i]<<" "<< value[i]<<std::endl;
	}
    _newvol->Update();
}

/**
**	Check if the variables are setted correctly
**/
// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManagerData::checkInvariant()throw (char *)
void wxMaracasMultipleVolumeRendererManagerData::checkInvariant()
{	
	try {
		#if (VTK_MAJOR_VERSION <= 7) 
			if(!_compositeFunction)
			{
				throw "No composite function initialized";
			}
			if(!_MIPFunction)
			{
				throw "No MIP function initialized";
			}
		#else 
			// ..
		#endif
			if(!_volumeMapper)
			{
				throw "No volume mapper initialized";
			}
	} catch (...) {
	  throw ;
	}
}

/**
**	Check if the variables are setted correctly
**/
void wxMaracasMultipleVolumeRendererManagerData::Update(){
	 _newvol->Update();
}
/**
**	get the prop3D 
**/
vtkProp3D* wxMaracasMultipleVolumeRendererManagerData::getProp3D(){
	return this->_newvol;
}
/**
**	return the id from the daat
**/
int wxMaracasMultipleVolumeRendererManagerData::getId(){
	return _id;
}
/**
**	set data id
**/
void wxMaracasMultipleVolumeRendererManagerData::setId(int propid){
	_id = propid;
}

/**
**	Get the filanme
**/
std::string wxMaracasMultipleVolumeRendererManagerData::getDataname(){
	return _dataname;
}
/**
** Set the filanme
**/
void wxMaracasMultipleVolumeRendererManagerData::setDataname(std::string dataname){
	_dataname = dataname;
}

// EED 2022-08-04	throw
//void wxMaracasMultipleVolumeRendererManagerData::changeCompositeMIPFunction(int function) throw (char *)
void wxMaracasMultipleVolumeRendererManagerData::changeCompositeMIPFunction(int function) 
{
	try {
			checkInvariant();	
		#if (VTK_MAJOR_VERSION <= 7) 
			if(function == 0)
			{
				_volumeMapper->SetVolumeRayCastFunction(_compositeFunction);
			}else{
				_volumeMapper->SetVolumeRayCastFunction(_MIPFunction);
			}
		#else 
			printf("EED   wxMaracasMultipleVolumeRendererManagerData::changeCompositeMIPFunction   Composite MIP  ..... ??");
		#endif
	} catch (...) {
	  throw ;
	}
}

