/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasMultipleVolumeRendererPanel.h"
#include "wxMaracasMultipleVolumeRendererView.h"
#include "wxMaracas_N_ViewersWidget.h"
#include "wxMaracasDialog_NViewers.h"
#include "wxMaracasRendererView.h"

#include <wx/colordlg.h>

#include "vtkImageData.h"
#include "vtkRenderer.h"

#include <OpenImage.xpm>
#include <Add.xpm>
#include "Color.xpm"
#include <vector>
//#include <vtkImageCast.h>
/**
**	Implementation of viewProp3D
**/

/**
** Class constructor
**/
wxMaracasMultipleVolumeRendererPanel::wxMaracasMultipleVolumeRendererPanel(wxWindow* parent,int propid, vtkImageData* img, bool _isComplexBox)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize)
{
	_propid = propid;
	isComplexBox = _isComplexBox;
	
	createControls(img);
}

/**
** Class destructor
**/
wxMaracasMultipleVolumeRendererPanel::~wxMaracasMultipleVolumeRendererPanel(){	
	
	//if(isComplexBox)
		//((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->deleteVolume(_propid);
	//else
		//wxMaracasMultipleVolumeRendererView::getInstance()->deleteVolume(_propid);
	delete mwxwidget;
}

/**
** Sets panel elements
**/
void wxMaracasMultipleVolumeRendererPanel::createControls(vtkImageData* img){

	wxFlexGridSizer* sizerirmprop = new wxFlexGridSizer(3);
	
	if(!isComplexBox)
	{
//		wxStaticText* label = new wxStaticText(this, -1, wxString(_T("")));	
//		wxStaticText* label2 = new wxStaticText(this, -1, wxString(_T("")));


		checkbox = new  wxCheckBox(this,-1,wxString(_T("Show Actor")));
		Connect(checkbox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onCheckBoxChange);	
		checkbox->SetValue(true);	

		wxString choices[] = {_T("Composite"), _T("MIP")};
		_radiobox = new wxRadioBox(this, -1, wxString(_T("Function")), wxDefaultPosition, wxDefaultSize, 2, choices);
		Connect(_radiobox->GetId(), wxEVT_COMMAND_RADIOBOX_SELECTED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onRadioBoxSelectFunction);

		sizerirmprop->Add(checkbox,wxFIXED_MINSIZE);
		sizerirmprop->AddSpacer(5);
		sizerirmprop->Add(_radiobox,wxFIXED_MINSIZE);
		//sizerirmprop->Add(label2,wxFIXED_MINSIZE);
	}
	//wxBitmap bitmap(Color_xpm);
	//_colorchoose = new wxBitmapButton(this, -1, bitmap,wxDefaultPosition,wxSize(30,30));	
	//Connect(_colorchoose->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onColorChange);			

	mwxwidget = new HistogramDialogComboBox(this);
	mwxwidget->setImageData(img);
    //mwxwidget->PushEventHandler(this);
	Connect(mwxwidget->GetId(), wxEVT_COMMAND_COMBOBOX_SELECTED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onColorChange);
	sizerirmprop->Add(mwxwidget,wxFIXED_MINSIZE);	

	wxBitmap bitmap0(Add_xpm);
	_viewimage = new wxBitmapButton(this, -1, bitmap0, wxDefaultPosition, wxSize(30,30));	
	Connect(_viewimage->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onViewImage);			
	sizerirmprop->Add(_viewimage,wxFIXED_MINSIZE);	

	//std::string iconsdir = wxMaracasMultipleVolumeRendererView::getInstance()->getPath();
	//iconsdir+="/data/Icons/Add.xmp";
	//wxBitmap* bitmap = new wxBitmap(wxString(iconsdir.c_str(),wxConvUTF8), wxBITMAP_TYPE_XPM);

	this->SetSizer(sizerirmprop, true);		
	this->SetAutoLayout( true );
    
	//_frame = new wxFrame(this, 10, _T("Configure Transfer Functions"));	

	/*wxButton* button1 = new wxButton(_frame,20,_T("OK"));
	Connect(button1->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onOK);				
	wxButton* button2 = new wxButton(_frame,30,_T("Cancel") );
	Connect(button2->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onCancel);				
	wxButton* button3 = new wxButton(_frame,40,_T("Update"));
	Connect(button3->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasMultipleVolumeRendererPanel::onUpdate);				*/

	/*mwxwidget->erasePointsTransferenceFunction();
	double range[2];
	img->GetScalarRange(range);
	double max = range[1];

	
	//X
	mwxwidget->addPointToTransferenceFunction(max * 0/2,0.0);
	mwxwidget->addPointToTransferenceFunction(max * 1/2,100.0);
	mwxwidget->addPointToTransferenceFunction(max * 2/2,100.0);

	mwxwidget->addColorPoint(max*0/4,(int)(0.0*255),(int)(0.0*255),(int)(0.0*255));
	mwxwidget->addColorPoint(max*1/4,(int)(1.0*255),(int)(0.0*255),(int)(0.0*255));
	mwxwidget->addColorPoint(max*2/4,(int)(0.0*255),(int)(0.0*255),(int)(1.0*255));
	mwxwidget->addColorPoint(max*3/4,(int)(0.0*255),(int)(1.0*255),(int)(0.0*255));
	mwxwidget->addColorPoint(max*4/4,(int)(0.0*255),(int)(0.0*255),(int)(0.2*255));	*/

	/*wxBoxSizer* boxSizer0 = new wxBoxSizer(wxHORIZONTAL);
	boxSizer0->Add(mwxwidget, 4, wxGROW);

	wxBoxSizer* boxSizer = new wxBoxSizer(wxHORIZONTAL);
	boxSizer->AddSpacer(40);
	boxSizer->Add(button1, wxCENTER);
	boxSizer->AddSpacer(40);
	boxSizer->Add(button2, wxCENTER);
	boxSizer->AddSpacer(40);
	boxSizer->Add(button3, wxCENTER);

	wxBoxSizer* boxsizer2 = new wxBoxSizer(wxVERTICAL);
	boxsizer2->Add(boxSizer0,1,wxEXPAND);	
	boxsizer2->Add(boxSizer,0,wxCENTER);	
    
	_frame->SetAutoLayout(true);


    _frame->SetSizer(boxsizer2);

	_frame->Refresh();
	_frame->Update();*/	
	//mwxwidget->SetFunctions(wxMaracasMultipleVolumeRendererView::getInstance()->GetTransferFunction(getPropId()),
	//						wxMaracasMultipleVolumeRendererView::getInstance()->GetColorFunction(getPropId()));
	mwxwidget->Refresh();	
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::onOK(wxCommandEvent& event){
    updateVolume();
	//_frame->Show(false);
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::onCancel(wxCommandEvent& event){
	//_frame->Show(false);
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::onUpdate(wxCommandEvent& event){
	updateVolume();    
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::updateVolume(){
	std::vector<double> greylevelcolors;
	std::vector<double> red;
	std::vector<double> green;
	std::vector<double> blue;

	std::vector<double> greylevel;
	std::vector<double> values;

    mwxwidget->GetValuesColorPointsFunction(greylevelcolors, red, green, blue);
	mwxwidget->GetValuesPointsFunction(greylevel, values);

	if(this->isComplexBox)
	{
		( (wxMaracasRendererView::getInstance())->getTabbedPanel(this->_propid) )->SetValuesColorPointsFunction(this->_propid,greylevelcolors, red, green, blue);
		( (wxMaracasRendererView::getInstance())->getTabbedPanel(this->_propid) )->SetValuesPointsFunction(this->_propid, greylevel, values);
	}
	else
	{	
		wxMaracasMultipleVolumeRendererView::getInstance()->SetValuesColorPointsFunction(this->_propid, greylevelcolors, red, green, blue);
		wxMaracasMultipleVolumeRendererView::getInstance()->SetValuesPointsFunction(this->_propid, greylevel, values);
	}
}

/**
** Updates the volume visualization
**/
void wxMaracasMultipleVolumeRendererPanel::onColorChange(wxCommandEvent& event){	

	//if(mwxwidget->ShowModal()==wxID_OK){
        updateVolume();
	//	mwxwidget->Show(false);
	//}	
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::onViewImage(wxCommandEvent& event)
{	
	vtkImageData* img;
	std::vector<int> type;
	type.push_back(6);

	wxFrame* frame = new wxFrame(this, -1, wxString(_T("Volume Visualization")));
	frame->SetSize(wxDefaultSize);

	if(this->isComplexBox)
	{
		img = (wxMaracasRendererView::getInstance())->getTabbedPanel(_propid)->getVolImage();	
	}
	else
	{	
		img = wxMaracasMultipleVolumeRendererView::getInstance()->getVolumeRenderManager()->getImageData();
	}

	//	wxMaracas_N_ViewersWidget* viewer = new wxMaracas_N_ViewersWidget(frame, img, &type);
	new wxMaracas_N_ViewersWidget(frame, img, &type);
	frame->Show();
}

/**
**
**/
void wxMaracasMultipleVolumeRendererPanel::onCheckBoxChange(wxCommandEvent& event){	
	if(this->isComplexBox)
		( (wxMaracasRendererView::getInstance())->getTabbedPanel(this->_propid) )->addRemoveActorV(this->getPropId(), checkbox->GetValue());
	else
		wxMaracasMultipleVolumeRendererView::getInstance()->addRemoveActor(this->getPropId(), checkbox->GetValue());	
}

/**
** Gets the propId
**/
int wxMaracasMultipleVolumeRendererPanel::getPropId(){
	return _propid;
}

void wxMaracasMultipleVolumeRendererPanel::onRadioBoxSelectFunction(wxCommandEvent& event){	
	
	wxMaracasMultipleVolumeRendererView::getInstance()->changeCompositeMIPFunction(this->getPropId(), _radiobox->GetSelection());	
}

/**
** Carolina Perez: Recently added method
**/
HistogramDialogComboBox* wxMaracasMultipleVolumeRendererPanel::getMwxwidget()
{
	return mwxwidget;
}

