/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasRenderImageManagementPanel.h"


#include <vtkVolume.h>

/**
** Class constructor
**/
wxMaracasRenderImageManagementPanel::wxMaracasRenderImageManagementPanel(wxWindow* parent, VolumeRendererManager* _vol, wxMaracasSurfaceRenderingManager* _surface1,
																		 wxMaracasSurfaceRenderingManager* _surface2, wxMaracasSurfaceRenderingManager* _surface3, wxString title, int id)
: wxDialog(parent, -1, title, wxDefaultPosition, wxDefaultSize, wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE)
{
	wxtrasform = new wxMaracasRenderImageTransformation(_vol, _surface1, _surface2, _surface3, id);
	createControls();
}

/**
** 
**/
void wxMaracasRenderImageManagementPanel::createControls()
{
	wxFlexGridSizer* sizersliders = new wxFlexGridSizer(1);
	
	wxStaticText* tx = new wxStaticText(this, -1, wxString(_T("  Translate X  ")));
	sliderTranslateX = new wxSlider(this, -1, 0, -200, 200, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderTranslateX->SetLineSize(1);
	Connect(sliderTranslateX->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(tx, wxFIXED_MINSIZE);
	sizersliders->Add(sliderTranslateX, 1, wxALL|wxEXPAND, 2);

	wxStaticText* ty = new wxStaticText(this, -1, wxString(_T("  Translate Y  ")));
	sliderTranslateY = new wxSlider(this, -1, 0, -200, 200, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderTranslateY->SetLineSize(1);
	Connect(sliderTranslateY->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(ty, wxFIXED_MINSIZE);
	sizersliders->Add(sliderTranslateY, 1, wxALL|wxEXPAND, 2);

	wxStaticText* tz = new wxStaticText(this, -1, wxString(_T("  Translate Z  ")));
	sliderTranslateZ = new wxSlider(this, -1, 0, -200, 200, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderTranslateZ->SetLineSize(1);
	Connect(sliderTranslateZ->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(tz, wxFIXED_MINSIZE);
	sizersliders->Add(sliderTranslateZ,wxSizerFlags().Expand().Center());

	wxStaticText* rx = new wxStaticText(this, -1, wxString(_T("  Rotate X  ")));
	sliderRotateX = new wxSlider(this, -1, 0, -360, 360, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderRotateX->SetLineSize(1);
	Connect(sliderRotateX->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(rx, wxFIXED_MINSIZE);
	sizersliders->Add(sliderRotateX,wxSizerFlags().Expand().Center());

	wxStaticText* ry = new wxStaticText(this, -1, wxString(_T("  Rotate Y  ")));
	sliderRotateY = new wxSlider(this, -1, 0, -360, 360, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderRotateY->SetLineSize(1);
	Connect(sliderRotateY->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(ry, wxFIXED_MINSIZE);
	sizersliders->Add(sliderRotateY,wxSizerFlags().Expand().Center());

	wxStaticText* rz = new wxStaticText(this, -1, wxString(_T("  Rotate Z  ")));
	sliderRotateZ = new wxSlider(this, -1, 0, -360, 360, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderRotateZ->SetLineSize(1);
	Connect(sliderRotateZ->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(rz, wxFIXED_MINSIZE);
	sizersliders->Add(sliderRotateZ,wxSizerFlags().Expand().Center());

	wxStaticText* sx = new wxStaticText(this, -1, wxString(_T("  Scale X  ")));
	sliderScaleX = new wxSlider(this, -1, 100, 1, 200, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderScaleX->SetLineSize(1);
	Connect(sliderScaleX->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(sx, wxFIXED_MINSIZE);
	sizersliders->Add(sliderScaleX,wxSizerFlags().Expand().Center());

	wxStaticText* sy = new wxStaticText(this, -1, wxString(_T("  Scale Y  ")));
	sliderScaleY = new wxSlider(this, -1, 100, 1, 200, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
	sliderScaleY->SetLineSize(1);
	Connect(sliderScaleY->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(sy, wxFIXED_MINSIZE);
	sizersliders->Add(sliderScaleY,wxSizerFlags().Expand().Center());

	wxStaticText* sz = new wxStaticText(this, -1, wxString(_T("  Scale Z  ")));
	sliderScaleZ = new wxSlider(this, -1, 100, 1, 200, wxDefaultPosition, this->GetSize(), wxSL_LABELS);
	sliderScaleZ->SetLineSize(1);
	Connect(sliderScaleZ->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction)&wxMaracasRenderImageManagementPanel::Transform);
	sizersliders->Add(sz, wxFIXED_MINSIZE);
	sizersliders->Add(sliderScaleZ,wxSizerFlags().Expand().Center());
	
	//ATENTION!! A SUPRIMER LES LIGNES ON BAS SI ELES NE SONT PAS NECESSAIRES!!
	
	/*
	//wxString choices[2];
	//choices[0] = wxString(_T("On"));
	//choices[1] = wxString(_T("Off"));
	checkboxSA = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering A")));
	Connect(checkboxSA->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSAChange);	
	checkboxSA->SetValue(true);	

	sizercheck->Add(checkboxSA, wxFIXED_MINSIZE);

	//wxString choices[2];
	//choices[0] = wxString(_T("On"));
	//choices[1] = wxString(_T("Off"));
	checkboxSB = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering B")));
	Connect(checkboxSB->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSBChange);	
	checkboxSB->SetValue(true);	

	sizercheck->Add(checkboxSB, wxFIXED_MINSIZE);

	//wxString choices[2];
	//choices[0] = wxString(_T("On"));
	//choices[1] = wxString(_T("Off"));
	checkboxSC = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering C")));
	Connect(checkboxSC->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSCChange);	
	checkboxSC->SetValue(true);	

	sizercheck->Add(checkboxSC, wxFIXED_MINSIZE);
	sizerrenderprop->Add(sizercheck, wxFIXED_MINSIZE);*/

	this->SetSizer(sizersliders, true);		
	this->SetAutoLayout(true);
}

/**
** Class destructor
**/
wxMaracasRenderImageManagementPanel::~wxMaracasRenderImageManagementPanel()
{	
}

/**
** Transforms a volume by the given value for the X axis
**/
void wxMaracasRenderImageManagementPanel::Transform(wxCommandEvent& event)
{
	//printf("wxMaracasRenderImageManagementPanel::Translate translateX = %d \n", sliderTranslateX->GetValue());
	//printf("wxMaracasRenderImageManagementPanel::Translate translatey = %d \n", sliderTranslateY->GetValue());
	//printf("wxMaracasRenderImageManagementPanel::Translate translatez = %d \n", sliderTranslateZ->GetValue());
	try{
		wxtrasform->Translate( sliderTranslateX->GetValue(), sliderTranslateY->GetValue(), sliderTranslateZ->GetValue(), 
			sliderRotateX->GetValue(), sliderRotateY->GetValue(), sliderRotateZ->GetValue(), 
			sliderScaleX->GetValue(), sliderScaleY->GetValue(), sliderScaleZ->GetValue() );
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
	}
}
