/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <creaWx.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <stdlib.h>
#include <iostream> // for std::cout

#include "wxMaracasRenderImageTransformation.h"
#include "wxMaracasRendererView.h"

/**
** Class constructor
**/
wxMaracasRenderImageTransformation::wxMaracasRenderImageTransformation(VolumeRendererManager* _vol, wxMaracasSurfaceRenderingManager* _surface1,
                                                                       wxMaracasSurfaceRenderingManager* _surface2, wxMaracasSurfaceRenderingManager* _surface3, int id)
{
	vol = _vol;
	surface1 = _surface1;
	surface2 = _surface2;
	surface3 = _surface3;
	
	propID = id;
	transformV = vtkTransform::New();
	transformS1 = vtkTransform::New();
	transformS2 = vtkTransform::New();
	transformS3 = vtkTransform::New();
}

/**
** Class destructor
**/
wxMaracasRenderImageTransformation::~wxMaracasRenderImageTransformation()
{	
	
}

/**
** Transforms a volume by the given value for the X axis
**/
void wxMaracasRenderImageTransformation::Translate(int tx, int ty, int tz, int rx, int ry, int rz, int sx, int sy, int sz)
{
	//printf("wxMaracasRenderImageManagementPanel::Rotate float:scaleX = %f \n", tx);
	//printf("wxMaracasRenderImageManagementPanel::Rotate float:scaleY = %f \n", ty);
	//printf("wxMaracasRenderImageManagementPanel::Rotate float:scaleZ = %f \n", tz);

	double volspX;
	double volspY;
	double volspZ;
	vol->getImageData()->GetSpacing(volspX, volspY, volspZ);
	
	double surfspX;
	double surfspY;
	double surfspZ;
	surface1->getImageData()->GetSpacing(surfspX, surfspY, surfspZ);

	int ext[6];
	vol->getImageData()->GetExtent(ext);

	transformV->Identity();
	transformS1->Identity();
	transformS2->Identity();
	transformS3->Identity();

	transformV->PostMultiply();
	transformS1->PostMultiply();
	transformS2->PostMultiply();
	transformS3->PostMultiply();
	
	printf("CPR: wxMaracasRenderImageTransformation::Translate-> %f\n", -(ext[1]-ext[0])*volspX );
	printf("CPR: wxMaracasRenderImageTransformation::Translate-> %f\n", -(ext[3]-ext[2])*surfspY);
	printf("CPR: wxMaracasRenderImageTransformation::Translate-> %f\n", -(ext[5]-ext[4])*surfspZ);

	transformV ->Translate( -(ext[1]-ext[0])*volspX/2,  -(ext[3]-ext[2])*volspY/2,  -(ext[5]-ext[4])*volspZ/2  );
	transformS1->Translate( -(ext[1]-ext[0])*surfspX/2, -(ext[3]-ext[2])*surfspY/2, -(ext[5]-ext[4])*surfspZ/2 );
	transformS2->Translate( -(ext[1]-ext[0])*surfspX/2, -(ext[3]-ext[2])*surfspY/2, -(ext[5]-ext[4])*surfspZ/2 );
	transformS3->Translate( -(ext[1]-ext[0])*surfspX/2, -(ext[3]-ext[2])*surfspY/2, -(ext[5]-ext[4])*surfspZ/2 );

	transformV ->Scale( (sx/100.0), (sy/100.0), (sz/100.0) );
	transformS1->Scale( (sx/100.0), (sy/100.0), (sz/100.0) );
	transformS2->Scale( (sx/100.0), (sy/100.0), (sz/100.0) );
	transformS3->Scale( (sx/100.0), (sy/100.0), (sz/100.0) );

	transformV ->RotateX( rx );
	transformS1->RotateX( rx );
	transformS2->RotateX( rx );
	transformS3->RotateX( rx );

	transformV ->RotateY( ry );
	transformS1->RotateY( ry );
	transformS2->RotateY( ry );
	transformS3->RotateY( ry );

	transformV ->RotateZ( rz );
	transformS1->RotateZ( rz );
	transformS2->RotateZ( rz );
	transformS3->RotateZ( rz );

	transformV ->Translate( tx*volspX + (ext[1]-ext[0])*volspX/2,  ty*volspY + (ext[3]-ext[2])*volspY/2,  tz*volspZ + (ext[5]-ext[4])*volspZ/2 );
	transformS1->Translate( tx*surfspX + (ext[1]-ext[0])*volspX/2, ty*surfspY + (ext[3]-ext[2])*volspY/2, tz*surfspZ + (ext[5]-ext[4])*volspZ/2 );
	transformS2->Translate( tx*surfspX + (ext[1]-ext[0])*volspX/2, ty*surfspY + (ext[3]-ext[2])*volspY/2, tz*surfspZ + (ext[5]-ext[4])*volspZ/2 );
	transformS3->Translate( tx*surfspX + (ext[1]-ext[0])*volspX/2, ty*surfspY + (ext[3]-ext[2])*volspY/2, tz*surfspZ + (ext[5]-ext[4])*volspZ/2 );

	Refresh();
}

/**
** Updates each Matrix
**/
// EED 2022-08-04	throw
//void wxMaracasRenderImageTransformation::Refresh()throw(char*)
void wxMaracasRenderImageTransformation::Refresh()
{
	try {
		transformV->Update();
		transformS1->Update();
		transformS2->Update();
		transformS3->Update();
		vol->getViewData(propID)->getProp3D()->SetUserMatrix(transformV->GetMatrix());
		//vol->Update(propID);
		surface1->getViewData(propID)->getProp3D()->SetUserMatrix(transformV->GetMatrix());
		//surface1->Update(propID);
		surface2->getViewData(propID)->getProp3D()->SetUserMatrix(transformV->GetMatrix());
		//surface2->getRenderer()->Render();
		surface3->getViewData(propID)->getProp3D()->SetUserMatrix(transformV->GetMatrix());
		//surface3->getRenderer()->Render();
	} catch (...) {
	  throw ;
	}

}
