/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasRenderTabbedPanel.h"

#include "HistogramDialogComboBox.h"
#include "wxMaracasMultipleVolumeRendererPanel.h"
#include "wxMaracasSurfaceRenderingPanel.h"
#include "wxMaracasSurfaceRenderingProp3DMHD.h"
#include "volumerenderermanagerdata.h"
#include "wxMaracasDialog_NViewers.h"
#include "wxVtkMPR3DViewCntrlPanel.h"

#include <wx/colordlg.h>
#include <wx/button.h> 
#include <vtkProp3D.h>
#include <OpenImage.xpm>

#include "Color.xpm"
//#include "creaSystem.h"

#include "creaWx.h"

	BEGIN_EVENT_TABLE( wxMaracasRenderTabbedPanel, wxPanel )
		EVT_MENU( 12121, wxMaracasRenderTabbedPanel::OnRefreshView )
		//EVT_MENU( 12122, wxMaracasRenderTabbedPanel::OnDClickLeft  )
	END_EVENT_TABLE( );

/**
** Class constructor
**/
wxMaracasRenderTabbedPanel::wxMaracasRenderTabbedPanel(wxWindow* parent, int id, wxVtk3DBaseView* _baseView)
  : wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize)
{
	_id = id;
	baseView = _baseView;
	dialog = NULL;

        volmanager =      new VolumeRendererManager();
	surrendmanager1 = new wxMaracasSurfaceRenderingManager();
	surrendmanager2 = new wxMaracasSurfaceRenderingManager();
	surrendmanager3 = new wxMaracasSurfaceRenderingManager();
}

/**
** Class Destructor
**/
wxMaracasRenderTabbedPanel::~wxMaracasRenderTabbedPanel()
{	
	//wxMaracasRenderTabbedPanel::getInstance()->addRemoveActorV(_propid, false);
	//wxMaracasRenderTabbedPanel::getInstance()->addRemoveActorSA(_propid, false);
	//wxMaracasRenderTabbedPanel::getInstance()->addRemoveActorSB(_propid, false);
	//wxMaracasRenderTabbedPanel::getInstance()->addRemoveActorSC(_propid, false);
	addRemoveActorMPR(false);
	if( vtkmpr3Ddataviewer	)   { delete vtkmpr3Ddataviewer; }
	if( mwxvtkmpr3Dview	)   { delete mwxvtkmpr3Dview;    }

	this->deleteVolume(_id);
	delete dialog;
	delete wxtabs;
}

/**
** Initializes rendered images, and creates and adds elements to the panel
**/
void wxMaracasRenderTabbedPanel::createControls(vtkImageData* inImg, std::string pathfile, std::string filename)
{
	wxFlexGridSizer* sizerrenderprop = new wxFlexGridSizer(1);

	wxFlexGridSizer* sizercheck = new wxFlexGridSizer(3);
	checkboxVol = new  wxCheckBox(this,-1,wxString(_T("Volume Rendering")));
	Connect(checkboxVol->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxVChange);	
	checkboxVol->SetValue(false);	
	sizercheck->Add(checkboxVol, wxFIXED_MINSIZE);

	checkboxSA = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering A")));
	Connect(checkboxSA->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSAChange);	
	checkboxSA->SetValue(false);	
	sizercheck->Add(checkboxSA, wxFIXED_MINSIZE);	

	checkboxViewer = new  wxCheckBox(this,-1,wxString(_T("MPR")));
	Connect(checkboxViewer->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onMPROptions);	
	checkboxViewer->SetValue(true);
	sizercheck->Add(checkboxViewer, wxFIXED_MINSIZE);

	checkboxSB = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering B")));
	Connect(checkboxSB->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSBChange);	
	checkboxSB->SetValue(false);	
	sizercheck->Add(checkboxSB, wxFIXED_MINSIZE);

	checkboxSC = new  wxCheckBox(this,-1,wxString(_T("Surface Rendering C")));
	Connect(checkboxSC->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onCheckBoxSCChange);	
	checkboxSC->SetValue(false);	
	sizercheck->Add(checkboxSC, wxFIXED_MINSIZE);
	
	sizercheck->Add(new wxStaticText(this, -1,_T("")), wxFIXED_MINSIZE);

	wxButton* _openParameters = new wxButton(this, -1, wxString(_T("Apply Transformation")));	
	Connect(_openParameters->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onOpenParameters);			
	sizercheck->Add(_openParameters,wxFIXED_MINSIZE);

	wxButton* _openCutter = new wxButton(this, -1, wxString(_T("Open Cutter View")));	
	Connect(_openCutter->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasRenderTabbedPanel::onOpenCutter);			
	sizercheck->Add(_openCutter,wxFIXED_MINSIZE);
	sizerrenderprop->Add(sizercheck, wxFIXED_MINSIZE);

	wxtabs = new wxNotebook(this, -1);

	if(inImg == NULL)
	{
		vtkImageData* img = volmanager->getImageData(pathfile);
		//vtkImageData* img1 = surrendmanager1->getImageData(pathfile);
		//vtkImageData* img2 = surrendmanager2->getImageData(pathfile);
		//vtkImageData* img3 = surrendmanager3->getImageData(pathfile);
		if(img!=NULL /*&& img1!=NULL && img2!=NULL && img3!=NULL*/)
		{
			addVolume(img,   filename);
			addSurface1(img, filename);
			addSurface2(img, filename);
			addSurface3(img, filename);	
			addMPROptions();
			volname = crea::std2wx(filename);
			wxtabs->Refresh();
		}
	}	
	else
	{
		addVolume(inImg, filename);
		addSurface1(inImg, filename);
		addSurface2(inImg, filename);
		addSurface3(inImg, filename);	
		wxtabs->Refresh();
	}

	sizerrenderprop->Add(wxtabs, wxSizerFlags().Expand().Center());

	this->SetSizer(sizerrenderprop, true);		
	this->SetAutoLayout( true );
}


/**
** Sets given renderer
**/
void wxMaracasRenderTabbedPanel::setRenderer(vtkRenderer* renderer)
{
	volmanager->setRenderer(renderer);
	surrendmanager1->setRenderer(renderer);
	surrendmanager2->setRenderer(renderer);
	surrendmanager3->setRenderer(renderer);
}

/**
** Adds a volume using Volume Rendering
**/
void wxMaracasRenderTabbedPanel::addVolume(vtkImageData* img, std::string dataname)
{
	try
	{
		int _propidV = volmanager->addVolume(_id, img, dataname);
		if(_propidV!=-1)
		{
			wxMaracasMultipleVolumeRendererPanel* controlpanV = new wxMaracasMultipleVolumeRendererPanel(wxtabs, _propidV, img, true);
			wxtabs->AddPage(controlpanV, _T("Vol Rendering"), true);
			controlpanV->updateVolume();
			wxtabs->GetPage(0)->Disable();

			volmanager->addRemoveActor(this->getPropIdV(), checkboxSC->GetValue());
		}
	}
	catch(char* str)
	{
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds a volume using surface rendering
**/
void wxMaracasRenderTabbedPanel::addSurface1(vtkImageData* img, std::string dataname)
{
	try
	{
		int _propidSA = surrendmanager1->addPropMHD(_id, img, dataname);
		
		if(_propidSA!=-1)
		{
			wxMaracasSurfaceRenderingPanel* controlpanSA = new wxMaracasSurfaceRenderingProp3DMHD(wxtabs, _propidSA, true, 1);
			int maxiso = surrendmanager1->getMaxIsoValue(_propidSA);
			((wxMaracasSurfaceRenderingProp3DMHD*)controlpanSA)->createControls(maxiso);
			wxtabs->AddPage(controlpanSA, _T("SR A"));
			wxtabs->GetPage(1)->Disable();

			surrendmanager1->addRemoveActor(this->getPropIdV(), checkboxSC->GetValue());
		}
	}
	catch(char* str)
	{
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds a volume using surface rendering
**/
void wxMaracasRenderTabbedPanel::addSurface2(vtkImageData* img, std::string dataname)
{
	try
	{
		int _propidSB = surrendmanager2->addPropMHD(_id, img, dataname);
		if(_propidSB!=-1)
		{
			wxMaracasSurfaceRenderingPanel* controlpanSB = new wxMaracasSurfaceRenderingProp3DMHD(wxtabs, _propidSB, true, 2);
			int maxiso = surrendmanager2->getMaxIsoValue(_propidSB);
			((wxMaracasSurfaceRenderingProp3DMHD*)controlpanSB)->createControls(maxiso);
			wxtabs->AddPage(controlpanSB, _T("SR B"));
			wxtabs->GetPage(2)->Disable();

			surrendmanager2->addRemoveActor(this->getPropIdV(), checkboxSC->GetValue());

		}
	}
	catch(char* str)
	{
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds a volume using Surface Rendering
**/
void wxMaracasRenderTabbedPanel::addSurface3(vtkImageData* img, std::string dataname)
{
	try
	{
		int _propidSC = surrendmanager3->addPropMHD(_id, img, dataname);

		if(_propidSC!=-1)
		{
			wxMaracasSurfaceRenderingPanel* controlpanSC = new wxMaracasSurfaceRenderingProp3DMHD(wxtabs, _propidSC, true, 3);
			int maxiso = surrendmanager3->getMaxIsoValue(_propidSC);
			((wxMaracasSurfaceRenderingProp3DMHD*)controlpanSC)->createControls(maxiso);
			wxtabs->AddPage(controlpanSC, _T("SR C"));
			wxtabs->GetPage(3)->Disable();

			surrendmanager3->addRemoveActor(this->getPropIdV(), checkboxSC->GetValue());
		}
	}
	catch(char* str)
	{
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
**
**/
void wxMaracasRenderTabbedPanel::addMPROptions()
{
	//Panel Construction
	vtkMPRBaseData* mvtkmprbasedata = new vtkMPRBaseData(); 
	marImageData*	marimagedata	= new marImageData( getVolImage() );			
	mvtkmprbasedata					->SetMarImageData(marimagedata);
	
	mwxvtkmpr3Dview					= new wxVtkMPR3DView( baseView );

	vtkmpr3Ddataviewer				= new vtkMPR3DDataViewer(); 	

	wxPanel			*panelControl	= new wxPanel(wxtabs,-1);	
	controlPanelMPR3D				= mwxvtkmpr3Dview->CreateControlPanel(panelControl, true);

	wxFlexGridSizer *sizerCtrol		= new wxFlexGridSizer(1);
	sizerCtrol						->Add(controlPanelMPR3D, 1, wxALL|wxEXPAND, 2);

	panelControl->SetAutoLayout(true);
	panelControl->SetSizer(sizerCtrol);
	panelControl->SetSize(400,350);
	panelControl->Layout();

	//Configure MPR
	int x = 0,y = 0,z = 0;
	int ext[6];
	ext[0] = 0;
	ext[1] = 0;
	ext[2] = 0;
	ext[3] = 0;
	ext[4] = 0;
	ext[5] = 0;

	double org[3],spc[3];
	org[0] = 0;
	org[1] = 0;
	org[2] = 0;
	spc[0] = 0;
	spc[1] = 0;
	spc[2] = 0;

	if (mvtkmprbasedata!=NULL)
	{
		mvtkmprbasedata->Configure();
		/*x = mvtkmprbasedata	->	GetMaxPositionX()/2;
		y = mvtkmprbasedata	->	GetMaxPositionY()/2;
		z = mvtkmprbasedata	->	GetMaxPositionZ()/2;		*/	
		
		if(mvtkmprbasedata->GetImageData() != NULL)
		{
			mvtkmprbasedata->GetImageData()->GetExtent(ext);
			mvtkmprbasedata->GetImageData()->GetOrigin(org);
			mvtkmprbasedata->GetImageData()->GetSpacing(spc);

			x = (ext[0]+ext[1])/2;
			y = (ext[2]+ext[3])/2;
			z = (ext[4]+ext[5])/2;

			mvtkmprbasedata->SetX( x );
			mvtkmprbasedata->SetY( y );
			mvtkmprbasedata->SetZ( z );
		}
		else
		{
			mvtkmprbasedata->SetX( 0 );
			mvtkmprbasedata->SetY( 0 );
			mvtkmprbasedata->SetZ( 0 );
		}
	}

	if (baseView!=NULL)	
	{
		baseView			->Configure();	
	}

	if (vtkmpr3Ddataviewer	!=NULL) 
	{
		vtkmpr3Ddataviewer	->SetVtkMPRBaseData(mvtkmprbasedata);
		vtkmpr3Ddataviewer	->Configure();
	}
	if (mwxvtkmpr3Dview	!=NULL)	
	{ 
		mwxvtkmpr3Dview		->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);		
		mwxvtkmpr3Dview		->Configure();
//EED 27/05/2013
		mwxvtkmpr3Dview		->GetWxvtk3Dbaseview()->ResetCamera(ext	,spc);
		vtkInteractorStyleBaseView* vtkInteractorBV = (vtkInteractorStyleBaseView*)mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetInteractorStyleBaseView();
		vtkInteractorBV->AddParentToReport(this);
	}

	int id = 4;
	wxtabs->AddPage(panelControl, _T("MPR"));
	wxtabs->GetPage(id)->Enable();
	wxtabs->SetSelection(id);

	((wxVtkMPR3DViewCntrlPanel*)controlPanelMPR3D)->SetVisibleZ(true);
	((wxVtkMPR3DViewCntrlPanel*)controlPanelMPR3D)->SetVisibleXYZ(true);
	mwxvtkmpr3Dview->showOutlineBoxActor(true);
	mwxvtkmpr3Dview->Refresh();
			
}

/**
** Deletes complete volume
**/
void wxMaracasRenderTabbedPanel::deleteVolume(int volid)
{
	try
	{
		volmanager->deleteActor(volid);
		surrendmanager1->deleteActor(volid);
		surrendmanager2->deleteActor(volid);
		surrendmanager3->deleteActor(volid);
	}
	catch(char* str)
	{
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds or removes volume rendering actor with given ID
**/
void wxMaracasRenderTabbedPanel::addRemoveActorV(int id, bool addremove)
{
	try{
		volmanager->addRemoveActor(id, addremove);

	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds or removes surface rendering actor with given ID
**/
void wxMaracasRenderTabbedPanel::addRemoveActorSA(int id, bool addremove)
{
	try{
		surrendmanager1->addRemoveActor(id, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds or removes surface rendering actor with given ID
**/
void wxMaracasRenderTabbedPanel::addRemoveActorSB(int id, bool addremove)
{
	try{
		surrendmanager2->addRemoveActor(id, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Adds or removes surface rendering actor with given ID
**/
void wxMaracasRenderTabbedPanel::addRemoveActorSC(int id, bool addremove)
{	
	try{
		surrendmanager3->addRemoveActor(id, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

void wxMaracasRenderTabbedPanel::addRemoveActorMPR(bool addremove)
{
	int id = 4;
	wxtabs->SetSelection(id);
	if(addremove)
	{
		wxtabs->GetPage(id)->Enable();
		bool valueX = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleX();
		bool valueY = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleY();
		bool valueZ = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleZ();
		bool valueXYZ = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleXYZ();
		bool valuePlane = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisiblePlane();
		mwxvtkmpr3Dview->VisibleImageActor( 0, valueX );
		mwxvtkmpr3Dview->VisibleImageActor( 1, valueY );
		mwxvtkmpr3Dview->VisibleImageActor( 2, valueZ );
		mwxvtkmpr3Dview->VisiblePointWidget(valueXYZ);
		mwxvtkmpr3Dview->VisiblePlaneWidget(valuePlane);
		mwxvtkmpr3Dview->showOutlineBoxActor(true);
		mwxvtkmpr3Dview->Refresh();
	} else {
		wxtabs->GetPage(id)->Disable();
		mwxvtkmpr3Dview->VisiblePointWidget(false);
		mwxvtkmpr3Dview->VisiblePlaneWidget(false);
		mwxvtkmpr3Dview->VisibleImageActor(0, false );
		mwxvtkmpr3Dview->VisibleImageActor(1, false );
		mwxvtkmpr3Dview->VisibleImageActor(2, false );
		mwxvtkmpr3Dview->showOutlineBoxActor(false);
		mwxvtkmpr3Dview->Refresh();
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 		mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 		mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
	} // if
}


/**
** Sets color points values for the given volume rendering identified by parameter: volumeid
**/
void wxMaracasRenderTabbedPanel::SetValuesColorPointsFunction(int volid, std::vector<double> greylevelcolors,std::vector<double> red,std::vector<double> green,std::vector<double> blue)
{
	volmanager->setVolumeColor(volid, greylevelcolors, red, green, blue);
}

/**
** Sets points values for the given volume rendering identified by parameter: volumeid
**/
void wxMaracasRenderTabbedPanel::SetValuesPointsFunction(int volid, std::vector<double> greylevel, std::vector<double> values)
{
	try{
		volmanager->setVolumeOpacity(volid, greylevel, values);
	}
	catch(char* str)
	{
		wxString s( str,wxConvUTF8 );
		wxMessageDialog* diag = new wxMessageDialog(this, s, s, wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Returns transfer function for the given volume rendering identified by parameter: volumeid
**/
vtkPiecewiseFunction* wxMaracasRenderTabbedPanel::GetTransferFunction(int volumeid)
{
	return volmanager->GetTransferFunction(volumeid);
}

/**
** Returns color function for the given volume rendering identified by parameter: volumeid
**/
vtkColorTransferFunction* wxMaracasRenderTabbedPanel::GetColorFunction(int volumeid)
{
    return volmanager->GetColorFunction(volumeid);
}

/**
** Changes color function by the given value for the given volume rendering identified by parameter: volumeid
**/
void wxMaracasRenderTabbedPanel::changeOpacityA(int _propid, int value)
{
	surrendmanager1->changeOpacity(_propid,value);
}

/**
** Changes isoValue by the given value for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeIsoValueA(int propid, double value)
{
	surrendmanager1->changeIsoValue(propid, value);
}

/**
** Changes color for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeColorA(int propid, double red, double green, double blue)
{
	try
	{
		surrendmanager1->changeColor(propid, red, green, blue);
	}
	catch(char* str)
	{
		wxString s( str,wxConvUTF8 );
		wxMessageDialog* diag = new wxMessageDialog(this, s, s, wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Changes color function by the given value for the given volume rendering identified by parameter: volumeid
**/
void wxMaracasRenderTabbedPanel::changeOpacityB(int _propid, int value)
{
	surrendmanager2->changeOpacity(_propid,value);
}

/**
** Changes isoValue by the given value for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeIsoValueB(int propid, double value)
{
	surrendmanager2->changeIsoValue(propid, value);
}

/**
** Changes color for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeColorB(int propid, double red, double green, double blue)
{
	try
	{
		surrendmanager2->changeColor(propid, red, green, blue);
	}
	catch(char* str)
	{
		wxString s( str,wxConvUTF8 );
		wxMessageDialog* diag = new wxMessageDialog(this, s, s, wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Changes color function by the given value for the given volume rendering identified by parameter: volumeid
**/
void wxMaracasRenderTabbedPanel::changeOpacityC(int _propid, int value)
{
	surrendmanager3->changeOpacity(_propid,value);
}

/**
** Changes isoValue by the given value for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeIsoValueC(int propid, double value)
{
	surrendmanager3->changeIsoValue(propid, value);
}

/**
** Changes color for the given surface rendering image identified by parameter: propid
**/
void wxMaracasRenderTabbedPanel::changeColorC(int propid, double red, double green, double blue)
{
	try
	{
		surrendmanager3->changeColor(propid, red, green, blue);
	}
	catch(char* str)
	{
		wxString s( str,wxConvUTF8 );
		wxMessageDialog* diag = new wxMessageDialog(this, s, s, wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Method called when VolumeRendering checkbox status changes: Either shows or hides VolumeRendering image
**/
void wxMaracasRenderTabbedPanel::onCheckBoxVChange(wxCommandEvent& event)
{
	try{
		volmanager->addRemoveActor(this->getPropIdV(), checkboxVol->GetValue());

		int id = 0;
		wxtabs->SetSelection(id);

		if(checkboxVol->GetValue())
		{
			wxtabs->GetPage(id)->Enable();
		}
		else
		{	
			wxtabs->GetPage(id)->Disable();
		}
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Method called when SurfaceRendering A checkbox status changes: Either shows or hides SurfaceRendering image
**/
void wxMaracasRenderTabbedPanel::onCheckBoxSAChange(wxCommandEvent& event)
{	
	try{
		surrendmanager1->addRemoveActor(this->getPropIdV(), checkboxSA->GetValue());	

		int id = 1;
		wxtabs->SetSelection(id);

		if(checkboxSA->GetValue())
		{
			wxtabs->GetPage(id)->Enable();

		}
		else
		{	
			wxtabs->GetPage(id)->Disable();
		}
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Method called when SurfaceRendering B checkbox status changes: Either shows or hides SurfaceRendering B image
**/
void wxMaracasRenderTabbedPanel::onCheckBoxSBChange(wxCommandEvent& event)
{	
	try{
		surrendmanager2->addRemoveActor(this->getPropIdV(), checkboxSB->GetValue());	

		int id = 2;
		wxtabs->SetSelection(id);

		if(checkboxSB->GetValue())
		{
			wxtabs->GetPage(id)->Enable();
		} else {	
			wxtabs->GetPage(id)->Disable();
		} // if checkboxSB
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Method called when SurfaceRendering C checkbox status changes: Either shows or hides SurfaceRendering C image
**/
void wxMaracasRenderTabbedPanel::onCheckBoxSCChange(wxCommandEvent& event)
{	
	try{
		surrendmanager3->addRemoveActor(this->getPropIdV(), checkboxSC->GetValue());

		int id = 3;
		wxtabs->SetSelection(id);

		if(checkboxSC->GetValue())
		{
			wxtabs->GetPage(id)->Enable();
		}
		else
		{	
			wxtabs->GetPage(id)->Disable();
		}
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

/**
** Method called when MPR checkbox status changes: Either shows or hides actors
**/
void wxMaracasRenderTabbedPanel::onMPROptions(wxCommandEvent& event)
{
	addRemoveActorMPR(checkboxViewer->IsChecked());
	/*
	int id = 4;
	wxtabs->SetSelection(id);
	if(checkboxViewer->IsChecked())
	{
		
		wxtabs->GetPage(id)->Enable();

		bool valueX = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleX();
		bool valueY = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleY();
		bool valueZ = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleZ();
		bool valueXYZ = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisibleXYZ();
		bool valuePlane = ((wxVtkMPR3DViewCntrlPanel*) controlPanelMPR3D)->GetVisiblePlane();

		mwxvtkmpr3Dview->VisibleImageActor( 0, valueX );
		mwxvtkmpr3Dview->VisibleImageActor( 1, valueY );
		mwxvtkmpr3Dview->VisibleImageActor( 2, valueZ );
		mwxvtkmpr3Dview->VisiblePointWidget(valueXYZ);
		mwxvtkmpr3Dview->VisiblePlaneWidget(valuePlane);
		mwxvtkmpr3Dview->showOutlineActor(true);
		
		mwxvtkmpr3Dview->Refresh();


	}
	else
	{
		wxtabs->GetPage(id)->Disable();

		mwxvtkmpr3Dview->VisiblePointWidget(false);
		mwxvtkmpr3Dview->VisiblePlaneWidget(false);
		mwxvtkmpr3Dview->VisibleImageActor(0, false );
		mwxvtkmpr3Dview->VisibleImageActor(1, false );
		mwxvtkmpr3Dview->VisibleImageActor(2, false );
		mwxvtkmpr3Dview->showOutlineActor(false);
		mwxvtkmpr3Dview->Refresh();

		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
 		mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
	}*/
}


void wxMaracasRenderTabbedPanel::OnRefreshView(wxCommandEvent & event) 
{
	printf("CPR wxMaracasRenderTabbedPanel::OnRefreshView \n");
	mwxvtkmpr3Dview->RefreshView();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	mwxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

/**
** 
**/
void wxMaracasRenderTabbedPanel::onOpenParameters(wxCommandEvent& event){	
	if(dialog == NULL)
	{
		dialog = new wxMaracasRenderImageManagementPanel(this, volmanager, surrendmanager1, surrendmanager2, surrendmanager3, volname, _id);
		dialog->SetSize(460, 580);
		dialog->Show();
	}
	else if(dialog != NULL)
	{
		dialog->Show();
	}
}

/**
**
**/
void wxMaracasRenderTabbedPanel::onOpenCutter(wxCommandEvent& event)
{	
	vtkImageData* img = getVolImage();	
	std::vector<int> type;
	type.push_back(5);
	type.push_back(1);
	type.push_back(2);
	type.push_back(0);
	
	wxMaracasDialog_NViewers* dialog1 = new wxMaracasDialog_NViewers(this, img, &type, wxString(_T("Cut Module") ));
	//dialog1->SetSize(800, 700);
	
	/**std::string path = crea::System::GetDllAppPath("bbcreaMaracasVisu.dll");
	cutter = CutModelMainPanel::getInstance(dialog1->getinternalPanel(), path);
	cutter->setRenderer( dialog1->getViewer()->GetwxVtkBaseView(1)->GetRenderer() );
	cutter->setInteractor( dialog1->getViewer()->GetwxVtkBaseView(1)->GetWxVTKRenderWindowInteractor() );
	cutter->setImageData(getVolImage());
	**/
	//dialog1->AddPanel(cutter);
	dialog1->Show();
}

/**
** Gets volume rendering image asociated to the given ID
**/
void wxMaracasRenderTabbedPanel::onColorChange(wxCommandEvent& event)
{	
	/*Temporarily disabled*/

	//if(mwxwidget->ShowModal()==wxID_OK){
        //updateVolume();
	//	mwxwidget->Show(false);
	//}	
}

/**
** 
**/
vtkImageData* wxMaracasRenderTabbedPanel::getVolImage()
{	
	return volmanager->getImageData();
}

/**
** Gets surface rendering A image asociated to the given ID
**/
vtkImageData* wxMaracasRenderTabbedPanel::getSurfAImage()
{	
	return surrendmanager1->getImageData();
}

/**
** Gets surface rendering B image asociated to the given ID
**/
vtkImageData* wxMaracasRenderTabbedPanel::getSurfBImage()
{	
	return surrendmanager2->getImageData();
}

/**
** Gets surface rendering C image asociated to the given ID
**/
vtkImageData* wxMaracasRenderTabbedPanel::getSurfCImage()
{	
	return surrendmanager3->getImageData();
}

/**
**
**/
int wxMaracasRenderTabbedPanel::getPropIdV()
{
	return _id;
}
