/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasRendererView.cxx,v $
  Language:  C++

=========================================================================*/

#include <wx/config.h>
#include <creaWx.h>
#include <wx/tooltip.h>

#include "wxMaracasRendererView.h"

#include <wx/colordlg.h>
#include <wx/bmpbuttn.h>

#include <OpenImage.xpm>
#include <Color.xpm>

wxMaracasRendererView* wxMaracasRendererView::instance=NULL;

/**
** Class constructor
**/
wxMaracasRendererView::wxMaracasRendererView(wxWindow* parent,std::string path)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){

	wxauimanager = new wxAuiManager(this);

	_idCount = 0;
	_path = path;

	std::string iconsdir = path;
	iconsdir+="/data/Icons";
	this->_toolb = new ToolBarRenderer(this,iconsdir);
	wxStaticText* txt = new wxStaticText(this, -1, wxString(_T("  Open File  ")));
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(txt,paneinfo.ToolbarPane().Top());
	wxauimanager->AddPane(_toolb,paneinfo.ToolbarPane().Top());

	wxauimanager->Update();	
}

/**
** Class destructor
**/
wxMaracasRendererView::~wxMaracasRendererView( )
{
	delete _toolb;
}

/**
** Gets class instance correponding to given parameters
**/
wxMaracasRendererView* wxMaracasRendererView::getInstance(wxWindow* parent,std::string path)
{
	if(instance==NULL)
	{
		instance = new wxMaracasRendererView(parent,path);
	}
	return instance;
}

/**
** Gets class intance
**/
wxMaracasRendererView* wxMaracasRendererView::getInstance()
{
	return instance;
}

/**
** Gets path for the given panel
**/
std::string wxMaracasRendererView::getPath()
{
	return _path;
}

/**
** Returns internal panel
**/
// EED 2022-08-04	throw
//wxMaracasRenderTabbedPanel* wxMaracasRendererView::getTabbedPanel(int id) throw(char*)
wxMaracasRenderTabbedPanel* wxMaracasRendererView::getTabbedPanel(int id) 
{
	try {
		int i;
		for(i = 0; i < (int)tabsVector.size(); i++)
		{
			if(tabsVector[i]->getPropIdV() == id)
				return tabsVector[i];
		}
		throw "id not found";
		return NULL;
	} catch (...) {
	  throw ;
	}
}

/**
**
**/
void wxMaracasRendererView::setRenderer(vtkRenderer* renderer)
{
	_renderer = renderer;
}

void wxMaracasRendererView::setVtkBaseView(wxVtk3DBaseView* vbv)
{
	baseView = vbv;
}

/**
** Called when an image file is opened
**/
void wxMaracasRendererView::onLoadImageFile()
{
	wxString mhd(_T("mhd"));	

	wxFileDialog* fildial = new wxFileDialog(this, wxString(_T("Select a MHD file")), wxString(_T("")),
					wxString(_T("")), wxString(_T("MHD files (*.mhd)|*.mhd")) );

	if(fildial->ShowModal()==wxID_OK)
	{
        	wxString filename = fildial->GetFilename();
		files.push_back( std::string(filename.mb_str()) );
		wxString pathfile(fildial->GetDirectory() + _T("/") + filename);

		if(filename.EndsWith(mhd))
		{
			std::string sPath = std::string(pathfile.mb_str());
			std::string sFileName = std::string(filename.mb_str());
			printf("wxMaracasRendererView::onLoadImageFile->Opening file... \n");
			addVolumes(NULL, sPath, sFileName);
		}
	}
	delete fildial;
}
/**
** Constructs and adds internal panel
**/
void wxMaracasRendererView::addPanels(wxMaracasRenderTabbedPanel* wxtabs, vtkImageData* img, std::string pathfile, std::string filename)
{
	wxString s(filename.c_str(),wxConvUTF8);
	
	wxtabs->createControls(img, pathfile, filename);
	
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(wxtabs, paneinfo.DefaultPane().Centre().DestroyOnClose().Caption(s));
	wxauimanager->Update();
}

/**
** Returns internal panel
**/
void wxMaracasRendererView::addVolumes(vtkImageData* img, std::string pathfile, std::string filename)
{
	wxMaracasRenderTabbedPanel* wxtabs = new wxMaracasRenderTabbedPanel(this, _idCount, baseView);
	wxtabs->setRenderer(_renderer);

	tabsVector.push_back(wxtabs);
	addPanels(wxtabs, img, pathfile, filename);	

	_idCount++;
}
/**
** Deletes current volume
**/
void wxMaracasRendererView::deleteVolume(int volid)
{
	
	getTabbedPanel(volid)->deleteVolume(volid);
}

/**
** Gets opened file names
**/
std::vector<std::string> wxMaracasRendererView::getFiles()
{
	return files;
}

/**
**
**/
ToolBarRenderer::ToolBarRenderer(wxWindow * parent,std::string iconsdir)
: wxToolBar(parent, -1, wxDefaultPosition, wxDefaultSize)
{
	std::string iconfil = iconsdir;

	//iconfil+= "/OpenImage.png";
	//wxBitmap* bitmap0 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	wxBitmap bitmap0(OpenImage_xpm);
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	this->AddTool(1, wxString(_T("test")),bitmap0, NULL, wxITEM_NORMAL, wxString(_T("Open File")));
#else
	this->AddTool(1, wxString(_T("test")),bitmap0, wxString(_T("Open File")), wxITEM_NORMAL );
#endif



	this->Realize();

	_evthand = new ToolBarEventHandlerRenderer();
	this->SetEventHandler(_evthand);

}

ToolBarRenderer::~ToolBarRenderer(void){
}

ToolBarEventHandlerRenderer::ToolBarEventHandlerRenderer()
: wxEvtHandler(){
}
ToolBarEventHandlerRenderer::~ToolBarEventHandlerRenderer(){
}

void ToolBarEventHandlerRenderer::onLoadImageFile(wxCommandEvent& event){
	wxMaracasRendererView::getInstance()->onLoadImageFile();
}


BEGIN_EVENT_TABLE(ToolBarEventHandlerRenderer, wxEvtHandler)
	EVT_MENU(1, ToolBarEventHandlerRenderer::onLoadImageFile)
END_EVENT_TABLE()


