/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasRendererView.h,v $
  Language:  C++

=========================================================================*/

#ifndef __wxMaracasRendererViewPanelH__
#define __wxMaracasRendererViewPanelH__

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "wx/aui/aui.h"

#include <vector>
#include <iostream>
#include "marTypes.h"
#include "vtkProp3D.h"
#include "wxVtkBaseView.h"

#include "wxMaracasRendererView.h"
#include "wxMaracasRenderTabbedPanel.h"
#include "volumerenderermanager.h"
#include "wxMaracasSurfaceRenderingManager.h"

class  creaMaracasVisu_EXPORT  wxMaracasRendererView : public wxPanel
{

public:
	wxMaracasRendererView( wxWindow* parent, std::string path);
        ~wxMaracasRendererView( );

	static wxMaracasRendererView* getInstance(wxWindow* parent,std::string path="");
	static wxMaracasRendererView* getInstance();

	std::string getPath();
	
// EED 2022-08-04	
//	wxMaracasRenderTabbedPanel* getTabbedPanel(int id) throw(char*);
	wxMaracasRenderTabbedPanel* getTabbedPanel(int id);

	void setRenderer(vtkRenderer*  renderer); /* throw(char*), */   // JPR
	void setVtkBaseView(wxVtk3DBaseView* base);
	void onLoadImageFile();
	void addVolumes(vtkImageData* img, std::string pathfile, std::string filename);
	void addPanels(wxMaracasRenderTabbedPanel* wxtabs, vtkImageData* img, std::string pathfile, std::string filename);

	void deleteVolume(int volid);
	std::vector<std::string> getFiles();

private:
	static wxMaracasRendererView* instance;

	std::vector<wxMaracasRenderTabbedPanel*> tabsVector;
	std::vector<std::string> files;

	wxAuiManager* wxauimanager;
	wxToolBar * _toolb;

	vtkRenderer*  _renderer;
	wxVtk3DBaseView* baseView;
	std::string _path;

	int _idCount;
};

class ToolBarEventHandlerRenderer : public wxEvtHandler
{
	public:
		ToolBarEventHandlerRenderer();
		~ToolBarEventHandlerRenderer();

		void onLoadImageFile(wxCommandEvent& event);

	private:

		DECLARE_EVENT_TABLE()
	};

class ToolBarRenderer : public wxToolBar{

public:
	ToolBarRenderer(wxWindow * parent,std::string iconsdir);
	~ToolBarRenderer(void);

private:

	ToolBarEventHandlerRenderer* _evthand;
};

#endif
