/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSuperposition.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.6 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasSuperposition.h"
#include "creaWx.h"
#include "vtkMetaImageReader.h"
#include "wx/artprov.h"



wxMaracasSuperposition* wxMaracasSuperposition::instance=NULL;

wxMaracasSuperposition::wxMaracasSuperposition( wxWindow* parent, std::vector<vtkImageData*> imgs): wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize)
{	
	m_mgr.SetManagedWindow(this);
	
	_superposition1 = NULL;
	_superposition2 = NULL;
	_superposition3 = NULL;	
	
	_images = imgs;
	
	// set up default notebook style
	m_notebook_style =wxAUI_NB_TAB_SPLIT | wxAUI_NB_TAB_EXTERNAL_MOVE | wxNO_BORDER;
	m_notebook_theme = 0;
	_notebook = this->createNotebook();
	
	createPanels();
	configurePanels();
}

wxMaracasSuperposition::~wxMaracasSuperposition()
{
	_notebook->Destroy();
	instance = NULL;
	m_mgr.UnInit();
}

wxMaracasSuperposition* wxMaracasSuperposition :: getInstance ( wxWindow* parent, std::vector<vtkImageData*> imgs)
{
		if(instance == NULL)
		{
			instance = new wxMaracasSuperposition(parent, imgs);
		}
		return instance;
}
	
wxMaracasSuperposition* wxMaracasSuperposition :: getInstance()
{
	return instance;
}

//------------------------------------------------------------------------------------------------------------
// Creational and initialization methods using WxAui
//------------------------------------------------------------------------------------------------------------

wxAuiNotebook * wxMaracasSuperposition :: createNotebook()
{
	wxSize client_size = GetClientSize();
	wxAuiNotebook* noteBook = new wxAuiNotebook(this, -1, wxPoint(client_size.x, client_size.y), wxSize(430,200), m_notebook_style);
	wxBitmap page_bmp = wxArtProvider::GetBitmap(wxART_NORMAL_FILE, wxART_OTHER, wxSize(16,16));

	return noteBook;
}

void wxMaracasSuperposition :: configurePanels()
{
	if( _superposition1!=NULL )
	{
		_notebook->AddPage( _superposition1, wxT("       Superoposition 1       ") );		
		m_mgr.Update();
	}

	if( _superposition2!=NULL )
	{
		_notebook->AddPage( _superposition2, wxT("       Superoposition 2       ") );
		m_mgr.Update();
	}
	
	if( _superposition3!=NULL )
	{
		_notebook->AddPage( _superposition3, wxT("       Superoposition 3       ") );
		m_mgr.Update();
	}
	

	m_mgr.AddPane(_notebook, wxAuiPaneInfo().Name(wxT("notebook_content")).CenterPane().PaneBorder(false));
	m_mgr.Update();
 
	SetMinSize(wxSize(300,300));
	m_mgr.Update();
}

void wxMaracasSuperposition :: createPanels()
{
	if( _superposition1==NULL )
	{
		_superposition1 = new wxMaracasSuperpositionPanel ( _images, 1, _notebook );
	}
	
	else if( _superposition1!=NULL )
	{
		
	}

	if( _superposition2==NULL )
	{
		_superposition2 = new wxMaracasSuperpositionPanel ( _images, 2, _notebook );
	}
	
	else if( _superposition2!=NULL )
	{
		
	}
	
	if( _superposition3==NULL )
	{
		_superposition3 = new wxMaracasSuperpositionPanel ( _images, 3, _notebook );
	}
	
	else if( _superposition3!=NULL )
	{
		
	}	
}


void wxMaracasSuperposition :: changeImages(std::vector<vtkImageData*> imgs)
{
	_images = imgs;
	
	createPanels();
	configurePanels();
}

std::vector<vtkImageData*> wxMaracasSuperposition :: getImages( )
{
		return _images;
}	
