/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxMaracasSuperpositionPanel.h"

//----------------------------------------------------------------------------------------------------------------
// Other includes
//----------------------------------------------------------------------------------------------------------------
	
	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	wxMaracasSuperpositionPanel :: wxMaracasSuperpositionPanel ( std::vector<vtkImageData*> imgs, int type, wxWindow *parent, const wxPoint& pos, const wxSize& size,long style, int vertStart, int vertEnd, int horzStart, int horzEnd )	
	:wxPanel(parent, -1, pos, size, style)		
	{				
		_images = imgs;
		_type = type;
		int gapH = 20;
		int gapV = 10;
		createSuperpositionPanel();

		outSizer = new wxFlexGridSizer(1, 1, gapH, gapV);
		outSizer -> AddGrowableCol(0);
		outSizer -> AddGrowableRow(0);
		outSizer->Add( theViewPanel, 1, wxGROW);
								
		this->SetSizer( outSizer );
		this->SetAutoLayout( true );
		this->Layout();
	}
	

	wxMaracasSuperpositionPanel :: ~wxMaracasSuperpositionPanel()
	{

	}

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	
	void wxMaracasSuperpositionPanel :: createSuperpositionPanel()
	{		

		std::vector<int> * numViews = new std::vector<int> ();
		numViews->push_back(0);
		
		if (_type==1 || _type==3)
		{
			theViewPanel = new wxMaracas_N_ViewersWidget( this, _images[0], numViews );			
		}
		else if (_type==2)
		{
			theViewPanel = new wxMaracas_N_ViewersWidget( this, _images[1], numViews );						
		}
		
		SetVisibleAxis(false);

		theViewPanel->SetBackgroundColour(wxColour(0,0,0));

		theViewPanel->SetSize(800, 900);
		theViewPanel->GetWindow(1)->SetSize(800, 900);	
	}

	//------------------------------------------------------------------------------------------------------------

	wxVtkBaseView* wxMaracasSuperpositionPanel :: GetWxVtkBaseView()
	{
		return theViewPanel->GetwxVtkBaseView(1);
	}


	wxVtkMPR2DView * wxMaracasSuperpositionPanel::GetwxVtkMPR2DView() 
	{
		return (wxVtkMPR2DView *) (theViewPanel->GetwxVtkBaseView(1));
	}

	vtkImageData * wxMaracasSuperpositionPanel::GetshowingVID() 
	{
		return _images[0];
	}

	int wxMaracasSuperpositionPanel::GetImageDataSizeZ()
	{
		int ext[6];
		GetshowingVID()->GetExtent(ext);
		int sizeZ = ext[5]-ext[4]+1;

		return sizeZ;
	}

	void wxMaracasSuperpositionPanel :: RefreshInterface()
	{
		GetWxVtkBaseView()->Refresh();
	}

	void wxMaracasSuperpositionPanel :: ChangeImage(vtkImageData* img)
	{
		theViewPanel->SetImage(img);
	}
	
	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void wxMaracasSuperpositionPanel::SetVisibleAxis(bool ok)
	{
		GetwxVtkMPR2DView()->SetVisibleAxis(ok);
	}

	//------------------------------------------------------------------------------------------------------------
	int wxMaracasSuperpositionPanel::GetX()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetX();
	}
	//------------------------------------------------------------------------------------------------------------
	int wxMaracasSuperpositionPanel::GetY()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetY();
	}
	//------------------------------------------------------------------------------------------------------------
	int wxMaracasSuperpositionPanel::GetZ()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetZ();
	}

	//------------------------------------------------------------------------------------------------------------
	void wxMaracasSuperpositionPanel::Refresh()
	{
		GetwxVtkMPR2DView()->GetRenWin()->Render();
	}
	
