/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_N_ViewersWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.24 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

//------------------------------------------------------------------------------------------------------------
// Definition includes
//------------------------------------------------------------------------------------------------------------
#include "wxMaracas_N_ViewersWidget.h"

//------------------------------------------------------------------------------------------------------------
// Other includes
//------------------------------------------------------------------------------------------------------------


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------


	BEGIN_EVENT_TABLE( wxMaracas_N_ViewersWidget, wxPanel )
		EVT_MENU( 12121, wxMaracas_N_ViewersWidget::OnRefreshView )
		EVT_MENU( 12122, wxMaracas_N_ViewersWidget::OnDClickLeft  )
	END_EVENT_TABLE( );


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------



	wxMaracas_N_ViewersWidget::wxMaracas_N_ViewersWidget(wxWindow *parent, vtkImageData* imagedata, std::vector<int> *nTypeView)
		: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
	{
		wxwindow1		= NULL;
		wxwindow2		= NULL;
		wxwindow3		= NULL;
		wxwindow4		= NULL;
		_currentwxw		= NULL;
		mvtkmprbasedata = NULL;
		wxSizer *sizer	= new wxBoxSizer(wxVERTICAL);
		this->SetSizer(sizer);
		this->SetAutoLayout(true);
		if(imagedata!=NULL && nTypeView!=NULL )
		{
			this->SetType(nTypeView);
			this->UpdateLayout(imagedata);
		}
	}
	/**
	*	@pre A wxWindow* object must be provided as a parent for the viewer and the type of layout for the viewer
	*	@post The layout of the viewer is initialized, if no image is provided at first, a default image is
	*		used
	*	@param wxWindow* parent of the window
	*	@param std::vector<int>* vector of the type for the viewer
	*	@param vtkImageData* imagedata of the viewer
	*/
	wxMaracas_N_ViewersWidget::wxMaracas_N_ViewersWidget(wxWindow *parent, std::vector<int> *nTypeView, vtkImageData* imagedata)
	: wxPanel( parent, -1){
		wxwindow1		= NULL;
		wxwindow2		= NULL;
		wxwindow3		= NULL;
		wxwindow4		= NULL;
		_currentwxw		= NULL;
		mvtkmprbasedata = NULL;

		wxSizer *sizer	= new wxBoxSizer(wxVERTICAL);
		this->SetSizer(sizer);
		this->SetAutoLayout(true);

		this->SetType(nTypeView);

		/*if(imagedata==NULL){
			double spc[3];
			spc[0] = 1;
			spc[1] = 1;
			spc[2] = 1;
			int extent[6];
			extent[0] = 0;
			extent[1] = 1;
			extent[2] = 0;
			extent[3] = 1;
			extent[4] = 0;
			extent[5] = 0;

			imagedata = vtkImageData::New();
			imagedata->SetSpacing(spc);
			imagedata->SetExtent(extent);
			imagedata->SetScalarTypeToUnsignedChar();
			imagedata->AllocateScalars();
		}*/

		this->UpdateLayout(imagedata);
	}
	//-------------------------------------------------------------------------

	wxMaracas_N_ViewersWidget::~wxMaracas_N_ViewersWidget()
	{
		if (mvtkmprbasedata!=NULL)
		{
			delete mvtkmprbasedata;
		}

	}
	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------


	//-------------------------------------------------------------------------

	void wxMaracas_N_ViewersWidget::Update()
	{
		//wxvtkrenderwindowinteractor->Render();
	//    wxvtkrenderwindowinteractor->Refresh();
	//    Refresh();
	}

	//-------------------------------------------------------------------------

	void wxMaracas_N_ViewersWidget::OnRefreshView(wxCommandEvent & event)
	{
		RefreshView();
	}
	//----------------------------------------------------------------------------
	void wxMaracas_N_ViewersWidget::OnDClickLeft(wxCommandEvent & event)
	{
		RefreshView();
	}

		//-------------------------------------------------------------------------

	vtkRenderer *wxMaracas_N_ViewersWidget::GetRenderer()
	{
		return NULL; //renderer;
	}

	void wxMaracas_N_ViewersWidget::RefreshView()
	{
		if (wxwindow1!=NULL) {wxwindow1->RefreshView(); }
		if (wxwindow2!=NULL) {wxwindow2->RefreshView(); }
		if (wxwindow3!=NULL) {wxwindow3->RefreshView(); }
		if (wxwindow4!=NULL) {wxwindow4->RefreshView(); }
	}

	//-------------------------------------------------------------------------
	wxMaracas_ViewerWidget *wxMaracas_N_ViewersWidget::GetWindow(int iWin)
	{
		wxMaracas_ViewerWidget *tmpWin=NULL;
		if  (iWin==1)
		{
			tmpWin=wxwindow1;
		}
		if  (iWin==2)
		{
			tmpWin=wxwindow2;
		}
		if  (iWin==3)
		{
			tmpWin=wxwindow3;
		}
		if  (iWin==4)
		{
			tmpWin=wxwindow4;
		}
		return tmpWin;
	}

	//-------------------------------------------------------------------------
	wxVtkBaseView *wxMaracas_N_ViewersWidget::GetwxVtkBaseView(int iWin)
	{
		wxVtkBaseView *wxvtkbaseview=NULL;
		wxMaracas_ViewerWidget *tmpWin=GetWindow(iWin);
		if (tmpWin!=NULL){  wxvtkbaseview = tmpWin->GetwxVtkBaseView();  }
		return wxvtkbaseview;
	}

	//-------------------------------------------------------------------------
	void wxMaracas_N_ViewersWidget::Refresh(bool eraseBackground, const wxRect* rect )
	{
		wxPanel::Refresh(false);
	}

	//-------------------------------------------------------------------------
	void wxMaracas_N_ViewersWidget::UpdateLayout(vtkImageData* imagedata)
	{
		wxWindow				*wxwindow	= NULL;
		wxSizer *sizer						= this->GetSizer();

		if (mvtkmprbasedata!=NULL)
		{
			delete mvtkmprbasedata;
		}

		marImageData	*marimagedata	= new marImageData( imagedata );
		mvtkmprbasedata					= new vtkMPRBaseData();
		mvtkmprbasedata->SetMarImageData(marimagedata);

		if(_currentwxw != NULL){
			_currentwxw->Show(false);
			delete _currentwxw;
			//sizer->Remove(currentwxwindow);
			//delete currentwxwindow;
		}

		//std::cout<<"size "<<nTypeView->size()<<std::endl;
		if (nTypeView->size()==1)
		{
			wxwindow1 = new wxMaracas_ViewerWidget(this, imagedata, (*nTypeView)[0], mvtkmprbasedata, nTDxWindow==0 );
			wxwindow = wxwindow1;
		}else	if (nTypeView->size()==2)	{
			wxSplitterWindow	*spliter	= new wxSplitterWindow( this , -1);
			spliter->SetMinimumPaneSize(1);
			//RaC Nov2012 Correctly resize internal panels with the window resize event
			spliter->SetSashGravity(0.5);
 			wxwindow1 = new wxMaracas_ViewerWidget(spliter, imagedata, (*nTypeView)[0], mvtkmprbasedata,nTDxWindow==0);
 			wxwindow2 = new wxMaracas_ViewerWidget(spliter, imagedata, (*nTypeView)[1], mvtkmprbasedata,nTDxWindow==1);
			spliter	-> SplitHorizontally( wxwindow1 , wxwindow2  );
			wxwindow = spliter;
		}else if (nTypeView->size()==3)
		{
			wxSplitterWindow	*spliter	= new wxSplitterWindow( this , -1);
			wxSplitterWindow	*spliterA	= new wxSplitterWindow( spliter , -1);
			spliter->SetMinimumPaneSize(1);
			spliterA->SetMinimumPaneSize(1);
			//RaC Nov2012 Correctly resize internal panels with the window resize event
			spliter->SetSashGravity(0.5);
			spliterA->SetSashGravity(0.5);
 			wxwindow1 = new wxMaracas_ViewerWidget(spliter , imagedata, (*nTypeView)[0], mvtkmprbasedata,nTDxWindow==0);
 			wxwindow2 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[1], mvtkmprbasedata,nTDxWindow==1);
 			wxwindow3 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[2], mvtkmprbasedata,nTDxWindow==2);
			spliter	-> SplitVertically( wxwindow1 , spliterA   );
			spliterA-> SplitHorizontally( wxwindow2 , wxwindow3  );
			wxwindow = spliter;
		}else if (nTypeView->size()>=4){
			wxSplitterWindow	*spliter	= new wxSplitterWindow( this , -1);
			wxSplitterWindow	*spliterA	= new wxSplitterWindow( spliter , -1);
			wxSplitterWindow	*spliterB	= new wxSplitterWindow( spliter , -1);
			spliter->SetMinimumPaneSize(1);
			spliterA->SetMinimumPaneSize(1);
			spliterB->SetMinimumPaneSize(1);
			//RaC Nov2012 Correctly resize internal panels with the window resize event
			spliter->SetSashGravity(0.5);
			spliterA->SetSashGravity(0.5);
			spliterB->SetSashGravity(0.5);

			spliter	-> SplitVertically( spliterA , spliterB   );
			
			
//EED 21 mars 2012  FLIP probleme  ..PLOP..			
// 			wxwindow1 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[0], mvtkmprbasedata);
// 			wxwindow2 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[1], mvtkmprbasedata);
// 			wxwindow3 = new wxMaracas_ViewerWidget(spliterB, imagedata, (*nTypeView)[2], mvtkmprbasedata);
// 			wxwindow4 = new wxMaracas_ViewerWidget(spliterB, imagedata, (*nTypeView)[3], mvtkmprbasedata);
//			spliterA-> SplitHorizontally( wxwindow1 , wxwindow2  );
//			spliterB-> SplitHorizontally( wxwindow3 , wxwindow4  );
			
			wxwindow1 = new wxMaracas_ViewerWidget(spliterB, imagedata, (*nTypeView)[0], mvtkmprbasedata,nTDxWindow==0);
			wxwindow2 = new wxMaracas_ViewerWidget(spliterB, imagedata, (*nTypeView)[1], mvtkmprbasedata,nTDxWindow==1);
			wxwindow3 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[2], mvtkmprbasedata,nTDxWindow==2);
			wxwindow4 = new wxMaracas_ViewerWidget(spliterA, imagedata, (*nTypeView)[3], mvtkmprbasedata,nTDxWindow==3);
			spliterA-> SplitHorizontally( wxwindow3 , wxwindow4  );
			spliterB-> SplitHorizontally( wxwindow2 , wxwindow1  );
			
			wxwindow = spliter;
		}


		//panel->SetDimension()
		sizer->Add( wxwindow , 1, wxGROW);
		sizer->Layout();
		//_currentwxw = wxwindow;
		//_currentwxw->Show(true);

		//this->Layout();
		//this->Refresh();

// I don't undestand how this works and not the opposite ...
		if (wxwindow4!=NULL) {wxwindow4->ConfigureVTK(); }
		if (wxwindow3!=NULL) {wxwindow3->ConfigureVTK(); }
		if (wxwindow2!=NULL) {wxwindow2->ConfigureVTK(); }
		if (wxwindow1!=NULL) {wxwindow1->ConfigureVTK(); }
 }


//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget::SetType(std::vector<int>* type)
{
	 nTypeView = type;
}

//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget::SetTDxWindow(int tdxwindow)
{
     nTDxWindow = tdxwindow;
}



//-----------------------------------------------------------------------------------
 void wxMaracas_N_ViewersWidget::SetImage( vtkImageData *image	)
 {
	 if (wxwindow1!=NULL) { wxwindow1->SetImage(image); }
	 if (wxwindow2!=NULL) { wxwindow2->SetImage(image); }
	 if (wxwindow3!=NULL) { wxwindow3->SetImage(image); }
	 if (wxwindow4!=NULL) { wxwindow4->SetImage(image); }
//	 ConfigureVTK();
 }


//-----------------------------------------------------------------------------------
 void wxMaracas_N_ViewersWidget::ConfigureVTK()
 {
	 if (wxwindow1!=NULL) { wxwindow1->ConfigureVTK(); }
	 if (wxwindow2!=NULL) { wxwindow2->ConfigureVTK(); }
	 if (wxwindow3!=NULL) { wxwindow3->ConfigureVTK(); }
	 if (wxwindow4!=NULL) { wxwindow4->ConfigureVTK(); }
 }

//-----------------------------------------------------------------------------------
double wxMaracas_N_ViewersWidget :: GetX()
{
	invariant();
	return mvtkmprbasedata->GetX();
//	return wxwindow1->GetX();
}

//-----------------------------------------------------------------------------------
double wxMaracas_N_ViewersWidget :: GetY()
{
	invariant();
	return mvtkmprbasedata->GetY();
//	return wxwindow1->GetY();
}


//-----------------------------------------------------------------------------------
double wxMaracas_N_ViewersWidget :: GetZ()
{
	invariant();
	return mvtkmprbasedata->GetZ();
//	return wxwindow1->GetZ();
}

//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget :: invariant()
{
	if(mvtkmprbasedata == 0)
	{
		throw "The image has not been set in the viewer";
	}
}

//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget::setColorTransferFunction(vtkColorTransferFunction* colortable)
{
    if (wxwindow1!=NULL) 
	{
		wxwindow1->setColorTransferFunction(colortable);
	}
	
	if (wxwindow2!=NULL) 
	{
		wxwindow2->setColorTransferFunction(colortable);
	}
	
	if (wxwindow3!=NULL) 
	{
		wxwindow3->setColorTransferFunction(colortable);
	}
	
	if (wxwindow4!=NULL) 
	{
		wxwindow4->setColorTransferFunction(colortable);
	}
}

//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget::SetColorWindowLevel(double colorWindow, double colorLevel)
{
	if (wxwindow1!=NULL) 
	{
		wxwindow1->SetColorWindowLevel(colorWindow, colorLevel);
	}
	
	if (wxwindow2!=NULL) 
	{
		wxwindow2->SetColorWindowLevel(colorWindow, colorLevel);
	}
	
	if (wxwindow3!=NULL) 
	{
		wxwindow3->SetColorWindowLevel(colorWindow, colorLevel);
	}
	
	if (wxwindow4!=NULL) 
	{
		wxwindow4->SetColorWindowLevel(colorWindow, colorLevel);
	}
	RefreshView();
}

//-----------------------------------------------------------------------------------
void wxMaracas_N_ViewersWidget::SetInterpolate(bool interpolate)
{
	mvtkmprbasedata->SetInterpolate(interpolate);
	RefreshView();
}



