/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_ViewerWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:35 $
  Version:   $Revision: 1.38 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

//------------------------------------------------------------------------------------------------------------
// Definition includes
//------------------------------------------------------------------------------------------------------------
#include "wxMaracas_ViewerWidget.h"
#include <wx/notebook.h>
//------------------------------------------------------------------------------------------------------------
// Other includes
//------------------------------------------------------------------------------------------------------------
	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	wxMaracas_ViewerWidget::wxMaracas_ViewerWidget(wxWindow *parent, vtkImageData* imagedata, int type, vtkMPRBaseData *vtkmprbasedata,bool TDxWindow)
		: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
	{
		wxPanel 			*panel 						= this;
		wxWindow 			*wxwindow 					= NULL;
 		wxWindow 			*window3D					= NULL;
		wxSplitterWindow	*panelClipping3D			= NULL;
//		wxPanel				*panelControl				= NULL;
//		wxFlexGridSizer  	*sizerCtrol					= NULL;
		wxPanel				*controlPanelMPR3D			= NULL;
		wxPanel				*controlPanelClippingSurf3D	= NULL;
		//RaC 03-2010 Adding a tab
		wxPanel				*controlPanelClippingVol3D	= NULL;

		wxBoxSizer *sizer								= 0;

		mType = type;

		if (vtkmprbasedata==NULL)
		{
			minternalVtkmprbasedata    	= true;
			mvtkmprbasedata	          	= new vtkMPRBaseData();
			marImageData *marimagedata	= new marImageData( imagedata );
			mvtkmprbasedata->SetMarImageData(marimagedata);
		} else {
			minternalVtkmprbasedata		= false;
			mvtkmprbasedata			    = vtkmprbasedata;
		}

		mvtk2Dbaseview					= NULL;
		mvtkmpr2Dview_X					= NULL;
		mvtkmpr2Dview_Y					= NULL;
		mvtkmpr2Dview_Z					= NULL;
		mvtkplane2Dview					= NULL;
		mwidgetMesure					= NULL;
		mwxsphereview					= NULL;
		mwxvtkclipping3Dview			= NULL;
		mwxvtk3Dbaseview_Clipping3D		= NULL;
		mwxvtkmpr3Dview			    	= NULL;
		vtkmpr3Ddataviewer		    	= NULL;

		if (type==-1)
		{
			mvtk2Dbaseview	= new wxVtk2DBaseView(panel,TDxWindow);
			mvtk2Dbaseview->SetVtkBaseData(mvtkmprbasedata);
			wxwindow	    = mvtk2Dbaseview->GetWxVTKRenderWindowInteractor();
		}else if (type==0)
		{
			mvtkmpr2Dview_Z = new wxVtkMPR2DView(panel,2,TDxWindow);
			mvtkmpr2Dview_Z->SetVtkBaseData(mvtkmprbasedata);
			wxwindow	    = mvtkmpr2Dview_Z->GetWxVTKRenderWindowInteractor();
		}else if (type==1)
		{
			mvtkmpr2Dview_X = new wxVtkMPR2DView(panel,0,TDxWindow);
			mvtkmpr2Dview_X->SetVtkBaseData(mvtkmprbasedata);
			wxwindow	    = mvtkmpr2Dview_X->GetWxVTKRenderWindowInteractor();
		}else if (type==2)
		{
			mvtkmpr2Dview_Y = new wxVtkMPR2DView(panel,1,TDxWindow);
			mvtkmpr2Dview_Y->SetVtkBaseData(mvtkmprbasedata);
			wxwindow	    = mvtkmpr2Dview_Y->GetWxVTKRenderWindowInteractor();
		}else if (type==3)
		{
			mwidgetMesure	= new wxWidgetMesure2D_Plane_in_MPR(panel);
			mvtkplane2Dview	= new vtkPlane2DView( mwidgetMesure->GetWindow2());
			mwidgetMesure	-> SetVtkPlane2DView( mvtkplane2Dview );
			mvtkplane2Dview	-> SetImgSize( 200 );
			mvtkplane2Dview	-> SetVtkBaseData(mvtkmprbasedata);
			wxwindow	= mwidgetMesure;
		}else if (type==4)
		{
//EED
//			mwxsphereview	= new wxSphereView( panel , mvtkmprbasedata , mvtkmprbasedata->GetImageData() );
			mwxsphereview	= new wxSphereView( panel , mvtkmprbasedata );
			wxwindow=mwxsphereview->GetWxVTKRenderWindowInteractor();
		}else if (type==5)
		{
			panelClipping3D	= new wxSplitterWindow( panel , -1);
			mwxvtk3Dbaseview_Clipping3D						= new wxVtk3DBaseView( panelClipping3D , vtkmprbasedata,TDxWindow);
			mwxvtkclipping3Dview							= new wxVtkClipping3DView(mwxvtk3Dbaseview_Clipping3D);
			vtkClipping3DDataViewer *vtkclipping3Ddataviewer= new vtkClipping3DDataViewer();
			vtkclipping3Ddataviewer->SetVtkMPRBaseData(mvtkmprbasedata);			
			vtkclipping3Ddataviewer->Configure();
			mwxvtkclipping3Dview->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer);

			mwxvtkmpr3Dview							= new wxVtkMPR3DView( mwxvtk3Dbaseview_Clipping3D );
			vtkMPR3DDataViewer *vtkmpr3Ddataviewer	= new vtkMPR3DDataViewer();
			vtkmpr3Ddataviewer->SetVtkMPRBaseData(mvtkmprbasedata);
			vtkmpr3Ddataviewer->Configure();
			mwxvtkmpr3Dview->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

			window3D = mwxvtk3Dbaseview_Clipping3D->GetWxVTKRenderWindowInteractor();

//--
			wxNotebook *notebook 		= new wxNotebook(panelClipping3D, -1);

			// First tab
			controlPanelMPR3D			= mwxvtkmpr3Dview->CreateControlPanel(notebook, true);
			notebook->AddPage(controlPanelMPR3D, _T("Planes") );

			// Second Tab
			controlPanelClippingSurf3D	= mwxvtkclipping3Dview->CreateSurfControlPanel(notebook);
			notebook->AddPage(controlPanelClippingSurf3D, _T("Surface") );

			//Third tab
			//RaC 03-2010 Moving the volume functionnality to other tab. The changes were realized only in the wxVtkClipping3DViewCntrlPanel class
			controlPanelClippingVol3D	= mwxvtkclipping3Dview->CreateVolControlPanel(notebook);
			notebook->AddPage(controlPanelClippingVol3D, _T("Volume") );

			panelClipping3D->SplitHorizontally( notebook , window3D , 10  );
			//panelClipping3D->SetMinimumPaneSize( 15 );
			panelClipping3D->SetMinimumPaneSize( 70 ); // JPR
			//RaC Nov2012 Correctly resize internal panels with the window resize event
			panelClipping3D->SetSashGravity(0.5);

	/*		EED 04 / Febrary / 2010
			panelControl			= new wxPanel(panelClipping3D,-1);
			controlPanelMPR3D		= mwxvtkmpr3Dview->CreateControlPanel(panelControl, false);
			controlPanelClipping3D	= mwxvtkclipping3Dview->CreateControlPanel(panelControl);
	//		                 mbtnCutImageData		= new wxCheckBox(panelControl,-1,_T("Cut Module"));
	//		Connect(_btnCutImageData->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED  , (wxObjectEventFunction) &wxMPRWidget::OnCutImagaData );
			sizerCtrol             = new wxFlexGridSizer(1);
			sizerCtrol->Add(controlPanelMPR3D	, 1, wxALL|wxEXPAND, 2);
			sizerCtrol->Add(controlPanelClipping3D	, 1, wxALL|wxEXPAND, 2);
	//		sizerCtrol->Add( mbtnCutImageData	, 1, wxALL, 2);
			panelControl->SetAutoLayout(true);
			panelControl->SetSizer(sizerCtrol);
			panelControl->SetSize(400,350);
			panelControl->Layout();
			panelClipping3D	-> SplitHorizontally( panelControl , window3D , 10  );
			panelClipping3D	-> SetMinimumPaneSize( 5 );
	 */
			wxwindow=panelClipping3D;

		} else if (type==6)		{
			panelClipping3D						= new wxSplitterWindow( panel , -1);
			mwxvtk3Dbaseview_Clipping3D			= new wxVtk3DBaseView( panelClipping3D , vtkmprbasedata,TDxWindow);
			mwxvtkmpr3Dview						= new wxVtkMPR3DView( mwxvtk3Dbaseview_Clipping3D );
			vtkmpr3Ddataviewer					= new vtkMPR3DDataViewer();
			wxWindow 		*window3D 			= mwxvtk3Dbaseview_Clipping3D->GetWxVTKRenderWindowInteractor();
			wxPanel			*panelControl		= new wxPanel(panelClipping3D,-1);
			wxPanel			*controlPanelMPR3D	= mwxvtkmpr3Dview->CreateControlPanel(panelControl, true);
			wxFlexGridSizer *sizerCtrol  		= new wxFlexGridSizer(1);
			sizerCtrol->Add(controlPanelMPR3D, 1, wxALL|wxEXPAND, 2);

			panelControl->SetAutoLayout(true);
			panelControl->SetSizer(sizerCtrol);
			panelControl->SetSize(400,350);
			panelControl->Layout();
			//panelClipping3D->SetMinimumPaneSize( 5 );
			panelClipping3D->SetMinimumPaneSize( 130 );  // FCY
			panelClipping3D->SplitHorizontally( panelControl , window3D , 0  );
			//panelClipping3D->SetSashSize(10);

			//RaC Nov2012 Correctly resize internal panels with the window resize event
			panelClipping3D->SetSashGravity(0.5);
			panelClipping3D->UpdateSize(); //FCY
			wxwindow=panelClipping3D;

			vtkmpr3Ddataviewer->SetVtkMPRBaseData(mvtkmprbasedata);
			//vtkmpr3Ddataviewer->Configure();

			mwxvtkmpr3Dview->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

		}else if (type==7)
		{
			mwxvtk3Dbaseview_Clipping3D = new wxVtk3DBaseView( panel ,vtkmprbasedata);
			wxwindow = (wxWindow*) mwxvtk3Dbaseview_Clipping3D->GetWxVTKRenderWindowInteractor();
		}

	sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( wxwindow, 1, wxGROW);
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	sizer->Layout();
	panel->Layout();
	panel->Refresh();

	//   mbbtkViewerMaracas= NULL;
	}
	//-------------------------------------------------------------------------

	wxMaracas_ViewerWidget::~wxMaracas_ViewerWidget()
	{
		if (minternalVtkmprbasedata==true)
		{
		   if (mvtkmprbasedata)         { delete mvtkmprbasedata;}
		}
		
		if (mvtk2Dbaseview)             { delete mvtk2Dbaseview; }
		if (mvtkmpr2Dview_X)            { delete mvtkmpr2Dview_X;}
		if (mvtkmpr2Dview_Y)            { delete mvtkmpr2Dview_Y;}
		if (mvtkmpr2Dview_Z)            { delete mvtkmpr2Dview_Z;}
		if (mwidgetMesure)              { delete mwidgetMesure;  }
		if (mvtkplane2Dview)            { delete mvtkplane2Dview;}
		if (mwxsphereview)              { delete mwxsphereview;  }
		if (mwxvtkmpr3Dview)            { delete mwxvtkmpr3Dview;}
		if (mwxvtkclipping3Dview)       { delete mwxvtkclipping3Dview;}
		if (mwxvtk3Dbaseview_Clipping3D){ delete mwxvtk3Dbaseview_Clipping3D; mwxvtk3Dbaseview_Clipping3D=NULL;}
		if (vtkmpr3Ddataviewer)			{ delete vtkmpr3Ddataviewer;}
	}
	//------------------------------------------------------------------------------------------------------------
	// Methods
	//------------------------------------------------------------------------------------------------------------

	//-------------------------------------------------------------------------

	void wxMaracas_ViewerWidget::ConfigureVTK()
	{
  		int x=0,y=0,z=0;
		/*
		int ext[6];
		ext[0]=0;
		ext[1]=0;
		ext[2]=0;
		ext[3]=0;
		ext[4]=0;
		ext[5]=0;
		*/
		int ext[] = {0, 0, 0, 0, 0, 0}; //JPR

		/*double org[3],spc[3];
		org[0]=0;
		org[1]=0;
		org[2]=0;
		spc[0]=0;
		spc[1]=0;
		spc[2]=0;
		*/
		double org[]={0.0, 0.0, 0.0}; //JPR
		double spc[]={0.0, 0.0, 0.0}; //JPR
		if (mvtkmprbasedata!=NULL)
		{
			mvtkmprbasedata->Configure();

			if(mvtkmprbasedata->GetImageData() != NULL)
			{
				mvtkmprbasedata->GetImageData()->GetExtent(ext);
				mvtkmprbasedata->GetImageData()->GetOrigin(org);
				mvtkmprbasedata->GetImageData()->GetSpacing(spc);

				x = (ext[0]+ext[1])/2;
				y = (ext[2]+ext[3])/2;
				z = (ext[4]+ext[5])/2;

				mvtkmprbasedata->SetX( x );
				mvtkmprbasedata->SetY( y );
				mvtkmprbasedata->SetZ( z );
			}
			else
			{
				mvtkmprbasedata->SetX( 0 );
				mvtkmprbasedata->SetY( 0 );
				mvtkmprbasedata->SetZ( 0 );
			}
		}

		if ( mvtk2Dbaseview      !=NULL ) { mvtk2Dbaseview->Configure();                }
		if ( mvtkmpr2Dview_X     !=NULL ) { mvtkmpr2Dview_X->Configure();               }
		if ( mvtkmpr2Dview_Y     !=NULL ) { mvtkmpr2Dview_Y->Configure();               }
		if ( mvtkmpr2Dview_Z     !=NULL ) { mvtkmpr2Dview_Z->Configure();               }
		if ( mvtkplane2Dview     !=NULL ) { mvtkplane2Dview->Configure();               }
		if ( mwidgetMesure       !=NULL ) { mwidgetMesure->ConfigureA(mvtkplane2Dview); }
		if ( mwidgetMesure       !=NULL ) { mwidgetMesure->ConfigureA(mvtkplane2Dview); }
		if ( mwidgetMesure       !=NULL ) { mwidgetMesure->SetActiveLink(true);         }
		if ( mwxsphereview       !=NULL ) { mwxsphereview->Configure();                 }

		
		if (mwxvtk3Dbaseview_Clipping3D	!=NULL)
		{
			mwxvtk3Dbaseview_Clipping3D->Configure();
		}

		if (vtkmpr3Ddataviewer			!=NULL)
		{
			vtkmpr3Ddataviewer->Configure();

		}

		if (mwxvtkmpr3Dview			!=NULL)
		{
			mwxvtkmpr3Dview->Configure();
//EED???			mwxvtkmpr3Dview->ResetCamera(ext,org,spc);
		}

		if (mwxvtkclipping3Dview		!=NULL)
		{
			mwxvtkclipping3Dview->Configure();
		}

		//if(vtkmpr3Ddataviewer!=NULL){vtkmpr3Ddataviewer->Configure();}
//		RefreshView();

		//if (mwxvtkmpr3Dview				!=NULL)	{
		//	mwxvtkmpr3Dview->ResetCamera();
		//}

	}

//-------------------------------------------------------------------------
void wxMaracas_ViewerWidget::Refresh(bool eraseBackground ,const wxRect* rect  )  // virtual  eraseBackground=true , rect=NULL
{
	wxPanel::Refresh(false);
}

	//-------------------------------------------------------------------------
	void wxMaracas_ViewerWidget::RefreshView()
	{
//printf("EED wxMaracas_ViewerWidget::RefreshView %p\n", this);
		if (mwxvtkmpr3Dview				!=NULL ){ mwxvtkmpr3Dview				->RefreshView();	}
		if (mwxvtkclipping3Dview		!=NULL ){ mwxvtkclipping3Dview			->Refresh();		}
		if (mwxvtk3Dbaseview_Clipping3D !=NULL ){ mwxvtk3Dbaseview_Clipping3D	->Refresh();	 	}
		if (mvtk2Dbaseview				!=NULL ){ mvtk2Dbaseview				->Refresh();		}
		if (mvtkmpr2Dview_X				!=NULL ){ mvtkmpr2Dview_X				->Refresh();		}
		if (mvtkmpr2Dview_Y				!=NULL ){ mvtkmpr2Dview_Y				->Refresh();		}
		if (mvtkmpr2Dview_Z				!=NULL ){ mvtkmpr2Dview_Z				->Refresh();		}
		if (mvtkplane2Dview				!=NULL ){ mvtkplane2Dview				->Refresh();		}
		if (mwxsphereview				!=NULL ){ mwxsphereview					->RefreshView();	}
	}

	//-------------------------------------------------------------------------

	wxVtkBaseView *wxMaracas_ViewerWidget::GetwxVtkBaseView()
	{
		wxVtkBaseView *wxvtkbaseview=NULL;
		if (mvtk2Dbaseview!=NULL)
		{
			wxvtkbaseview = mvtk2Dbaseview;
		}
		if (mvtkmpr2Dview_X!=NULL)
		{
			wxvtkbaseview = mvtkmpr2Dview_X;
		}
		if (mvtkmpr2Dview_Y!=NULL)
		{
			wxvtkbaseview = mvtkmpr2Dview_Y;
		}
		if (mvtkmpr2Dview_Z!=NULL)
		{
			wxvtkbaseview = mvtkmpr2Dview_Z;
		}
		if (mvtkplane2Dview!=NULL)
		{
			wxvtkbaseview = mvtkplane2Dview;
		}
		if (mwxsphereview!=NULL)
		{
			wxvtkbaseview = mwxsphereview;
		}
		if (mwxvtk3Dbaseview_Clipping3D!=NULL)
		{
			wxvtkbaseview = mwxvtk3Dbaseview_Clipping3D;
		}
		return wxvtkbaseview   ;
	}



//-------------------------------------------------------------------------
void wxMaracas_ViewerWidget::SetImage( vtkImageData *image )
{
	if(mvtkmprbasedata !=NULL)
	{
		marImageData* mar = mvtkmprbasedata->GetMarImageData();
		mar->removeImageData(0);
		mar->AddImageData(image);
	}	
	if (mvtk2Dbaseview!=NULL)
	{
			mvtk2Dbaseview->SetImageToVtkViewer(image);
	}	
	if (mvtkmpr2Dview_X!=NULL)
	{
		mvtkmpr2Dview_X->SetImageToVtkViewer(image);
		mvtkmpr2Dview_X->ResetBackXYZ();
	}
	if (mvtkmpr2Dview_Y!=NULL)
	{
		mvtkmpr2Dview_Y->SetImageToVtkViewer(image);
		mvtkmpr2Dview_Y->ResetBackXYZ();
	}
	if (mvtkmpr2Dview_Z!=NULL)
	{
		mvtkmpr2Dview_Z->SetImageToVtkViewer(image);
		mvtkmpr2Dview_Z->ResetBackXYZ();
	}	
	if (mvtkplane2Dview!=NULL)
	{
		// ???  EED 10 oct 2012
	}
	if (mwxsphereview!=NULL)
	{
		mwxsphereview->SetImage();
	}
	if (mwxvtkmpr3Dview!=NULL)
	{
		mwxvtkmpr3Dview->SetImage();
	}
	if (mwxvtkclipping3Dview!=NULL)
	{
		mwxvtkclipping3Dview->GetVtkClipping3DDataViewer()->SetImage();
	}		
		
//EED 26/11/2009
//		ConfigureVTK();
//		RefreshView();
}

	//-------------------------------------------------------------------------

	double wxMaracas_ViewerWidget :: GetX()
	{
		double value = -1;
		if(mvtkmprbasedata !=NULL)
		{
			value = mvtkmprbasedata->GetX();
		}
		return value;
	}

	//-------------------------------------------------------------------------

	double wxMaracas_ViewerWidget::GetY()
	{
		double value = -1;
		if(mvtkmprbasedata !=NULL)
		{
			value = mvtkmprbasedata->GetY();
		}
		return value;
	}

	//-------------------------------------------------------------------------

	double wxMaracas_ViewerWidget::GetZ()
	{
		double value = -1;
		if(mvtkmprbasedata !=NULL)
		{
			value = mvtkmprbasedata->GetZ();
		}
		return value;
//		return mvtk2Dbaseview->GetVtkBaseData()->GetZ();
	}

//-------------------------------------------------------------------------------------------
void wxMaracas_ViewerWidget::setColorTransferFunction(vtkColorTransferFunction* colortable)
{
	if(mvtkmpr2Dview_X!=NULL)
	{
		mvtkmpr2Dview_X->setColorTransferFunction(colortable);
	}
	
	if(mvtkmpr2Dview_Y!=NULL)
	{
		mvtkmpr2Dview_Y->setColorTransferFunction(colortable);
	}
	
	if(mvtkmpr2Dview_Z!=NULL)
	{
		mvtkmpr2Dview_Z->setColorTransferFunction(colortable);
	}
	
	if(mwxvtkmpr3Dview!=NULL)
	{
		mwxvtkmpr3Dview->setColorTransferFunction(colortable);
	}
}

//-------------------------------------------------------------------------------------------
void wxMaracas_ViewerWidget::SetColorWindowLevel(double colorWindow, double colorLevel)
{
	mvtkmprbasedata->SetColorWindow(colorWindow);
	mvtkmprbasedata->SetColorLevel(colorLevel);
}



